/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TdgssParseXml {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    public static final String outputEncoding = "UTF-8";
    private static PrintWriter out;
    private InputStream LibFile;
    private InputStream UserFile;
    public Node LegalNode = null;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public TdgssParseXml(InputStream inputStream, InputStream inputStream2) throws GSSException, Exception {
        if (inputStream == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_LIBRARY_FILE_BAD);
        }
        if (inputStream2 == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_USER_FILE_BAD);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, outputEncoding);
        out = new PrintWriter((Writer)outputStreamWriter, true);
        this.LibFile = inputStream;
        this.UserFile = inputStream2;
    }

    Node FindNode(Node node, Node node2) {
        if (node == null) {
            return null;
        }
        if (node2.getNodeType() == 1 && node2.getNodeName() != null && node.getNodeName().equalsIgnoreCase(node2.getNodeName())) {
            return node2;
        }
        Node node3 = null;
        if (node2.hasChildNodes()) {
            node3 = this.FindNode(node, node2.getFirstChild());
        }
        if (node3 != null) {
            return node3;
        }
        Node node4 = node2.getNextSibling();
        if (node4 != null && !node2.getNodeName().equalsIgnoreCase("LegalValues")) {
            node3 = this.FindNode(node, node4);
        }
        return node3;
    }

    int ValidateAttributes(Node node, Node node2) {
        Node node3 = this.FindNode(node, node2);
        boolean bl = false;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node4;
            block5: {
                int n;
                NamedNodeMap namedNodeMap2;
                block4: {
                    node4 = this.FindNode(namedNodeMap.item(i), node2);
                    if (node4 == null) break block4;
                    namedNodeMap2 = node4.getAttributes();
                    bl = false;
                    for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                        if (namedNodeMap.item(i).getNodeValue().toUpperCase().indexOf(namedNodeMap2.item(n).getNodeName().toUpperCase()) < 0) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    if (node4.getFirstChild().getNodeValue().toUpperCase().indexOf(namedNodeMap.item(i).getNodeValue().toUpperCase()) < 0) break block5;
                    bl = true;
                    break block5;
                }
                if (node3 != null) {
                    namedNodeMap2 = node3.getAttributes();
                    bl = false;
                    for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                        if (namedNodeMap.item(i).getNodeName().toUpperCase().indexOf(namedNodeMap2.item(n).getNodeName().toUpperCase()) < 0) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (bl || node3 == null && node4 == null) continue;
            logger.error("Error in " + namedNodeMap.item(i).getNodeName());
            return 0;
        }
        return 1;
    }

    int ValidateData(Node node, Node node2) {
        Node node3 = this.FindNode(node, node2);
        if (node3 == null) {
            return 1;
        }
        String string = null;
        string = node.getFirstChild().getNodeValue();
        if (string == null) {
            return 1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            n = 0;
            String string2 = stringTokenizer.nextToken();
            NamedNodeMap namedNodeMap = node3.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (namedNodeMap.item(i).getNodeName().toUpperCase().indexOf(string2.toUpperCase()) < 0) continue;
                n = 1;
            }
            if (n != 0) continue;
            logger.error(" Error in " + string2);
            break;
        }
        return n;
    }

    private int Validate(Node node, Node node2) {
        int n = 1;
        if (node == null) {
            return n;
        }
        if (node.getNodeType() == 1) {
            if (node.hasAttributes()) {
                n = this.ValidateAttributes(node, node2);
            }
            if (n == 0) {
                return n;
            }
            if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3 && node.getFirstChild().getNodeValue() != null && node.getFirstChild().getNodeValue().trim().length() > 0) {
                n = this.ValidateData(node, node2);
            }
            if (n == 0) {
                return n;
            }
        }
        if (node.hasChildNodes() && !node.getNodeName().equalsIgnoreCase("LegalValues")) {
            n = this.Validate(node.getFirstChild(), node2);
        }
        if (n == 0) {
            return n;
        }
        Node node3 = node.getNextSibling();
        if (node3 != null && node3.getNodeName().equalsIgnoreCase("LegalValues")) {
            node3 = node3.getNextSibling();
        }
        if (node3 != null) {
            n = this.Validate(node3, node2);
        }
        return n;
    }

    Node getLegalNode(Node node) {
        if (node == null) {
            return this.LegalNode;
        }
        if (node.getNodeType() == 1 && node.getNodeName() != null && node.getNodeName().equalsIgnoreCase("LegalValues")) {
            this.LegalNode = node;
        }
        if (this.LegalNode == null && node.hasChildNodes()) {
            this.getLegalNode(node.getFirstChild());
        }
        Node node2 = node.getNextSibling();
        if (this.LegalNode == null && node2 != null) {
            this.getLegalNode(node2);
        }
        return this.LegalNode;
    }

    void MergeAttributes(Node node, Node node2) {
        Object object;
        StringTokenizer stringTokenizer = null;
        String string = null;
        if (node2.hasAttributes()) {
            for (int i = 0; i < node2.getAttributes().getLength(); ++i) {
                int n = -1;
                for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                    if (!node.getAttributes().item(j).getNodeName().equalsIgnoreCase(node2.getAttributes().item(i).getNodeName())) continue;
                    n = j;
                    break;
                }
                if (n < 0) {
                    object = node2.getAttributes().item(i);
                    object = node.getOwnerDocument().importNode((Node)object, true);
                    node.getAttributes().setNamedItem((Node)object);
                    continue;
                }
                node.getAttributes().item(n).setNodeValue(node2.getAttributes().item(i).getNodeValue());
            }
        }
        if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3 && node.getFirstChild().getNodeValue() != null && node.getFirstChild().getNodeValue().trim().length() > 0) {
            string = node.getFirstChild().getNodeValue();
        }
        if (node2.hasChildNodes() && node2.getFirstChild().getNodeType() == 3 && node2.getFirstChild().getNodeValue() != null && node2.getFirstChild().getNodeValue().trim().length() > 0) {
            stringTokenizer = new StringTokenizer(node2.getFirstChild().getNodeValue(), " ");
        }
        if (string == null && stringTokenizer != null) {
            if (node.hasChildNodes()) {
                node.getFirstChild().setNodeValue(node2.getFirstChild().getNodeValue());
            } else {
                object = node2.getFirstChild();
                object = node.getOwnerDocument().importNode((Node)object, true);
                node.appendChild((Node)object);
                object.setNodeValue(object.getNodeValue());
            }
        }
        object = "";
        if (string != null && stringTokenizer != null) {
            object = ((String)object).concat(node.getFirstChild().getNodeValue());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string.toUpperCase().indexOf(string2.toUpperCase()) >= 0) continue;
                object = ((String)object).concat(string2.concat(" "));
            }
            node.getFirstChild().setNodeValue((String)object);
        }
    }

    private Document Merge(Node node, Node node2) {
        int n = 0;
        boolean bl = false;
        if (node == null) {
            return node2.getOwnerDocument();
        }
        if (node2 == null) {
            return node.getOwnerDocument();
        }
        this.MergeAttributes(node, node2);
        NodeList nodeList = node2.getChildNodes();
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            n = 0;
            int n2 = -1;
            int n3 = -1;
            bl = false;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 1) continue;
                if (nodeList.item(i).getNodeName().equalsIgnoreCase(nodeList2.item(j).getNodeName()) && nodeList.item(i).hasAttributes() && nodeList2.item(j).hasAttributes()) {
                    for (int k = 0; k < nodeList.item(i).getAttributes().getLength(); ++k) {
                        for (int i2 = 0; i2 < nodeList2.item(j).getAttributes().getLength(); ++i2) {
                            if (!nodeList.item(i).getAttributes().item(k).getNodeValue().equalsIgnoreCase(nodeList2.item(j).getAttributes().item(i2).getNodeValue()) || !nodeList.item(i).getAttributes().item(k).getNodeName().equalsIgnoreCase(nodeList2.item(j).getAttributes().item(i2).getNodeName())) continue;
                            n3 = j;
                        }
                    }
                }
                if (!nodeList.item(i).getNodeName().equalsIgnoreCase(nodeList2.item(j).getNodeName())) continue;
                ++n;
                if (!bl) {
                    n2 = j;
                }
                bl = true;
            }
            if (bl && n == 1) {
                this.Merge(nodeList2.item(n2), nodeList.item(i));
            }
            if (bl && n > 1) {
                if (n3 >= 0) {
                    this.Merge(nodeList2.item(n3), nodeList.item(i));
                } else {
                    Node node3 = nodeList.item(i);
                    node3 = node.getOwnerDocument().importNode(node3, true);
                    node.appendChild(node3);
                }
            }
            if (bl) continue;
            Node node4 = nodeList.item(i);
            node4 = node.getOwnerDocument().importNode(node4, true);
            node.appendChild(node4);
        }
        return node.getOwnerDocument();
    }

    public Document parse() throws GSSException, Exception {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(bl || bl2);
        if (bl2) {
            try {
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_SCHEMA_NOT_RECOGNIZED, illegalArgumentException);
            }
        }
        if (string != null) {
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, new File(string));
        }
        documentBuilderFactory.setExpandEntityReferences(!bl3);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.err, outputEncoding);
        documentBuilder.setErrorHandler(new MyErrorHandler());
        Document document = documentBuilder.parse(this.LibFile);
        if (document == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_LIBRARY_FILE_BAD);
        }
        Document document2 = documentBuilder.parse(this.UserFile);
        if (document2 == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_USER_FILE_BAD);
        }
        Node node = this.getLegalNode(document.getFirstChild());
        if (node == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_LIBRARY_FILE_BAD);
        }
        int n = 1;
        n = this.Validate(document.getFirstChild(), node);
        if (n == 0) {
            logger.debug(" OF LIB FILE \n");
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_LEGAL);
        }
        n = this.Validate(document2.getFirstChild(), node);
        if (n == 0) {
            logger.debug(" OF USER FILE \n");
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_LEGAL);
        }
        this.Merge(document, document2);
        return document;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            logger.warn("Warning: " + this.getParseExceptionInfo(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }
}

