/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssCredential
implements GSSCredential {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private Hashtable credImplementations;
    private Vector mechanisms;
    private Oid[] mechOids;
    private TdgssName name;
    private int lifetime;
    private int usage;

    public TdgssCredential(TdgssName tdgssName, int n, Oid[] oidArray, int n2, GSSMechanism[] gSSMechanismArray) throws GSSException {
        int n3;
        if (gSSMechanismArray == null || gSSMechanismArray.length == 0) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISM_IMPLEMENTATIONS);
        }
        this.credImplementations = new Hashtable(gSSMechanismArray.length);
        this.lifetime = n;
        this.usage = n2;
        this.mechOids = oidArray;
        this.name = tdgssName;
        this.mechanisms = new Vector(gSSMechanismArray.length);
        if (oidArray != null) {
            for (n3 = 0; n3 < oidArray.length; ++n3) {
                int n4 = 0;
                for (int i = 0; i < gSSMechanismArray.length; ++i) {
                    if (!gSSMechanismArray[i].getMech().equals(oidArray[n3])) continue;
                    this.mechanisms.addElement(gSSMechanismArray[i]);
                    ++n4;
                }
                if (n4 != 0) continue;
                throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISM_ADDED);
            }
        } else {
            for (n3 = 0; n3 < gSSMechanismArray.length; ++n3) {
                this.mechanisms.addElement(gSSMechanismArray[n3]);
            }
        }
        Enumeration enumeration = this.mechanisms.elements();
        while (enumeration.hasMoreElements()) {
            GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
            try {
                GSSCredential gSSCredential;
                if (tdgssName != null) {
                    GSSName gSSName = tdgssName.getNameImplementation(gSSMechanism);
                    if (gSSName == null) continue;
                    gSSCredential = gSSMechanism.createCredential(gSSName, n, n2);
                } else {
                    gSSCredential = gSSMechanism.createCredential(null, n, n2);
                }
                this.credImplementations.put(gSSMechanism, gSSCredential);
            }
            catch (GSSException gSSException) {
                logger.error(gSSException.getMessage());
            }
        }
        if (this.credImplementations.size() == 0) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_ALL_MECHANISMS_FAILED);
        }
    }

    public void dispose() throws GSSException {
        Enumeration enumeration = this.credImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredential gSSCredential = (GSSCredential)enumeration.nextElement();
            gSSCredential.dispose();
        }
    }

    public GSSName getName() throws GSSException {
        Enumeration enumeration = this.credImplementations.elements();
        if (enumeration.hasMoreElements()) {
            GSSCredential gSSCredential = (GSSCredential)enumeration.nextElement();
            return gSSCredential.getName();
        }
        return null;
    }

    public GSSName getName(Oid oid) throws GSSException {
        Enumeration enumeration = this.credImplementations.keys();
        while (enumeration.hasMoreElements()) {
            GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
            GSSCredential gSSCredential = (GSSCredential)this.credImplementations.get(gSSMechanism);
            if (!oid.equals(gSSMechanism.getMech())) continue;
            return gSSCredential.getName();
        }
        return null;
    }

    public int getRemainingLifetime() throws GSSException {
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        return this.mechOids;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        GSSName gSSName2 = null;
        GSSMechanism gSSMechanism = null;
        Enumeration enumeration = this.mechanisms.elements();
        while (enumeration.hasMoreElements()) {
            gSSMechanism = (GSSMechanism)enumeration.nextElement();
            if (!gSSMechanism.getMech().equals(oid)) continue;
            try {
                TdgssName tdgssName;
                if (gSSName != null && (gSSName2 = (tdgssName = (TdgssName)gSSName).getNameImplementation(gSSMechanism)) != null) break;
            }
            catch (ClassCastException classCastException) {
                throw new TdgssException(3, TdgssMinorStatus.TDGSS_ERR_NOT_CONTAINER_IMPLEMENTATION);
            }
        }
        if (gSSMechanism == null) {
            throw new TdgssException(2);
        }
        if (gSSName2 == null) {
            throw new TdgssException(3, TdgssMinorStatus.TDGSS_ERR_CANT_CANNONICALIZE_NAME);
        }
        int n4 = n > n2 ? n : n2;
        if (this.credImplementations.containsKey(gSSMechanism)) {
            GSSCredential gSSCredential = (GSSCredential)this.credImplementations.get(gSSMechanism);
            gSSCredential.add(gSSName2, n, n2, oid, n3);
        } else {
            GSSCredential gSSCredential = gSSMechanism.createCredential(gSSName2, n4, n3);
            if (gSSCredential == null) {
                throw new TdgssException(9, TdgssMinorStatus.TDGSS_ERR_CANT_ACQUIRE_CRED);
            }
            this.credImplementations.put(gSSMechanism, gSSCredential);
        }
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.credImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredential gSSCredential = (GSSCredential)enumeration.nextElement();
            stringBuffer.append(gSSCredential.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    protected GSSCredential getCredentialImplementation(GSSMechanism gSSMechanism) {
        return (GSSCredential)this.credImplementations.get(gSSMechanism);
    }
}

