/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class TdgssBundle {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private final String bundleName = this.getClass().getName().replaceAll("\\.", "/");
    private ResourceBundle bundle;

    protected TdgssBundle() {
        this.loadBundle(Locale.getDefault());
    }

    protected void loadBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle(this.bundleName, locale);
    }

    protected String getString(String string, Object[] objectArray) {
        String string2 = null;
        try {
            String string3 = this.bundle.getString(string);
            string2 = MessageFormat.format(string3, objectArray);
        }
        catch (RuntimeException runtimeException) {
            logger.error("Caught exception", runtimeException);
            return this.buildDefaultMessage(string, objectArray);
        }
        return string2;
    }

    private String buildDefaultMessage(String string, Object[] objectArray) {
        return "Unable to get error message for " + string;
    }
}

