/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.jgssp2tdnego.TdnegoContext;
import com.teradata.tdgss.jgssp2tdnego.TdnegoCredential;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssp2tdnego.TdnegoName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.util.ArrayList;
import java.util.Vector;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class TdnegoMechanism
implements GSSMechanism {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private static Oid mechOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    public static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    public static Oid GSS_C_NT_TDAT_USER;
    public static Oid GSS_C_NT_TDAT_PASSWORD;
    static final Oid MECH_OID;
    private Vector mechImplementations;
    private TdgssConfigApi confApi;
    protected static short servicesAvailable;

    public TdnegoMechanism() throws GSSException {
        servicesAvailable = 0;
        this.mechImplementations = new Vector();
        this.confApi = TdgssConfigApi.getInstance();
        if (this.confApi != null) {
            String[] stringArray = this.confApi.getEnabledNegMech(MECH_OID);
            for (int i = 0; i < stringArray.length; ++i) {
                GSSMechanism gSSMechanism = this.createObject(stringArray[i]);
                if (gSSMechanism == null) continue;
                this.mechImplementations.addElement(gSSMechanism);
                servicesAvailable = (short)(servicesAvailable | gSSMechanism.getServices());
            }
        }
    }

    private GSSMechanism createObject(String string) {
        GSSMechanism gSSMechanism = null;
        try {
            Class<?> clazz = Class.forName(string);
            gSSMechanism = (GSSMechanism)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.error(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException.getMessage());
        }
        return gSSMechanism;
    }

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Oid oid = gSSMechanism.getMech();
            Object object2 = ((TdnegoCredential)gSSCredential).getCredForMech(oid);
            if (!(object2 instanceof GSSCredential) || !gSSMechanism.acceptable(object, (GSSCredential)object2, objectArray)) continue;
            return true;
        }
        return false;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        logger.debug("getContextForAccept ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        return new TdnegoContext((TdnegoCredential)gSSCredential, objectArray, this.mechImplementations);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        logger.debug("getContextForInit ");
        s = (short)(s & servicesAvailable);
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        return new TdnegoContext((TdnegoCredential)gSSCredential, (TdnegoName)gSSName, n, objectArray, s, this.mechImplementations);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof TdnegoCredential)) {
            logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            return false;
        }
        if (gSSName != null && !(gSSName instanceof TdnegoName)) {
            logger.debug("must be a name created by this mech");
            return false;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Object object = null;
            Oid oid = gSSMechanism.getMech();
            if (gSSCredential != null) {
                object = ((TdnegoCredential)gSSCredential).getCredForMech(oid);
            }
            Object object2 = null;
            if (gSSName != null) {
                object2 = ((TdnegoName)gSSName).getNameForMech(oid);
            }
            if (!(object instanceof GSSCredential) || !gSSMechanism.initable((GSSCredential)object, (GSSName)object2, n, objectArray, s)) continue;
            return true;
        }
        return false;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        return new TdnegoCredential((TdnegoName)gSSName, n, n2, this.mechImplementations);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        return new TdnegoName(byArray, oid, this.mechImplementations);
    }

    public Oid[] getNames() {
        ArrayList<Oid> arrayList = new ArrayList<Oid>();
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Oid[] oidArray = gSSMechanism.getNames();
            for (int j = 0; j < oidArray.length; ++j) {
                Oid oid = oidArray[j];
                if (arrayList.contains(oid)) continue;
                arrayList.add(oid);
            }
        }
        Oid[] oidArray = new Oid[arrayList.size()];
        for (int i = 0; i < oidArray.length; ++i) {
            oidArray[i] = (Oid)arrayList.get(i);
        }
        return oidArray;
    }

    public Oid getMech() {
        return MECH_OID;
    }

    public short getServices() {
        return servicesAvailable;
    }

    static {
        try {
            mechOid = new Oid("1.3.6.1.4.1.28698.4.302.1.3");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
            GSS_C_NT_TDAT_USER = new Oid("1.3.6.1.4.1.191.1.1012.1.2.6");
            GSS_C_NT_TDAT_PASSWORD = new Oid("1.3.6.1.4.1.191.1.1012.1.2.7");
        }
        catch (GSSException gSSException) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError("Oid string is incorrectly formatted");
            exceptionInInitializerError.initCause(gSSException);
            throw exceptionInInitializerError;
        }
        MECH_OID = mechOid;
    }
}

