/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssp2tdnego.NegMech;
import com.teradata.tdgss.jgssp2tdnego.NegMechList;
import com.teradata.tdgss.jgssp2tdnego.NegTokenInit;
import com.teradata.tdgss.jgssp2tdnego.NegTokenResp;
import com.teradata.tdgss.jgssp2tdnego.TdnegoCredential;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMechanism;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssp2tdnego.TdnegoName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class TdnegoContext
implements GSSContext {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    TdgssConfigApi capi = TdgssConfigApi.getInstance();
    private int tokenNumber = 0;
    private int negState = 2;
    private int negStateFromPeer = 2;
    private boolean isPolicyAppiled = false;
    private NegMechList mechList;
    private NegMechList respMechList = null;
    private String authID = null;
    private String profileID = null;
    private String userID = null;
    private boolean isSSO = false;
    private GSSContext selectedCtx;
    int lifetimeContext = 0;
    private boolean initiator;
    private TdnegoCredential credential;
    private int lifetime;
    private short requestedServices;
    private TdnegoName targetName;
    private TdnegoName name;
    private Object[] chanBind = null;
    private final Oid KRB5_OID = new Oid("1.2.840.113554.1.2.2");
    private Vector mechObjs = null;
    private NegTokenInit initToken = null;
    private static final byte[] TDNEGO_TRAILER = new byte[]{6, 13, 43, 6, 1, 4, 1, -127, -32, 26, 4, -126, 46, 1, 3, 0, 0, 0, 0, 21, 1};

    public TdnegoContext(TdnegoCredential tdnegoCredential, Object[] objectArray, Vector vector) throws GSSException {
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        this.initiator = false;
        this.credential = tdnegoCredential;
        this.requestedServices = TdnegoMechanism.servicesAvailable;
    }

    public TdnegoContext(TdnegoCredential tdnegoCredential, TdnegoName tdnegoName, int n, Object[] objectArray, short s, Vector vector) throws GSSException {
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        this.mechObjs = vector;
        this.initiator = true;
        this.credential = tdnegoCredential;
        this.targetName = tdnegoName;
        this.lifetime = n;
        this.requestedServices = s;
        this.chanBind = objectArray;
        this.initialiseData();
    }

    public String getNameForOid(Oid oid) {
        String[] stringArray = this.capi.GetInforForMech(oid);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public boolean isEstablished() {
        return this.negState == 1;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public boolean getAnonymityState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getAnonymityState();
        }
        return false;
    }

    public boolean getConfState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getConfState();
        }
        return false;
    }

    public boolean getCredDelegState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getCredDelegState();
        }
        return false;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public boolean getIntegState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getIntegState();
        }
        return false;
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.selectedCtx.getLifetime();
        }
        return 0;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.isEstablished()) {
            return this.selectedCtx.getMIC(byArray, n, n2, messageProp);
        }
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
    }

    public Oid getMech() throws GSSException {
        if (this.isEstablished()) {
            return this.selectedCtx.getMech();
        }
        return TdnegoMechanism.MECH_OID;
    }

    public boolean getMutualAuthState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getMutualAuthState();
        }
        return false;
    }

    public boolean getReplayDetState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getReplayDetState();
        }
        return false;
    }

    public boolean getSequenceDetState() {
        if (this.isEstablished()) {
            return this.selectedCtx.getSequenceDetState();
        }
        return false;
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_CONTEXT_NOT_READY);
        }
        return this.selectedCtx.getWrapSizeLimit(n, bl, n2);
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        logger.debug("Token number is now " + this.tokenNumber + "\n");
        if (this.tokenNumber == 0) {
            logger.debug("Establishing TDNEGO context\n");
            try {
                byArray2 = this.buildInitToken(byArray, n, n2);
            }
            catch (GSSException gSSException) {
                throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE, gSSException);
            }
        }
        logger.debug("Just receive info-data from server \n");
        try {
            byArray2 = this.buildRespToken(byArray, n, n2);
        }
        catch (GSSException gSSException) {
            throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE, gSSException);
        }
        ++this.tokenNumber;
        logger.debug("Leaving after incrementing msgsequence to " + this.tokenNumber);
        return byArray2;
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public boolean isServer() throws GSSException {
        return false;
    }

    public boolean isProtReady() {
        return this.selectedCtx != null;
    }

    public boolean isTransferable() throws GSSException {
        if (!this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return false;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestAnonymity(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestConf(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestCredDeleg(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestInteg(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n2 = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestLifetime(n);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n2;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n2 == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestMutualAuth(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestReplayDet(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
        ListArray listArray = this.mechList.getNegMechList();
        int n = 0;
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            GSSContext gSSContext = negMech.getContext();
            try {
                if (gSSContext == null) continue;
                gSSContext.requestSequenceDet(bl);
                continue;
            }
            catch (TdgssException tdgssException) {
                ++n;
                logger.info(tdgssException.getMessage());
            }
        }
        if (n == listArray.size()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_INVALID_REQUEST);
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return this.selectedCtx.unwrap(byArray, n, n2, messageProp);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        this.selectedCtx.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_CONTEXT);
        }
        return this.selectedCtx.wrap(byArray, n, n2, messageProp);
    }

    private void initialiseData() throws GSSException {
        this.processNames();
        this.initMechData();
        if (this.isSSO) {
            this.rejectNonSSOmechs();
        }
    }

    private void rejectNonSSOmechs() {
        String string = null;
        ListArray listArray = this.mechList.getNegMechList();
        logger.info("Informations about mechanism local: \n");
        for (int i = 0; i < listArray.size(); ++i) {
            NegMech negMech = (NegMech)listArray.get(i);
            if (negMech.getMechType().equals(this.KRB5_OID)) continue;
            negMech.setNegMechState(3);
            negMech.setNegMechReason(7);
            negMech.setMajorStatus(11);
            negMech.setMinStatus(TdnegoMinorStatus.TDNEGO_ERR_INT_FAILURE.getErrorCode());
            negMech.setMinorText(TdnegoMinorStatus.TDNEGO_ERR_INT_FAILURE.getErrorMessage());
            negMech.setContext(null);
            string = this.getNegLog(negMech);
            logger.info(string);
        }
    }

    private void initMechData() throws GSSException {
        Oid oid = null;
        String string = null;
        Enumeration enumeration = this.mechObjs.elements();
        this.mechList = new NegMechList();
        GSSCredential gSSCredential = null;
        GSSContext gSSContext = null;
        logger.info("Informations about mechanism local: \n");
        while (enumeration.hasMoreElements()) {
            NegMech negMech;
            block7: {
                GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
                oid = gSSMechanism.getMech();
                negMech = new NegMech();
                negMech.setMechType(oid);
                negMech.setNegMechState(1);
                negMech.setNegMechReason(1);
                if (this.authID == null && oid.equals(this.KRB5_OID)) {
                    this.isSSO = true;
                }
                try {
                    Object object = this.credential.getCredForMech(oid);
                    if (object instanceof GSSCredential) {
                        gSSCredential = (GSSCredential)this.credential.getCredForMech(oid);
                    } else if (object instanceof GSSException) {
                        throw (GSSException)object;
                    }
                    gSSContext = gSSMechanism.getContextForInit(gSSCredential, (GSSName)this.targetName.getNameForMech(oid), this.lifetime, this.chanBind, this.requestedServices);
                    negMech.setContext(gSSContext);
                }
                catch (GSSException gSSException) {
                    logger.debug("GetContext failed for mechanism: " + this.getNameForOid(oid) + "\n");
                    negMech.setNegMechState(3);
                    negMech.setNegMechReason(3);
                    negMech.setMajorStatus(gSSException.getMajor());
                    negMech.setMinStatus(gSSException.getMinor());
                    negMech.setMinorText(gSSException.getMinorString());
                    if (!this.isSSO || !oid.equals(this.KRB5_OID)) break block7;
                    throw new TdgssException(9, TdnegoMinorStatus.TDNEGO_ERR_BAD_CRED_USAGE);
                }
            }
            negMech.setContext(gSSContext);
            negMech.setContextEstablished(false);
            string = this.getNegLog(negMech);
            logger.info(string);
            this.mechList.add(negMech);
        }
    }

    private void processNames() {
        GSSName gSSName = null;
        Oid oid = null;
        ListArray listArray = this.credential.returnNames();
        for (int i = 0; i < listArray.size(); ++i) {
            String[] stringArray;
            int n;
            gSSName = (GSSName)listArray.get(i);
            String string = ((Object)gSSName).toString();
            try {
                oid = gSSName.getStringNameType();
            }
            catch (GSSException gSSException) {
                logger.info(gSSException.getMessage());
            }
            if (oid.equals(TdnegoMechanism.GSS_C_NT_TDAT_USER)) {
                this.authID = string;
                continue;
            }
            if (oid.equals(TdnegoMechanism.GSS_C_NT_TDAT_PASSWORD)) continue;
            String string2 = string;
            Object var8_8 = null;
            if (string2 == null) continue;
            StringBuffer stringBuffer = new StringBuffer(string2);
            String[] stringArray2 = new String[]{"user=", "profile=", "authcid="};
            char c = '\u0000';
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < stringArray2.length; ++n) {
                int n2;
                stringArray = stringArray2[n];
                bl = false;
                bl2 = false;
                int n3 = string2.indexOf((String)stringArray);
                if (n3 == -1) continue;
                if (string2.charAt(n3 + stringArray.length()) == '\'' || string2.charAt(n3 + stringArray.length()) == '\"') {
                    c = string2.charAt(n3 + stringArray.length());
                    bl = true;
                }
                for (n2 = n3 + stringArray.length() + 1; n2 < string2.length(); ++n2) {
                    if (!bl || c != string2.charAt(n2)) continue;
                    bl2 = true;
                    break;
                }
                int n4 = bl2 ? n2 + 1 : (string2.indexOf(32, n3) == -1 ? string2.length() : string2.indexOf(32, n3));
                String string3 = string2.substring(n3, n4);
                int n5 = 0;
                if (string3 != null) {
                    n5 = string3.indexOf("user=");
                    if (n5 != -1) {
                        this.userID = string3.substring(n5 + 5);
                    }
                    if ((n5 = string3.indexOf("profile=")) != -1) {
                        this.profileID = string3.substring(n5 + 8);
                    }
                    if ((n5 = string3.indexOf("authcid=")) != -1) {
                        this.authID = string3.substring(n5 + 8);
                    }
                }
                stringBuffer.delete(stringBuffer.indexOf(string3), stringBuffer.indexOf(string3) + string3.length());
            }
            if (stringBuffer.length() > 0) {
                string2 = new String(stringBuffer).trim();
            }
            if ((n = string2.indexOf("@@")) != -1) {
                stringArray = string2.split("@@");
                this.authID = stringArray[0];
                continue;
            }
            this.authID = string2;
        }
    }

    private String getNegLog(NegMech negMech) {
        String[] stringArray = new String[]{"Invalid", "Available", "Selected", "Rejected"};
        String[] stringArray2 = new String[]{"Invalid", "Available", "GSSAPI Error", "Not Available at Client", "Not Available at Server", "Due to Policy", "Due to Rank", "Single Sign-On Required", "Authentication ID not Available"};
        String[] stringArray3 = new String[]{"Invalid", "Completed", "Incomplete", "Reject", "Request MIC"};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Record:\n");
        if (null != negMech) {
            stringBuffer.append("    Mechanism:            " + this.getNameForOid(negMech.getMechType()) + "\n");
            stringBuffer.append("    MechState:            " + stringArray[negMech.getNegMechState()] + "\n");
            if (negMech.isMechReasonSet()) {
                stringBuffer.append("    MechReason:           " + stringArray2[negMech.getNegMechState()] + "\n");
            }
            if (negMech.isMajorStatusSet()) {
                stringBuffer.append("    MajorStatus:          " + negMech.getMajorStatus() + "\n");
            }
            if (negMech.isMinorStatusSet()) {
                stringBuffer.append("    MinorStatus:          " + negMech.getMinStatus() + "\n");
            }
            if (negMech.isMinorTextSet()) {
                stringBuffer.append("    MinorStatusText       " + negMech.getMinorText() + "\n");
            }
            if (negMech.isContextEstablished()) {
                stringBuffer.append("    IsContextEstablished: TRUE\n");
            } else {
                stringBuffer.append("    IsContextEstablished: FALSE\n");
            }
        }
        if (this.isPolicyAppiled) {
            stringBuffer.append("    IsPolicyApplied:      TRUE\n");
        } else {
            stringBuffer.append("    IsPolicyApplied:      FALSE\n");
        }
        stringBuffer.append("    NegState:             " + stringArray3[this.negState] + "\n");
        stringBuffer.append("    NegStatefrompeer:     " + stringArray3[this.negStateFromPeer] + "\n");
        return stringBuffer.toString();
    }

    private byte[] buildRespToken(byte[] byArray, int n, int n2) throws GSSException {
        NegMech negMech;
        Object object;
        int n3;
        byte[] byArray2 = null;
        NegTokenResp negTokenResp = new NegTokenResp();
        DER dER = null;
        if (byArray == null) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        dER = new DER(byArray, true);
        if (dER != null) {
            negTokenResp.parseDERObject(dER);
        }
        this.respMechList = negTokenResp.getNegMechList();
        if (this.respMechList == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        int n4 = this.respMechList.getNegMechList().size();
        this.negStateFromPeer = negTokenResp.getNegState();
        this.isPolicyAppiled = negTokenResp.getNegPolicyApplied();
        boolean bl = negTokenResp.isNegMechSelected();
        Oid oid = null;
        if (bl) {
            oid = negTokenResp.getNegMechSelected();
        }
        logger.info("Information on mechanisms from peer\n");
        for (n3 = 0; n3 < n4; ++n3) {
            object = (NegMech)this.respMechList.getNegMechList().get(n3);
            String string = this.getNegLog((NegMech)object);
            logger.info(string);
        }
        n3 = this.initToken.getNegMechList().getNegMechList().size();
        object = this.initToken.getNegMechList();
        if (this.negStateFromPeer == 1 && oid != null) {
            for (int i = 0; i < n3; ++i) {
                negMech = (NegMech)this.initToken.getNegMechList().getNegMechList().get(i);
                if (!negMech.getMechType().equals(oid)) continue;
                logger.info("Negotiation context established\n");
                this.selectedCtx = negMech.getContext();
                for (int j = 0; j < n4; ++j) {
                    byte[] byArray3;
                    NegMech negMech2 = (NegMech)this.respMechList.getNegMechList().get(j);
                    if (!negMech.getMechType().equals(negMech2.getMechType()) || (byArray3 = negMech2.getMechToken()) == null || byArray3.length == 0) continue;
                    byArray2 = this.selectedCtx.initSecContext(byArray3, 0, byArray3.length);
                }
                negMech.setContextEstablished(true);
                this.negState = 1;
                return byArray2;
            }
        }
        if (this.negStateFromPeer == 3) {
            logger.info("Negotiation context establishment failed\n");
            throw new TdgssException(12, TdnegoMinorStatus.TDNEGO_ERR_NO_MECH_SELECTED);
        }
        if (this.negStateFromPeer == 2) {
            for (int i = 0; i < n4; ++i) {
                negMech = (NegMech)this.respMechList.getNegMechList().get(i);
                this.formRespMechList(negMech);
            }
        }
        NegTokenResp negTokenResp2 = new NegTokenResp();
        negTokenResp2.setNegState(2);
        if (object != null) {
            logger.info("Information on mechanisms local\n");
            for (int i = 0; i < ((NegMechList)object).getNegMechList().size(); ++i) {
                NegMech negMech3 = (NegMech)((NegMechList)object).getNegMechList().get(i);
                String string = this.getNegLog(negMech3);
                logger.info(string);
            }
            negTokenResp2.setNegMechList((NegMechList)object);
            byArray2 = negTokenResp2.getDERObject().getEncodedValue(true);
        }
        return byArray2;
    }

    private void formRespMechList(NegMech negMech) {
        int n = this.initToken.getNegMechList().getNegMechList().size();
        NegMechList negMechList = this.initToken.getNegMechList();
        for (int i = 0; i < n; ++i) {
            NegMech negMech2 = (NegMech)negMechList.getNegMechList().get(i);
            Oid oid = negMech2.getMechType();
            Oid oid2 = negMech.getMechType();
            if (!oid2.equals(oid)) continue;
            if (1 == negMech.getNegMechState()) {
                byte[] byArray = new byte[]{};
                logger.info("InitSecContext:" + this.tokenNumber + 1 + "\n");
                byte[] byArray2 = negMech.getMechToken();
                if (byArray2 == null) continue;
                GSSContext gSSContext = negMech2.getContext();
                try {
                    byArray = gSSContext.initSecContext(byArray2, 0, byArray2.length);
                    negMech2.setMechToken(byArray);
                }
                catch (GSSException gSSException) {
                    negMech2.setNegMechState(3);
                    negMech2.setNegMechReason(2);
                    negMech2.setMajorStatus(gSSException.getMajor());
                    negMech2.setMinStatus(gSSException.getMinor());
                    negMech2.setMinorText(gSSException.getMinorString());
                    logger.info("InitSecContext:1 falied for" + this.getNameForOid(negMech2.getMechType()) + "\n");
                }
                continue;
            }
            negMech2.setNegMechState(3);
            negMech2.setNegMechReason(4);
        }
    }

    private byte[] buildInitToken(byte[] byArray, int n, int n2) throws GSSException {
        NegMech negMech = null;
        int n3 = 0;
        byte[] byArray2 = null;
        if (this.mechList.getNegMechList() == null) {
            logger.info("No mechanism is avilable for negotiation\n");
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        n3 = this.mechList.getNegMechList().size();
        for (int i = 0; i < n3; ++i) {
            Object object;
            Object object2;
            byte[] byArray3 = null;
            negMech = (NegMech)this.mechList.getNegMechList().get(i);
            if (negMech.getNegMechState() != 1) continue;
            Oid oid = negMech.getMechType();
            GSSContext gSSContext = negMech.getContext();
            if (gSSContext != null) {
                logger.info("InitContext:1 called  for" + this.getNameForOid(oid) + "\n");
                try {
                    byArray3 = gSSContext.initSecContext(byArray, n, n2);
                }
                catch (GSSException gSSException) {
                    logger.info("InitSecContext:1 falied for" + this.getNameForOid(oid) + "\n");
                    negMech.setNegMechState(3);
                    negMech.setNegMechReason(2);
                    negMech.setMajorStatus(gSSException.getMajor());
                    negMech.setMinStatus(gSSException.getMinor());
                    negMech.setMinorText(gSSException.getMinorString());
                }
                if (this.isSSO) {
                    object2 = (GssContext)gSSContext;
                    object = ((GssContext)object2).getCredential();
                    if (object == null) {
                        throw new TdgssException(13, TdnegoMinorStatus.TDNEGO_ERR_MISSING_AUTHENTICATION_ID);
                    }
                    this.authID = ((Object)object.getName()).toString();
                    negMech.setSsoAuthID(this.authID);
                }
            }
            if (byArray3 != null && byArray3.length > 0) {
                logger.info("InitSecContext1 succeeded for" + this.getNameForOid(oid) + "\n");
                logger.info("Continue needed for mechanism to establish context\n");
            }
            object2 = new byte[4];
            System.arraycopy(byArray3, byArray3.length - 5, object2, 0, ((byte[])object2).length);
            object = new BigInteger((byte[])object2);
            int n4 = ((BigInteger)object).intValue();
            byte[] byArray4 = new byte[byArray3.length - n4];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            negMech.setMechToken(byArray4);
            String string = this.getNegLog(negMech);
            logger.info(string);
        }
        if (this.mechList.getNegMechList().size() >= 1) {
            this.initToken = new NegTokenInit();
            this.initToken.setNegState(this.negState);
            this.initToken.setNegMechList(this.mechList);
            if (this.profileID != null) {
                this.initToken.setProfileName(this.profileID);
            }
            if (this.userID != null) {
                this.initToken.setUserName(this.userID);
            }
            this.initToken.setAuthenticationID(this.authID);
            if (this.isSSO) {
                this.initToken.setSSO(this.isSSO);
            }
        } else {
            logger.info("No mechanism is avilable for negotiation\n");
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NO_MECHS_AVAILABLE);
        }
        byArray2 = this.initToken.getDERObject().getEncodedValue();
        byte[] byArray5 = new byte[byArray2.length + TDNEGO_TRAILER.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(TDNEGO_TRAILER, 0, byArray5, byArray2.length, TDNEGO_TRAILER.length);
        return byArray5;
    }
}

