/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jgssp2td2.Td2MinorStatus;
import com.teradata.tdgss.jgssp2td2.Td2Token;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public final class Td2Crypto {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private SecretKey secretKey;
    private byte[] key;
    private byte[] hSecretKey;
    private AlgQop algQop;
    private String encAlg;
    private String mode;
    private String padding;
    private String micAlg;
    private int peerCapabilities;
    private MessageDigest wrapDigest;
    private MessageDigest unwrapDigest;
    private MessageDigest getMicDigest;
    private MessageDigest verifyMicDigest;

    public Td2Crypto(SecretKey secretKey, byte[] byArray, AlgQop algQop, int n) throws GSSException {
        this.secretKey = secretKey;
        this.key = byArray;
        this.algQop = algQop;
        this.hSecretKey = null;
        this.encAlg = algQop.getConfidentialityAlgorithm();
        this.mode = algQop.getMode();
        this.padding = algQop.getPadding();
        this.micAlg = algQop.getIntegrityAlgorithm();
        this.peerCapabilities = n;
        try {
            this.wrapDigest = MessageDigest.getInstance(this.micAlg);
            this.unwrapDigest = MessageDigest.getInstance(this.micAlg);
            this.getMicDigest = MessageDigest.getInstance(this.micAlg);
            this.verifyMicDigest = MessageDigest.getInstance(this.micAlg);
        }
        catch (Exception exception) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL, exception);
        }
    }

    public void computeKeyHash() throws GSSException {
        if ((this.peerCapabilities & 1) == 1) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.micAlg);
                messageDigest.update(this.key, 0, this.key.length);
                this.hSecretKey = messageDigest.digest();
                logger.debug("The Secret Key hash is ************************", this.hSecretKey);
            }
            catch (Exception exception) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL, exception);
            }
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        boolean bl = false;
        byte[] byArray2 = new byte[]{};
        logger.debug("Entering!");
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            logger.debug("Token Header is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.wrapDigest == null) {
            logger.debug("Wrap digest argument is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((td2Token.getFlags() & 4) == 4) {
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            this.wrapDigest.update(byArray, n, n2);
            byte[] byArray3 = this.wrapDigest.digest();
            int n3 = n2 + byArray3.length;
            if (!bl) {
                byte[] byArray4 = new byte[n3 + 16];
                td2Token.setMsgLength(n3);
                byte[] byArray5 = td2Token.GetTokenBytes();
                System.arraycopy(byArray, n, byArray4, 0, n2);
                System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
                System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
                byArray2 = byArray4;
            } else {
                int n4;
                byte[] byArray6;
                String string = this.encAlg + "/" + this.mode + "/" + this.padding;
                byte[] byArray7 = new byte[n3];
                System.arraycopy(byArray, n, byArray7, 0, n2);
                System.arraycopy(byArray3, 0, byArray7, n2, byArray3.length);
                int n5 = byArray7.length;
                try {
                    Cipher cipher = Cipher.getInstance(string);
                    if (this.padding.equalsIgnoreCase("NoPadding")) {
                        int n6 = cipher.getBlockSize();
                        n5 = byArray7.length / n6 * n6;
                    }
                    if (this.mode.equalsIgnoreCase("ECB")) {
                        cipher.init(1, this.secretKey);
                    } else {
                        byte[] byArray8 = new byte[cipher.getBlockSize()];
                        for (int i = 0; i < byArray8.length; ++i) {
                            byArray8[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray8);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    byArray6 = cipher.doFinal(byArray7, 0, n5);
                    n4 = byArray6.length;
                }
                catch (Exception exception) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
                }
                td2Token.setMsgLength(n4);
                byte[] byArray9 = td2Token.GetTokenBytes();
                byArray2 = new byte[n4 + 16];
                System.arraycopy(byArray6, 0, byArray2, 0, byArray6.length);
                System.arraycopy(byArray9, 0, byArray2, byArray6.length, byArray9.length);
            }
        } else if ((this.peerCapabilities & 1) == 1) {
            if (this.hSecretKey == null) {
                logger.debug("Hash of the secret key is null");
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
            }
            int n7 = n2 + this.hSecretKey.length;
            td2Token.setMsgLength(n7 + 16);
            byte[] byArray10 = new byte[n7 + 16];
            System.arraycopy(byArray, n, byArray10, 0, n2);
            System.arraycopy(this.hSecretKey, 0, byArray10, n2, this.hSecretKey.length);
            if (!bl) {
                byte[] byArray11 = td2Token.GetTokenBytes();
                System.arraycopy(byArray11, 0, byArray10, n7, byArray11.length);
                this.wrapDigest.update(byArray10);
                byte[] byArray12 = this.wrapDigest.digest();
                System.arraycopy(byArray12, 0, byArray10, n2, byArray12.length);
                byArray2 = byArray10;
            } else {
                byte[] byArray13;
                int n8;
                String string = this.encAlg + "/" + this.mode + "/" + this.padding;
                int n9 = byArray10.length;
                byte[] byArray14 = td2Token.GetTokenBytes();
                try {
                    Cipher cipher = Cipher.getInstance(string);
                    if (this.padding.equalsIgnoreCase("NoPadding")) {
                        int n10 = cipher.getBlockSize();
                        n9 = byArray10.length / n10 * n10;
                    }
                    if (this.mode.equalsIgnoreCase("ECB")) {
                        cipher.init(1, this.secretKey);
                    } else {
                        byArray14 = td2Token.GetTokenBytes();
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    n8 = cipher.getOutputSize(n9);
                    td2Token.setMsgLength(n8);
                    byArray14 = td2Token.GetTokenBytes();
                    System.arraycopy(byArray14, 0, byArray10, n7, byArray14.length);
                    this.wrapDigest.update(byArray10);
                    byte[] byArray15 = this.wrapDigest.digest();
                    System.arraycopy(byArray15, 0, byArray10, n2, byArray15.length);
                    if (!this.mode.equalsIgnoreCase("ECB")) {
                        byArray14 = td2Token.GetTokenBytes();
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                    }
                    byArray13 = cipher.doFinal(byArray10, 0, n9);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
                }
                catch (Exception exception) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
                }
                byArray2 = new byte[n8 + 16];
                System.arraycopy(byArray13, 0, byArray2, 0, byArray13.length);
                System.arraycopy(byArray14, 0, byArray2, byArray13.length, byArray14.length);
            }
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        logger.debug("Leaving!");
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        boolean bl = false;
        byte[] byArray2 = new byte[]{};
        int n3 = 0;
        logger.debug("Entering!");
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            logger.debug("Input argument is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            logger.debug("Token Header is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.unwrapDigest == null) {
            logger.debug("Unwrap digest is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((td2Token.getFlags() & 4) == 4) {
            bl = true;
        }
        n3 = this.unwrapDigest.getDigestLength();
        if (this.peerCapabilities == 0) {
            if (td2Token.getVersion() != 1 || td2Token.getMsgType() != 3) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
            }
            if (!bl) {
                int n4 = n2 - n3 - 16;
                byte[] byArray3 = new byte[n4];
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray, n, byArray3, 0, n4);
                System.arraycopy(byArray, n + n4, byArray4, 0, n3);
                if (!this.verifyHash(byArray3, byArray4, this.unwrapDigest)) {
                    throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
                }
                byArray2 = byArray3;
            } else {
                byte[] byArray5 = new byte[n2 - 16];
                byte[] byArray6 = new byte[]{};
                String string = this.encAlg + "/" + this.mode + "/" + this.padding;
                System.arraycopy(byArray, n, byArray5, 0, n2 - 16);
                try {
                    Cipher cipher = Cipher.getInstance(string);
                    byte[] byArray7 = new byte[cipher.getBlockSize()];
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                    cipher.init(2, (Key)this.secretKey, ivParameterSpec);
                    byArray6 = cipher.doFinal(byArray5, 0, byArray5.length);
                }
                catch (Exception exception) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
                }
                int n5 = byArray6.length - n3;
                byte[] byArray8 = new byte[n5];
                byte[] byArray9 = new byte[n3];
                System.arraycopy(byArray6, 0, byArray8, 0, n5);
                System.arraycopy(byArray6, n5, byArray9, 0, n3);
                if (!this.verifyHash(byArray8, byArray9, this.unwrapDigest)) {
                    throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
                }
                byArray2 = byArray8;
            }
        } else if ((this.peerCapabilities & 1) == 1) {
            if (td2Token.getVersion() != 3 || td2Token.getMsgType() != 7) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
            }
            if (!bl) {
                byte[] byArray10 = (byte[])byArray.clone();
                byte[] byArray11 = new byte[n3];
                int n6 = n2 - n3 - 16;
                System.arraycopy(this.hSecretKey, 0, byArray10, n6, this.hSecretKey.length);
                System.arraycopy(byArray, n + n6, byArray11, 0, n3);
                if (!this.verifyHash(byArray10, byArray11, this.unwrapDigest)) {
                    throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
                }
                byArray2 = new byte[n6];
                System.arraycopy(byArray10, 0, byArray2, 0, n6);
            } else {
                byte[] byArray12;
                byte[] byArray13 = new byte[n2 - 16];
                byte[] byArray14 = new byte[16];
                String string = this.encAlg + "/" + this.mode + "/" + this.padding;
                System.arraycopy(byArray, n, byArray13, 0, n2 - 16);
                System.arraycopy(byArray, n + n2 - 16, byArray14, 0, 16);
                try {
                    Cipher cipher = Cipher.getInstance(string);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray14);
                    cipher.init(2, (Key)this.secretKey, ivParameterSpec);
                    byArray12 = cipher.doFinal(byArray13, 0, byArray13.length);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
                }
                catch (Exception exception) {
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
                }
                for (int i = 0; i < 16; ++i) {
                    byte by = byArray12[byArray12.length - 16 + i];
                    if (by == byArray14[i]) continue;
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL);
                }
                byte[] byArray15 = (byte[])byArray12.clone();
                byte[] byArray16 = new byte[n3];
                int n7 = byArray12.length - n3 - 16;
                System.arraycopy(this.hSecretKey, 0, byArray15, n7, n3);
                System.arraycopy(byArray12, n7, byArray16, 0, n3);
                if (!this.verifyHash(byArray15, byArray16, this.unwrapDigest)) {
                    throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
                }
                byArray2 = new byte[n7];
                System.arraycopy(byArray15, 0, byArray2, 0, n7);
            }
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        logger.debug("Leaving!");
        return byArray2;
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        byte[] byArray2 = new byte[]{};
        logger.debug("Entering!");
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            logger.debug("Token Header is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.getMicDigest == null) {
            logger.debug("Get MIC digest is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if (this.peerCapabilities == 0) {
            this.getMicDigest.update(byArray, n, n2);
            byte[] byArray3 = this.getMicDigest.digest();
            int n3 = byArray3.length;
            byte[] byArray4 = new byte[n3 + 16];
            td2Token.setMsgLength(n3);
            byte[] byArray5 = td2Token.GetTokenBytes();
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
            byArray2 = byArray4;
        } else if ((this.peerCapabilities & 1) == 1) {
            int n4 = this.getMicDigest.getDigestLength();
            int n5 = n2 + this.hSecretKey.length;
            td2Token.setMsgLength(n4);
            byte[] byArray6 = new byte[n5 + 16];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            System.arraycopy(this.hSecretKey, 0, byArray6, n2, this.hSecretKey.length);
            byte[] byArray7 = td2Token.GetTokenBytes();
            System.arraycopy(byArray7, 0, byArray6, n5, byArray7.length);
            this.getMicDigest.update(byArray6);
            byte[] byArray8 = this.getMicDigest.digest();
            byArray2 = new byte[n4 + 16];
            System.arraycopy(byArray8, 0, byArray2, 0, byArray8.length);
            System.arraycopy(byArray7, 0, byArray2, byArray8.length, 16);
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        logger.debug("Leaving!");
        return byArray2;
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        logger.debug("Entering!");
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            logger.debug("Input length is larger than buffer size ");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        int n5 = this.verifyMicDigest.getDigestLength();
        if (this.peerCapabilities == 0) {
            if (td2Token.getVersion() != 1 || td2Token.getMsgType() != 4) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
            }
            byte[] byArray3 = new byte[n5];
            byte[] byArray4 = new byte[n4];
            System.arraycopy(byArray, n, byArray3, 0, n5);
            System.arraycopy(byArray2, n3, byArray4, 0, n4);
            if (!this.verifyHash(byArray4, byArray3, this.verifyMicDigest)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
        } else if ((this.peerCapabilities & 1) == 1) {
            if (td2Token.getVersion() != 3 || td2Token.getMsgType() != 8) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
            }
            int n6 = n4 + n5 + 16;
            byte[] byArray5 = new byte[n5];
            byte[] byArray6 = new byte[n6];
            byte[] byArray7 = td2Token.GetTokenBytes();
            System.arraycopy(byArray, n, byArray5, 0, n5);
            System.arraycopy(byArray2, n3, byArray6, 0, n4);
            System.arraycopy(this.hSecretKey, 0, byArray6, n4, this.hSecretKey.length);
            System.arraycopy(byArray7, 0, byArray6, n6 - 16, 16);
            if (!this.verifyHash(byArray6, byArray5, this.verifyMicDigest)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        logger.debug("Leaving!");
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        int n3;
        logger.debug("Entering!");
        int n4 = 0;
        if (n2 < 16) {
            return 0;
        }
        if (bl) {
            n3 = this.getMaxInputLength(n2 - 16);
            n4 = n3 > 16 ? n3 : 0;
            if (n4 > 16) {
                n4 -= 16;
            }
        } else {
            n4 = n2 - 16;
        }
        n3 = this.wrapDigest.getDigestLength();
        if (n4 > n3) {
            n4 -= n3;
        }
        logger.debug("Leaving!");
        return n4;
    }

    private int getMaxInputLength(int n) throws GSSException {
        String string = this.encAlg + "/" + this.mode + "/" + this.padding;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            Cipher cipher = Cipher.getInstance(string);
            if (this.mode.equalsIgnoreCase("ECB")) {
                cipher.init(1, this.secretKey);
            } else {
                byte[] byArray = new byte[cipher.getBlockSize()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = 0;
                }
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                cipher.init(1, (Key)this.secretKey, ivParameterSpec);
            }
            n3 = cipher.getBlockSize();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
        }
        catch (Exception exception) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
        }
        n2 = 0;
        n4 = n;
        if (this.mode.equalsIgnoreCase("CBC")) {
            if (n4 < n3) {
                n2 = 0;
            } else {
                n5 = n4 % n3;
                n2 = this.padding.equalsIgnoreCase("NoPadding") ? n4 - n5 : (this.padding.equalsIgnoreCase("PKCS5Padding") ? n4 - (n3 + n5) : 0);
            }
        } else if (this.mode.equalsIgnoreCase("CFB") || this.mode.equalsIgnoreCase("OFB")) {
            n5 = n4 >= n3 ? n4 % n3 : 0;
            n2 = this.padding.equalsIgnoreCase("NoPadding") ? n4 : (this.padding.equalsIgnoreCase("PKCS5Padding") ? (n4 >= n3 ? n4 - (n5 + 1) : 0) : 0);
        } else {
            n2 = 0;
        }
        return n2;
    }

    private boolean verifyHash(byte[] byArray, byte[] byArray2, MessageDigest messageDigest) {
        messageDigest.update(byArray);
        byte[] byArray3 = messageDigest.digest();
        if (byArray3.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

