/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.AlgQopDer;
import com.teradata.tdgss.jgssp2td2.Td2Credential;
import com.teradata.tdgss.jgssp2td2.Td2Crypto;
import com.teradata.tdgss.jgssp2td2.Td2DH;
import com.teradata.tdgss.jgssp2td2.Td2Mechanism;
import com.teradata.tdgss.jgssp2td2.Td2MinorStatus;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import com.teradata.tdgss.jgssp2td2.Td2Token;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jgssp2td2.Td2Version;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class Td2Context
implements GSSContext {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private static final short maxshort = Short.MAX_VALUE;
    private int msgsequence = 0;
    private byte server_client = 1;
    private byte contextInit = 0;
    private TdgssVersion mylibraryversion;
    private Td2Version mymethodversion;
    private byte myendien = 1;
    private boolean protReady = false;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] masterKey = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    private boolean initiator;
    private Td2Credential credential;
    private Td2Name targetName;
    private int lifetime;
    private short requestedServices;
    private Td2DH DH;
    private byte[] TrailerBytes;
    private static String[] QOPComp;
    private static Integer[] QOPValues;
    private int publicKeyLength;
    private byte[] publicKeybuf;
    private AlgQop legacyQop;
    private AlgQop[] globalQops;
    private static final int MAXMSGSEQUENCESERVER = 1;
    private int MAXMSGSEQUENCECLIENT = 2;
    private static final int HEADERLEN = 16;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int VERIFYDHKEY = 32;
    private static final int PARCEL_LENGTH = 36;
    private static final int KEY_DATA = 80;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final int INITMSGLEN = 64;
    private int verifyDHKey;
    static final String[] msgexttxt;
    private BigInteger mySeqNum = new BigInteger("1");
    private BigInteger peerSeqNum = new BigInteger("1");
    private int peerCapabilities = 0;
    private Td2Crypto[] td2Crypto = new Td2Crypto[4];

    public Td2Context(Td2Credential td2Credential, Object[] objectArray) throws GSSException {
        this.initiator = false;
        this.credential = td2Credential;
        this.requestedServices = (short)98;
        this.InitialiseData();
    }

    public Td2Context(Td2Credential td2Credential, Td2Name td2Name, int n, Object[] objectArray, short s) throws GSSException {
        this.initiator = true;
        this.credential = td2Credential;
        this.targetName = td2Name;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Td2Version InquireMethodVersion() {
        Td2Version td2Version = new Td2Version();
        return td2Version;
    }

    private void InitialiseData() throws GSSException {
        this.msgsequence = 0;
        this.mylibraryversion = Td2Context.InquireLibraryVersion();
        this.mymethodversion = Td2Context.InquireMethodVersion();
        this.myendien = 1;
        this.mycbmaxtoken = 80;
        this.DH = new Td2DH();
        if (QOPComp == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_BIN_FILE_NAME_BAD);
        }
        this.TrailerBytes = this.GetTrailerBytes();
    }

    private Td2Token ValidateMsgInfo(byte[] byArray, int n, int n2) throws GSSException {
        boolean bl;
        if (n2 <= 16) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        Td2Token td2Token = new Td2Token(byArray2, 0);
        byte by = td2Token.getVersion();
        byte by2 = td2Token.getMsgType();
        byte by3 = td2Token.getByteVar();
        if (by == 1 && (by2 != 3 && by2 != 4 || by3 != 2)) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        if (by == 3 && by2 != 7 && by2 != 8) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        boolean bl2 = bl = (td2Token.getFlags() & 4) == 4;
        if (by == 3 && by2 == 7 && !bl ? n2 != td2Token.getMsgLength() : n2 != td2Token.getMsgLength() + 16) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        return td2Token;
    }

    public String[] ParseQOP(int n) throws GSSException {
        return QOPComp;
    }

    private byte[] GetTrailerBytes() throws GSSException {
        byte[] byArray = null;
        byte[] byArray2 = this.getMech().getDER();
        String string = "0.0." + QOPValues[0] + "." + QOPValues[1] + "." + QOPValues[2] + "." + QOPValues[3] + "." + QOPValues[4] + ".0";
        Oid oid = new Oid(string);
        byte[] byArray3 = oid.getDER();
        byArray = new byte[byArray2.length + 1 + byArray3.length - 1 + 1 + 4 + 1];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        byArray[byArray2.length] = 70;
        System.arraycopy(byArray3, 1, byArray, byArray2.length + 1, byArray3.length - 1);
        byArray[byArray2.length + 1 + byArray3.length - 1] = 1;
        byte[] byArray4 = Td2Util.inttobytearray(byArray.length);
        System.arraycopy(byArray4, 0, byArray, byArray2.length + byArray3.length + 1, 4);
        byArray[byArray2.length + byArray3.length + 1 + 4] = 1;
        return byArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        logger.debug("We will initiate the handshake now...");
        logger.debug("Trailer Bytes :");
        byArray2 = this.TrailerBytes;
        if (byArray2 == null) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_TRAILERERROR);
        }
        byte[] byArray3 = AlgParcel.getCipherSuitesParcel();
        int n = byArray3.length;
        logger.debug("", byArray2);
        int n2 = this.mycbmaxtoken + n + byArray2.length;
        byArray = new byte[n2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        Td2Token td2Token = new Td2Token(1, by, 1, this.isserver() ? (byte)1 : 0, 5, 0, 0, 64 + n, null);
        byte[] byArray4 = td2Token.GetTokenBytes();
        System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        byte[] byArray5 = Td2Util.inttobytearray(n);
        System.arraycopy(byArray5, 0, byArray, 36, byArray5.length);
        System.arraycopy(byArray3, 0, byArray, this.mycbmaxtoken, n);
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken + n, byArray2.length);
        logger.debug("Successfully generated first message as", byArray);
        return byArray;
    }

    private void ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = new byte[4];
        logger.debug("Receiving and processing first message");
        if (n != 0) {
            logger.debug("Only offset = 0 is allowed!");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_OFFSET_NOT_ZERO);
        }
        Td2Token td2Token = new Td2Token(byArray, n);
        this.mytargetendien = (td2Token.getFlags() & 2) == 2 ? (byte)1 : 0;
        logger.debug("Checking target endien as " + this.mytargetendien);
        if (this.byteflipneeded()) {
            logger.debug("We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            logger.debug("*** Illegal library version *** ");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_VERSION_MISMATCH);
        }
        if (td2Token.getMsgType() != 1 && td2Token.getMsgType() != 2 || td2Token.getByteVar() != 1) {
            logger.debug(" Message header is not proper");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        System.arraycopy(byArray, 32, byArray2, 0, 4);
        this.verifyDHKey = Td2Util.ByteAtoInt(byArray2);
        this.peerCapabilities = td2Token.getCapabilities();
        logger.debug("verifyDHKey= " + this.verifyDHKey);
        logger.debug("The received message is OK!");
    }

    private void ExtractKeys(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = null;
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = Td2Util.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = Td2Util.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray7, 0, 4);
        int n5 = Td2Util.ByteAtoInt(byArray7);
        byArray6 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray6, 0, n5);
        if ((this.peerCapabilities & 4) == 4) {
            System.arraycopy(byArray, 36, byArray8, 0, 4);
            int n6 = Td2Util.ByteAtoInt(byArray8);
            byArray9 = new byte[n6];
            System.arraycopy(byArray, 80 + n3 + n4 + n5, byArray9, 0, n6);
            object3 = new AlgQopDer(byArray9);
            this.globalQops = new AlgQop[4];
            this.globalQops[0] = ((AlgQopDer)object3).getAlgQop(0);
            this.globalQops[1] = ((AlgQopDer)object3).getAlgQop(1);
            this.globalQops[2] = ((AlgQopDer)object3).getAlgQop(2);
            this.globalQops[3] = ((AlgQopDer)object3).getAlgQop(3);
        } else {
            AlgQop algQop;
            object3 = QOPComp[0];
            String string = QOPComp[1].substring(1);
            int n7 = Integer.parseInt(string);
            String string2 = QOPComp[2];
            object2 = QOPComp[3];
            object = QOPComp[4];
            String string3 = "DH";
            int n8 = 640;
            this.legacyQop = algQop = new AlgQop((String)object3, n7, string2, (String)object2, (String)object, string3, n8);
        }
        logger.debug("Generate DH Parameters ...");
        this.DH.GenerateParameters(1, byArray4, byArray2);
        logger.debug("Generate DH Public Key ...");
        this.publicKeybuf = this.DH.GenerateKey();
        logger.debug("Compute  DH Private Key ...");
        this.masterKey = this.DH.ComputeKey(byArray6);
        logger.debug("The Master Key is ***********************************", this.masterKey);
        this.publicKeyLength = n5;
        if ((this.peerCapabilities & 4) == 4) {
            int n9 = 0;
            for (int i = 0; i < 4; ++i) {
                AlgQop algQop = this.globalQops[i];
                int n10 = algQop.getKeyLength() / 8;
                object2 = new byte[n10];
                System.arraycopy(this.masterKey, n9, object2, 0, n10);
                object = this.DH.BytetoKey(algQop.getConfidentialityAlgorithm(), (byte[])object2, 0, n10);
                this.td2Crypto[i] = new Td2Crypto((SecretKey)object, (byte[])object2, algQop, this.peerCapabilities);
                this.td2Crypto[i].computeKeyHash();
                n9 += n10;
            }
        } else {
            object3 = this.DH.BytetoKey(this.legacyQop.getConfidentialityAlgorithm(), this.masterKey, 0, this.legacyQop.getKeyLength() / 8);
            this.td2Crypto[0] = new Td2Crypto((SecretKey)object3, this.masterKey, this.legacyQop, this.peerCapabilities);
            this.td2Crypto[0].computeKeyHash();
        }
        this.protReady = true;
    }

    private byte[] BuildServerMsg() throws GSSException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 1;
        if ((this.peerCapabilities & 1) == 1) {
            by = 3;
        }
        Td2Token td2Token = new Td2Token(by, 1, 2, this.isserver() ? (byte)1 : 0, 0, 0, 0, this.publicKeyLength, null);
        byte[] byArray3 = td2Token.GetTokenBytes();
        if (this.verifyDHKey > 0) {
            this.MAXMSGSEQUENCECLIENT = 3;
            MessageProp messageProp = new MessageProp(0, true);
            byArray2 = this.wrap(this.masterKey, 0, this.masterKey.length, messageProp);
            byArray = new byte[16 + this.publicKeyLength + byArray2.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, byArray3.length, this.publicKeybuf.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length + this.publicKeybuf.length, byArray2.length);
        } else {
            byArray = new byte[16 + this.publicKeyLength];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, byArray3.length, this.publicKeybuf.length);
        }
        this.publicKeybuf = null;
        logger.debug("The received message is OK!");
        return byArray;
    }

    public void setkey(byte[] byArray) {
        this.masterKey = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        if (this.mytargetendien != this.myendien) {
            logger.debug("target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    logger.debug("We are server! No need to byte-flip!");
                } else {
                    logger.debug("We are client, we have to byte-flip!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        if (!this.byteflipneeded()) {
            logger.debug("No flipping needed!");
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        logger.debug("msgsequence is now " + this.msgsequence);
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                logger.debug("Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.BuildInitMsg((byte)1);
                break;
            }
            case 1: {
                logger.debug("Just receive info-data from server as:", byArray);
                this.ProcessInitMsg(byArray, n, n2);
                this.ExtractKeys(byArray, n, n2);
                byArray2 = this.BuildServerMsg();
                break;
            }
            case 2: {
                logger.debug("Key Match Result From Srvr " + byArray[0]);
                if (byArray[0] == 0) break;
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_KEYMISMATCH);
            }
            default: {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ILLEGAL_SEQUENCE);
            }
        }
        ++this.msgsequence;
        logger.debug("Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                logger.debug("Just receive info-data from client as:", byArray);
                byArray2 = this.BuildInitMsg((byte)2);
                this.ProcessInitMsg(byArray, n, n2);
                break;
            }
            default: {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ILLEGAL_SEQUENCE);
            }
        }
        ++this.msgsequence;
        logger.debug("Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        try {
            n = this.isserver() ? 1 : this.MAXMSGSEQUENCECLIENT;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        logger.debug("Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (!this.isProtReady()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_CONTEXT_NOT_READY);
        }
        n = this.validateQop(n);
        int n3 = this.td2Crypto[n].getWrapSizeLimit(n, bl, n2);
        return n3;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        logger.debug("Entering!");
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        Td2Token td2Token = null;
        if (!this.isProtReady()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (messageProp == null) {
            throw new TdgssException(14, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        n3 = messageProp.getQOP();
        n3 = this.validateQop(n3);
        if (this.getConfState() && messageProp.getPrivacy()) {
            by = (byte)(by | 4);
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            td2Token = new Td2Token(1, 3, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            td2Token = new Td2Token(3, 7, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = this.td2Crypto[n3].wrap(byArray, n, n2, messageProp, td2Token);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (bl) {
            messageProp.setPrivacy(true);
        }
        logger.debug("Leaving!");
        return byArray2;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        BigInteger bigInteger;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        logger.debug("Entering!");
        if (!this.isProtReady()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            logger.debug("Input argument is null");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        Td2Token td2Token = this.ValidateMsgInfo(byArray, n, n2);
        boolean bl5 = (td2Token.getFlags() & 4) == 4;
        if ((this.peerCapabilities & 1) == 1 && 0 != (bigInteger = td2Token.getSeqNumber()).compareTo(this.peerSeqNum)) {
            Td2MinorStatus td2MinorStatus = Td2MinorStatus.TD2_ERR_ILLEGAL_SEQUENCE;
            if (bigInteger.equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, td2MinorStatus.getErrorCode(), td2MinorStatus.getErrorMessage());
            }
        }
        int n3 = td2Token.getQOP();
        n3 = this.validateQop(n3);
        byte[] byArray2 = this.td2Crypto[n3].unwrap(byArray, n, n2, messageProp, td2Token);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (messageProp != null) {
            messageProp.setPrivacy(bl5);
            messageProp.setQOP(n3);
        }
        logger.debug("Leaving!");
        return byArray2;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = 0;
        Td2Token td2Token = null;
        logger.debug("Entering!");
        if (!this.isProtReady()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        byte by = 0;
        if (this.peerCapabilities == 0) {
            td2Token = new Td2Token(1, 4, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null);
        } else if ((this.peerCapabilities & 1) == 1) {
            td2Token = new Td2Token(3, 8, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum);
        } else {
            logger.debug("Unknown peer capabilities");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = this.td2Crypto[n3].getMIC(byArray, n, n2, messageProp, td2Token);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        logger.debug("Leaving!");
        return byArray2;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        BigInteger bigInteger;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        logger.debug("Entering!");
        if (!this.isProtReady()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_CONTEXT_NOT_READY);
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            logger.debug("Argument out of Range");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            logger.debug("Input length  is larger than buffer size ");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        Td2Token td2Token = this.ValidateMsgInfo(byArray, n, n2);
        if ((this.peerCapabilities & 1) == 1 && 0 != (bigInteger = td2Token.getSeqNumber()).compareTo(this.peerSeqNum)) {
            Td2MinorStatus td2MinorStatus = Td2MinorStatus.TD2_ERR_ILLEGAL_SEQUENCE;
            if (bigInteger.equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, td2MinorStatus.getErrorCode(), td2MinorStatus.getErrorMessage());
            }
        }
        int n5 = td2Token.getQOP();
        n5 = this.validateQop(n5);
        this.td2Crypto[n5].verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp, td2Token);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        logger.debug("Leaving!");
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    private int validateQop(int n) throws GSSException {
        if ((this.peerCapabilities & 4) == 4 ? n < 0 || n >= 4 : n != 0) {
            throw new TdgssException(14, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        return n;
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_REQUEST);
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    public boolean getCredDelegState() {
        return false;
    }

    public boolean getMutualAuthState() {
        return false;
    }

    public boolean getReplayDetState() {
        return false;
    }

    public boolean getSequenceDetState() {
        return false;
    }

    public boolean getAnonymityState() {
        return false;
    }

    public boolean getConfState() {
        return this.contextInit != 0;
    }

    public boolean getIntegState() {
        return this.contextInit != 0;
    }

    public int getLifetime() {
        return this.isEstablished() ? this.lifetime : 0;
    }

    public boolean isTransferable() {
        return false;
    }

    public boolean isProtReady() {
        return this.contextInit == 0 ? false : this.protReady;
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return Td2Mechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, Td2MinorStatus.TD2_ERR_API_NOT_SUPPORTED);
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    static {
        msgexttxt = new String[]{"client", "server"};
        TdgssConfigApi tdgssConfigApi = TdgssConfigApi.getInstance();
        if (tdgssConfigApi == null) {
            QOPComp = null;
            QOPValues = null;
        } else {
            try {
                Oid oid = Td2Mechanism.mechOid;
                QOPComp = tdgssConfigApi.GetInforForOID(oid.toString());
            }
            catch (Exception exception) {
                QOPComp = null;
                QOPValues = null;
            }
            if (QOPComp != null) {
                QOPValues = new Integer[5];
                Td2Context.QOPValues[0] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[0]);
                Td2Context.QOPValues[1] = tdgssConfigApi.GetPropertyForLegal("KeyLength", QOPComp[1]);
                Td2Context.QOPValues[2] = tdgssConfigApi.GetPropertyForLegal("Mode", QOPComp[2]);
                Td2Context.QOPValues[3] = tdgssConfigApi.GetPropertyForLegal("Padding", QOPComp[3]);
                Td2Context.QOPValues[4] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[4]);
            }
        }
    }
}

