/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1MinorStatus;
import com.teradata.tdgss.jgssp2td1.Td1Util;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.ietf.jgss.GSSException;

public final class Td1DH {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private static int TDGSS_SHARED_G;
    private static int TDGSS_SHARED_N;
    private byte[] TDGSS_SHARED_G_NEW = null;
    private byte[] TDGSS_SHARED_N_NEW = null;
    private int keysize;
    private int Version = 1;
    private BigInteger[] PrivateKey;
    private BigInteger SharedKey;
    private static final int BITSPERBYTE = 8;
    private int CURRENTKEYBYTES = 52;
    private final int MAXKEYBYTES = 128;
    private final int BYTESININT = 4;
    private final int MAX_EXPONENTIAL = Short.MAX_VALUE;
    private final int sizeofoneset = 4;
    private int num_diffie_hellman_sets;

    public Td1DH(int n, int n2, int n3) {
        this.keysize = n;
        TDGSS_SHARED_G = n2;
        TDGSS_SHARED_N = n3;
        this.num_diffie_hellman_sets = this.keysize / 4;
        this.PrivateKey = new BigInteger[this.num_diffie_hellman_sets];
    }

    public Td1DH(int n, byte[] byArray, byte[] byArray2, int n2) {
        this.Version = n2;
        this.CURRENTKEYBYTES = this.keysize = n;
        this.TDGSS_SHARED_G_NEW = new byte[n];
        System.arraycopy(byArray, 0, this.TDGSS_SHARED_G_NEW, 0, this.keysize);
        this.TDGSS_SHARED_N_NEW = new byte[n];
        System.arraycopy(byArray2, 0, this.TDGSS_SHARED_N_NEW, 0, this.keysize);
    }

    public byte[] makeseed(int n) {
        byte[] byArray = null;
        Integer n2 = new Integer(TDGSS_SHARED_G);
        Integer n3 = new Integer(TDGSS_SHARED_N);
        Integer n4 = new Integer(Short.MAX_VALUE);
        BigInteger bigInteger = new BigInteger(32, new SecureRandom());
        this.PrivateKey[n] = bigInteger = bigInteger.mod(new BigInteger(n4.toString()));
        BigInteger bigInteger2 = new BigInteger(n2.toString());
        bigInteger2 = bigInteger2.modPow(bigInteger, new BigInteger(n3.toString()));
        logger.debug("X = g^x mod n = (" + TDGSS_SHARED_G + ")^ " + bigInteger + " mod (" + TDGSS_SHARED_N + ") = " + bigInteger2 + " = 0x" + bigInteger2.toString(16));
        byArray = this.normalize_key(bigInteger2);
        return byArray;
    }

    public byte[] genseed() throws GSSException {
        byte[] byArray = null;
        int n = 0;
        if (this.keysize >= 128) {
            logger.debug(" *** ERROR! Requesting " + this.keysize + "exceeds max key bytes " + 128);
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ALG_KEY_GEN_FAILURE);
        }
        if (this.Version == 1) {
            int n2;
            logger.debug(" A total of " + this.num_diffie_hellman_sets + " sets of " + 4 + " bytes key = " + this.keysize + " bytes will be generated\n");
            byArray = new byte[this.keysize];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = 0;
            }
            for (n2 = 0; n2 < this.num_diffie_hellman_sets; ++n2) {
                logger.debug("Computing seed number " + n2);
                byte[] byArray2 = this.makeseed(n2);
                System.arraycopy(byArray2, 0, byArray, n, 4);
                n += 4;
            }
        } else {
            BigInteger bigInteger;
            BigInteger bigInteger2 = new BigInteger(1, this.TDGSS_SHARED_N_NEW);
            BigInteger bigInteger3 = new BigInteger(1, this.TDGSS_SHARED_G_NEW);
            SecureRandom secureRandom = new SecureRandom();
            while ((bigInteger = new BigInteger(this.CURRENTKEYBYTES * 8, secureRandom)).compareTo(BigInteger.ZERO) != 1 || bigInteger.compareTo(bigInteger2.subtract(BigInteger.ONE)) != -1) {
            }
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
            logger.debug(" pG =" + bigInteger3 + "pN = " + bigInteger2);
            logger.debug(" x =" + bigInteger + "y = " + bigInteger4);
            this.SharedKey = bigInteger;
            byArray = this.normalize_key(bigInteger4);
            logger.debug("Generated seed with length =" + byArray.length);
        }
        return byArray;
    }

    private byte[] compute_one_key(byte[] byArray, int n) {
        BigInteger bigInteger = new BigInteger(byArray);
        Integer n2 = new Integer(TDGSS_SHARED_N);
        BigInteger bigInteger2 = bigInteger;
        bigInteger2 = bigInteger2.modPow(this.PrivateKey[n], new BigInteger(n2.toString()));
        logger.debug("K  = (Y^x mod n) = " + bigInteger + "^" + this.PrivateKey[n] + " mod " + TDGSS_SHARED_N + " = " + bigInteger2 + " = 0x" + bigInteger2.toString(16));
        byte[] byArray2 = bigInteger2.toByteArray();
        byte[] byArray3 = this.normalize_key(byArray2);
        return byArray3;
    }

    public byte[] normalize_key(BigInteger bigInteger) {
        if (this.Version == 1) {
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = this.normalize_key(byArray);
            return byArray2;
        }
        byte[] byArray = bigInteger.toByteArray();
        logger.debug("normalize_key :outbuf = " + byArray.length, byArray);
        if (byArray.length != this.keysize) {
            if (byArray.length > this.keysize) {
                byte[] byArray3 = new byte[this.keysize];
                System.arraycopy(byArray, byArray.length - this.keysize, byArray3, 0, this.keysize);
                logger.debug("", byArray3);
                return byArray3;
            }
            byte[] byArray4 = new byte[this.keysize];
            int n = this.keysize - byArray.length;
            for (int i = 0; i < n; ++i) {
                byArray4[i] = 0;
            }
            System.arraycopy(byArray, 0, byArray4, n, byArray.length);
            logger.debug("", byArray4);
            return byArray4;
        }
        return byArray;
    }

    public byte[] normalize_key(int n) {
        Integer n2 = new Integer(n);
        BigInteger bigInteger = new BigInteger(n2.toString());
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = this.normalize_key(byArray);
        return byArray2;
    }

    public byte[] normalize_key(byte[] byArray) {
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            int n = byArray.length;
            for (int i = 4; i > 0; --i) {
                if (--n >= 0) {
                    byArray2[i] = byArray[n];
                    continue;
                }
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }

    private byte[] normalize_key_temp(BigInteger bigInteger) {
        int n = 0;
        if (this.Version == 1) {
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = this.normalize_key(byArray);
            return byArray2;
        }
        byte[] byArray = bigInteger.toByteArray();
        logger.debug("normalize_key_temp: outbuf = " + byArray.length, byArray);
        if (byArray.length > this.keysize) {
            byte[] byArray3 = new byte[this.keysize];
            System.arraycopy(byArray, byArray.length - this.keysize, byArray3, 0, this.keysize);
            logger.debug("", byArray3);
            return byArray3;
        }
        if (byArray[0] == 0) {
            for (int i = 0; i < byArray.length && byArray[i] == 0; ++i) {
                ++n;
            }
            byte[] byArray4 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray4, 0, byArray.length - n);
            logger.debug("", byArray4);
            return byArray4;
        }
        return byArray;
    }

    public byte[] compute_key(byte[] byArray) throws GSSException {
        byte[] byArray2;
        byte[] byArray3 = new byte[4];
        int n = 0;
        if (this.keysize >= 128) {
            logger.debug(" *** ERROR! Requesting " + this.keysize + "exceeds max key bytes " + 128);
            throw new TdgssException(11, Td1MinorStatus.TD1_ERR_ALG_KEY_COMP_FAILURE);
        }
        if (this.Version == 1) {
            int n2;
            logger.debug(" A total of " + this.num_diffie_hellman_sets + " sets of " + 4 + " bytes key = " + this.keysize + " bytes will be generated\n");
            byArray2 = new byte[this.keysize];
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray2[n2] = 0;
            }
            for (n2 = 0; n2 < this.num_diffie_hellman_sets; ++n2) {
                logger.debug("Computing Key number " + n2);
                System.arraycopy(byArray, n, byArray3, 0, 4);
                byte[] byArray4 = this.compute_one_key(byArray3, n2);
                System.arraycopy(byArray4, 0, byArray2, n, 4);
                n += 4;
            }
            logger.debug("Key is computed as ", byArray2);
        } else {
            BigInteger bigInteger;
            BigInteger bigInteger2 = bigInteger = new BigInteger(1, byArray);
            BigInteger bigInteger3 = new BigInteger(1, this.TDGSS_SHARED_N_NEW);
            bigInteger2 = bigInteger2.modPow(this.SharedKey, bigInteger3);
            byArray2 = this.normalize_key_temp(bigInteger2);
            logger.debug("Key is computed as ");
            Td1Util.prtbuf(byArray2);
        }
        return byArray2;
    }
}

