/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class LdapName
implements GSSName {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private byte[] name;
    private byte[] EDKey;
    private Oid namespace;

    public LdapName(byte[] byArray, Oid oid) throws GSSException {
        this.namespace = oid == null ? GSSName.NT_USER_NAME : oid;
        if (byArray == null) {
            throw new TdgssException(3, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        this.EDKey = LdapUtil.getEDKey();
        this.name = LdapUtil.encryptBuffer(this.EDKey, byArray);
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        return this.getStringNameType().equals(gSSName.getStringNameType()) && this.toString().equals(((Object)gSSName).toString());
    }

    public boolean equals(Object object) {
        try {
            GSSName gSSName = (GSSName)object;
            return this.equals(gSSName);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(LdapMechanism.mechOid)) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        return this;
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    public String toString() {
        try {
            if (this.namespace.equals(LdapMechanism.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                return new String(LdapUtil.decryptBuffer(this.EDKey, this.name), "UTF-16");
            }
            if (this.namespace.equals(LdapMechanism.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                return new String(LdapUtil.decryptBuffer(this.EDKey, this.name), "UTF-8");
            }
            return new String(LdapUtil.decryptBuffer(this.EDKey, this.name), "US-ASCII");
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            return null;
        }
    }

    public Oid getStringNameType() throws GSSException {
        return this.namespace;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isMN() {
        return true;
    }
}

