/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssp2gss.GssCredential;
import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jgssp2gss.GssName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SspiMechanism
implements GSSMechanism {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private static Oid _mechOid;
    private static Oid _gssOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    private static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    public static Oid GSS_C_NT_TDAT_USER;
    public static Oid GSS_C_NT_TDAT_PASSWORD;
    private String userName = null;
    private String realm = null;
    private String extLogdata = null;
    private GSSManager mgr = GSSManager.getInstance();
    protected static final Oid mechOid;
    protected static final Oid gssOid;
    protected static final short servicesAvailable = 127;

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            logger.debug("Token is null");
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return (byArray[8] & 1) != 1 && byArray[1] == 1;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        logger.debug("Getting an acceptable context ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_INVALID_TOKEN);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSCredential);
        return new GssContext(gSSContext, mechOid, null);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        logger.debug("Getting an initable context ");
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_INVALID_TOKEN);
        }
        GSSCredential gSSCredential2 = null;
        if (gSSCredential == null) {
            logger.debug("No Credential Object");
            throw new TdgssException(13);
        }
        ((GssCredential)gSSCredential).login();
        gSSCredential2 = ((GssCredential)gSSCredential).getGssCredential();
        GSSName gSSName2 = this.mgr.createName(((Object)gSSName).toString().getBytes(), gSSName.getStringNameType());
        GSSContext gSSContext = this.mgr.createContext(gSSName2, gssOid, gSSCredential2, n);
        this.setServices(gSSContext, s);
        return new GssContext(gSSContext, mechOid, (GssCredential)gSSCredential);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (gSSName == null) {
            logger.debug("GSSException.BAD_NAME: target name cannot be null");
            return false;
        }
        if ((0x7F & s) == s) {
            return true;
        }
        logger.debug("unable to support requested services");
        logger.debug("servicesAvailable are 127");
        logger.debug("servicesRequested are " + s);
        return false;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        GssName gssName;
        if (gSSName == null) {
            gssName = null;
        } else if (gSSName instanceof GssName) {
            gssName = (GssName)gSSName;
        } else {
            throw new TdgssException(3);
        }
        return new GssCredential(gssName, n, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (oid != null && oid.equals(GSS_C_NT_TDAT_MECHDATA_UTF16)) {
            byte[] byArray2;
            try {
                String string = new String(byArray, "UTF-16");
                byArray2 = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            return new GssName(byArray2, GSS_C_NT_TDAT_MECHDATA_UTF8);
        }
        return new GssName(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{GSSName.NT_HOSTBASED_SERVICE, GSS_C_NT_TDAT_MECHDATA, GSS_C_NT_TDAT_MECHDATA_UTF8, GSS_C_NT_TDAT_MECHDATA_UTF16, GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 127;
    }

    public void setServices(GSSContext gSSContext, short s) throws GSSException {
        if ((s & 1) != 0) {
            gSSContext.requestCredDeleg(true);
        }
        if ((s & 2) != 0) {
            gSSContext.requestMutualAuth(true);
        }
        if ((s & 4) != 0) {
            gSSContext.requestReplayDet(true);
        }
        if ((s & 8) != 0) {
            gSSContext.requestSequenceDet(true);
        }
        if ((s & 0x10) != 0) {
            gSSContext.requestAnonymity(true);
        }
        if ((s & 0x20) != 0) {
            gSSContext.requestConf(true);
        }
        if ((s & 0x40) != 0) {
            gSSContext.requestInteg(true);
        }
    }

    static {
        try {
            _mechOid = new Oid("1.2.840.113554.1.2.2");
            _gssOid = new Oid("1.2.840.113554.1.2.2");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
            GSS_C_NT_TDAT_USER = new Oid("1.3.6.1.4.1.191.1.1012.1.2.6");
            GSS_C_NT_TDAT_PASSWORD = new Oid("1.3.6.1.4.1.191.1.1012.1.2.7");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        gssOid = _gssOid;
    }
}

