/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssLogin;
import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jgssp2gss.GssName;
import com.teradata.tdgss.jgssp2gss.SspiMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class GssCredential
implements GSSCredential {
    private GssName name;
    private String user = null;
    private String password = null;
    private String realm = null;
    private String extLogdata = null;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private GSSManager mgr = null;
    private GSSName gssName = null;
    private GSSCredential gssCred = null;

    public GssCredential(GssName gssName, int n, int n2) throws GSSException {
        GssName gssName2 = gssName == null ? new GssName(null, null) : gssName;
        this.mgr = GSSManager.getInstance();
        this.createCredName(gssName2);
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
    }

    public void dispose() throws GSSException {
        this.password = null;
    }

    public GSSName getName() throws GSSException {
        if (this.name == null && this.gssCred != null) {
            return this.gssCred.getName();
        }
        return this.name;
    }

    public GSSName getName(Oid oid) throws GSSException {
        if (oid != SspiMechanism.mechOid) {
            throw new TdgssException(2, GssMinorStatus.GSSP2GSS_ERR_INVALID_ARGUMENT);
        }
        return this.name;
    }

    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(SspiMechanism.mechOid);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(SspiMechanism.mechOid);
        }
        int n2 = this.getRemainingAcceptLifetime(SspiMechanism.mechOid);
        return n2 < (n = this.getRemainingInitLifetime(SspiMechanism.mechOid)) ? n2 : n;
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != SspiMechanism.mechOid) {
            throw new TdgssException(2, GssMinorStatus.GSSP2GSS_ERR_INVALID_ARGUMENT);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.initEnd);
        return n < 0 ? 0 : n;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != SspiMechanism.mechOid) {
            throw new TdgssException(2, GssMinorStatus.GSSP2GSS_ERR_INVALID_ARGUMENT);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.acceptEnd);
        return n < 0 ? 0 : n;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (oid != SspiMechanism.mechOid) {
            throw new GSSException(2);
        }
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{SspiMechanism.mechOid};
        return oidArray;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        GSSName gSSName2 = gSSName == null ? new GssName(null, null) : gSSName;
        this.createCredName(gSSName2);
    }

    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (gSSCredential.getName() != null && this.getName() != null && !gSSCredential.getName().equals(this.name)) {
                return false;
            }
            if (gSSCredential.getName() == null && this.getName() != null || gSSCredential.getName() != null && this.getName() == null) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    private static int hashCode(char[] cArray) {
        int n = 31;
        if (cArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = n * n2 + cArray[i];
        }
        return n2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.password == null ? 0 : GssCredential.hashCode(this.password.toCharArray()));
        n = 31 * n + this.usage;
        try {
            Oid[] oidArray = this.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (!this.initOnly) {
                    n = n * 31 + (this.indefiniteAccept ? 1231 : this.acceptLifetime);
                }
                if (this.acceptOnly) continue;
                n = n * 31 + (this.indefiniteInit ? 1231 : this.initLifetime);
            }
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
        }
        return n;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getExtraLogdata() {
        return this.extLogdata;
    }

    public GSSCredential getGssCredential() {
        return this.gssCred;
    }

    public void login() throws GSSException {
        GssLogin gssLogin = new GssLogin(this.user, this.password, this.gssName, SspiMechanism.mechOid, this.initLifetime, this.usage);
        this.gssCred = gssLogin.login();
    }

    private void createCredName(GSSName gSSName) throws GSSException {
        String string = ((Object)gSSName).toString();
        Oid oid = gSSName.getStringNameType();
        if (oid.equals(SspiMechanism.GSS_C_NT_TDAT_USER)) {
            this.user = string;
        } else if (oid.equals(SspiMechanism.GSS_C_NT_TDAT_PASSWORD)) {
            this.password = string;
        } else {
            String[] stringArray;
            int n;
            String string2 = string;
            Object var6_5 = null;
            Object var7_6 = null;
            if (string2 == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            String[] stringArray2 = new String[]{"user=", "profile="};
            char c = '\u0000';
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < stringArray2.length; ++n) {
                int n2;
                stringArray = stringArray2[n];
                bl = false;
                bl2 = false;
                int n3 = string2.indexOf((String)stringArray);
                if (n3 == -1) continue;
                if (string2.charAt(n3 + stringArray.length()) == '\'' || string2.charAt(n3 + stringArray.length()) == '\"') {
                    c = string2.charAt(n3 + stringArray.length());
                    bl = true;
                }
                for (n2 = n3 + stringArray.length() + 1; n2 < string2.length(); ++n2) {
                    if (!bl || c != string2.charAt(n2)) continue;
                    bl2 = true;
                    break;
                }
                int n4 = bl2 ? n2 + 1 : (string2.indexOf(32, n3) == -1 ? string2.length() : string2.indexOf(32, n3));
                String string3 = string2.substring(n3, n4);
                this.extLogdata = this.extLogdata == null ? string3 : this.extLogdata + " " + string3;
                stringBuffer.delete(stringBuffer.indexOf(string3), stringBuffer.indexOf(string3) + string3.length());
            }
            if (stringBuffer.length() <= 0) {
                return;
            }
            string2 = new String(stringBuffer).trim();
            n = string2.indexOf("@@");
            if (n != -1) {
                stringArray = string2.split("@{2}");
                if (stringArray == null || stringArray.length != 2) {
                    throw new TdgssException(9, GssMinorStatus.GSSP2GSS_ERR_INVALID_INPUT);
                }
                this.user = stringArray[0];
                this.password = stringArray[1];
            } else {
                this.user = string2;
            }
        }
        if (oid.equals(SspiMechanism.GSS_C_NT_TDAT_USER) && this.user != null) {
            this.name = new GssName(this.user.getBytes(), GSSName.NT_USER_NAME);
            this.gssName = this.mgr.createName(this.user.getBytes(), GSSName.NT_USER_NAME);
        }
    }
}

