/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;

public class DataInfoField {
    protected int type;
    protected long length;
    private int scale;
    private int precision;
    private int significantDigits = 0;
    private short m_nNumberOfIntervalDigits = 0;
    private short m_structDepth = 0;
    private String m_fullyQualifiedTypeName = "";
    private short m_serverDataType = 0;
    private String m_attributeName = "";
    private DataInfoField[] m_attributes;
    private int[] m_anArrayCardinalities;
    private boolean m_bArraySupported;
    public static final int LENGTH = 4;
    public static final int SIZEOF_ARRAY_DIMENSION = 2;
    public static final int SIZEOF_ARRAY_CARDINALITY = 4;

    public DataInfoField() {
    }

    public DataInfoField(int n, long l, int n2, int n3, String string, short s, int[] nArray, boolean bl) {
        this.type = n;
        this.length = l;
        this.scale = n2;
        this.precision = n3;
        this.m_fullyQualifiedTypeName = string;
        this.m_serverDataType = s;
        this.m_anArrayCardinalities = nArray;
        this.m_bArraySupported = bl;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getSignificantDigits() {
        return this.significantDigits;
    }

    public void setSignificantDigits(int n) {
        this.significantDigits = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public void putBufferType(TDPacketStream tDPacketStream) {
        tDPacketStream.putShort((short)this.type);
    }

    public void putBufferLength(TDPacketStream tDPacketStream) {
        tDPacketStream.putShort((short)this.length);
    }

    public int getSize() {
        return 4;
    }

    public short getArrayDimensions() {
        return (short)(this.m_anArrayCardinalities == null ? 0 : this.m_anArrayCardinalities.length);
    }

    public int[] getArrayCardinalities() {
        return this.m_anArrayCardinalities;
    }

    public int getArrayCardinality(int n) {
        return this.m_anArrayCardinalities == null || this.m_anArrayCardinalities.length == 0 ? 0 : this.m_anArrayCardinalities[n - 1];
    }

    public void setArrayCardinalities(int[] nArray) {
        this.m_anArrayCardinalities = nArray;
    }

    public boolean isArraySupported() {
        return this.m_bArraySupported;
    }

    public boolean isArray() {
        return this.type == 505 || this.type == 509;
    }

    public short getStructSize(int n) throws SQLException {
        return (short)(24 + n + this.m_attributeName.length() + (this.isArray() ? 2 + 4 * this.getArrayDimensions() : 0));
    }

    public short getStructDepth() {
        return this.m_structDepth;
    }

    public String getFullyQualifiedTypeName() {
        return this.m_fullyQualifiedTypeName;
    }

    public void setStructDepth(short s) {
        this.m_structDepth = s;
    }

    public void setFullyQualifiedTypeName(String string) {
        this.m_fullyQualifiedTypeName = string;
    }

    public void setAttributes(DataInfoField[] dataInfoFieldArray) {
        this.m_attributes = dataInfoFieldArray;
    }

    public short copyAttributeInfo(DataInfoField[] dataInfoFieldArray, short s, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        if (dataInfoFieldArray == null) {
            return 0;
        }
        this.m_attributes = new DataInfoField[dataInfoFieldArray.length];
        short s2 = 0;
        for (int i = 0; i < dataInfoFieldArray.length; ++i) {
            this.m_attributes[i] = new DataInfoField(dataInfoFieldArray[i].getType(), dataInfoFieldArray[i].getLength(), dataInfoFieldArray[i].getScale(), dataInfoFieldArray[i].getPrecision(), dataInfoFieldArray[i].getFullyQualifiedTypeName(), dataInfoFieldArray[i].getServerDataType(), dataInfoFieldArray[i].getArrayCardinalities(), dataInfoFieldArray[i].isArraySupported());
            this.m_attributes[i].setStructDepth(s);
            s2 = (short)(s2 + this.m_attributes[i].getStructSize(Encoder.encodeStringParameter(genericTeradataConnection, i + 1, this.m_attributes[i].getFullyQualifiedTypeName()).length));
            if (!this.m_attributes[i].isStruct() && !this.m_attributes[i].isArray()) continue;
            s2 = (short)(s2 + this.m_attributes[i].copyAttributeInfo(dataInfoFieldArray[i].getAttributeFieldArray(), (short)(s + 1), genericTeradataConnection));
        }
        return s2;
    }

    public void setAdjustedAttributes(int n, DataInfoField[] dataInfoFieldArray, boolean bl, boolean bl2) throws SQLException {
        if (this.m_attributes == null) {
            this.m_attributes = dataInfoFieldArray;
            return;
        }
        for (int i = 0; i < dataInfoFieldArray.length; ++i) {
            this.getAttribute(i + 1).setAdjustedType(n, this.m_fullyQualifiedTypeName, i + 1, dataInfoFieldArray[i]);
            this.getAttribute(i + 1).setAdjustedSignificantDigits(dataInfoFieldArray[i].getSignificantDigits());
            this.getAttribute(i + 1).setAdjustedPrec(dataInfoFieldArray[i].getPrecision());
            this.getAttribute(i + 1).setAdjustedLength(dataInfoFieldArray[i].getLength());
            this.getAttribute(i + 1).setAdjustedScale(dataInfoFieldArray[i].getScale(), bl, bl2);
            if (!this.getAttribute(i + 1).isStruct()) continue;
            this.getAttribute(i + 1).setAdjustedAttributes(n, dataInfoFieldArray[i].getAttributeFieldArray(), bl, bl2);
        }
    }

    public DataInfoField getAttribute(int n) {
        return this.m_attributes[n - 1];
    }

    public DataInfoField[] getAttributeFieldArray() {
        return this.m_attributes;
    }

    public boolean isStruct() {
        return this.type == 441;
    }

    public short getServerDataType() {
        return this.m_serverDataType;
    }

    public void setServerDataType(short s) {
        this.m_serverDataType = s;
    }

    public boolean isDataset() {
        return this.m_serverDataType == 513;
    }

    public boolean useStructLayout() {
        return this.isStruct() || this.isArray() || this.isDataset();
    }

    public void resetDecimalToNumber() {
        this.setLength(19);
        this.setPrecision(-128);
        this.setScale(-128);
        this.setSignificantDigits(0);
    }

    public void setAdjustedLength(long l) {
        if (this.getLength() < l) {
            this.setLength(l);
        }
    }

    public void setAdjustedType(int n, String string, int n2, DataInfoField dataInfoField) throws SQLException {
        int n3 = this.teraTypesMatch(dataInfoField);
        if (n3 < 0) {
            if (string == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ229", n, dataInfoField.getType(), this.getType());
            }
            throw ErrorFactory.makeDriverJDBCException("TJ643", String.valueOf(dataInfoField.getType()), String.valueOf(this.getType()), String.valueOf(n), string.length() > 0 ? string : JDBC4Constants.getTDTypeName(this.m_serverDataType), String.valueOf(n2));
        }
        this.setType(n3);
    }

    public void setAdjustedScale(int n, boolean bl, boolean bl2) {
        if (this.getScale() == 0 && n == -128 || this.getScale() < n) {
            this.setScale(n);
        }
        n = this.getScale();
        int n2 = this.getSignificantDigits();
        int n3 = this.getPrecision();
        int n4 = 18;
        if (bl2) {
            n4 = 38;
        }
        if (n + n2 > n4) {
            int n5 = n4 - n2;
            this.setScale(n5);
            this.setLength(this.getDecLength(n3, n5, bl));
        }
    }

    private long getDecLength(int n, int n2, boolean bl) {
        if (bl) {
            return ComUtil.makeDataInfoXDecLength(n, n2);
        }
        return ComUtil.makeDataInfoDecLength((short)n, (byte)n2);
    }

    public void setAdjustedPrec(int n) {
        if (this.getPrecision() == 0 && n == -128 || this.getPrecision() < n) {
            this.setPrecision(n);
        }
    }

    public void setAdjustedSignificantDigits(int n) {
        if (this.getSignificantDigits() < n) {
            this.setSignificantDigits(n);
        }
    }

    public void setNumberOfIntervalDigits(short s) {
        this.m_nNumberOfIntervalDigits = s;
    }

    public short getNumberOfIntervalDigits() {
        return this.m_nNumberOfIntervalDigits;
    }

    public void setAdjustedArrayCardinalities(int n, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.m_anArrayCardinalities.length == 0) {
            this.m_anArrayCardinalities = nArray;
            return;
        }
        if (nArray.length != this.m_anArrayCardinalities.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ750", n, nArray.length, this.m_anArrayCardinalities.length);
        }
        for (int i = 0; i < this.m_anArrayCardinalities.length; ++i) {
            if (this.m_anArrayCardinalities[i] >= nArray[i]) continue;
            this.m_anArrayCardinalities[i] = nArray[i];
        }
    }

    private int teraTypesMatch(DataInfoField dataInfoField) {
        int n = -1;
        int n2 = this.getType();
        int n3 = dataInfoField.getType();
        if (n2 == 0 || n3 == 0 || n2 == n3) {
            n = n3;
        } else if (this.nullColType(n2) && n2 - 1 == n3) {
            n = n2;
        } else if (this.nullColType(n3) && n3 - 1 == n2) {
            n = n3;
        } else {
            switch (n2) {
                case 421: {
                    if (n3 == 449) {
                        n = 449;
                        break;
                    }
                    if (n3 != 425) break;
                    n = 425;
                    break;
                }
                case 449: {
                    if (n3 == 421) {
                        n = 449;
                        break;
                    }
                    if (n3 == 889) {
                        n = n3;
                        break;
                    }
                    if (!JDBC4Constants.isIntervalType(n3)) break;
                    this.setNumberOfIntervalDigits(dataInfoField.getNumberOfIntervalDigits());
                    this.setLength(dataInfoField.getLength());
                    n = n3;
                    break;
                }
                case 405: {
                    if (n3 == 689) {
                        n = 689;
                        break;
                    }
                    if (n3 != 409) break;
                    n = 409;
                    break;
                }
                case 689: {
                    if (n3 != 405) break;
                    n = 689;
                    break;
                }
                case 409: {
                    if (n3 != 405) break;
                    n = 409;
                    break;
                }
                case 425: {
                    if (n3 != 421) break;
                    n = 425;
                    break;
                }
                case 605: {
                    if (n3 != 485) break;
                    n = 605;
                    dataInfoField.resetDecimalToNumber();
                    break;
                }
                case 485: {
                    if (n3 != 605) break;
                    n = 605;
                    this.resetDecimalToNumber();
                    break;
                }
                case 889: {
                    if (n3 == 449) {
                        dataInfoField.setType(n2);
                        n = 889;
                        break;
                    }
                    if (n3 != 885) break;
                    n = n3;
                    break;
                }
                case 885: {
                    if (n3 != 889) break;
                    n = 885;
                    break;
                }
                default: {
                    if (!JDBC4Constants.isIntervalType(n2) || n3 != 449) break;
                    dataInfoField.setNumberOfIntervalDigits(this.getNumberOfIntervalDigits());
                    dataInfoField.setLength(this.getLength());
                    n = n2;
                }
            }
        }
        return n;
    }

    private boolean nullColType(int n) {
        return n % 2 == 1;
    }

    public void clear() {
        this.setLength(0);
        this.setType(0);
        this.setPrecision(0);
        this.setScale(0);
        this.setNumberOfIntervalDigits((short)0);
        this.setSignificantDigits(0);
        this.setStructDepth((short)0);
        this.setFullyQualifiedTypeName("");
        this.m_attributes = null;
        this.m_anArrayCardinalities = null;
        this.m_bArraySupported = false;
    }
}

