/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.ifsupport.EscapeConverter;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.ManageEscapeState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class ConvertScalarFunction
implements EscapeConverter {
    boolean addParams = false;
    int beginParenCount = 0;
    int endParenCount = 0;
    protected ManageEscapeState escapeState = new ManageEscapeState();

    public String processTokens(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        if ("SECOND".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(SECOND FROM ", stringTokenizer);
        }
        if ("MINUTE".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(MINUTE FROM ", stringTokenizer);
        }
        if ("HOUR".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(HOUR FROM ", stringTokenizer);
        }
        if ("DAYOFMONTH".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(DAY FROM ", stringTokenizer);
        }
        if ("WEEK".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(WEEK FROM ", stringTokenizer);
        }
        if ("MONTH".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(MONTH FROM ", stringTokenizer);
        }
        if ("YEAR".equals(string)) {
            return this.createNativeSQL(string, "EXTRACT(YEAR FROM ", stringTokenizer);
        }
        if ("LENGTH".equals(string)) {
            return this.createNativeSQL(string, "CHARACTER_LENGTH(", stringTokenizer);
        }
        if ("LTRIM".equals(string)) {
            return this.createNativeSQL(string, "TRIM(LEADING FROM ", stringTokenizer);
        }
        if ("RTRIM".equals(string)) {
            return this.createNativeSQL(string, "TRIM(TRAILING FROM ", stringTokenizer);
        }
        if ("LCASE".equals(string)) {
            return this.createNativeSQL(string, "LOWER(", stringTokenizer);
        }
        if ("UCASE".equals(string)) {
            return this.createNativeSQL(string, "UPPER(", stringTokenizer);
        }
        if ("TERADATA_SETLOGLEVEL".equals(string)) {
            return this.processLocalEscapeFunction(string, stringTokenizer, localEscapeFunctions, 1);
        }
        if ("TERADATA_PROVIDE".equals(string)) {
            return this.processLocalEscapeFunction(string, stringTokenizer, localEscapeFunctions, 1);
        }
        if ("LOG".equals(string)) {
            return this.createNativeSQL(string, "LN(", stringTokenizer);
        }
        if ("CHAR".equals(string)) {
            return this.createNativeSQL(string, "CHR(", stringTokenizer);
        }
        if ("COT".equals(string)) {
            return this.createNativeSQL(string, "(1 / TAN(", stringTokenizer, 1, true, ")");
        }
        if ("INSERT".equals(string)) {
            return this.createNativeSQL(string, "SYSJDBC.ESCINSERT(", stringTokenizer, 4, true, "");
        }
        if ("LOG10".equals(string)) {
            return this.createNativeSQL(string, " LOG(", stringTokenizer);
        }
        if ("RAND".equals(string)) {
            return this.createNativeSQL(string, "(CAST(RANDOM(0, 999999999) AS FLOAT) / 1000000000.0)", stringTokenizer, 1, false, "");
        }
        if ("REPEAT".equals(string)) {
            return this.createNativeSQL(string, "SYSJDBC.ESCREPEAT(", stringTokenizer, 2, true, "");
        }
        if ("REPLACE".equals(string)) {
            return this.createNativeSQL(string, "OREPLACE(", stringTokenizer, 3, true, "");
        }
        if ("RIGHT".equals(string)) {
            return this.createNativeSQL(string, "SYSJDBC.ESCRIGHT(", stringTokenizer, 2, true, "");
        }
        if ("SPACE".equals(string)) {
            return this.createNativeSQL(string, "RPAD('', ", stringTokenizer);
        }
        if ("TRUNCATE".equals(string)) {
            return this.createNativeSQL(string, "TRUNC(", stringTokenizer, 2, true, "");
        }
        return null;
    }

    private String createNativeSQL(String string, String string2, StringTokenizer stringTokenizer) throws SQLException {
        return this.createNativeSQL(string, string2, stringTokenizer, 1, true, "");
    }

    private String createNativeSQL(String string, String string2, StringTokenizer stringTokenizer, int n, boolean bl, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            this.countEscapeTokens(string4);
            if (this.canICountComma() && ",".equals(string4)) {
                ++n2;
            }
            if (this.addParams && bl) {
                stringBuffer.append(string4);
            }
            if (!this.isStartParen(string4)) continue;
            this.addParams = true;
        }
        if (n2 + 1 != n) {
            throw ErrorFactory.makeDriverJDBCException("TJ377", string);
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private String processLocalEscapeFunction(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions, int n) throws SQLException {
        CharSequence charSequence;
        CharSequence charSequence2;
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            charSequence2 = stringTokenizer.nextToken();
            this.countEscapeTokens((String)charSequence2);
            if (this.isEndParen((String)charSequence2)) {
                this.addParams = false;
                continue;
            }
            if (this.canICountComma() && ",".equals(charSequence2)) {
                ++n2;
                arrayList.add(new StringBuffer());
                continue;
            }
            if (this.addParams) {
                charSequence = (StringBuffer)arrayList.get(n2);
                ((StringBuffer)charSequence).append((String)charSequence2);
                continue;
            }
            if (!this.isStartParen((String)charSequence2)) continue;
            this.addParams = true;
            arrayList.add(new StringBuffer());
        }
        if (arrayList.size() != n) {
            throw ErrorFactory.makeDriverJDBCException("TJ377", string);
        }
        if ("TERADATA_SETLOGLEVEL".equals(string)) {
            charSequence2 = (StringBuffer)arrayList.get(0);
            charSequence = ((StringBuffer)charSequence2).toString();
            return localEscapeFunctions.setLogLevel((String)charSequence);
        }
        if ("TERADATA_PROVIDE".equals(string)) {
            charSequence2 = (StringBuffer)arrayList.get(0);
            return localEscapeFunctions.teradataProvide(((StringBuffer)charSequence2).toString());
        }
        return null;
    }

    public void countEscapeTokens(String string) {
        this.escapeState.setManageEscapeState(string);
        if (!this.escapeState.inEscapeState() && "(".equals(string)) {
            ++this.beginParenCount;
        } else if (!this.escapeState.inEscapeState() && ")".equals(string)) {
            ++this.endParenCount;
        }
    }

    protected int parenDiff() {
        return this.beginParenCount - this.endParenCount;
    }

    protected boolean canICountComma() {
        return !this.escapeState.inEscapeState() && this.parenDiff() <= 1;
    }

    protected boolean isStartParen(String string) throws SQLException {
        if (" \t\n\r\f".indexOf(string) != -1) {
            return false;
        }
        if (!this.escapeState.inEscapeState() && "(".equals(string) && this.beginParenCount == 1) {
            return true;
        }
        if (!this.addParams && this.beginParenCount == 0 && " \t\n\r\f".indexOf(string) == -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ386", string);
        }
        return false;
    }

    protected boolean isEndParen(String string) {
        return !this.escapeState.inEscapeState() && ")".equals(string) && this.beginParenCount != 0 && this.parenDiff() == 0;
    }

    protected String getInterval(String string, String string2) throws SQLException {
        if (string2.trim().equals("SQL_TSI_YEAR")) {
            return "YEAR";
        }
        if (string2.trim().equals("SQL_TSI_MONTH")) {
            return "MONTH";
        }
        if (string2.trim().equals("SQL_TSI_DAY")) {
            return "DAY";
        }
        if (string2.trim().equals("SQL_TSI_HOUR")) {
            return "HOUR";
        }
        if (string2.trim().equals("SQL_TSI_MINUTE")) {
            return "MINUTE";
        }
        if (string2.trim().equals("SQL_TSI_SECOND")) {
            return "SECOND";
        }
        throw ErrorFactory.makeDriverJDBCException("TJ387", string2, string);
    }
}

