/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssContext;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssManager;
import com.teradata.tdgss.jtdgss.TdgssMechProp;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GenericTeraEncrypt
implements PrivilegedExceptionAction {
    static final String GSS_KERBEROS_PRINCIPALNAME = "1.2.840.113554.1.2.2.1";
    static final String TD1_OID = "1.3.6.1.4.1.191.1.1012.1.1.8";
    static final String KRB5_OID = "1.2.840.113554.1.2.2";
    static final int MECH_SUPPORTS_UTF16 = 8;
    static final int MECH_SUPPORTS_UTF8 = 4;
    static final int MECH_SUPPORTS_MECHDATA = 2;
    static final int SIZE_USER_NAME_PASS_DATA_ACCT = 50;
    private static TdgssManager myGSSManager;
    private static TdgssConfigApi myConfig;
    private TdgssContext context;
    private byte[] inToken;
    private byte trip;
    private boolean enabled;
    private boolean isPreV2R6;
    private GSSCredential myCred = null;
    private TdgssName myID = null;
    private TdgssName m_credUserName = null;
    private TdgssName m_credPassword = null;
    private int lifetimeCredential = 0;
    private Oid mechOid;
    private boolean usingGeneratedCredentials = false;
    protected Log log;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;

    private static SQLException transformException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return ErrorFactory.makeDriverJDBCException("TJ314", "tdgss-stack-trace-begin>>> " + stringWriter + " <<<end-tdgss-stack-trace");
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(TD1_OID);
            genericTeradataConnection.setAuthMethod(new AuthMechanism(oid, this.log));
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = true;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(string);
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = false;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    private void initEncrypt(GenericTeradataConnection genericTeradataConnection, Oid oid) throws SQLException, GSSException, LoginException {
        boolean bl;
        Object object;
        TdgssName tdgssName = null;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        this.mechOid = oid;
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
        String string = null;
        if (this.log.canLog(1)) {
            object = TdgssManager.InquireLibraryVersion();
            this.log.info("tdgss version: " + object.MajorRelease + "." + object.MinorRelease + "." + object.MaintenanceRelease + "." + object.EmergencyRelease);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("java.security.auth.login.config: " + System.getProperty("java.security.auth.login.config"));
            this.log.debug("javax.security.auth.useSubjectCredsOnly: " + System.getProperty("javax.security.auth.useSubjectCredsOnly"));
            object = this.getLocalMechs();
            if (object != null) {
                this.log.debug((String)object);
            }
        }
        object = tdgssConfigApi.InquirePropertiesForMech(oid.toString());
        genericTeradataConnection.setAuthMethod(new AuthMechanism(oid.toString(), this.log));
        block23: for (bl = false; bl < ((TdgssMechProp[])object).length - 1; bl += 1) {
            if (object[bl] == null) continue;
            switch (object[bl].getIndex()) {
                case 1: {
                    if (object[bl].getValue().compareToIgnoreCase("yes") != 0) continue block23;
                    this.enabled = true;
                    continue block23;
                }
                case 24: {
                    n = this.getInt(object[bl].getValue());
                    continue block23;
                }
                case 25: {
                    this.lifetimeCredential = this.getInt(object[bl].getValue());
                    continue block23;
                }
                case 2: {
                    bl2 = this.getBool(object[bl].getValue());
                    continue block23;
                }
                case 3: {
                    bl3 = this.getBool(object[bl].getValue());
                    continue block23;
                }
            }
        }
        if (!this.enabled) {
            throw ErrorFactory.makeDriverJDBCException("TJ339", oid.toString());
        }
        boolean bl4 = bl = bl2 || bl3;
        if (this.log.isDebugEnabled()) {
            this.log.debug("SSOSupported is: " + bl);
        }
        if (!bl && genericTeradataConnection.getLogonInformation().getUserName().equals("") && genericTeradataConnection.getLogonInformation().getPassword().equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ332", tdgssConfigApi.GetInforForMech(oid)[0]);
        }
        Oid[] oidArray = tdgssManager.getNamesForMech(oid);
        if (oidArray != null) {
            int n2 = 0;
            for (int i = 0; i < oidArray.length; ++i) {
                if (oidArray[i].equals(GSSName.NT_HOSTBASED_SERVICE)) {
                    InetAddress inetAddress = genericTeradataConnection.getIO().getRemoteAddress();
                    String string2 = inetAddress.getHostAddress();
                    long l = System.currentTimeMillis();
                    String string3 = inetAddress.getCanonicalHostName();
                    if (this.log.canLog(2)) {
                        this.log.timing("getCanonicalHostName for " + inetAddress + " took " + (System.currentTimeMillis() - l) + " ms and returned " + string3);
                    }
                    String string4 = string2.equals(string3) ? genericTeradataConnection.getMachineName() : string3;
                    String string5 = "TERADATA@" + string4;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("initEncrypt: iaRemote=" + inetAddress + " sRemoteLiteralIPAddress=" + string2 + " sRemoteFQDN=" + string3 + " serverNameString=" + string5);
                    }
                    tdgssName = (TdgssName)tdgssManager.createName(string5, GSSName.NT_HOSTBASED_SERVICE, oid);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA)) {
                    n2 = Math.max(n2, 2);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                    if (genericTeradataConnection.getGtwConfig() == null || !genericTeradataConnection.getGtwConfig().isUTF_CredentialSupported()) continue;
                    n2 = Math.max(n2, 8);
                    continue;
                }
                if (oidArray[i].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                    if (genericTeradataConnection.getGtwConfig() == null || !genericTeradataConnection.getGtwConfig().isUTF_CredentialSupported()) continue;
                    n2 = Math.max(n2, 4);
                    continue;
                }
                this.log.debug("Unknown Oid Name Type for Mechanism: " + oidArray[i].toString());
            }
            string = genericTeradataConnection.getlogdata();
            if (string != null && string.length() != 0) {
                switch (n2) {
                    case 8: {
                        this.myID = (TdgssName)tdgssManager.createName(string, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, oid);
                        break;
                    }
                    case 4: {
                        this.myID = (TdgssName)tdgssManager.createName(string, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, oid);
                        break;
                    }
                    case 2: {
                        byte[] byArray = Encoder.encodeString(genericTeradataConnection, string);
                        try {
                            this.myID = (TdgssName)tdgssManager.createName(byArray, TdgssName.GSS_C_NT_TDAT_MECHDATA, oid);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw GenericTeraEncrypt.transformException(throwable);
                        }
                    }
                }
            }
        }
        String string6 = genericTeradataConnection.getLogonInformation().getUserName();
        String string7 = genericTeradataConnection.getLogonInformation().getPassword();
        if (string6 != null && string6.length() != 0) {
            this.m_credUserName = (TdgssName)tdgssManager.createName(string6, TdgssName.GSS_C_NT_TDAT_USER, oid);
        }
        if (string7 != null && string7.length() != 0) {
            this.m_credPassword = (TdgssName)tdgssManager.createName(string7, TdgssName.GSS_C_NT_TDAT_PASSWORD, oid);
        }
        if (this.myID != null) {
            this.myCred = (TdgssCredential)tdgssManager.createCredential((GSSName)this.myID, this.lifetimeCredential, oid, 1);
        }
        if (this.m_credUserName != null && this.m_credPassword != null) {
            if (this.myCred == null) {
                this.myCred = (TdgssCredential)tdgssManager.createCredential((GSSName)this.m_credUserName, this.lifetimeCredential, oid, 1);
            } else {
                this.myCred.add(this.m_credUserName, this.lifetimeCredential, this.lifetimeCredential, oid, 1);
            }
            this.myCred.add(this.m_credPassword, this.lifetimeCredential, this.lifetimeCredential, oid, 1);
        }
        if (this.myCred == null) {
            this.myCred = (TdgssCredential)tdgssManager.createCredential(null, this.lifetimeCredential, oid, 1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Credentials are: " + this.myCred);
        }
        this.context = (TdgssContext)tdgssManager.createContext(tdgssName, oid, this.myCred, n);
        this.inToken = new byte[0];
        block25: for (int i = 0; i < ((TdgssMechProp[])object).length - 1; ++i) {
            if (object[i] == null) continue;
            switch (object[i].getIndex()) {
                case 18: {
                    this.context.requestCredDeleg(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 19: {
                    this.context.requestMutualAuth(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 20: {
                    this.context.requestReplayDet(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 33: {
                    this.context.requestSequenceDet(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 21: {
                    this.context.requestConf(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 23: {
                    this.context.requestAnonymity(this.getBool(object[i].getValue()));
                    continue block25;
                }
                case 22: {
                    this.context.requestInteg(this.getBool(object[i].getValue()));
                }
            }
        }
    }

    public Object run() throws Exception {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        this.myCred = tdgssManager.createCredential((GSSName)this.myID, this.lifetimeCredential, this.mechOid, 1);
        return this.myCred;
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws SQLException {
        long l = System.currentTimeMillis();
        byte[] byArray2 = null;
        try {
            byArray2 = this.context.initSecContext(byArray, n, n2);
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        if (this.log.canLog(2)) {
            this.log.timing("TdgssContext.initSecContext took " + (System.currentTimeMillis() - l) + " ms");
        }
        return byArray2;
    }

    public byte[] encrypt(int n, boolean bl, byte[] byArray, int n2, int n3) throws SQLException {
        try {
            MessageProp messageProp = new MessageProp(n, bl);
            byte[] byArray2 = this.context.wrap(byArray, n2, n3, messageProp);
            if (byArray2 == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ647");
            }
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.encrypt: nQualityOfProtection=" + n + " bPrivacy=" + bl + " inBuf.length=" + byArray.length + " offset=" + n2 + " len=" + n3 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " expansion=" + (byArray2 == null ? "n/a" : "" + (byArray2.length - n3)));
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws SQLException {
        try {
            MessageProp messageProp = new MessageProp(true);
            byte[] byArray2 = this.context.unwrap(byArray, n, n2, messageProp);
            if (byArray2 == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ648");
            }
            SQLException sQLException = null;
            if (messageProp.isDuplicateToken()) {
                sQLException = Utility.chainSQLExceptions(sQLException, ErrorFactory.makeDriverJDBCException("TJ793"));
            }
            if (messageProp.isOldToken()) {
                sQLException = Utility.chainSQLExceptions(sQLException, ErrorFactory.makeDriverJDBCException("TJ798"));
            }
            if (messageProp.isUnseqToken()) {
                sQLException = Utility.chainSQLExceptions(sQLException, ErrorFactory.makeDriverJDBCException("TJ799"));
            }
            if (messageProp.isGapToken()) {
                sQLException = Utility.chainSQLExceptions(sQLException, ErrorFactory.makeDriverJDBCException("TJ800"));
            }
            if (sQLException != null) {
                throw sQLException;
            }
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.decrypt: inBuf.length=" + byArray.length + " offset=" + n + " len=" + n2 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " shrinkage=" + (byArray2 == null ? "n/a" : "" + (n2 - byArray2.length)));
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public byte[] getIntoken() {
        return this.inToken;
    }

    public void setIntoken(byte[] byArray) {
        this.inToken = byArray;
    }

    public byte getTrip() {
        return this.trip;
    }

    public void incTrip() {
        this.trip = (byte)(this.trip + 2);
    }

    public void showContext() throws SQLException {
        GSSName gSSName;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("Context Information:" + Log.LINE_SEP);
        stringBuffer.append("getAnonymityState: " + this.context.getAnonymityState() + Log.LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + Log.LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + Log.LINE_SEP);
        stringBuffer.append("getCredDelegState: " + this.context.getCredDelegState() + Log.LINE_SEP);
        stringBuffer.append("getLifeTime: " + this.context.getLifetime() + Log.LINE_SEP);
        try {
            stringBuffer.append("getMech: " + this.context.getMech().toString() + Log.LINE_SEP);
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        stringBuffer.append("getMutualAuthState: " + this.context.getMutualAuthState() + Log.LINE_SEP);
        stringBuffer.append("getReplayDetState: " + this.context.getReplayDetState() + Log.LINE_SEP);
        stringBuffer.append("getSequenceDetState: " + this.context.getSequenceDetState() + Log.LINE_SEP);
        try {
            stringBuffer.append("SrcName is: ");
            gSSName = this.context.getSrcName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + Log.LINE_SEP);
            } else {
                stringBuffer.append("undefined" + Log.LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        try {
            stringBuffer.append("TargName is: ");
            gSSName = this.context.getTargName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + Log.LINE_SEP);
            } else {
                stringBuffer.append("undefined" + Log.LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        stringBuffer.append("isEstablished: " + this.context.isEstablished() + Log.LINE_SEP);
        stringBuffer.append("isProtReady: " + this.context.isProtReady() + Log.LINE_SEP);
        this.log.debug(stringBuffer.toString());
    }

    public static byte[] getTDgssVersion() {
        TdgssVersion tdgssVersion = TdgssManager.InquireLibraryVersion();
        byte[] byArray = new byte[]{tdgssVersion.MajorRelease, tdgssVersion.MinorRelease, tdgssVersion.MaintenanceRelease, tdgssVersion.EmergencyRelease};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssManager getGSSM(Log log) {
        if (myGSSManager == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                if (myGSSManager == null) {
                    long l = System.currentTimeMillis();
                    myGSSManager = (TdgssManager)TdgssManager.getInstance();
                    long l2 = System.currentTimeMillis();
                    myConfig = TdgssConfigApi.getInstance();
                    if (log.canLog(2)) {
                        log.timing("TdgssManager initialization took " + (l2 - l) + " ms, TdgssConfigApi initialization took " + (System.currentTimeMillis() - l2) + " ms");
                    }
                }
            }
        }
        return myGSSManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssConfigApi getConfig(Log log) {
        if (myConfig == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                GenericTeraEncrypt.getGSSM(log);
            }
        }
        return myConfig;
    }

    String dispOidType(Oid oid) {
        if (oid.equals(GSSName.NT_USER_NAME)) {
            return new String("\tNT_USER_NAME");
        }
        if (oid.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            return new String("\tNT_HOSTBASED_SERVICE");
        }
        if (oid.equals(GSSName.NT_EXPORT_NAME)) {
            return new String("\tNT_EXPORT_NAME");
        }
        if (oid.equals(GSSName.NT_ANONYMOUS)) {
            return new String("\tNT_ANONYMOUS");
        }
        if (oid.equals(GSSName.NT_MACHINE_UID_NAME)) {
            return new String("\tNT_MACHINE_UID_NAME");
        }
        if (oid.equals(GSSName.NT_STRING_UID_NAME)) {
            return new String("\tNT_STRING_UID_NAME");
        }
        if (oid.toString().equals(GSS_KERBEROS_PRINCIPALNAME)) {
            return new String("\tNT__ Kerberos Principal Name");
        }
        return new String("\tNT__ Unknown");
    }

    public boolean getBool(String string) {
        return string.equalsIgnoreCase(new String("yes"));
    }

    public int getInt(String string) {
        return string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    public byte getSSOAuthMethod() {
        if (this.isPreV2R6) {
            return 8;
        }
        return 0;
    }

    public static Oid getOidForName(String string, Log log) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray = tdgssConfigApi.GetInforForMech(oidArray[i]);
            if (stringArray[0].compareToIgnoreCase(string) != 0) continue;
            return oidArray[i];
        }
        return null;
    }

    public static String getUserNameForOid(Oid oid, Log log) {
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        String[] stringArray = tdgssConfigApi.GetInforForMech(oid);
        return stringArray[0];
    }

    public String getLocalMechs() {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Locally defined Mechanisms are:");
        String[][] stringArray = new String[oidArray.length][2];
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray2 = tdgssConfigApi.GetInforForMech(oidArray[i]);
            stringBuffer.append(Log.LINE_SEP + stringArray2[0] + "\t" + oidArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Oid getClientDefaultMech(Log log, boolean bl) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        for (int i = 0; i < oidArray.length; ++i) {
            if (oidArray[i] == null) continue;
            TdgssMechProp[] tdgssMechPropArray = tdgssConfigApi.InquirePropertiesForMech(oidArray[i].toString());
            boolean bl2 = false;
            boolean bl3 = false;
            block6: for (int j = 0; j < tdgssMechPropArray.length - 1; ++j) {
                if (tdgssMechPropArray[j] == null) continue;
                switch (tdgssMechPropArray[j].getIndex()) {
                    case 16: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0 || bl) continue block6;
                        bl3 = true;
                        continue block6;
                    }
                    case 112: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0 || !bl) continue block6;
                        bl3 = true;
                        continue block6;
                    }
                    case 1: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0) continue block6;
                        bl2 = true;
                    }
                }
            }
            if (!bl2 || !bl3) continue;
            if (log.isDebugEnabled()) {
                log.debug("Client default " + (bl ? "negotiating" : "(non-negotiating)") + " mechanism is: " + oidArray[i]);
            }
            return oidArray[i];
        }
        return null;
    }

    public void updateGeneratedCredentials() throws SQLException {
        try {
            this.usingGeneratedCredentials = false;
            if (this.m_credUserName == null || this.m_credPassword == null) {
                return;
            }
            TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
            Oid oid = this.context.getMech();
            TdgssMechProp[] tdgssMechPropArray = tdgssConfigApi.InquirePropertiesForMech(oid.toString());
            for (int i = 0; i < tdgssMechPropArray.length - 1; ++i) {
                if (tdgssMechPropArray[i] == null || tdgssMechPropArray[i].getIndex() != 2) continue;
                this.usingGeneratedCredentials = this.getBool(tdgssMechPropArray[i].getValue());
                break;
            }
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public boolean isUsingGeneratedCredentials() {
        return this.usingGeneratedCredentials;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

