/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.teradata.utils.TeradataSplitUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class TeradataSplitUtilsTest {
    @Test
    public void testStringToBigDecimal() throws Exception {
        Method method = TeradataSplitUtils.class.getDeclaredMethod("stringToBigDecimal", String.class);
        method.setAccessible(true);
        Assert.assertEquals((Object)new BigDecimal(9.918366558849812E-4), (Object)method.invoke(null, "AB"));
        Method method2 = TeradataSplitUtils.class.getDeclaredMethod("bigDecimalToString", BigDecimal.class);
        method2.setAccessible(true);
        Assert.assertEquals((Object)"AB", (Object)method2.invoke(null, new BigDecimal(9.918366558849812E-4)));
        TeradataSplitUtils t = new TeradataSplitUtils();
        List<Object> splitStrings = new ArrayList();
        ArrayList<String> splitStringsOP = new ArrayList<String>();
        splitStringsOP.add("10330045A1");
        splitStringsOP.add("10330145A1");
        splitStringsOP.add("10330245A1");
        splitStringsOP.add("10330345A1");
        splitStrings = TeradataSplitUtils.getStringSplitPoints(4, "10330045A1", "10330535A67898");
        Assert.assertEquals((int)4, (int)splitStrings.size());
        Assert.assertEquals(splitStringsOP, splitStrings);
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(70, "000301542582", "998392158163");
        Assert.assertEquals((int)70, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStringsOP = new ArrayList();
        splitStringsOP.add("000301542582");
        splitStringsOP.add("249824196477");
        splitStringsOP.add("499346850373");
        splitStringsOP.add("748869504268");
        splitStrings = TeradataSplitUtils.getStringSplitPoints(4, "000301542582", "998392158163");
        Assert.assertEquals((int)4, (int)splitStrings.size());
        Assert.assertEquals(splitStringsOP, splitStrings);
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(70, "10330045A1", "10330535A6712345678987123712345678987123");
        Assert.assertEquals((int)70, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(60, "10330045A1", "10330535A6712345678987123712345678987123");
        Assert.assertEquals((int)60, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(61, "10330045A1", "10330535A6712345678987123712345678987123");
        Assert.assertEquals((int)61, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(31, "10330045A1", "10330535A6712345678987123712345678987123");
        Assert.assertEquals((int)31, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(8, "10330045A1", "10330535A671234567898712371234567898712");
        Assert.assertEquals((int)8, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(10, "10330045A1", "10330535A67123456789871237123456789871234");
        Assert.assertEquals((int)10, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(10, "10330045A1", "10330535A6712345678987123712345678987123");
        Assert.assertEquals((int)10, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(4, "10330045A1", "10331045A1");
        Assert.assertEquals((int)4, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(4, "10330045A1", "10334045A1");
        Assert.assertEquals((int)4, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(17, "10300045A1", "10390045A1");
        Assert.assertEquals((int)17, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(9, "10300045A1", "10330045A1");
        Assert.assertEquals((int)9, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStringsOP = new ArrayList();
        splitStringsOP.add("10300045A1");
        splitStringsOP.add("1030\u00b9045A1");
        splitStringsOP.add("10310045A1");
        splitStringsOP.add("1031\u00b9045A1");
        splitStringsOP.add("10320045A1");
        splitStringsOP.add("1032c045A1");
        splitStringsOP.add("1032\u00b8045A1");
        splitStringsOP.add("1032\u00c9045A1");
        splitStrings = TeradataSplitUtils.getStringSplitPoints(8, "10300045A1", "10330045A1");
        Assert.assertEquals((int)8, (int)splitStrings.size());
        Assert.assertEquals(splitStringsOP, splitStrings);
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(3, "10000045A1", "10800045A1");
        Assert.assertEquals((int)3, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStrings = TeradataSplitUtils.getStringSplitPoints(8, "10000045A1", "10900045A1");
        Assert.assertEquals((int)8, (int)splitStrings.size());
        splitStrings = new ArrayList();
        splitStringsOP = new ArrayList();
        splitStringsOP.add("10000045A1");
        splitStringsOP.add("10200045A1");
        splitStringsOP.add("10400045A1");
        splitStringsOP.add("10600045A1");
        splitStrings = TeradataSplitUtils.getStringSplitPoints(4, "10000045A1", "10800045A1");
        Assert.assertEquals((int)4, (int)splitStrings.size());
        Assert.assertEquals(splitStringsOP, splitStrings);
    }

    @Test
    public void testGetSplitsByBooleanType() {
        Assert.assertEquals((int)2, (int)TeradataSplitUtils.getSplitsByBooleanType(new Configuration(), "", false, true).size());
    }

    @Test
    public void testGetSupportedCharCode() {
        Assert.assertEquals((int)65470, (int)TeradataSplitUtils.getSupportedCharCode(65535));
        Assert.assertEquals((int)65281, (int)TeradataSplitUtils.getSupportedCharCode(65280));
    }
}

