/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.teradata.TeradataInputFormat;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class TeradataSplitUtils {
    private static final BigDecimal POINT_BASE = new BigDecimal(65536);
    private static final int NUM_CHARS = 8;
    protected static boolean nullable = false;
    protected static Object defaultValue = null;

    public static List<BigDecimal> getSplitPoints(BigDecimal minValue, BigDecimal maxValue, long num, int type) {
        BigDecimal numSplit = new BigDecimal(num);
        BigDecimal one = new BigDecimal(1);
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        BigDecimal remainder = maxValue.subtract(minValue).remainder(numSplit);
        int intRemainder = remainder.intValue();
        BigDecimal splitRange = TeradataSplitUtils.bigDecimalDivision(maxValue.subtract(minValue), numSplit);
        BigDecimal currentPoint = minValue;
        list.add(currentPoint);
        for (long i = 1L; i < num; ++i) {
            currentPoint = currentPoint.add(splitRange);
            if (type == 4 && i <= (long)intRemainder) {
                currentPoint = currentPoint.add(one);
            }
            list.add(currentPoint);
        }
        return list;
    }

    private static BigDecimal stringToBigDecimal(String value) {
        BigDecimal denominatorValue = POINT_BASE;
        BigDecimal charBigDecimal = BigDecimal.ZERO;
        int len = Math.min(value.length(), 8);
        for (int i = 0; i < len; ++i) {
            int codePoint = value.codePointAt(i);
            charBigDecimal = charBigDecimal.add(TeradataSplitUtils.bigDecimalDivision(new BigDecimal(codePoint), denominatorValue));
            denominatorValue = denominatorValue.multiply(POINT_BASE);
        }
        return charBigDecimal;
    }

    private static String bigDecimalToString(BigDecimal bigDecimal) {
        BigDecimal currentValue = bigDecimal.stripTrailingZeros();
        StringBuilder stringBuilder = new StringBuilder();
        for (int numConverted = 0; numConverted < 8; ++numConverted) {
            int currentCodeInt;
            currentValue = currentValue.multiply(POINT_BASE);
            int transferredCodeInt = currentCodeInt = currentValue.intValue();
            if (0 == currentCodeInt) break;
            transferredCodeInt = TeradataSplitUtils.getSupportedCharCode(currentCodeInt);
            currentValue = currentValue.subtract(new BigDecimal(currentCodeInt));
            stringBuilder.append(Character.toChars(transferredCodeInt));
        }
        return stringBuilder.toString();
    }

    private static java.util.Date longToDate(long value, int sqlDataType) throws ConnectorException {
        switch (sqlDataType) {
            case 91: {
                return new Date(value);
            }
            case 92: {
                return new Time(value);
            }
            case 93: {
                return new Timestamp(value);
            }
        }
        throw new ConnectorException(23001);
    }

    private static long dateToLong(ResultSet resultSet, int columnIndex, int sqlDataType) throws ConnectorException {
        try {
            switch (sqlDataType) {
                case 91: {
                    return resultSet.getDate(columnIndex).getTime();
                }
                case 92: {
                    return resultSet.getTime(columnIndex).getTime();
                }
                case 93: {
                    return resultSet.getTimestamp(columnIndex).getTime();
                }
            }
            throw new ConnectorException(23001);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private static List<Long> getTimeSplitPoints(long numSplits, long minValue, long maxValue) {
        ArrayList<Long> splitPoints = new ArrayList<Long>();
        List<BigDecimal> points = TeradataSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 92);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).longValue());
        }
        return splitPoints;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByTimeType(Configuration configuration, String splitByColumn, ResultSet resultSetMinMaxValues) throws ConnectorException {
        try {
            int sqlDataType = resultSetMinMaxValues.getMetaData().getColumnType(1);
            long minValue = TeradataSplitUtils.dateToLong(resultSetMinMaxValues, 1, sqlDataType);
            long maxValue = TeradataSplitUtils.dateToLong(resultSetMinMaxValues, 2, sqlDataType);
            String lowerBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
            String upperBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " < ";
            String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
            int numSplits = ConnectorConfiguration.getNumMappers(configuration);
            List<Long> splitPoints = TeradataSplitUtils.getTimeSplitPoints(numSplits, minValue, maxValue);
            ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
            long lowPoint = splitPoints.get(0);
            java.util.Date startDate = TeradataSplitUtils.longToDate(lowPoint, sqlDataType);
            long highPoint = lowPoint;
            java.util.Date endDate = TeradataSplitUtils.longToDate(highPoint, sqlDataType);
            if (sqlDataType == 93) {
                ((Timestamp)startDate).setNanos(resultSetMinMaxValues.getTimestamp(1).getNanos());
            }
            int i = 0;
            while (i < splitPoints.size()) {
                if (i == splitPoints.size() - 1) {
                    if (sqlDataType == 93) {
                        ((Timestamp)endDate).setNanos(resultSetMinMaxValues.getTimestamp(2).getNanos());
                    }
                    splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + "'" + startDate + "'"));
                    ++i;
                } else {
                    highPoint = splitPoints.get(++i);
                    endDate = TeradataSplitUtils.longToDate(highPoint, sqlDataType);
                    splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + "'" + startDate + "' AND " + upperBoundary + "'" + endDate + "'"));
                }
                startDate = endDate;
            }
            return splits;
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByBooleanType(Configuration conf, String splitByColumn, boolean minValue, boolean maxValue) {
        ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
        String splitSql = TeradataPlugInConfiguration.getInputSplitSql(conf);
        if (!minValue) {
            splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " = FALSE"));
        }
        if (maxValue) {
            splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " = TRUE"));
        }
        return splits;
    }

    private static List<Double> getDoubleSplitPoints(long numSplits, double minValue, double maxValue) {
        ArrayList<Double> splitPoints = new ArrayList<Double>();
        List<BigDecimal> points = TeradataSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 8);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).doubleValue());
        }
        return splitPoints;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByDoubleType(Configuration configuration, String splitByColumn, double minValue, double maxValue) {
        double lowPoint;
        ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
        String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
        double minDoubleValue = minValue;
        double maxDoubleValue = maxValue;
        long numSplits = ConnectorConfiguration.getNumMappers(configuration);
        String lowerBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        List<Double> splitPoints = TeradataSplitUtils.getDoubleSplitPoints(numSplits, minDoubleValue, maxDoubleValue);
        double highPoint = lowPoint = splitPoints.get(0).doubleValue();
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + Double.toString(lowPoint)));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + Double.toString(lowPoint) + " AND " + upperBoundary + Double.toString(highPoint)));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    private static List<Long> getIntegerSplitPoints(long numSplits, long minValue, long maxValue) {
        ArrayList<Long> splitPoints = new ArrayList<Long>();
        List<BigDecimal> points = TeradataSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 4);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).longValue());
        }
        return splitPoints;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByIntType(Configuration configuration, String splitByColumn, long minValue, long maxValue) {
        long lowPoint;
        long minIntValue = minValue;
        long maxIntValue = maxValue;
        String lowerBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
        int numSplits = ConnectorConfiguration.getNumMappers(configuration);
        List<Long> splitPoints = TeradataSplitUtils.getIntegerSplitPoints(numSplits, minIntValue, maxIntValue);
        ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
        long highPoint = lowPoint = splitPoints.get(0).longValue();
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + Long.toString(lowPoint)));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + Long.toString(lowPoint) + " AND " + upperBoundary + Long.toString(highPoint)));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    private static BigDecimal bigDecimalDivision(BigDecimal numerator, BigDecimal denominator) {
        try {
            return numerator.divide(denominator);
        }
        catch (ArithmeticException ae) {
            return numerator.divide(denominator, 1);
        }
    }

    private static List<BigDecimal> getBigDecimalSplitPoints(long numSplits, BigDecimal minDecimalValue, BigDecimal maxDecimalValue) {
        List<BigDecimal> splits = TeradataSplitUtils.getSplitPoints(minDecimalValue, maxDecimalValue, numSplits, 3);
        return splits;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByDecimalType(Configuration configuration, String splitByColumn, BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal lowPoint;
        BigDecimal minDecimalValue = minValue;
        BigDecimal maxDecimalValue = maxValue;
        String lowerBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
        long numSplits = ConnectorConfiguration.getNumMappers(configuration);
        List<BigDecimal> splitPoints = TeradataSplitUtils.getBigDecimalSplitPoints(numSplits, minDecimalValue, maxDecimalValue);
        ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
        BigDecimal highPoint = lowPoint = splitPoints.get(0);
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + lowPoint.toString()));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowerBoundary + lowPoint.toString() + " AND " + upperBoundary + highPoint.toString()));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    public static List<String> getStringSplitPoints(int numSplits, String minString, String maxString) {
        ArrayList<String> splitStrings = new ArrayList<String>();
        if (minString.matches("[0-9]+") && maxString.matches("[0-9]+")) {
            splitStrings.add(minString);
            BigDecimal minVal = (BigDecimal)defaultValue;
            BigDecimal maxVal = (BigDecimal)defaultValue;
            minVal = TeradataSplitUtils.StringToBigDecimal(minString);
            maxVal = TeradataSplitUtils.StringToBigDecimal(maxString);
            List<BigDecimal> splitPoints = TeradataSplitUtils.getBigDecimalSplitPointsString(numSplits, minVal, maxVal);
            for (BigDecimal BigDecimalValue : splitPoints) {
                splitStrings.add(TeradataSplitUtils.BigDecimalToSTring(BigDecimalValue));
            }
            Collections.sort(splitStrings);
        } else {
            splitStrings = TeradataSplitUtils.getAsciiStringSplitPoints(numSplits, minString, maxString);
            Collections.sort(splitStrings);
        }
        return splitStrings;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByStringType(Configuration configuration, String splitByColumn, String minValue, String maxValue) {
        String startString;
        String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
        int numSplits = ConnectorConfiguration.getNumMappers(configuration);
        String lowClausePrefix = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " >= '";
        String highClausePrefix = ConnectorSchemaUtils.quoteFieldName(splitByColumn) + " < '";
        List<String> splitStrings = TeradataSplitUtils.getStringSplitPoints(numSplits, minValue, maxValue);
        ArrayList<TeradataInputFormat.TeradataInputSplit> splits = new ArrayList<TeradataInputFormat.TeradataInputSplit>();
        String endString = startString = splitStrings.get(0);
        int i = 0;
        while (i < splitStrings.size()) {
            if (i == splitStrings.size() - 1) {
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowClausePrefix + startString.replace("'", "''") + "'"));
                ++i;
            } else {
                endString = splitStrings.get(++i);
                splits.add(new TeradataInputFormat.TeradataInputSplit(splitSql + " " + lowClausePrefix + startString.replace("'", "''") + "' AND " + highClausePrefix + endString.replace("'", "''") + "'"));
            }
            startString = endString;
        }
        return splits;
    }

    private static List<BigDecimal> getBigDecimalSplitPointsString(long numSplits, BigDecimal minDecimalValue, BigDecimal maxDecimalValue) {
        List<BigDecimal> splits = TeradataSplitUtils.getSplitPointsString(minDecimalValue, maxDecimalValue, numSplits);
        return splits;
    }

    public static BigDecimal StringToBigDecimal(String str) {
        if (str == null || str.isEmpty()) {
            return nullable ? null : (BigDecimal)defaultValue;
        }
        return new BigDecimal(str);
    }

    public static List<Integer> getStringAsciiList(String input) {
        char[] ascii = input.toCharArray();
        ArrayList<Integer> asciiInt = new ArrayList<Integer>();
        for (char ch : ascii) {
            asciiInt.add(Integer.valueOf(ch));
        }
        return asciiInt;
    }

    public static List<String> getSplitInDiff(List<Integer> asciiInMax, List<Integer> asciiInMin, List<String> inSplitStrings, int index, int numSplits) {
        List<String> splitStrings = inSplitStrings;
        int getNextMin = asciiInMin.get(index + 1);
        int totRange = 255 - getNextMin;
        int splitVal = totRange / numSplits;
        if (numSplits == 0) {
            return splitStrings;
        }
        for (int nm = 1; nm < numSplits; ++nm) {
            ArrayList<Integer> asciiInt = new ArrayList<Integer>();
            asciiInt.addAll(asciiInMin);
            int substValue = getNextMin + splitVal * nm;
            if (substValue > 255) {
                substValue = 255;
            }
            asciiInt.remove(index + 1);
            asciiInt.add(index + 1, substValue);
            splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
        }
        return splitStrings;
    }

    public static List<String> getSplitInDiffSizeMismatch(List<Integer> asciiInMax, List<Integer> asciiInMin, List<String> inSplitStrings, int index, int numSplits) {
        List<String> splitStrings = inSplitStrings;
        int getMax = asciiInMax.get(index);
        int getNextMin = asciiInMin.get(index + 1);
        int totRange = getNextMin + getMax;
        int splitVal = totRange / numSplits;
        int substValue = 0;
        if (numSplits == 0) {
            return splitStrings;
        }
        for (int nm = 1; nm < numSplits; ++nm) {
            ArrayList<Integer> asciiInt = new ArrayList<Integer>();
            asciiInt.addAll(asciiInMin);
            substValue = getNextMin + splitVal + substValue;
            if (substValue > 255) {
                substValue = 255;
            }
            asciiInt.remove(index + 1);
            asciiInt.add(index + 1, substValue);
            splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
        }
        return splitStrings;
    }

    public static String BigDecimalToSTring(BigDecimal bigdecimal) {
        if (bigdecimal == null) {
            return nullable ? null : "";
        }
        return bigdecimal.toPlainString();
    }

    protected static List<BigDecimal> getSplitPointsString(BigDecimal minValue, BigDecimal maxValue, long num) {
        int scale = 0;
        BigDecimal numSplit = new BigDecimal(num);
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        BigDecimal splitRange = TeradataSplitUtils.bigDecimalDivision(maxValue.subtract(minValue), numSplit);
        BigDecimal currentPoint = minValue;
        for (long i = 1L; i < num; ++i) {
            currentPoint = currentPoint.add(splitRange);
            list.add(currentPoint.setScale(scale, RoundingMode.HALF_UP));
        }
        return list;
    }

    public static String getAsciiToString(List<Integer> splitAsciiList) {
        String asciiToStr = "";
        for (int asciival : splitAsciiList) {
            if (asciival >= 127 && asciival <= 160) {
                asciival = 161 + (asciival - 127);
            }
            if (asciival >= 0 && asciival <= 32) {
                asciival = 33 + asciival;
            }
            if (asciival == 173 || asciival > 255) {
                asciival = 256;
            }
            asciiToStr = asciiToStr + Character.toString((char)asciival);
        }
        return asciiToStr;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> getAsciiStringSplitPoints(int numSplits, String minString, String maxString) {
        int mxsize;
        int sizediff;
        List<Integer> asciiIntMin;
        List<Integer> asciiIntMax;
        List<String> splitStrings;
        block48: {
            int diff;
            int mn;
            int mx;
            block49: {
                splitStrings = new ArrayList<String>();
                asciiIntMax = TeradataSplitUtils.getStringAsciiList(maxString);
                asciiIntMin = TeradataSplitUtils.getStringAsciiList(minString);
                mx = 0;
                mn = 0;
                if (minString.equals(maxString)) {
                    splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiIntMin));
                    return splitStrings;
                }
                Iterator<Integer> iterator = asciiIntMax.iterator();
                block0: while (true) {
                    if (!iterator.hasNext()) {
                        return splitStrings;
                    }
                    int max = iterator.next();
                    if (mx >= asciiIntMin.size()) {
                        splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiIntMin));
                        sizediff = asciiIntMax.size() - asciiIntMin.size();
                        mxsize = asciiIntMax.size();
                        if (sizediff == numSplits) {
                            int nm = 1;
                            while (true) {
                                if (nm >= numSplits) {
                                    return splitStrings;
                                }
                                List<Integer> asciiInt = asciiIntMin;
                                asciiInt.add(asciiIntMax.get(mxsize - (numSplits - nm + 1)));
                                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
                                ++nm;
                            }
                        }
                        if (sizediff > numSplits) {
                            List<Integer> asciiInt;
                            int nm;
                            int rem = sizediff % numSplits;
                            if (rem == 0) {
                                int numSplitsDiff = sizediff / numSplits;
                                while (nm < sizediff) {
                                    List<Integer> asciiInt2 = asciiIntMin;
                                    asciiInt2.add(asciiIntMax.get(mxsize - (sizediff - nm + 1)));
                                    if (nm % numSplitsDiff == 0) {
                                        splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt2));
                                    }
                                    ++nm;
                                }
                                return splitStrings;
                            }
                            int numSplitsDiff = sizediff / numSplits;
                            for (nm = 1; nm <= sizediff; ++nm) {
                                asciiInt = asciiIntMin;
                                asciiInt.add(asciiIntMax.get(mxsize - (sizediff - nm + 1)));
                                if (nm % (numSplitsDiff + 1) != 0 || asciiInt.size() == asciiIntMax.size()) continue;
                                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
                            }
                            if (splitStrings.size() >= numSplits) return splitStrings;
                            asciiInt = new ArrayList<Integer>();
                            asciiInt.addAll(asciiIntMax);
                            asciiInt.remove(asciiIntMax.size() - 1);
                            asciiInt.add(asciiIntMax.size() - 1, 0);
                            return TeradataSplitUtils.getSplitInDiffSizeMismatch(asciiIntMax, asciiInt, splitStrings, asciiInt.size() - 2, numSplits - splitStrings.size() + 1);
                        }
                        break block48;
                    }
                    for (int min : asciiIntMin) {
                        if (mx == mn) {
                            if (max == min) break;
                            if (max > min) {
                                diff = max - min;
                                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiIntMin));
                                if (diff == numSplits) {
                                    int nm = 1;
                                    int minNum = min;
                                    while (true) {
                                        if (nm >= numSplits) {
                                            return splitStrings;
                                        }
                                        ++minNum;
                                        ArrayList<Integer> asciiInt = new ArrayList<Integer>();
                                        asciiInt.addAll(asciiIntMin);
                                        asciiInt.remove(mn);
                                        asciiInt.add(mn, minNum);
                                        splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
                                        ++nm;
                                    }
                                }
                                if (diff >= numSplits) break block49;
                                if (diff == 1) {
                                    return TeradataSplitUtils.getSplitInDiff(asciiIntMax, asciiIntMin, splitStrings, mn, numSplits);
                                }
                                break block0;
                            }
                        }
                        ++mn;
                    }
                    ++mx;
                    mn = 0;
                }
                int rem = numSplits % diff;
                int iNumSplitsPerDiff = numSplits / diff;
                int nm = 0;
                int getMin = asciiIntMin.get(mn);
                while (true) {
                    block51: {
                        block50: {
                            if (nm >= diff) {
                                return splitStrings;
                            }
                            if (iNumSplitsPerDiff == 1) break block50;
                            ArrayList<Integer> asciiMn = new ArrayList<Integer>();
                            ArrayList<Integer> asciiMx = new ArrayList<Integer>();
                            asciiMn.addAll(asciiIntMin);
                            asciiMx.addAll(asciiIntMax);
                            asciiMn.remove(mn);
                            asciiMn.add(mn, getMin + nm);
                            asciiMx.remove(mx);
                            asciiMx.add(mx, getMin + nm + 1);
                            if (diff - nm == 1) {
                                if ((splitStrings = TeradataSplitUtils.getSplitInDiff(asciiMx, asciiMn, splitStrings, mn, iNumSplitsPerDiff + rem)).size() < numSplits) {
                                    splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiMx));
                                }
                                break block51;
                            } else if ((splitStrings = TeradataSplitUtils.getSplitInDiff(asciiMx, asciiMn, splitStrings, mn, iNumSplitsPerDiff)).size() < numSplits) {
                                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiMx));
                            }
                            break block51;
                        }
                        ArrayList<Integer> asciiInt = new ArrayList<Integer>();
                        asciiInt.addAll(asciiIntMin);
                        asciiInt.remove(mn);
                        asciiInt.add(mn, getMin + nm + 1);
                        if (diff - nm == 1) {
                            ArrayList<Integer> asciiMn = new ArrayList<Integer>();
                            ArrayList<Integer> asciiMx = new ArrayList<Integer>();
                            asciiMn.addAll(asciiIntMin);
                            asciiMx.addAll(asciiIntMax);
                            asciiMn.remove(mn);
                            asciiMn.add(mn, getMin + nm);
                            splitStrings = TeradataSplitUtils.getSplitInDiff(asciiMx, asciiMn, splitStrings, mn, iNumSplitsPerDiff + rem);
                            if (splitStrings.size() < numSplits) {
                                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiMx));
                            }
                        } else if (splitStrings.size() < numSplits) {
                            splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
                        }
                    }
                    ++nm;
                }
            }
            int rem = diff % numSplits;
            int iNumSplitsPerDiff = diff / numSplits;
            int nm = 0;
            int getMin = asciiIntMin.get(mn);
            int getmax = asciiIntMax.get(mx);
            while (true) {
                if (nm >= diff) {
                    return splitStrings;
                }
                ArrayList<Integer> asciiInt = new ArrayList<Integer>();
                if (diff - nm < rem) {
                    int subValue = 1;
                    if (rem != 1) {
                        subValue = rem / 2;
                    }
                    asciiInt.addAll(asciiIntMax);
                    asciiInt.remove(mn);
                    asciiInt.add(mn, getmax - subValue);
                    nm = diff + 1;
                } else {
                    asciiInt.addAll(asciiIntMin);
                    asciiInt.remove(mn);
                    if (getMin + (iNumSplitsPerDiff + nm) >= getmax) {
                        asciiInt.add(mn, getmax - 1);
                        nm = diff + 1;
                    } else if (rem == 0) {
                        asciiInt.add(mn, getMin + (iNumSplitsPerDiff + nm));
                        nm = iNumSplitsPerDiff + nm;
                    } else if (iNumSplitsPerDiff != 1) {
                        asciiInt.add(mn, getMin + (iNumSplitsPerDiff + nm + 1));
                        nm = iNumSplitsPerDiff + nm + 1;
                    } else if (nm == numSplits - 1) {
                        nm = diff + 1;
                    } else {
                        asciiInt.add(mn, getMin + (iNumSplitsPerDiff + nm));
                        nm = iNumSplitsPerDiff + nm;
                    }
                }
                if (splitStrings.size() >= numSplits) continue;
                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
            }
        }
        int rem = numSplits % sizediff;
        int iNumSplitsPerDiff = numSplits / sizediff;
        int nm = 0;
        while (nm < sizediff) {
            List<Integer> asciiInt = asciiIntMin;
            asciiInt.add(asciiIntMax.get(mxsize - (sizediff - nm)));
            ArrayList<Integer> asciiMn = new ArrayList<Integer>();
            ArrayList<Integer> asciiMx = new ArrayList<Integer>();
            asciiMx.addAll(asciiInt);
            asciiMn.addAll(asciiInt);
            asciiMn.remove(asciiMn.size() - 1);
            asciiMn.add(0);
            if (sizediff - nm == 1) {
                splitStrings = TeradataSplitUtils.getSplitInDiffSizeMismatch(asciiMx, asciiMn, splitStrings, asciiMn.size() - 2, iNumSplitsPerDiff + rem);
            } else if (iNumSplitsPerDiff == 1) {
                splitStrings.add(TeradataSplitUtils.getAsciiToString(asciiInt));
            } else {
                splitStrings = TeradataSplitUtils.getSplitInDiffSizeMismatch(asciiMx, asciiMn, splitStrings, asciiMn.size() - 2, iNumSplitsPerDiff + 1);
            }
            ++nm;
        }
        return splitStrings;
    }

    public static List<TeradataInputFormat.TeradataInputSplit> getSplitsByColumnType(Configuration configuration, String splitbyColumn, ResultSet resultSetMinMaxValues) throws ConnectorException {
        try {
            int splitColumnDataType = resultSetMinMaxValues.getMetaData().getColumnType(1);
            switch (splitColumnDataType) {
                case 2: 
                case 3: {
                    return TeradataSplitUtils.getSplitsByDecimalType(configuration, splitbyColumn, resultSetMinMaxValues.getBigDecimal(1), resultSetMinMaxValues.getBigDecimal(2));
                }
                case -7: 
                case 16: {
                    return TeradataSplitUtils.getSplitsByBooleanType(configuration, splitbyColumn, resultSetMinMaxValues.getBoolean(1), resultSetMinMaxValues.getBoolean(2));
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return TeradataSplitUtils.getSplitsByIntType(configuration, splitbyColumn, resultSetMinMaxValues.getLong(1), resultSetMinMaxValues.getLong(2));
                }
                case 6: 
                case 7: 
                case 8: {
                    return TeradataSplitUtils.getSplitsByDoubleType(configuration, splitbyColumn, resultSetMinMaxValues.getDouble(1), resultSetMinMaxValues.getDouble(2));
                }
                case -1: 
                case 1: 
                case 12: {
                    return TeradataSplitUtils.getSplitsByStringType(configuration, splitbyColumn, resultSetMinMaxValues.getString(1), resultSetMinMaxValues.getString(2));
                }
                case 91: 
                case 92: 
                case 93: {
                    return TeradataSplitUtils.getSplitsByTimeType(configuration, splitbyColumn, resultSetMinMaxValues);
                }
            }
            throw new ConnectorException(23001);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static int getSupportedCharCode(int charCode) {
        if (charCode < 578) {
            return charCode <= 32 ? 33 : charCode;
        }
        if (charCode <= 591) {
            charCode = 592;
        } else if (charCode >= 880 && charCode <= 909) {
            charCode = 910;
        } else if (charCode >= 930 && charCode <= 1424) {
            charCode = 1425;
        } else if (charCode >= 1466 && charCode <= 1599) {
            charCode = 1600;
        } else if (charCode == 1631) {
            charCode = 1632;
        } else if (charCode == 1806) {
            charCode = 1807;
        } else if (charCode == 1867 || charCode == 1868) {
            charCode = 1869;
        } else if (charCode >= 1902 && charCode <= 1919) {
            charCode = 1920;
        } else if (charCode >= 1970 && charCode <= 2304) {
            charCode = 2305;
        } else if (charCode >= 2362 && charCode <= 2564) {
            charCode = 2565;
        } else if (charCode >= 2571 && charCode <= 4255) {
            charCode = 4256;
        } else if (charCode >= 4294 && charCode <= 4351) {
            charCode = 4352;
        } else if (charCode >= 4442 && charCode <= 4446) {
            charCode = 4447;
        } else if (charCode >= 4515 && charCode <= 4519) {
            charCode = 4520;
        } else if (charCode >= 4602 && charCode <= 5120) {
            charCode = 5121;
        } else if (charCode >= 5751 && charCode <= 8207) {
            charCode = 8208;
        } else if (charCode >= 8266 && charCode <= 9311) {
            charCode = 9312;
        } else if (charCode >= 9840 && charCode <= 13311) {
            charCode = 13312;
        } else if (charCode >= 19894 && charCode <= 19967) {
            charCode = 19968;
        } else if (charCode >= 40892 && charCode <= 44031) {
            charCode = 44032;
        } else if (charCode >= 55204 && charCode <= 64466) {
            charCode = 64467;
        } else if (charCode >= 64832 && charCode <= 64847) {
            charCode = 64848;
        } else if (charCode == 64912 || charCode == 64913) {
            charCode = 64914;
        } else if (charCode >= 64968 && charCode <= 65071) {
            charCode = 65072;
        } else if (charCode >= 65107 && charCode <= 65141) {
            charCode = 65142;
        } else if (charCode >= 65277 && charCode <= 65280) {
            charCode = 65281;
        } else if (charCode >= 65471) {
            charCode = 65470;
        }
        return charCode;
    }
}

