/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LogContainer {
    private List<String> lstException = new ArrayList<String>();
    private static final LogContainer holder = new LogContainer();

    private List<String> getData() {
        return this.lstException;
    }

    private void setData(List<String> data) {
        this.lstException = data;
    }

    public int listSize() {
        return this.lstException.size();
    }

    public static LogContainer getInstance() {
        return holder;
    }

    public void addLogToList(String logExceptionRow, Configuration configuration) throws ConnectorException {
        List<String> lstException = this.getData();
        int logRowLimit = ConnectorConfiguration.getLogRowsCount(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        int limitRowsQuo = logRowLimit / numMappers;
        int limitRowsRem = logRowLimit % numMappers;
        if (this.listSize() >= limitRowsQuo + limitRowsRem) {
            throw new ConnectorException(String.format("Number of rows in HDFS log exceeded limit", "-limitrows", "expected  more "));
        }
        lstException.add(logExceptionRow);
        this.setData(lstException);
    }

    public void writeHdfsLogs(Configuration configuration) throws ConnectorException {
        String path = ConnectorConfiguration.getHdfsLoggingPath(configuration) + TeradataPlugInConfiguration.getOutputTable(configuration) + System.currentTimeMillis() + ".log";
        try {
            FileSystem fs = FileSystem.get((Configuration)configuration);
            Path filenamePath = new Path(path);
            if (fs.exists(filenamePath)) {
                fs.delete(filenamePath, true);
            }
            FSDataOutputStream fin = fs.create(filenamePath);
            for (String lstStr : this.lstException) {
                fin.writeChars(lstStr + "\n");
            }
            fin.close();
        }
        catch (Exception e) {
            throw new ConnectorException(String.format("Error while writing HDFS log", new Object[0]));
        }
    }
}

