/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.schema;

import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import junit.framework.Assert;
import org.junit.Test;

public class TeradataColumnDescTest {
    @Test
    public void testGetScale() {
        TeradataColumnDesc desc = new TeradataColumnDesc();
        desc.setType(93);
        desc.setScale(7);
        Assert.assertEquals((int)6, (int)desc.getScale());
        desc.setType(2002);
        desc.setTypeName("TIME_PERIOD");
        Assert.assertEquals((int)6, (int)desc.getScale());
    }

    @Test
    public void testGetLobLengthInKMG() {
        TeradataColumnDesc desc = new TeradataColumnDesc();
        desc.setLength(2048L);
        Assert.assertEquals((String)"2K", (String)desc.getLobLengthInKMG());
        desc.setLength(0x400000L);
        Assert.assertEquals((String)"4M", (String)desc.getLobLengthInKMG());
        desc.setLength(0x200000000L);
        Assert.assertEquals((String)"8G", (String)desc.getLobLengthInKMG());
    }

    @Test
    public void testGetTypeString4Using() {
        TeradataColumnDesc desc = new TeradataColumnDesc();
        desc.setType(1);
        desc.setLength(20L);
        Assert.assertEquals((String)"VARCHAR(60)", (String)desc.getTypeString4Using("UTF8", 0));
        Assert.assertEquals((String)"VARCHAR(40)", (String)desc.getTypeString4Using("UTF16", 0));
        desc.setLength(0x400000L);
        desc.setType(2005);
        Assert.assertEquals((String)"CLOB(4M)", (String)desc.getTypeString4Using("UTF16", 0));
        desc.setType(92);
        Assert.assertEquals((String)"CHAR(16)", (String)desc.getTypeString4Using("UTF16", 0));
        Assert.assertEquals((String)"CHAR(14)", (String)desc.getTypeString4Using("UTF8", 5));
        Assert.assertEquals((String)"CHAR(30)", (String)desc.getTypeString4Using("UTF16", 6));
        desc.setType(93);
        Assert.assertEquals((String)"CHAR(38)", (String)desc.getTypeString4Using("UTF16", 0));
        Assert.assertEquals((String)"CHAR(24)", (String)desc.getTypeString4Using("UTF8", 4));
        Assert.assertEquals((String)"CHAR(52)", (String)desc.getTypeString4Using("UTF16", 6));
        desc.setType(0);
        Assert.assertEquals((String)"", (String)desc.getTypeString4Using("UTF8", 0));
    }

    @Test
    public void testGetTypeStringWithoutNullability() {
        TeradataColumnDesc desc = new TeradataColumnDesc();
        desc.setType(1);
        desc.setCharType(2);
        desc.setCaseSensitive(true);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("UNICODE"));
        desc.setType(12);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("CASESPECIFIC"));
        desc.setType(-1);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("UNICODE CASESPECIFIC"));
        desc.setType(6);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("FLOAT"));
        desc.setType(7);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("REAL"));
        desc.setType(2);
        desc.setTypeName("NUMERIC");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("NUMERIC(0, 0)"));
        desc.setType(2005);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().contains("UNICODE"));
        desc.setType(2002);
        desc.setTypeName("TIME");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("TIME"));
        desc.setTypeName("TIMESTAMP_WITH_PERIOD");
        desc.setScale(7);
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("PERIOD(TIMESTAMP)"));
        desc.setTypeName("TIME_WITH_PERIOD");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("PERIOD(TIME)"));
        desc.setTypeName("PERIOD");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("PERIOD"));
        desc.setType(-7);
        desc.setTypeName("BIT");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("BIT"));
        desc.setType(2009);
        desc.setTypeName("XML");
        Assert.assertTrue((boolean)desc.getTypeStringWithoutNullability().equals("XML"));
    }
}

