/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.processor;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataOutputProcessor;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class TeradataBatchInsertProcessor
extends TeradataOutputProcessor {
    public static String taskIDColumnName = "TDCH_BI_TASKID";
    private static Log logger = LogFactory.getLog(TeradataBatchInsertProcessor.class);

    @Override
    public void setupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
        String outputTableName;
        String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
        String objectName = outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
        outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
        String stageDatabase = TeradataPlugInConfiguration.getOutputStageDatabase(configuration);
        String stageTableName = TeradataPlugInConfiguration.getOutputStageTableName(configuration);
        boolean stagingEnabled = true;
        if (!TeradataPlugInConfiguration.getOutputStageTableForced(configuration)) {
            try {
                if (this.connection.isTableNoPrimaryIndex(outputTableName)) {
                    stagingEnabled = false;
                }
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        TeradataPlugInConfiguration.setOutputStageEnabled(configuration, stagingEnabled);
        int maxLength = this.connection.getMaxTableNameLength();
        if (stagingEnabled) {
            if (stageTableName.isEmpty()) {
                stageTableName = TeradataSchemaUtils.getStageTableName(maxLength, objectName, "TDCBISTAGE");
            } else if (stageTableName.length() > maxLength) {
                throw new ConnectorException(13014, maxLength);
            }
            TeradataPlugInConfiguration.setOutputStageAreas(configuration, stageTableName);
            TeradataPlugInConfiguration.setOutputFinalTable(configuration, objectName);
            TeradataPlugInConfiguration.setOutputFinalDatabase(configuration, outputDatabase);
            TeradataPlugInConfiguration.setOutputTable(configuration, stageTableName);
            TeradataPlugInConfiguration.setOutputDatabase(configuration, stageDatabase);
            TeradataColumnDesc[] fieldDescs = TeradataSchemaUtils.tableDescFromText(TeradataPlugInConfiguration.getOutputTableDesc(configuration)).getColumns();
            TeradataTableDesc stageTableDesc = new TeradataTableDesc();
            stageTableDesc.setName(stageTableName);
            stageTableDesc.setDatabaseName(stageDatabase);
            stageTableDesc.setColumns(fieldDescs);
            stageTableDesc.setHasPrimaryIndex(false);
            stageTableDesc.setHasPartitionColumns(false);
            stageTableDesc.setBlockSize(TeradataPlugInConfiguration.getOutputStageTableBlocksize(configuration));
            TeradataPlugInConfiguration.setOutputTableDesc(configuration, TeradataSchemaUtils.tableDescToJson(stageTableDesc));
            if (!TeradataPlugInConfiguration.getOutputBIDisableFailoverSupport(configuration)) {
                TeradataColumnDesc[] fieldDescsWithTaskID = TeradataSchemaUtils.addTaskIDColumn(fieldDescs, taskIDColumnName);
                stageTableDesc.setColumns(fieldDescsWithTaskID);
            }
            String createStageSQL = TeradataConnection.getCreateTableSQL(stageTableDesc);
            try {
                this.connection.executeDDL(createStageSQL);
                logger.info((Object)("create output stage table " + TeradataPlugInConfiguration.getOutputStageAreas(configuration) + "the sql is " + createStageSQL));
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        } else {
            logger.info((Object)"output staging table is not needed");
        }
    }

    @Override
    public void cleanupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
        if (TeradataPlugInConfiguration.getOutputStageEnabled(configuration)) {
            String outputDatabase = TeradataPlugInConfiguration.getOutputFinalDatabase(configuration);
            String outputTableName = TeradataPlugInConfiguration.getOutputFinalTable(configuration);
            String stageDatabase = TeradataPlugInConfiguration.getOutputStageDatabase(configuration);
            String stageTableName = TeradataPlugInConfiguration.getOutputStageAreas(configuration);
            String[] outputTableFieldNames = TeradataPlugInConfiguration.getOutputFieldNamesArray(configuration);
            boolean jobSucceeded = ConnectorConfiguration.getJobSucceeded(configuration);
            outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
            stageTableName = TeradataConnection.getQuotedEscapedName(stageDatabase, stageTableName);
            boolean stageTableInsertSelected = false;
            boolean stageTableDeleted = false;
            SQLException firstException = null;
            boolean stageKept = TeradataPlugInConfiguration.getOutputStageTableKept(configuration);
            if (jobSucceeded) {
                try {
                    logger.info((Object)"insert from staget table to target table ");
                    long startTime = System.currentTimeMillis();
                    logger.info((Object)("the insert select sql starts at: " + startTime));
                    this.connection.executeInsertSelect(stageTableName, outputTableFieldNames, outputTableName, outputTableFieldNames);
                    long endTime = System.currentTimeMillis();
                    logger.info((Object)("the insert select sql ends at: " + endTime));
                    logger.info((Object)("the total elapsed time of the insert select sql  is: " + (endTime - startTime) / 1000L + "s"));
                    stageTableInsertSelected = true;
                }
                catch (SQLException e) {
                    firstException = e;
                    logger.debug((Object)e.getMessage());
                }
                if (stageTableInsertSelected) {
                    try {
                        this.connection.dropTable(stageTableName);
                        logger.info((Object)("drop stage table " + stageTableName));
                        stageTableDeleted = true;
                    }
                    catch (SQLException e) {
                        firstException = e;
                        logger.debug((Object)e.getMessage());
                    }
                } else if (!stageKept) {
                    try {
                        this.connection.dropTable(stageTableName);
                        logger.info((Object)("drop stage table " + stageTableName));
                        stageTableDeleted = true;
                    }
                    catch (SQLException e) {
                        logger.debug((Object)e.getMessage());
                    }
                }
            } else if (!stageKept) {
                try {
                    this.connection.dropTable(stageTableName);
                    logger.info((Object)("drop stage table " + stageTableName));
                    stageTableDeleted = true;
                }
                catch (SQLException e) {
                    logger.debug((Object)e.getMessage());
                }
            }
            if (!stageTableInsertSelected && stageKept) {
                logger.warn((Object)("unable to insert data from staging table into the target table. Please manually move data from " + stageTableName + " into the target table"));
            }
            if (!stageTableDeleted) {
                logger.warn((Object)("staging table " + stageTableName + " is not dropped"));
            }
            if (firstException != null) {
                throw new ConnectorException(firstException.getMessage(), firstException);
            }
        }
    }

    @Override
    protected void validateConfiguration(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        super.validateConfiguration(configuration, connection);
        if (TeradataPlugInConfiguration.getOutputBatchSize(configuration) > 13683) {
            TeradataPlugInConfiguration.setOutputBatchSize(configuration, 13683);
        }
    }
}

