/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.db;

import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.common.utils.StandardCharsets;
import com.teradata.connector.teradata.processor.TeradataBatchInsertProcessor;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.schema.TeradataViewDesc;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdk6.JDK6_SQL_ResultSetMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;

public class TeradataConnection {
    private static Log logger = LogFactory.getLog(TeradataConnection.class);
    protected String className = null;
    protected String url = null;
    protected String userName = null;
    protected String password = null;
    protected String currentDatabase = "";
    protected int ampCount = 0;
    protected Connection connection = null;
    protected Configuration configuration;
    protected String dbProductName;
    protected int dbMajorVersion;
    protected int dbMinorVersion;
    protected int jdbcMajorVersion;
    protected int jdbcMinorVersion;
    protected int maxTableNameLength;
    protected boolean useXView = true;
    protected static final String TERADATA_PRODUCT_NAME = "TERADATA";
    protected static final int TERADATA_MIN_DB_MAJOR_VERSION = 13;
    protected static final int TERADATA_MIN_DB_MINOR_VERSION = 0;
    protected static final int TERADATA_MIN_JDBC_MAJOR_VERSION = 13;
    protected static final int TERADATA_MIN_JDBC_MINOR_VERSION = 0;
    protected static final int TERADATA_MIN_DB_MAJOR_VERSION_EON = 14;
    protected static final int TERADATA_MIN_DB_MINOR_VERSION_EON = 10;
    public static final String JDBC_CONNECTION_TYPE_PROPERTY = "TYPE";
    public static final String JDBC_CONNECTION_FASTLOAD_VALUE = "TYPE=FASTLOAD";
    public static final String FASTLOAD_ERROR_TABLE_EXT_ONE = "_ERR_1";
    public static final String FASTLOAD_ERROR_TABLE_EXT_TWO = "_ERR_2";
    public static final int DB_TABLE_BLOCKSIZE_MAX = 130048;
    protected static final String SQL_SET_QUERY_BAND = "SET QUERY_BAND = '%s' For Session";
    protected static final String SQL_ENABLE_UNICODE_PASSTHROUGH = "SET SESSION CHARACTER SET UNICODE PASS THROUGH ON";
    protected static final String ACCESS_LOCK_SQL = "LOCK ROW FOR ACCESS ";
    protected static final int JDBC_RESULTSET_BUFFER_MAX = 0x100000;
    protected static final String JDBC_CONNECTION_DATABASE_PROPERTY = "DATABASE";
    protected static final int JDBC_STATEMENT_LENGTH_MAX = 524288;
    protected static final String SQL_GET_AMP_COUNT = "{fn teradata_amp_count()}";
    protected static final String SQL_GET_CURRENT_DATABASE = "SELECT DATABASE";
    protected static final String SQL_GET_CURRENT_TIMESTAMP = "SELECT CURRENT_TIMESTAMP";
    protected static final String SQL_GET_TABLE_ROW_COUNT = "SELECT CAST(COUNT(*) AS BIGINT) FROM %s %s";
    protected static final String SQL_IS_TABLE_NONEMPTY = "SELECT CAST(COUNT(*) AS BIGINT) FROM %s";
    protected static final String SQL_TABLE_DELETE_STMT = "DELETE FROM %s";
    protected static final String SQL_SELECT_FROM_SOURCE_WHERE = "SELECT %s FROM %s %s";
    protected static final String SQL_INSERT = "INSERT INTO %s (%s) VALUES (%s)";
    protected static final String SQL_INSERT_SELECT_INTO_TABLE = "INSERT INTO %s (%s) SELECT %s FROM %s";
    protected static final String SQL_CREATE_TABLE = "CREATE %s TABLE %s, %s NO FALLBACK, NO BEFORE JOURNAL, NO AFTER JOURNAL, CHECKSUM = DEFAULT (%s) %s %s";
    protected static final String SQL_DROP_TABLE = "DROP TABLE %s";
    protected static final String SQL_CREATE_VIEW = "CREATE VIEW %s (%s) AS %s";
    protected static final String SQL_DROP_VIEW = "DROP VIEW %s";
    protected static final String SQL_DELETE_FROM_TABLE = "DELETE FROM %s %s";
    protected static final String SQL_USING_INSERT_INTO_TABLE = "USING %s INSERT INTO %s ( %s ) VALUES ( %s )";
    protected static final String SQL_CHECK_TABLE_FASTLOADABLE = "SELECT COUNT(*) as NOTFASTLOADABLE FROM DBC.INDICESV IDX   WHERE IDX.DATABASENAME = %s AND IDX.TABLENAME = %s AND IDX.INDEXTYPE NOT IN ('P', 'Q')  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.COLUMNSV COL   WHERE COL.DATABASENAME = %s AND COL.TABLENAME = %s AND COL.COLUMNCONSTRAINT IS NOT NULL  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.TABLE_LEVELCONSTRAINTSV TL   WHERE TL.DATABASENAME = %s AND TL.TABLENAME = %s  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.TRIGGERSV TR   WHERE TR.DATABASENAME = %s AND TR.TABLENAME = %s  UNION ALL SELECT PARENTCOUNT + CHILDCOUNT AS NOTFASTLOADABLE FROM DBC.TABLESV T   WHERE T.DATABASENAME = %s AND T.TABLENAME = %s";
    protected static final String SQL_CHECK_TABLE_FASTLOADABLE_XVIEW = "SELECT COUNT(*) as NOTFASTLOADABLE FROM DBC.INDICESVX IDX   WHERE IDX.DATABASENAME = %s AND IDX.TABLENAME = %s AND IDX.INDEXTYPE NOT IN ('P', 'Q')  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.COLUMNSVX COL   WHERE COL.DATABASENAME = %s AND COL.TABLENAME = %s AND COL.COLUMNCONSTRAINT IS NOT NULL  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.TABLE_LEVELCONSTRAINTSVX TL   WHERE TL.DATABASENAME = %s AND TL.TABLENAME = %s  UNION ALL SELECT COUNT(*) AS NOTFASTLOADABLE FROM DBC.TRIGGERSVX TR   WHERE TR.DATABASENAME = %s AND TR.TABLENAME = %s  UNION ALL SELECT PARENTCOUNT + CHILDCOUNT AS NOTFASTLOADABLE FROM DBC.TABLESVX T   WHERE T.DATABASENAME = %s AND T.TABLENAME = %s";
    protected static final String SQL_GET_DATABASES = "SELECT TRIM(TRAILING FROM DBS.DATABASENAME) AS DATABASENAME FROM DBC.DATABASESV DBS";
    protected static final String SQL_GET_DATABASES_XVIEW = "SELECT TRIM(TRAILING FROM DBS.DATABASENAME) AS DATABASENAME FROM DBC.DATABASESVX DBS";
    protected static final String SQL_GET_TABLES = "SELECT TRIM(TRAILING FROM T.TABLENAME) AS TABLENAME FROM DBC.TABLESV T WHERE T.DATABASENAME = %s and (T.TABLEKIND IN ('O', 'T'))";
    protected static final String SQL_GET_TABLES_XVIEW = "SELECT TRIM(TRAILING FROM T.TABLENAME) AS TABLENAME FROM DBC.TABLESVX T WHERE T.DATABASENAME = %s and (T.TABLEKIND IN ('O', 'T'))";
    protected static final String SQL_GET_PRIMARY_KEY = "SELECT TRIM(TRAILING FROM RST.COLUMNNAME) AS COLUMNNAME FROM (   SELECT 1 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESV I   WHERE I.INDEXTYPE = 'K' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s UNION ALL   SELECT 2 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESV I   WHERE I.INDEXTYPE = 'P' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s UNION ALL   SELECT 3 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESV I   WHERE I.INDEXTYPE = 'S' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s ) RST QUALIFY RANK(RST.INDEXORDER ASC, RST.INDEXNUMBER ASC) = 1 ORDER BY RST.COLUMNPOSITION ASC";
    protected static final String SQL_GET_PRIMARY_KEY_XVIEW = "SELECT TRIM(TRAILING FROM RST.COLUMNNAME) AS COLUMNNAME FROM (   SELECT 1 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESVX I   WHERE I.INDEXTYPE = 'K' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s UNION ALL   SELECT 2 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESVX I   WHERE I.INDEXTYPE = 'P' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s UNION ALL   SELECT 3 AS INDEXORDER, I.INDEXNUMBER, I.COLUMNNAME, I.COLUMNPOSITION FROM DBC.INDICESVX I   WHERE I.INDEXTYPE = 'S' AND I.UNIQUEFLAG = 'Y' AND I.DATABASENAME = %s AND I.TABLENAME = %s ) RST QUALIFY RANK(RST.INDEXORDER ASC, RST.INDEXNUMBER ASC) = 1 ORDER BY RST.COLUMNPOSITION ASC";
    protected static final String SQL_GET_TABLE_KIND = "SELECT TRIM(T.TABLEKIND) AS TABLEKIND FROM DBC.TABLESV T WHERE T.DATABASENAME = %s AND T.TABLENAME = %s";
    protected static final String SQL_GET_TABLE_KIND_XVIEW = "SELECT TRIM(T.TABLEKIND) AS TABLEKIND FROM DBC.TABLESVX T WHERE T.DATABASENAME = %s AND T.TABLENAME = %s";
    protected static final String SQL_GET_PRIMARY_INDEX = "SELECT TRIM(TRAILING FROM I.COLUMNNAME) AS COLUMNNAME FROM DBC.INDICESV I  WHERE I.DATABASENAME = %s AND I.TABLENAME = %s AND (I.INDEXTYPE IN ('P', 'Q'))";
    protected static final String SQL_GET_PRIMARY_INDEX_XVIEW = "SELECT TRIM(TRAILING FROM I.COLUMNNAME) AS COLUMNNAME FROM DBC.INDICESVX I  WHERE I.DATABASENAME = %s AND I.TABLENAME = %s AND (I.INDEXTYPE IN ('P', 'Q'))";
    protected static final String SQL_GET_PARTITIONED_PRIMARY_INDEX = "SELECT TRIM(TRAILING FROM I.COLUMNNAME) AS COLUMNNAME FROM DBC.INDICESV I  WHERE UPPER(I.DATABASENAME) = UPPER(%s) AND I.TABLENAME = %s AND (I.INDEXTYPE = 'Q')";
    protected static final String SQL_GET_PARTITIONED_PRIMARY_INDEX_XVIEW = "SELECT TRIM(TRAILING FROM I.COLUMNNAME) AS COLUMNNAME FROM DBC.INDICESVX I  WHERE UPPER(I.DATABASENAME) = UPPER(%s) AND I.TABLENAME = %s AND (I.INDEXTYPE = 'Q')";
    protected static final String SQL_GET_TABLE_COLUMNS = "SELECT TRIM(TRAILING FROM C.COLUMNNAME) AS COLUMNNAME FROM DBC.COLUMNSV C  WHERE C.DATABASENAME = %s AND C.TABLENAME = %s ORDER BY COLUMNID";
    protected static final String SQL_GET_TABLE_COLUMNS_XVIEW = "SELECT TRIM(TRAILING FROM C.COLUMNNAME) AS COLUMNNAME FROM DBC.COLUMNSVX C  WHERE C.DATABASENAME = %s AND C.TABLENAME = %s ORDER BY COLUMNID";
    protected static final String SQL_GET_TABLE_COLUMN_INFOS = "SELECT TRIM(TRAILING FROM C.COLUMNNAME) AS COLUMNNAME, CHARTYPE FROM DBC.COLUMNSV C  WHERE C.DATABASENAME = %s AND C.TABLENAME = %s ORDER BY COLUMNID";
    protected static final String SQL_GET_TABLE_COLUMN_INFOS_XVIEW = "SELECT TRIM(TRAILING FROM C.COLUMNNAME) AS COLUMNNAME, CHARTYPE FROM DBC.COLUMNSVX C  WHERE C.DATABASENAME = %s AND C.TABLENAME = %s ORDER BY COLUMNID";
    protected static final String SQL_GET_PARTITION_DISTINCT = "SELECT DISTINCT PARTITION FROM %s";
    protected static final String SQL_GET_PARTITION_COUNT = "SELECT CAST(COUNT(DISTINCT PARTITION) as BIGINT) FROM %s";
    protected static final String SQL_GET_PARTITION_MIN_MAX = "SELECT CAST(MIN(PARTITION) AS BIGINT), CAST(MAX(PARTITION) AS BIGINT) FROM %s";
    protected static final String SQL_UNION_ALL_SELECT = " UNION ALL ";
    private static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";

    public TeradataConnection(String className, String url, String userName, String password, Boolean useXview) {
        this.className = className;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.useXView = useXview;
    }

    public String getDatabaseProductName() {
        return this.dbProductName;
    }

    public int getDatabaseMajorVersion() {
        return this.dbMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.dbMinorVersion;
    }

    public int getJDBCMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public int getJDBCMinorVersion() {
        return this.jdbcMinorVersion;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || !this.connection.isClosed()) {
            return this.connection;
        }
        return null;
    }

    public void connect() throws SQLException, ClassNotFoundException {
        if (this.connection == null || this.connection.isClosed()) {
            Class.forName(this.className);
            this.connection = this.userName == null ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.userName, this.password);
        }
    }

    public void connect(byte[] userNameBytes, byte[] passwordBytes) throws SQLException, ClassNotFoundException {
        Class.forName(this.className);
        this.connection = null == userNameBytes || null == passwordBytes ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, new String(userNameBytes, StandardCharsets.UTF_8), new String(passwordBytes, StandardCharsets.UTF_8));
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection.nativeSQL(sql);
        }
        return null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.setTransactionIsolation(level);
        }
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.connection = null;
        }
    }

    public void executeDDL(String sql) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            Statement statement = this.connection.createStatement();
            statement.execute(sql);
            statement.close();
            this.connection.commit();
        }
    }

    public void executeUpdate(String sql) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            Statement statement = this.connection.createStatement();
            logger.debug((Object)sql);
            statement.executeUpdate(sql);
            statement.close();
        }
    }

    public void createTable(TeradataTableDesc tableDesc) throws SQLException {
        String createTableSQL = TeradataConnection.getCreateTableSQL(tableDesc);
        logger.debug((Object)createTableSQL);
        this.executeDDL(createTableSQL);
    }

    public void createView(TeradataViewDesc viewDesc) throws SQLException {
        String createViewSQL = TeradataConnection.getCreateViewSQL(viewDesc);
        logger.debug((Object)createViewSQL);
        this.executeDDL(createViewSQL);
    }

    public void dropTables(String[] tableNames) throws SQLException {
        for (int i = 0; i < tableNames.length; ++i) {
            String dropTableSQL = TeradataConnection.getDropTableSQL(tableNames[i]);
            logger.debug((Object)dropTableSQL);
            this.executeDDL(dropTableSQL);
        }
    }

    public void dropTable(String tableName) throws SQLException {
        String dropTableSQL = TeradataConnection.getDropTableSQL(tableName);
        logger.debug((Object)dropTableSQL);
        this.executeDDL(dropTableSQL);
    }

    public void dropView(String viewName) throws SQLException {
        String dropViewSQL = TeradataConnection.getDropViewSQL(viewName);
        logger.debug((Object)dropViewSQL);
        this.executeDDL(dropViewSQL);
    }

    public void deleteTable(String tableName) throws SQLException {
        String deleteSQL = TeradataConnection.getDeleteTableSQL(tableName, null);
        logger.debug((Object)deleteSQL);
        this.executeUpdate(deleteSQL);
    }

    public void deleteTable(String tableName, String condition) throws SQLException {
        String deleteSQL = TeradataConnection.getDeleteTableSQL(tableName, condition);
        logger.debug((Object)deleteSQL);
        this.executeUpdate(deleteSQL);
    }

    public void executeInsertUnionSelect(String targetTableName, String[] targetFieldNames, String[] sourceTableNames, String[] sourceFieldNames) throws SQLException {
        String unionInsertSQL = TeradataConnection.getInsertSelectSQL(targetTableName, targetFieldNames, sourceTableNames[0], sourceFieldNames);
        int length = unionInsertSQL.length();
        int unionRequestTextLength = SQL_UNION_ALL_SELECT.length();
        for (int i = 1; i < sourceTableNames.length; ++i) {
            String selectSQL = TeradataConnection.getSelectSQL(sourceTableNames[i], sourceFieldNames, null);
            length += selectSQL.length();
            if ((length += unionRequestTextLength) <= 524288) {
                unionInsertSQL = unionInsertSQL + SQL_UNION_ALL_SELECT + selectSQL;
                continue;
            }
            logger.debug((Object)unionInsertSQL);
            this.executeUpdate(unionInsertSQL);
            unionInsertSQL = TeradataConnection.getInsertSelectSQL(targetTableName, targetFieldNames, sourceTableNames[i], sourceFieldNames);
            length = unionInsertSQL.length();
        }
        logger.debug((Object)unionInsertSQL);
        this.executeUpdate(unionInsertSQL);
    }

    public void executeInsertSelect(String sourceTableName, String[] sourceColumns, String targetTableName, String[] targetColumns) throws SQLException {
        String insertSelectSQL = TeradataConnection.getInsertSelectSQL(targetTableName, targetColumns, sourceTableName, sourceColumns);
        logger.debug((Object)insertSelectSQL);
        this.executeUpdate(insertSelectSQL);
    }

    public String getTableKind(String tableName) throws SQLException {
        if (this.connection != null) {
            String tableKind = "";
            String sql = TeradataConnection.getTableKindSQL(tableName, this.useXView);
            logger.debug((Object)sql);
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                tableKind = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            return tableKind;
        }
        return "";
    }

    public boolean isTable(String tableName) throws SQLException {
        String tableKind = this.getTableKind(tableName).trim();
        return tableKind.equalsIgnoreCase("T") || tableKind.equalsIgnoreCase("O");
    }

    public boolean isTableFastloadable(String tableName) throws SQLException {
        if (this.connection != null) {
            boolean isFastloadable = true;
            String checkFastloadableSql = TeradataConnection.getCheckTableFastloadableSQL(tableName, this.useXView);
            logger.debug((Object)("check fastloadableSql is " + checkFastloadableSql));
            String checkTableNonEmptySql = TeradataConnection.getIsTableNonEmptySQL(tableName);
            logger.debug((Object)("check table non empty sql is " + checkTableNonEmptySql));
            Statement stmt = this.connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(checkTableNonEmptySql);
            if (resultSet.next()) {
                long rowCount = resultSet.getLong(1);
                isFastloadable = rowCount <= 0L;
            }
            resultSet.close();
            if (isFastloadable) {
                resultSet = stmt.executeQuery(checkFastloadableSql);
                while (resultSet.next()) {
                    if (resultSet.getLong(1) <= 0L) continue;
                    isFastloadable = false;
                }
                resultSet.close();
            }
            return isFastloadable;
        }
        return false;
    }

    public ArrayList<Long> getTablePartitions(String tableName, Boolean accessLock) throws SQLException {
        ArrayList<Long> partitionValue = new ArrayList<Long>();
        String sql = String.format(SQL_GET_PARTITION_DISTINCT, tableName);
        if (accessLock.booleanValue()) {
            sql = TeradataConnection.addAccessLockToSql(sql);
        }
        logger.debug((Object)sql);
        if (this.connection != null) {
            Statement stmt = this.connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                partitionValue.add(resultSet.getLong(1));
            }
            resultSet.close();
            stmt.close();
        }
        Collections.sort(partitionValue);
        return partitionValue;
    }

    public ArrayList<Long> getTablePartitionMinMax(String tableName) throws SQLException {
        ArrayList<Long> partitionValue = new ArrayList<Long>();
        if (this.connection != null) {
            String sql = String.format(SQL_GET_PARTITION_MIN_MAX, tableName);
            logger.debug((Object)sql);
            Statement stmt = this.connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            if (resultSet.next()) {
                partitionValue.add(resultSet.getLong(1));
                partitionValue.add(resultSet.getLong(2));
            }
            resultSet.close();
            stmt.close();
        }
        return partitionValue;
    }

    public long getTablePartitionCount(String tableName, Boolean accessLock) throws SQLException {
        if (this.connection != null) {
            String sql = String.format(SQL_GET_PARTITION_COUNT, tableName);
            if (accessLock.booleanValue()) {
                sql = TeradataConnection.addAccessLockToSql(sql);
            }
            logger.debug((Object)sql);
            long partitionCount = 0L;
            Statement stmt = this.connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            if (resultSet.next()) {
                partitionCount = resultSet.getLong(1);
            }
            resultSet.close();
            stmt.close();
            return partitionCount;
        }
        return 0L;
    }

    public boolean isTableNoPrimaryIndex(String tableName) throws SQLException {
        return this.getPrimaryIndex(tableName).length == 0;
    }

    public boolean isTablePPI(String tableName) throws SQLException {
        return this.getPartitionedPrimaryIndex(tableName).length != 0;
    }

    public boolean isTableNonEmpty(String tableName) throws SQLException {
        if (this.connection != null) {
            Statement statement = this.connection.createStatement();
            String sql = TeradataConnection.getIsTableNonEmptySQL(tableName);
            logger.debug((Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            long rowCount = 0L;
            if (resultSet.next()) {
                rowCount = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
            return rowCount > 0L;
        }
        return true;
    }

    public boolean isSupportedDatabase() {
        return TERADATA_PRODUCT_NAME.equalsIgnoreCase(this.dbProductName) && (this.dbMajorVersion > 13 || this.dbMajorVersion == 13 && this.dbMinorVersion >= 0);
    }

    public boolean isSupportedJDBC() {
        return this.jdbcMajorVersion > 13 || this.jdbcMajorVersion == 13 && this.jdbcMinorVersion >= 0;
    }

    public String[] getColumnNamesForTable(String tableName) throws SQLException {
        TeradataColumnDesc[] columns = this.getColumnDescsForTable(tableName, null);
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = columns[i].getName();
        }
        return result;
    }

    public String[] getColumnNamesForSQL(String sql) throws SQLException {
        TeradataColumnDesc[] columns = this.getColumnDescsForSQL(sql);
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = columns[i].getName();
        }
        return result;
    }

    public Map<String, Integer> getColumnTypesForSQL(String sql) throws SQLException {
        TeradataColumnDesc[] columns = this.getColumnDescsForSQL(sql);
        HashMap<String, Integer> result = new HashMap<String, Integer>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            result.put(columns[i].getName(), columns[i].getType());
        }
        return result;
    }

    public Map<String, String> getColumnTypeNamesForSQL(String sql) throws SQLException {
        TeradataColumnDesc[] columns = this.getColumnDescsForSQL(sql);
        HashMap<String, String> result = new HashMap<String, String>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            result.put(columns[i].getName(), columns[i].getTypeName());
        }
        return result;
    }

    public TeradataColumnDesc[] getColumnDescsForSQL(String sql) throws SQLException {
        if (this.connection != null) {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            ResultSetMetaData metadata = stmt.getMetaData();
            stmt.close();
            return this.getColumnDescs(metadata);
        }
        return null;
    }

    public TeradataColumnDesc[] getColumnDescsForSQLWithCharSet(String sql, String charset) throws SQLException {
        TeradataColumnDesc[] columnDescs = this.getColumnDescsForSQL(sql);
        if (columnDescs != null && columnDescs.length > 0) {
            int charType = 1;
            if (!ConnectorStringUtils.isEmpty(charset) && (charset.equalsIgnoreCase("UTF8") || charset.equalsIgnoreCase("UTF16"))) {
                charType = 2;
            }
            block3: for (TeradataColumnDesc columnDesc : columnDescs) {
                switch (columnDesc.getType()) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        columnDesc.setCharType(charType);
                        continue block3;
                    }
                    default: {
                        columnDesc.setCharType(0);
                    }
                }
            }
        }
        return columnDescs;
    }

    public TeradataColumnDesc[] getColumnDescsForTable(String tableName, String[] columnNames) throws SQLException {
        String selectColumnsSQL = TeradataConnection.getSelectSQL(tableName, columnNames, null);
        TeradataColumnDesc[] columnDescs = this.getColumnDescsForSQL(selectColumnsSQL);
        HashMap<String, Integer> columnNamesMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnDescs.length; ++i) {
            columnNamesMap.put(columnDescs[i].getName().toUpperCase(), i);
        }
        String selectColumnInfosSQL = TeradataConnection.getListColumnInfosSQL(tableName, this.useXView);
        Statement stmt = this.connection.createStatement();
        ResultSet resultSet = stmt.executeQuery(selectColumnInfosSQL);
        while (resultSet.next()) {
            String colName = resultSet.getString("COLUMNNAME").toUpperCase();
            Integer pos = (Integer)columnNamesMap.get(colName);
            if (pos == null) continue;
            TeradataColumnDesc columnDesc = columnDescs[pos];
            columnDesc.setCharType(resultSet.getInt("CHARTYPE"));
        }
        return columnDescs;
    }

    public String[] getListColumns(String tableName) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getListColumnsSQL(tableName, this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        logger.debug((Object)sql);
        while (resultSet.next()) {
            tables.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return tables.toArray(new String[tables.size()]);
    }

    public String[] getPrimaryKey(String tableName) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getPrimaryKeySQL(tableName, this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            primaryKeys.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return primaryKeys.toArray(new String[0]);
    }

    public String[] getPrimaryIndex(String tableName) throws SQLException {
        ArrayList<String> primaryIndices = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getPrimaryIndexSQL(tableName, this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            primaryIndices.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return primaryIndices.toArray(new String[0]);
    }

    public void truncateTable(String tableName) throws SQLException {
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getTableDeleteStmt(tableName);
        statement.executeQuery(sql);
        statement.close();
    }

    public String[] getPartitionedPrimaryIndex(String tableName) throws SQLException {
        ArrayList<String> ppiIndices = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getPartitionedPrimaryIndexSQL(tableName, this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            ppiIndices.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return ppiIndices.toArray(new String[0]);
    }

    public String[] getTablesOfNameStartWith(String databaseName, String tablePattern) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        String database = databaseName;
        String tableName = tablePattern;
        String selectTableSQL = null;
        int index = tablePattern.indexOf(46);
        String dbcTablesView = "DBC.TABLESV";
        if (this.useXView) {
            dbcTablesView = "DBC.TABLESVX";
        }
        if (index > 0) {
            database = tablePattern.substring(0, index);
            tableName = tablePattern.substring(index + 1);
            selectTableSQL = TeradataConnection.getSelectSQL(dbcTablesView, new String[]{"TRIM(TRAILING FROM TABLENAME)"}, "DATABASENAME = '" + database + "' AND TABLENAME LIKE '" + tableName + "%'", false);
        } else if (database == null || database.isEmpty()) {
            database = SQL_GET_CURRENT_DATABASE;
            selectTableSQL = TeradataConnection.getSelectSQL(dbcTablesView, new String[]{"TRIM(TRAILING FROM TABLENAME)"}, "DATABASENAME = (" + database + ") AND TABLENAME LIKE '" + tableName + "%'", false);
        } else {
            selectTableSQL = TeradataConnection.getSelectSQL(dbcTablesView, new String[]{"TRIM(TRAILING FROM TABLENAME)"}, "DATABASENAME = '" + database + "' AND TABLENAME LIKE '" + tableName + "%'", false);
        }
        logger.debug((Object)selectTableSQL);
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(selectTableSQL);
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        tableDesc.setDatabaseName(databaseName);
        while (resultSet.next()) {
            tableDesc.setName(resultSet.getString(1));
            tableList.add(tableDesc.getQualifiedName());
        }
        resultSet.close();
        statement.close();
        return tableList.toArray(new String[0]);
    }

    public long getTableRowCount(String tableName, String condition) throws SQLException {
        long rowCount = 0L;
        String sql = TeradataConnection.getTableRowCountSQL(tableName, condition);
        logger.debug((Object)sql);
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        if (resultSet.next()) {
            rowCount = resultSet.getLong(1);
        }
        resultSet.close();
        statement.close();
        return rowCount;
    }

    public void getDatabaseProperty() throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        this.dbProductName = dbMetaData.getDatabaseProductName();
        this.dbMajorVersion = dbMetaData.getDatabaseMajorVersion();
        this.dbMinorVersion = dbMetaData.getDatabaseMinorVersion();
        this.jdbcMajorVersion = dbMetaData.getDriverMajorVersion();
        this.jdbcMinorVersion = dbMetaData.getDriverMinorVersion();
        this.maxTableNameLength = dbMetaData.getMaxTableNameLength();
        if (this.maxTableNameLength == 0) {
            this.maxTableNameLength = Integer.MAX_VALUE;
        }
        dbMetaData = null;
    }

    public int getAMPCount() throws SQLException {
        if (this.ampCount == 0) {
            try {
                String result = this.nativeSQL(SQL_GET_AMP_COUNT);
                if (result != null) {
                    this.ampCount = Integer.parseInt(result);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.ampCount;
    }

    public String toJavaType(int sqlType) {
        if (sqlType == 4) {
            return "Integer";
        }
        if (sqlType == 12) {
            return "String";
        }
        if (sqlType == 1) {
            return "String";
        }
        if (sqlType == -1) {
            return "String";
        }
        if (sqlType == -9) {
            return "String";
        }
        if (sqlType == -15) {
            return "String";
        }
        if (sqlType == -16) {
            return "String";
        }
        if (sqlType == 2) {
            return "java.math.BigDecimal";
        }
        if (sqlType == 3) {
            return "java.math.BigDecimal";
        }
        if (sqlType == -7) {
            return "Boolean";
        }
        if (sqlType == 16) {
            return "Boolean";
        }
        if (sqlType == -6) {
            return "Integer";
        }
        if (sqlType == 5) {
            return "Integer";
        }
        if (sqlType == -5) {
            return "Long";
        }
        if (sqlType == 7) {
            return "Float";
        }
        if (sqlType == 6) {
            return "Double";
        }
        if (sqlType == 8) {
            return "Double";
        }
        if (sqlType == 91) {
            return "java.sql.Date";
        }
        if (sqlType == 92) {
            return "java.sql.Time";
        }
        if (sqlType == 93) {
            return "java.sql.Timestamp";
        }
        if (sqlType == 2003 || sqlType == 2002 || sqlType == 1111) {
            return "String";
        }
        if (sqlType == -2 || sqlType == -3) {
            return BytesWritable.class.getName();
        }
        if (sqlType == 2005) {
            return "java.sql.Clob";
        }
        if (sqlType == 2004 || sqlType == -4) {
            return "java.sql.Blob";
        }
        return null;
    }

    public String[] listTables(String databaseName) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getListTablesSQL(databaseName, this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        logger.debug((Object)sql);
        while (resultSet.next()) {
            tables.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return tables.toArray(new String[tables.size()]);
    }

    public String[] listDatabases() throws SQLException {
        ArrayList<String> databases = new ArrayList<String>();
        Statement statement = this.connection.createStatement();
        String sql = TeradataConnection.getListDatabasesSQL(this.useXView);
        ResultSet resultSet = statement.executeQuery(sql);
        logger.debug((Object)sql);
        while (resultSet.next()) {
            databases.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return databases.toArray(new String[databases.size()]);
    }

    public void setQueryBandProperty(String queryBandProperty) throws SQLException {
        String queryBandSql = String.format(SQL_SET_QUERY_BAND, queryBandProperty);
        Statement statement = this.connection.createStatement();
        statement.execute(queryBandSql);
        statement.close();
    }

    public void enableUnicodePassthrough() throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.execute(SQL_ENABLE_UNICODE_PASSTHROUGH);
        statement.close();
    }

    public String getCurrentDatabase() throws SQLException {
        if (this.currentDatabase.isEmpty() && this.connection != null && !this.connection.isClosed()) {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(SQL_GET_CURRENT_DATABASE);
            if (resultSet.next()) {
                this.currentDatabase = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        return this.currentDatabase;
    }

    public static String getURLParamValue(String url, String paramName) {
        if (url == null || url.isEmpty() || url.toLowerCase().indexOf("jdbc:") != 0) {
            return null;
        }
        if (paramName == null || paramName.isEmpty()) {
            return null;
        }
        int pos = url.indexOf("://");
        if (pos < 0) {
            return null;
        }
        String urlparams = url.substring(pos + 3);
        if ((pos = urlparams.indexOf(47)) <= 0) {
            return null;
        }
        urlparams = urlparams.substring(pos + 1);
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar(',');
        List<String> tokens = parser.tokenize(urlparams);
        for (String token : tokens) {
            pos = token.indexOf(61);
            if (pos <= 0 || !paramName.equalsIgnoreCase(token.substring(0, pos))) continue;
            return token.substring(pos + 1);
        }
        return null;
    }

    public static Connection getConnection(String classname, String url, String username, String password, String properties) throws SQLException, ClassNotFoundException {
        url = url.charAt(url.length() - 1) == '/' ? url + properties : url + "," + properties;
        Connection connection = null;
        Class.forName(classname);
        connection = username == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, username, password);
        return connection;
    }

    public static Connection getConnection(String classname, String url, byte[] usernameBytes, byte[] passwordBytes, String properties) throws SQLException, ClassNotFoundException {
        url = url.charAt(url.length() - 1) == '/' ? url + properties : url + "," + properties;
        TeradataConnection teradata_connection = new TeradataConnection(classname, url, "", "", false);
        teradata_connection.connect(usernameBytes, passwordBytes);
        return teradata_connection.getConnection();
    }

    public static Connection getConnection(String classname, String url, byte[] usernameBytes, byte[] passwordBytes, String properties, boolean enableUnicodePassthrough) throws SQLException, ClassNotFoundException {
        url = url.charAt(url.length() - 1) == '/' ? url + properties : url + "," + properties;
        TeradataConnection teradata_connection = new TeradataConnection(classname, url, "", "", false);
        teradata_connection.connect(usernameBytes, passwordBytes);
        if (enableUnicodePassthrough) {
            teradata_connection.enableUnicodePassthrough();
        }
        return teradata_connection.getConnection();
    }

    public static String getAMPCountSQL() {
        return SQL_GET_AMP_COUNT;
    }

    public static String getTableRowCountSQL(String tableName, String condition) {
        String conditionExp = "";
        if (condition != null && !condition.isEmpty()) {
            conditionExp = " WHERE " + condition;
        }
        return String.format(SQL_GET_TABLE_ROW_COUNT, tableName, conditionExp);
    }

    public static String getIsTableNonEmptySQL(String tableName) {
        return String.format(SQL_IS_TABLE_NONEMPTY, tableName);
    }

    public static String getTableDeleteStmt(String tableName) {
        return String.format(SQL_TABLE_DELETE_STMT, tableName);
    }

    public static String getCheckTableFastloadableSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_CHECK_TABLE_FASTLOADABLE_XVIEW, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp);
        }
        return String.format(SQL_CHECK_TABLE_FASTLOADABLE, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp);
    }

    public static String getSelectSQL(String tableName, String[] columns, String condition) {
        return TeradataConnection.getSelectSQL(tableName, columns, condition, true);
    }

    public static String getSelectSQL(String tableName, String[] columns, String condition, boolean quoteColumnName) {
        StringBuilder colExpBuilder = new StringBuilder();
        if (columns != null && columns.length != 0) {
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    colExpBuilder.append(", ");
                }
                colExpBuilder.append(quoteColumnName ? TeradataConnection.getQuotedName(columns[i]) : columns[i]);
            }
        } else {
            colExpBuilder.append('*');
        }
        String conditionExp = "";
        if (condition != null && !condition.isEmpty()) {
            conditionExp = " WHERE " + condition;
        }
        return String.format(SQL_SELECT_FROM_SOURCE_WHERE, colExpBuilder.toString(), tableName, conditionExp);
    }

    public static String getDeleteTableSQL(String tableName, String condition) {
        String conditionExp = "";
        if (condition != null && !condition.isEmpty()) {
            conditionExp = " WHERE " + condition;
        }
        return String.format(SQL_DELETE_FROM_TABLE, tableName, conditionExp);
    }

    public static String getInsertPreparedStatmentSQL(String tableName, String[] columns) {
        StringBuilder colExpBuilder = new StringBuilder();
        StringBuilder valuesExpBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                colExpBuilder.append(", ");
                valuesExpBuilder.append(", ");
            }
            colExpBuilder.append(TeradataConnection.getQuotedName(columns[i]));
            valuesExpBuilder.append('?');
        }
        return String.format(SQL_INSERT, tableName, colExpBuilder.toString(), valuesExpBuilder.toString());
    }

    public static String getInsertPreparedStatmentSQLWithTaskID(String tableName, String[] columns, String taskID) {
        StringBuilder colExpBuilder = new StringBuilder();
        StringBuilder valuesExpBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                colExpBuilder.append(", ");
                valuesExpBuilder.append(", ");
            }
            colExpBuilder.append(TeradataConnection.getQuotedName(columns[i]));
            if (columns[i].equals(TeradataBatchInsertProcessor.taskIDColumnName)) {
                valuesExpBuilder.append("'" + taskID + "'");
                continue;
            }
            valuesExpBuilder.append('?');
        }
        return String.format(SQL_INSERT, tableName, colExpBuilder.toString(), valuesExpBuilder.toString());
    }

    public static String getInsertSelectSQL(String targetTableName, String[] targetColumns, String sourceTableName, String[] sourceColumns) {
        int i;
        StringBuilder targetColExpBuilder = new StringBuilder();
        StringBuilder sourceColExpBuilder = new StringBuilder();
        for (i = 0; i < targetColumns.length; ++i) {
            if (i > 0) {
                targetColExpBuilder.append(", ");
            }
            targetColExpBuilder.append(TeradataConnection.getQuotedName(targetColumns[i]));
        }
        for (i = 0; i < sourceColumns.length; ++i) {
            if (i > 0) {
                sourceColExpBuilder.append(", ");
            }
            sourceColExpBuilder.append(TeradataConnection.getQuotedName(sourceColumns[i]));
        }
        return String.format(SQL_INSERT_SELECT_INTO_TABLE, targetTableName, targetColExpBuilder.toString(), sourceColExpBuilder.toString(), sourceTableName);
    }

    public static String getInsertSelectSQL(String targetTableName, String targetQuotedColumns, String sourceTableName, String sourceQuotedColumns) {
        return String.format(SQL_INSERT_SELECT_INTO_TABLE, targetTableName, targetQuotedColumns, sourceQuotedColumns, sourceTableName);
    }

    public static String getDropTableSQL(String tableName) {
        return String.format(SQL_DROP_TABLE, tableName);
    }

    public static String getCreateTableSQL(TeradataTableDesc tableDesc) {
        String tableType = tableDesc.isMultiset() ? "MULTISET" : "SET";
        StringBuilder colExpBuilder = new StringBuilder();
        StringBuilder parColExpBuilder = new StringBuilder();
        StringBuilder piColExpBuilder = new StringBuilder();
        TeradataColumnDesc[] columns = tableDesc.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                colExpBuilder.append(", ");
            }
            TeradataColumnDesc column = columns[i];
            String quotedColumnName = TeradataConnection.getQuotedName(column.getName());
            colExpBuilder.append(quotedColumnName).append(' ').append(column.getTypeString());
        }
        Iterator<String> paritr = tableDesc.getPartitionColumnNames().iterator();
        while (paritr.hasNext()) {
            parColExpBuilder.append(TeradataConnection.getQuotedName(paritr.next().toString()));
            if (!paritr.hasNext()) continue;
            parColExpBuilder.append(", ");
        }
        Iterator<String> piitr = tableDesc.getPrimaryIndices().iterator();
        while (piitr.hasNext()) {
            piColExpBuilder.append(TeradataConnection.getQuotedName(piitr.next().toString()));
            if (!piitr.hasNext()) continue;
            piColExpBuilder.append(", ");
        }
        String blockExp = tableDesc.getBlockSize() > 0 ? "DATABLOCKSIZE = " + tableDesc.getBlockSize() + " BYTES," : "";
        String partitionColExp = parColExpBuilder.length() > 0 ? "PARTITION BY " + parColExpBuilder : " ";
        String piColExp = "";
        if (!tableDesc.hasPrimaryIndex()) {
            piColExp = "NO PRIMARY INDEX";
        } else if (piColExpBuilder.length() > 0) {
            piColExp = "PRIMARY INDEX (" + piColExpBuilder.toString() + ")";
        }
        return String.format(SQL_CREATE_TABLE, tableType, tableDesc.getQualifiedName(), blockExp, colExpBuilder.toString(), piColExp, partitionColExp);
    }

    public static String getCreateViewSQL(TeradataViewDesc viewDesc) {
        Boolean accessLock = viewDesc.getAccessLock();
        if (accessLock.booleanValue()) {
            return String.format(SQL_CREATE_VIEW, viewDesc.getQualifiedName(), viewDesc.getColumnsString(), TeradataConnection.addAccessLockToSql(viewDesc.getQuery()));
        }
        return String.format(SQL_CREATE_VIEW, viewDesc.getQualifiedName(), viewDesc.getColumnsString(), viewDesc.getQuery());
    }

    public static String getDropViewSQL(String viewName) {
        return String.format(SQL_DROP_VIEW, viewName);
    }

    public static String getUsingSQL(String tableName, String[] columns, String[] types4Using, String charset) {
        StringBuilder targetColExpBuilder = new StringBuilder();
        StringBuilder usingColExpBuilder = new StringBuilder();
        StringBuilder usingValExpBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                targetColExpBuilder.append(", ");
                usingColExpBuilder.append(", ");
                usingValExpBuilder.append(", ");
            }
            String quotedUsingCol = TeradataConnection.getQuotedName(columns[i]);
            String quotedCol = TeradataConnection.getQuotedName(columns[i]);
            targetColExpBuilder.append(quotedCol);
            usingColExpBuilder.append(quotedUsingCol).append(" (").append(types4Using[i]).append(')');
            usingValExpBuilder.append(':').append(quotedUsingCol);
        }
        return String.format(SQL_USING_INSERT_INTO_TABLE, usingColExpBuilder.toString(), tableName, targetColExpBuilder.toString(), usingValExpBuilder.toString());
    }

    public static String getDatabaseSQL() {
        return SQL_GET_CURRENT_DATABASE;
    }

    public static String getCurTimestampSQL() {
        return SQL_GET_CURRENT_TIMESTAMP;
    }

    public static String getListDatabasesSQL(boolean useXView) {
        if (useXView) {
            return SQL_GET_DATABASES_XVIEW;
        }
        return SQL_GET_DATABASES;
    }

    public static String getPrimaryKeySQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_PRIMARY_KEY_XVIEW, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp);
        }
        return String.format(SQL_GET_PRIMARY_KEY, dbExp, tblExp, dbExp, tblExp, dbExp, tblExp);
    }

    public static String getPrimaryIndexSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_PRIMARY_INDEX_XVIEW, dbExp, tblExp);
        }
        return String.format(SQL_GET_PRIMARY_INDEX, dbExp, tblExp);
    }

    public static String getPartitionedPrimaryIndexSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_PARTITIONED_PRIMARY_INDEX_XVIEW, dbExp, tblExp);
        }
        return String.format(SQL_GET_PARTITIONED_PRIMARY_INDEX, dbExp, tblExp);
    }

    public static String getListTablesSQL(String databaseName, boolean useXView) {
        String dbExp = databaseName == null || databaseName.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(databaseName);
        if (useXView) {
            return String.format(SQL_GET_TABLES_XVIEW, dbExp);
        }
        return String.format(SQL_GET_TABLES, dbExp);
    }

    public static String getTableKindSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_TABLE_KIND_XVIEW, dbExp, tblExp);
        }
        return String.format(SQL_GET_TABLE_KIND, dbExp, tblExp);
    }

    public static String getListColumnsSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_TABLE_COLUMNS_XVIEW, dbExp, tblExp);
        }
        return String.format(SQL_GET_TABLE_COLUMNS, dbExp, tblExp);
    }

    public static String getListColumnInfosSQL(String tableName, boolean useXView) {
        String dbExp;
        String tblExp;
        if (tableName == null || tableName.isEmpty()) {
            tblExp = "''";
            dbExp = "''";
        } else {
            dbExp = TeradataConnection.getDatabaseName(tableName);
            dbExp = dbExp.isEmpty() ? "(" + TeradataConnection.getDatabaseSQL() + ")" : TeradataConnection.getQuotedValue(dbExp);
            tblExp = TeradataConnection.getQuotedValue(TeradataConnection.getObjectName(tableName));
        }
        if (useXView) {
            return String.format(SQL_GET_TABLE_COLUMN_INFOS_XVIEW, dbExp, tblExp);
        }
        return String.format(SQL_GET_TABLE_COLUMN_INFOS, dbExp, tblExp);
    }

    public static String getDatabaseName(String dbObject) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(dbObject, 2, false);
        if (tokens.size() == 2) {
            return tokens.get(0);
        }
        return "";
    }

    public static String getObjectName(String dbObject) {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        List<String> tokens = parser.tokenize(dbObject, 2, false);
        switch (tokens.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return tokens.get(0);
            }
        }
        return tokens.get(1);
    }

    public static String getQuotedName(String name) {
        return TeradataSchemaUtils.quoteFieldNameForSql(name);
    }

    public static String getQuotedValue(String value) {
        return TeradataSchemaUtils.quoteFieldValueForSql(value);
    }

    public static String getQuotedColumnNames(String columnName) {
        return TeradataSchemaUtils.quoteFieldNamesForSql(columnName);
    }

    public static String getEscapedName(String name) {
        if (name == null) {
            return "";
        }
        return name.replace("\"", "\"\"");
    }

    public static String getEscapedValue(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("'", "''");
    }

    public static String getQuotedEscapedName(String ... nameparts) {
        StringBuilder builder = new StringBuilder();
        for (String namepart : nameparts) {
            if (ConnectorStringUtils.isEmpty(namepart)) continue;
            builder.append('\"').append(TeradataConnection.getEscapedName(namepart)).append("\".");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getQuotedEscapedValue(String value) {
        return "'" + TeradataConnection.getEscapedValue(value) + "'";
    }

    public static String addAccessLockToSql(String selectQuery) {
        return ACCESS_LOCK_SQL + selectQuery;
    }

    public static void setQueryBandProperty(Connection specifiedConnection, String queryBandProperty) throws SQLException {
        String queryBandSql = String.format(SQL_SET_QUERY_BAND, queryBandProperty);
        Statement statement = specifiedConnection.createStatement();
        statement.execute(queryBandSql);
        statement.close();
    }

    public static void enableUnicodePassthrough(Connection specifiedConnection) throws SQLException {
        Statement statement = specifiedConnection.createStatement();
        statement.execute(SQL_ENABLE_UNICODE_PASSTHROUGH);
        statement.close();
    }

    protected static String getUsingSQL(String tableName, TeradataColumnDesc[] columnDescs, int columnCount, String charset) {
        int strCharOrVarcharMultiplier = 1;
        int strTimeOrIntervalMultiplier = 1;
        if ("UTF16".equalsIgnoreCase(charset)) {
            strCharOrVarcharMultiplier = 2;
            strTimeOrIntervalMultiplier = 2;
        } else if ("UTF8".equalsIgnoreCase(charset)) {
            strCharOrVarcharMultiplier = 3;
        }
        StringBuilder usingColExpBuilder = new StringBuilder();
        StringBuilder usingValExpBuilder = new StringBuilder();
        StringBuilder targetColExpBuilder = new StringBuilder();
        int length = columnDescs.length;
        block7: for (int i = 0; i < Math.min(length, columnCount); ++i) {
            if (i > 0) {
                usingColExpBuilder.append(", ");
                usingValExpBuilder.append(", ");
                targetColExpBuilder.append(", ");
            }
            TeradataColumnDesc column = columnDescs[i];
            String quotedColName = TeradataConnection.getQuotedName(column.getName());
            targetColExpBuilder.append(quotedColName);
            usingValExpBuilder.append(':').append(quotedColName);
            int type = column.getType();
            int scale = column.getScale();
            switch (type) {
                case 3: {
                    usingColExpBuilder.append(quotedColName).append(" (DECIMAL (38, ").append(scale).append("))");
                    continue block7;
                }
                case 1: 
                case 12: {
                    Long mlen = (long)strCharOrVarcharMultiplier * column.getLength();
                    usingColExpBuilder.append(quotedColName).append(" (VARCHAR(").append(mlen.toString()).append("))");
                    continue block7;
                }
                case 92: {
                    int tnanoLength = scale > 0 ? 8 + scale + 1 : 8;
                    Integer mlen = strTimeOrIntervalMultiplier * tnanoLength;
                    usingColExpBuilder.append(quotedColName).append(" (CHAR(").append(mlen).append("))");
                    continue block7;
                }
                case 93: {
                    int tsnanoLength = scale > 0 ? 19 + scale + 1 : 19;
                    Integer mlen = strTimeOrIntervalMultiplier * tsnanoLength;
                    usingColExpBuilder.append(quotedColName).append(" (CHAR(").append(mlen.toString()).append("))");
                    continue block7;
                }
                case 0: {
                    usingColExpBuilder.append(quotedColName).append(" (").append(column.getTypeStringWithoutNullability()).append(")");
                    continue block7;
                }
                default: {
                    usingColExpBuilder.append(quotedColName).append(" (").append(column.getTypeStringWithoutNullability()).append(")");
                }
            }
        }
        return String.format(SQL_USING_INSERT_INTO_TABLE, tableName, usingColExpBuilder.toString(), targetColExpBuilder.toString(), usingValExpBuilder.toString());
    }

    protected int getColumnCount(String sql) throws SQLException {
        PreparedStatement prepareStatement = this.connection.prepareStatement(sql);
        ResultSetMetaData metadata = prepareStatement.getMetaData();
        int columnCount = metadata.getColumnCount();
        prepareStatement.close();
        return columnCount;
    }

    protected String[] getColumnNames(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            columnNames[i - 1] = metadata.getColumnName(i);
        }
        return columnNames;
    }

    protected TeradataColumnDesc[] getColumnDescs(ResultSetMetaData metadata) throws SQLException {
        JDK6_SQL_ResultSetMetaData tdMetadata = (JDK6_SQL_ResultSetMetaData)metadata;
        int columnCount = metadata.getColumnCount();
        TeradataColumnDesc[] columns = new TeradataColumnDesc[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            ColumnProperties columnProperties = tdMetadata.getColumnProperties(i);
            TeradataColumnDesc column = new TeradataColumnDesc();
            String columnTypeName = metadata.getColumnTypeName(i).toUpperCase();
            column.setName(metadata.getColumnName(i));
            int columnType = metadata.getColumnType(i);
            if (6 == columnType) {
                columnType = 8;
            }
            if (1111 == columnType && columnTypeName.equals("JSON")) {
                columnType = 2005;
            }
            column.setType(columnType);
            column.setTypeName(metadata.getColumnTypeName(i));
            column.setClassName(metadata.getColumnClassName(i));
            column.setFormat(columnProperties.getColumnFormat());
            column.setNullable(metadata.isNullable(i) > 0);
            column.setLength(metadata.getColumnDisplaySize(i));
            column.setCaseSensitive(metadata.isCaseSensitive(i));
            column.setPrecision(metadata.getPrecision(i));
            column.setScale(metadata.getScale(i));
            columns[i - 1] = column;
        }
        return columns;
    }

    public static URLParameters getJDBCURLParameters(String url) throws SQLException {
        String prefix = REMOTE_CONN_PREFIX;
        String remain = url.substring(prefix.length());
        int slashPosition = remain.indexOf("/");
        String paramString = "";
        paramString = slashPosition >= 0 ? remain.substring(slashPosition + 1) : "";
        return new URLParameters(paramString);
    }
}

