/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.teradata.TeradataInputFormat;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSplitUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class TeradataSplitByValueInputFormat
extends TeradataInputFormat {
    private static Log logger = LogFactory.getLog(TeradataSplitByValueInputFormat.class);
    protected static final String SQL_SELECT_COLUMN_SPLIT_RANGE = "SELECT %s FROM %s WHERE %s";
    protected static final String SQL_GET_COLUMN_VALUE_MIN_MAX = "SELECT MIN( %s ), MAX( %s ) FROM %s";
    protected static final int NUM_MAPPER_DEFAULT = 20;

    @Override
    public void validateConfiguration(JobContext context) throws ConnectorException {
        super.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        if (splitColumn.isEmpty() && numMappers != 1) {
            throw new ConnectorException(23002);
        }
        this.connection = TeradataUtils.openInputConnection(context);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        this.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        this.inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
        this.inputConditions = TeradataPlugInConfiguration.getInputConditions(configuration);
        this.inputFieldNamesArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        Boolean accessLock = TeradataPlugInConfiguration.getInputAccessLock(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        String[] locations = HadoopConfigurationUtils.getAllActiveHosts(context);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (numMappers == 1) {
            String inputSplitSql = TeradataConnection.getSelectSQL(this.inputTableName, this.inputFieldNamesArray, this.inputConditions);
            if (accessLock.booleanValue()) {
                inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
            }
            TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
            split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
            splits.add(split);
        } else {
            String splitColumnName = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
            String splitSql = this.inputConditions.isEmpty() ? String.format(SQL_SELECT_COLUMN_SPLIT_RANGE, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "") : String.format(SQL_SELECT_COLUMN_SPLIT_RANGE, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "(" + this.inputConditions + ") AND ");
            TeradataPlugInConfiguration.setInputSplitSql(configuration, splitSql);
            ResultSet resultSetMinMaxValues = null;
            Statement statement = null;
            try {
                Connection sqlConnection = this.connection.getConnection();
                if (sqlConnection != null) {
                    String sql = String.format(SQL_GET_COLUMN_VALUE_MIN_MAX, splitColumnName, splitColumnName, this.inputTableName);
                    if (accessLock.booleanValue()) {
                        sql = TeradataConnection.addAccessLockToSql(sql);
                    }
                    logger.info((Object)sql);
                    statement = sqlConnection.createStatement();
                    resultSetMinMaxValues = statement.executeQuery(sql);
                }
                if (resultSetMinMaxValues == null || !resultSetMinMaxValues.next()) {
                    throw new ConnectorException(23003);
                }
                if (resultSetMinMaxValues.getString(1) == null || resultSetMinMaxValues.getString(2) == null) {
                    throw new ConnectorException(23004);
                }
            }
            catch (SQLException e) {
                TeradataUtils.closeConnection(this.connection);
                throw new ConnectorException(e.getMessage(), e);
            }
            List<TeradataInputFormat.TeradataInputSplit> columnSplits = TeradataSplitUtils.getSplitsByColumnType(configuration, splitColumnName, resultSetMinMaxValues);
            for (int i = 0; i < columnSplits.size(); ++i) {
                TeradataInputFormat.TeradataInputSplit split = columnSplits.get(i);
                if (accessLock.booleanValue()) {
                    String inputSplitSql = TeradataConnection.addAccessLockToSql(split.getSplitSql());
                    split.setSplitSql(inputSplitSql);
                }
                split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                splits.add(split);
            }
            try {
                if (resultSetMinMaxValues != null && !resultSetMinMaxValues.isClosed()) {
                    resultSetMinMaxValues.close();
                    resultSetMinMaxValues = null;
                }
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            finally {
                TeradataUtils.closeConnection(this.connection);
            }
        }
        return splits;
    }
}

