/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.teradata.TeradataInputFormat;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class TeradataSplitByPartitionInputFormat
extends TeradataInputFormat {
    private static Log logger = LogFactory.getLog(TeradataSplitByPartitionInputFormat.class);
    protected static final int PARTITION_RANGE_MIN = 10;
    protected static final String COLUMN_PARTITION = "PARTITION";
    protected static final String SQL_SELECT_NOSTAGE_PARTITION = "SELECT %s FROM %s WHERE %s %s.PARTITION";
    protected static final String SQL_SELECT_NOSTAGE_NOPARTITION = "SELECT %s FROM %s WHERE %s";

    @Override
    public void validateConfiguration(JobContext context) throws ConnectorException {
        super.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        this.inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
        this.inputConditions = TeradataPlugInConfiguration.getInputConditions(configuration);
        this.inputFieldNamesArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        if (TeradataPlugInConfiguration.getInputTable(configuration).isEmpty()) {
            if (TeradataPlugInConfiguration.getInputQuery(configuration).isEmpty() || ConnectorConfiguration.getNumMappers(configuration) != 1) {
                throw new ConnectorException(12005);
            }
            this.connection = TeradataUtils.openInputConnection(context);
        } else {
            this.connection = TeradataUtils.openInputConnection(context);
            try {
                if (!this.connection.isTablePPI(this.inputTableName) && numMappers != 1) {
                    throw new ConnectorException(12020);
                }
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        this.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        long numMappers = ConnectorConfiguration.getNumMappers(configuration);
        boolean accessLock = TeradataPlugInConfiguration.getInputAccessLock(configuration);
        boolean stagingEnabled = TeradataPlugInConfiguration.getInputStageTableEnabled(configuration);
        String[] locations = HadoopConfigurationUtils.getAllActiveHosts(context);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        long numPartitions = 1L;
        if (stagingEnabled || !TeradataPlugInConfiguration.getInputQuery(configuration).isEmpty()) {
            numPartitions = TeradataPlugInConfiguration.getInputNumPartitions(configuration);
        } else if (numMappers > 1L) {
            try {
                numPartitions = this.connection.getTablePartitionCount(this.inputTableName, accessLock);
            }
            catch (SQLException e1) {
                throw new ConnectorException(e1.getMessage(), e1);
            }
        }
        String splitSql = this.inputConditions.isEmpty() ? String.format(SQL_SELECT_NOSTAGE_PARTITION, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "", this.inputTableName) : String.format(SQL_SELECT_NOSTAGE_PARTITION, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "(" + this.inputConditions + ") AND ", this.inputTableName);
        long partitionRange = numPartitions / numMappers;
        if (numMappers == 1L || numPartitions == 0L) {
            logger.debug((Object)"SPLIT.BY.PARTITION; NUM MAPPERS = 1 OR NUM PARTITIONS = 0 - NO NEED TO PARTITION");
            splitSql = !this.inputTableName.isEmpty() ? TeradataConnection.getSelectSQL(this.inputTableName, this.inputFieldNamesArray, this.inputConditions) : TeradataPlugInConfiguration.getInputQuery(configuration);
            if (accessLock) {
                splitSql = TeradataConnection.addAccessLockToSql(splitSql);
            }
            TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(splitSql);
            split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
            splits.add(split);
            logger.debug((Object)splitSql);
            TeradataUtils.closeConnection(this.connection);
        } else {
            if (numMappers >= numPartitions) {
                logger.debug((Object)"SPLIT.BY.PARTITION; NUM MAPPERS >= NUM PARTITIONS - SPLIT FOR EACH PARTITION");
                if (numMappers > numPartitions) {
                    logger.debug((Object)"SPLIT.BY.PARTITION; NUM MAPPERS > NUM PARTITIONS - SET NUM MAPPERS TO NUM PARTITIONS");
                    numMappers = numPartitions;
                    ConnectorConfiguration.setNumMappers(configuration, (int)numMappers);
                }
                try {
                    ArrayList<Long> allPartitions = this.connection.getTablePartitions(this.inputTableName, accessLock);
                    int i = 0;
                    while ((long)i < numMappers) {
                        long partId = stagingEnabled ? (long)(i + 1) : allPartitions.get(i);
                        String inputSplitSql = splitSql + " = " + partId;
                        if (accessLock) {
                            inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                        }
                        logger.debug((Object)inputSplitSql);
                        TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                        split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                        splits.add(split);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                finally {
                    TeradataUtils.closeConnection(this.connection);
                }
            }
            if (numPartitions > Integer.MAX_VALUE || partitionRange >= 10L) {
                logger.debug((Object)"SPLIT.BY.PARTITION; LARGE NUM PARTITIONS - CALCULATE OPTIMIZED RANGE");
                try {
                    TeradataInputFormat.TeradataInputSplit split;
                    String inputSplitSql;
                    long i;
                    this.connection = TeradataUtils.openInputConnection(context);
                    ArrayList<Long> minMaxPartitions = this.connection.getTablePartitionMinMax(this.inputTableName);
                    long minPartId = stagingEnabled ? 1L : minMaxPartitions.get(0);
                    long maxPartId = stagingEnabled ? numPartitions : minMaxPartitions.get(1);
                    long currPartId = minPartId;
                    long estimatedRange = (maxPartId - minPartId) / numMappers;
                    long remainder = (maxPartId - minPartId) % numMappers;
                    for (i = 1L; i <= remainder; ++i) {
                        inputSplitSql = splitSql + " BETWEEN " + currPartId + " AND " + String.valueOf(currPartId + estimatedRange);
                        if (accessLock) {
                            inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                        }
                        logger.debug((Object)inputSplitSql);
                        split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                        split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                        splits.add(split);
                        currPartId = currPartId + estimatedRange + 1L;
                    }
                    for (i = remainder + 1L; i < numMappers; ++i) {
                        inputSplitSql = splitSql + " BETWEEN " + currPartId + " AND " + String.valueOf(currPartId + estimatedRange - 1L);
                        if (accessLock) {
                            inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                        }
                        logger.debug((Object)inputSplitSql);
                        split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                        split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                        splits.add(split);
                        currPartId += estimatedRange;
                    }
                    String inputSplitSql2 = splitSql + " BETWEEN " + currPartId + " AND " + maxPartId;
                    if (accessLock) {
                        inputSplitSql2 = TeradataConnection.addAccessLockToSql(inputSplitSql2);
                    }
                    logger.debug((Object)inputSplitSql2);
                    TeradataInputFormat.TeradataInputSplit split2 = new TeradataInputFormat.TeradataInputSplit(inputSplitSql2);
                    split2.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split2);
                }
                catch (SQLException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                finally {
                    TeradataUtils.closeConnection(this.connection);
                }
            }
            logger.debug((Object)"SPLIT.BY.PARTITION; DEFAULT CASE: NUM MAPPERS < NUM PARTITIONS");
            int rangeExtras = (int)(numPartitions % numMappers);
            int range = (int)partitionRange;
            int currPartRangePos = 0;
            try {
                TeradataInputFormat.TeradataInputSplit split;
                String inputSplitSql;
                int endPos;
                int beginPos;
                int i;
                this.connection = TeradataUtils.openInputConnection(context);
                ArrayList<Long> allPartitions = this.connection.getTablePartitions(this.inputTableName, accessLock);
                for (i = 1; i <= rangeExtras; ++i) {
                    beginPos = stagingEnabled ? currPartRangePos : allPartitions.get(currPartRangePos).intValue();
                    endPos = stagingEnabled ? currPartRangePos + range : allPartitions.get(currPartRangePos + range).intValue();
                    inputSplitSql = splitSql + " BETWEEN " + beginPos + " AND " + endPos;
                    if (accessLock) {
                        inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                    }
                    logger.debug((Object)inputSplitSql);
                    split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                    split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split);
                    currPartRangePos = currPartRangePos + range + 1;
                }
                i = rangeExtras + 1;
                while ((long)i < numMappers) {
                    beginPos = stagingEnabled ? currPartRangePos : allPartitions.get(currPartRangePos).intValue();
                    endPos = stagingEnabled ? currPartRangePos + range - 1 : allPartitions.get(currPartRangePos + range - 1).intValue();
                    inputSplitSql = splitSql + " BETWEEN " + beginPos + " AND " + endPos;
                    if (accessLock) {
                        inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                    }
                    logger.debug((Object)inputSplitSql);
                    split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                    split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split);
                    currPartRangePos += range;
                    ++i;
                }
                if ((long)currPartRangePos < (stagingEnabled ? numPartitions : (long)allPartitions.size())) {
                    int beginPos2 = stagingEnabled ? currPartRangePos : allPartitions.get(currPartRangePos).intValue();
                    int endPos2 = stagingEnabled ? (int)numPartitions : allPartitions.get(allPartitions.size() - 1).intValue();
                    String inputSplitSql3 = splitSql + " BETWEEN " + beginPos2 + " AND " + endPos2;
                    if (accessLock) {
                        inputSplitSql3 = TeradataConnection.addAccessLockToSql(inputSplitSql3);
                    }
                    logger.debug((Object)inputSplitSql3);
                    TeradataInputFormat.TeradataInputSplit split3 = new TeradataInputFormat.TeradataInputSplit(inputSplitSql3);
                    split3.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split3);
                } else {
                    String inputSplitSql4 = splitSql + " = " + currPartRangePos;
                    if (accessLock) {
                        inputSplitSql4 = TeradataConnection.addAccessLockToSql(inputSplitSql4);
                    }
                    logger.debug((Object)inputSplitSql4);
                    TeradataInputFormat.TeradataInputSplit split4 = new TeradataInputFormat.TeradataInputSplit(inputSplitSql4);
                    split4.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split4);
                }
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            finally {
                TeradataUtils.closeConnection(this.connection);
            }
        }
        return splits;
    }
}

