/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class TeradataObjectArrayWritable
extends ConnectorRecord
implements DBWritable {
    protected int objectCount;
    protected int[] nullJdbcTypes = null;
    protected int[] nullJdbcScales = null;
    protected int nullJdbcTypeCount = 0;
    protected Object[] nullDefaultValues = null;
    protected int nullDefaultValueCount = 0;
    protected int[] recordTypes = null;
    protected Calendar nullCal = Calendar.getInstance();
    private Map<Integer, Calendar> calendarCache;

    public TeradataObjectArrayWritable() {
        this.record = new Object[0];
        this.objectCount = 0;
        this.calendarCache = new HashMap<Integer, Calendar>();
    }

    public TeradataObjectArrayWritable(int objectCount) {
        if (objectCount > 0) {
            this.record = new Object[objectCount];
            this.objectCount = objectCount;
        }
        this.calendarCache = new HashMap<Integer, Calendar>();
    }

    private Calendar getCachedCalendarObject(int index) {
        Calendar cal = this.calendarCache.get(index);
        if (cal == null) {
            cal = Calendar.getInstance();
            this.calendarCache.put(index, cal);
        }
        return cal;
    }

    public Object[] getObjects() {
        return this.record;
    }

    public void setObjects(Object[] objects) {
        this.record = objects;
        this.objectCount = objects.length;
    }

    @Override
    public Object get(int position) {
        return this.record[position];
    }

    @Override
    public void set(int position, Object object) {
        this.record[position] = object;
    }

    public int[] getNullJdbcTypes() {
        return this.nullJdbcTypes;
    }

    public void setNullJdbcTypes(int[] jdbcTypes) {
        if (jdbcTypes != null) {
            this.nullJdbcTypes = jdbcTypes;
            this.nullJdbcTypeCount = jdbcTypes.length;
        }
    }

    public int[] getNullJdbcScales() {
        return this.nullJdbcScales;
    }

    public void setNullJdbcScales(int[] jdbcScales) {
        if (jdbcScales != null) {
            this.nullJdbcScales = jdbcScales;
        }
    }

    public Object[] getNullDefaultValues() {
        return this.nullDefaultValues;
    }

    public void setNullDefaultValues(Object[] defaultValues) {
        if (defaultValues != null) {
            this.nullDefaultValues = defaultValues;
            this.nullDefaultValueCount = defaultValues.length;
        }
    }

    public void setRecordTypes(String[] typeNames) {
        this.recordTypes = new int[typeNames.length];
        for (int i = 0; i < this.recordTypes.length; ++i) {
            this.recordTypes[i] = ConnectorSchemaUtils.isTimeWithTimeZoneType(typeNames[i]) ? 1885 : (ConnectorSchemaUtils.isTimestampWithTimeZoneType(typeNames[i]) ? 1886 : 1882);
        }
    }

    public int[] getRecordTypes() {
        return this.recordTypes;
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        this.objectCount = metadata.getColumnCount();
        if (this.objectCount > 0) {
            this.record = new Object[this.objectCount];
        }
        for (int i = 0; i < this.objectCount; ++i) {
            long milliSec;
            Date ts;
            Calendar calendar;
            if (this.recordTypes[i] == 1885) {
                calendar = this.getCachedCalendarObject(i + 1);
                ts = resultSet.getTime(i + 1, calendar);
                if (ts == null) {
                    this.record[i] = null;
                    continue;
                }
                milliSec = ts.getTime();
                milliSec = ConnectorDataTypeConverter.convertMillisecFromSourceToDefaultTZ(milliSec, calendar.getTimeZone());
                calendar.setTimeInMillis(milliSec);
                this.record[i] = calendar;
                continue;
            }
            if (this.recordTypes[i] == 1886) {
                calendar = this.getCachedCalendarObject(i + 1);
                ts = resultSet.getTimestamp(i + 1, calendar);
                if (ts == null) {
                    this.record[i] = null;
                    continue;
                }
                milliSec = ((Timestamp)ts).getTime();
                milliSec = ConnectorDataTypeConverter.convertMillisecFromSourceToDefaultTZ(milliSec, calendar.getTimeZone());
                calendar.setTimeInMillis(milliSec);
                this.record[i] = calendar;
                continue;
            }
            this.record[i] = resultSet.getObject(i + 1);
        }
    }

    public void write(PreparedStatement statement) throws SQLException {
        for (int i = 0; i < this.objectCount; ++i) {
            long milliSec;
            Calendar cal;
            if (this.record[i] == null) {
                if (this.nullDefaultValues != null && this.nullDefaultValueCount > i) {
                    statement.setObject(i + 1, this.nullDefaultValues[i]);
                    continue;
                }
                if (this.nullJdbcTypes != null && this.nullJdbcTypeCount > i) {
                    switch (this.nullJdbcTypes[i]) {
                        case 2: 
                        case 3: {
                            statement.setObject(i + 1, null, this.nullJdbcTypes[i], this.nullJdbcScales[i]);
                            break;
                        }
                        case 1111: 
                        case 2002: 
                        case 2003: {
                            statement.setObject(i + 1, null, 12);
                            break;
                        }
                        case 92: 
                        case 93: {
                            if (this.recordTypes[i] == 1886) {
                                statement.setTimestamp(i + 1, null, this.nullCal);
                                break;
                            }
                            if (this.recordTypes[i] == 1885) {
                                statement.setTime(i + 1, null, this.nullCal);
                                break;
                            }
                        }
                        default: {
                            statement.setNull(i + 1, this.nullJdbcTypes[i]);
                            break;
                        }
                    }
                    continue;
                }
                statement.setObject(i + 1, "");
                continue;
            }
            if (this.recordTypes[i] == 1886) {
                Timestamp timestamp = new Timestamp(0L);
                cal = (Calendar)this.record[i];
                milliSec = cal.getTimeInMillis();
                milliSec = ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(milliSec, cal.getTimeZone());
                timestamp.setTime(milliSec);
                statement.setTimestamp(i + 1, timestamp, cal);
                continue;
            }
            if (this.recordTypes[i] == 1885) {
                Time time = new Time(0L);
                cal = (Calendar)this.record[i];
                milliSec = cal.getTimeInMillis();
                milliSec = ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(milliSec, cal.getTimeZone());
                time.setTime(milliSec);
                statement.setTime(i + 1, time, cal);
                continue;
            }
            statement.setObject(i + 1, this.record[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int len = in.readInt();
        this.recordTypes = new int[len];
        for (int i = 0; i < len; ++i) {
            this.recordTypes[i] = in.readInt();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.recordTypes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.recordTypes.length);
            for (int i = 0; i < this.recordTypes.length; ++i) {
                out.writeInt(this.recordTypes[i]);
            }
        }
    }
}

