/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.teradata.TeradataInputFormat;
import com.teradata.connector.teradata.TeradataObjectArrayWritable;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInternalFastExportProcessor;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import com.teradata.jdbc.jdbc_4.TDSession;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TeradataInternalFastExportInputFormat
extends TeradataInputFormat {
    private static Log logger = LogFactory.getLog(TeradataInternalFastExportInputFormat.class);
    protected static Connection lsnConnection;
    protected static ServerSocket server;
    public static String MSG_FASTEXPORT_TRANSFER_BEGIN;
    public static String MSG_FASTEXPORT_TRANSFER_END;
    public static String MSG_FASTEXPORT_CONNECTION_READY;
    public static String MSG_FASTEXPORT_CONNECTION_CLOSE;
    public static String MSG_FASTEXPORT_PING;
    protected static String PARAM_FASTEXPORT_CONNECTION;
    protected static String PARAM_LSN_CONNECTION;
    protected static String PARAM_SESSION_CONNECTION;
    protected static String SQL_GET_LSN;
    protected static String SQL_REQUEST_TRACKING_ON;
    protected static String SQL_REQUEST_TRACKING_OFF;
    protected static String SQL_PROVIDE_REQUEST_TRACKING;
    protected static String SQL_PROVIDE_REQUESTS;
    protected static String SQL_CLEAR_REQUESTS;
    protected static String SQL_BEGIN_FASTEXPORT;
    protected static String SQL_END_FASTEXPORT;
    protected static String FASTEXPORT_PARAMS_FILE_NAME;
    private static final String CHECK_WORKLOAD_BEGIN = "CHECK WORKLOAD FOR ";
    private static final String CHECK_WORKLOAD_END = "CHECK WORKLOAD END";
    private static final String LSS_TYPE = "LSS_TYPE=E";
    private static final String FASTEXPORT_QUERY_BAND = "UtilityName=JDBCE;";
    private static final String LINE_SEP;
    public static int SOCKET_CONNECT_TIMEOUT;
    public static int SOCKET_CONNECT_RETRY_MAX;
    public static int SOCKET_CONNECT_RETRY_WAIT_MIN;
    public static int SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED;
    protected static int SOCKET_SERVER_ACCEPT_TIME_OUT;
    protected static int SOCKET_PING_TIME_OUT;
    protected String charset = "";
    protected boolean isGoverned = false;
    protected boolean isFastFail = false;
    protected boolean enableUnicodePassthrough = false;
    protected String jdbcUrl = "";
    protected int readyConnCount = 0;
    protected int readySessionCount = 0;

    @Override
    public void validateConfiguration(JobContext context) throws ConnectorException {
        super.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        this.inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
        this.inputConditions = TeradataPlugInConfiguration.getInputConditions(configuration);
        this.inputFieldNamesArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        boolean accessLock = TeradataPlugInConfiguration.getInputAccessLock(configuration);
        String inputQuery = TeradataConnection.getSelectSQL(this.inputTableName, this.inputFieldNamesArray, this.inputConditions);
        if (accessLock) {
            inputQuery = TeradataConnection.addAccessLockToSql(inputQuery);
        }
        TeradataPlugInConfiguration.setInputSplitSql(configuration, inputQuery);
        try {
            this.jdbcUrl = TeradataPlugInConfiguration.getInputJdbcUrl(configuration);
            this.charset = TeradataConnection.getURLParamValue(this.jdbcUrl, "CHARSET");
            if (this.charset == null || !this.charset.equalsIgnoreCase("UTF8") && !this.charset.equalsIgnoreCase("UTF16")) {
                this.charset = "";
            }
            this.isGoverned = TeradataConnection.getJDBCURLParameters(this.jdbcUrl).isGoverned();
            this.isFastFail = TeradataPlugInConfiguration.getInputFastFail(configuration);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        this.enableUnicodePassthrough = TeradataPlugInConfiguration.getUnicodePassthrough(configuration);
        TeradataUtils.closeConnection(this.connection);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        this.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        String classname = TeradataPlugInConfiguration.getOutputJdbcDriverClass(configuration);
        try {
            server = HadoopConfigurationUtils.createServerSocket(TeradataPlugInConfiguration.getInputFastExportSocketPort(configuration), TeradataPlugInConfiguration.getInputFastExportSocketBacklog(configuration));
            String connectionString = PARAM_LSN_CONNECTION;
            if (!this.charset.equals("")) {
                connectionString = connectionString + ",CHARSET=" + this.charset;
            }
            if (this.isGoverned || this.isFastFail) {
                connectionString = connectionString + ",LSS_TYPE=E";
            }
            lsnConnection = TeradataConnection.getConnection(classname, this.jdbcUrl, TeradataPlugInConfiguration.getInputTeradataUserName(context), TeradataPlugInConfiguration.getInputTeradataPassword(context), connectionString, this.enableUnicodePassthrough);
            String queryBandProperty = TeradataPlugInConfiguration.getInputQueryBand(configuration) + (this.isGoverned || this.isFastFail ? FASTEXPORT_QUERY_BAND : "");
            TeradataUtils.validateQueryBand(queryBandProperty);
            TeradataConnection.setQueryBandProperty(lsnConnection, queryBandProperty);
            int numSessions = TeradataInternalFastExportInputFormat.getFastExportSessionCount(configuration);
            ConnectorConfiguration.setNumMappers(configuration, numSessions);
            this.configFastExportConnectivity(context, numSessions);
            logger.info((Object)("started load sessions: " + numSessions));
            InternalFastExportCoordinator coordinator = new InternalFastExportCoordinator(numSessions, configuration);
            Thread thread = new Thread(coordinator);
            thread.start();
            String[] locations = HadoopConfigurationUtils.getAllActiveHosts(context);
            String splitSql = TeradataPlugInConfiguration.getInputSplitSql(configuration);
            for (int i = 0; i < numSessions; ++i) {
                TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(splitSql);
                split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                splits.add(split);
            }
        }
        catch (SQLException e) {
            TeradataUtils.closeConnection(lsnConnection);
            this.closeServer(server);
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            TeradataUtils.closeConnection(lsnConnection);
            this.closeServer(server);
            throw new ConnectorException(e.getMessage(), e);
        }
        return splits;
    }

    private static int getFastExportSessionCount(Configuration configuration) throws SQLException {
        TDSession session = (TDSession)lsnConnection;
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        boolean isGoverned = session.getURLParameters().isGoverned();
        if (session.useCheckWorkload()) {
            String inputDatabase = TeradataPlugInConfiguration.getInputDatabase(configuration);
            String inputTableName = TeradataPlugInConfiguration.getInputTable(configuration);
            inputTableName = TeradataConnection.getQuotedEscapedName(inputDatabase, inputTableName);
            String inputQuery = TeradataPlugInConfiguration.getInputSplitSql(configuration);
            String checkWorkloadBegin = CHECK_WORKLOAD_BEGIN + SQL_BEGIN_FASTEXPORT;
            Statement controlStmt = lsnConnection.createStatement();
            controlStmt.executeUpdate(checkWorkloadBegin);
            String checkWorkloadQuery = CHECK_WORKLOAD_BEGIN + inputQuery;
            controlStmt.executeQuery(checkWorkloadQuery);
            String checkWorkloadEnd = (!isGoverned ? "{fn TERADATA_FAILFAST}" : "") + CHECK_WORKLOAD_END;
            ResultSet rs = controlStmt.executeQuery(checkWorkloadEnd);
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next() && rsmd.getColumnCount() >= 2 && rs.getString(1) != null) {
                if (rs.getString(1).trim().equalsIgnoreCase("Y")) {
                    int count = rs.getInt(2);
                    if (count > 0) {
                        int numSugSessn = Math.min(numMappers, count);
                        if (numSugSessn < numMappers) {
                            logger.info((Object)("user provided number of Mappers [" + numMappers + "] is overridden by [" + numSugSessn + "] returned from DBS"));
                        } else {
                            logger.info((Object)("user provided number of Mappers is NOT overridden by [" + count + "] DBS."));
                        }
                        return numSugSessn;
                    }
                    logger.info((Object)("invalid number " + count + " returned from DBS"));
                } else {
                    logger.info((Object)"returned TASM-flag is N");
                }
            } else {
                logger.info((Object)"unrecognized column returned");
            }
            rs.close();
            controlStmt.close();
        } else {
            logger.info((Object)"TDCH is not controlled by TASM");
        }
        return numMappers;
    }

    private void configFastExportConnectivity(JobContext context, int numTasks) throws SQLException, IOException {
        Configuration configuration = context.getConfiguration();
        String host = TeradataPlugInConfiguration.getInputFastExportSocketHost(configuration);
        int port = TeradataPlugInConfiguration.getInputFastExportSocketPort(configuration);
        String lsnNumber = lsnConnection.nativeSQL(SQL_GET_LSN);
        if (lsnNumber == null || lsnNumber.length() == 0) {
            throw new SQLException("lsn number missing");
        }
        logger.debug((Object)("fastexport lsn number is " + lsnNumber));
        TeradataPlugInConfiguration.setInputFastExportLsn(configuration, lsnNumber);
        if (host.isEmpty() || host.equalsIgnoreCase("default") || host.equalsIgnoreCase("localhost")) {
            host = HadoopConfigurationUtils.getClusterNodeInterface(context);
            TeradataPlugInConfiguration.setInputFastExportSocketHost(configuration, host);
        }
        if (port == 0) {
            port = server.getLocalPort();
            TeradataPlugInConfiguration.setInputFastExportSocketPort(configuration, port);
        }
    }

    protected void closeServer(ServerSocket server) {
        if (server != null && !server.isClosed()) {
            try {
                server.close();
            }
            catch (IOException e1) {
                logger.debug((Object)e1.getMessage());
            }
        }
    }

    protected void closeSocket(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e1) {
                logger.debug((Object)e1.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getJobStatus() {
        Class<TeradataInternalFastExportProcessor> clazz = TeradataInternalFastExportProcessor.class;
        synchronized (TeradataInternalFastExportProcessor.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return TeradataInternalFastExportProcessor.jobSuccess;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordReader<LongWritable, ConnectorRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        String submitJobHost = configuration.get("mapreduce.job.submithostname");
        String lsn = TeradataPlugInConfiguration.getInputFastExportLsn(configuration);
        String host = TeradataPlugInConfiguration.getInputFastExportSocketHost(configuration);
        int port = TeradataPlugInConfiguration.getInputFastExportSocketPort(configuration);
        logger.debug((Object)("FastExport mapper socket host is " + host));
        logger.debug((Object)("FastExport mapper socket port is " + port));
        logger.debug((Object)("FastExport lsn is " + lsn));
        Socket socket = null;
        Connection fastExportConnection = null;
        Connection sessionConnection = null;
        int retryCount = 0;
        try {
            while (socket == null) {
                try {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(host, port), SOCKET_CONNECT_TIMEOUT);
                    socket.setTcpNoDelay(true);
                    logger.debug((Object)"Connection to InternalFastExport coordinator successful");
                }
                catch (Exception e) {
                    if (++retryCount >= SOCKET_CONNECT_RETRY_MAX) {
                        logger.debug((Object)("After " + retryCount + " retries, unable to connect to InternalFastExport coordinator"));
                        throw new ConnectorException(e.getMessage(), e);
                    }
                    socket = null;
                    if (!submitJobHost.isEmpty() && retryCount % 10 == 0) {
                        try {
                            socket = new Socket();
                            socket.connect(new InetSocketAddress(submitJobHost, port), SOCKET_CONNECT_TIMEOUT);
                            socket.setTcpNoDelay(true);
                            host = submitJobHost;
                            logger.debug((Object)"Connection to InternalFastExport coordinator successful via mapreduce.job.submithostname");
                        }
                        catch (Exception e2) {
                            logger.debug((Object)("Caught exception " + e.getMessage()));
                        }
                    }
                    try {
                        int waitSeconds = new Random().nextInt(SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED) + SOCKET_CONNECT_RETRY_WAIT_MIN;
                        Thread.sleep(waitSeconds);
                    }
                    catch (InterruptedException e1) {
                        logger.debug((Object)"InterruptedException occurred during random sleep between retries");
                    }
                }
            }
            DataInputStream in = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String taskAttempId = context.getTaskAttemptID().toString();
            if (context.getTaskAttemptID().getId() > 0) {
                logger.debug((Object)"Current task attempt ID is > 0, internal.fastexport doesn't support preemption/failover, FastExport job failed");
                out.writeUTF("FastExport job failed on task " + taskAttempId);
                out.flush();
                throw new ConnectorException(22102);
            }
            if (lsn == null || lsn.isEmpty()) {
                logger.debug((Object)"No LSN found for FastExport job, FastExport job failed.");
                out.writeUTF("FastExport job failed on task " + taskAttempId);
                out.flush();
                throw new ConnectorException(22112);
            }
            String timeConnProperties = "";
            String url = TeradataPlugInConfiguration.getInputJdbcUrl(configuration).toLowerCase();
            if (!url.contains("/tsnano=") && !url.contains(",tsnano=")) {
                timeConnProperties = timeConnProperties + "tsnano=6,";
            }
            if (!url.contains("/tnano=") && !url.contains(",tnano=")) {
                timeConnProperties = timeConnProperties + "tnano=6,";
            }
            boolean isGoverned = TeradataConnection.getJDBCURLParameters(url).isGoverned();
            boolean isFastFail = TeradataPlugInConfiguration.getInputFastFail(configuration);
            String connection_param = isGoverned || isFastFail ? "LSS_TYPE=E," + PARAM_FASTEXPORT_CONNECTION : PARAM_FASTEXPORT_CONNECTION;
            logger.debug((Object)"Creating JDBC FastExport connection to DBS");
            fastExportConnection = TeradataConnection.getConnection(TeradataPlugInConfiguration.getInputJdbcDriverClass(configuration), TeradataPlugInConfiguration.getInputJdbcUrl(configuration), TeradataPlugInConfiguration.getInputTeradataUserName((JobContext)context), TeradataPlugInConfiguration.getInputTeradataPassword((JobContext)context), timeConnProperties + connection_param + lsn);
            logger.debug((Object)"Creating JDBC connection to DBS for session control");
            String connectionString = PARAM_SESSION_CONNECTION;
            if (!this.charset.equals("")) {
                connectionString = connectionString + ",CHARSET=" + this.charset;
            }
            sessionConnection = TeradataConnection.getConnection(TeradataPlugInConfiguration.getInputJdbcDriverClass(configuration), TeradataPlugInConfiguration.getInputJdbcUrl(configuration), TeradataPlugInConfiguration.getInputTeradataUserName((JobContext)context), TeradataPlugInConfiguration.getInputTeradataPassword((JobContext)context), connectionString);
            fastExportConnection.setAutoCommit(false);
            logger.info((Object)("FastExport connection is created for task " + taskAttempId));
            String splitSql = ((TeradataInputFormat.TeradataInputSplit)split).getSplitSql();
            out.writeUTF(MSG_FASTEXPORT_CONNECTION_READY);
            out.flush();
            String message = in.readUTF();
            if (!message.contains(MSG_FASTEXPORT_TRANSFER_BEGIN)) {
                logger.debug((Object)("Received unsupported message from InternalFastExport coordinator: " + message));
                throw new ConnectorException(22101);
            }
            logger.debug((Object)"Received FastExport transfer begin message from InternalFastExport coordinator");
            int session_uniqueid = Integer.parseInt(in.readUTF());
            logger.debug((Object)("Received FastExport session unique id " + session_uniqueid + "  from InternalFastExport coordinator"));
            String submitJobDir = configuration.get("mapreduce.job.dir");
            Path path = new Path(submitJobDir, FASTEXPORT_PARAMS_FILE_NAME);
            FileSystem fileSystem = path.getFileSystem(configuration);
            boolean noSpoolEnabled = true;
            String blockCountString = null;
            if (fileSystem.exists(path)) {
                FSDataInputStream inputStream = fileSystem.open(path);
                noSpoolEnabled = Boolean.parseBoolean(inputStream.readUTF());
                blockCountString = inputStream.readUTF();
                inputStream.close();
            }
            TeradataInternalFastExportRecordReader teradataInternalFastExportRecordReader = new TeradataInternalFastExportRecordReader(splitSql, sessionConnection, fastExportConnection, host, port, noSpoolEnabled, blockCountString, session_uniqueid);
            this.closeSocket(socket);
            return teradataInternalFastExportRecordReader;
        }
        catch (SQLException e) {
            try {
                TeradataUtils.closeConnection(fastExportConnection);
                TeradataUtils.closeConnection(sessionConnection);
                throw new ConnectorException(e.getMessage(), e);
                catch (UnknownHostException e2) {
                    TeradataUtils.closeConnection(fastExportConnection);
                    TeradataUtils.closeConnection(sessionConnection);
                    throw new ConnectorException(e2.getMessage(), e2);
                }
                catch (ClassNotFoundException e3) {
                    TeradataUtils.closeConnection(fastExportConnection);
                    TeradataUtils.closeConnection(sessionConnection);
                    throw new ConnectorException(e3.getMessage(), e3);
                }
                catch (IOException e4) {
                    TeradataUtils.closeConnection(fastExportConnection);
                    TeradataUtils.closeConnection(sessionConnection);
                    throw new ConnectorException(e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                this.closeSocket(socket);
                throw throwable;
            }
        }
    }

    static {
        server = null;
        MSG_FASTEXPORT_TRANSFER_BEGIN = "FASTEXPORT_TRANSFER_BEGIN";
        MSG_FASTEXPORT_TRANSFER_END = "FASTEXPORT_TRANSFER_END";
        MSG_FASTEXPORT_CONNECTION_READY = "FASTEXPORT_CONNECTION_READY";
        MSG_FASTEXPORT_CONNECTION_CLOSE = "FASTEXPORT_CONNECTION_CLOSE";
        MSG_FASTEXPORT_PING = "FASTEXPORT_PING";
        PARAM_FASTEXPORT_CONNECTION = "PARTITION=EXPORT,CONNECT_FUNCTION=2,LSS_TYPE=E,LOGON_SEQUENCE_NUMBER=";
        PARAM_LSN_CONNECTION = "TMODE=TERA,CONNECT_FUNCTION=1";
        PARAM_SESSION_CONNECTION = "TMODE=TERA";
        SQL_GET_LSN = "{fn teradata_logon_sequence_number()}";
        SQL_REQUEST_TRACKING_ON = "{fn teradata_provide(request_tracking_on)}";
        SQL_REQUEST_TRACKING_OFF = "{fn teradata_provide(request_tracking_off)}";
        SQL_PROVIDE_REQUEST_TRACKING = "{fn teradata_provide(request_tracking)}";
        SQL_PROVIDE_REQUESTS = "{fn teradata_provide(requests)}";
        SQL_CLEAR_REQUESTS = "{fn teradata_provide(clear_requests)}";
        SQL_BEGIN_FASTEXPORT = "BEGIN FASTEXPORT WITH NO SPOOL";
        SQL_END_FASTEXPORT = "END FASTEXPORT";
        FASTEXPORT_PARAMS_FILE_NAME = "fastexportparamsfile";
        LINE_SEP = System.getProperty("line.separator");
        SOCKET_CONNECT_TIMEOUT = 5000;
        SOCKET_CONNECT_RETRY_MAX = 50;
        SOCKET_CONNECT_RETRY_WAIT_MIN = 200;
        SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED = 500;
        SOCKET_SERVER_ACCEPT_TIME_OUT = 20000;
        SOCKET_PING_TIME_OUT = 60000;
    }

    public class TeradataInternalFastExportRecordReader
    extends RecordReader<LongWritable, ConnectorRecord> {
        private Log logger = LogFactory.getLog(TeradataInternalFastExportRecordReader.class);
        private Socket socket;
        private DataInputStream in = null;
        private DataOutputStream out = null;
        private String host = null;
        private String blockCountString = null;
        private int port = 0;
        private boolean noSpoolEnabled = true;
        private ArrayList<Integer> blockCountList = null;
        private Connection sessionConnection = null;
        private Connection fastExportConnection = null;
        private PreparedStatement sessionPreparedStatement = null;
        private PreparedStatement fastExportPreparedStatement = null;
        private ArrayList<ResultSetMetaData> metaDataList = null;
        private long resultCount = 0L;
        private TeradataObjectArrayWritable curValue = null;
        private ResultSet resultset = null;
        private String splitSQL;
        private long end_timestamp = 0L;
        private int uniqueId = 0;
        private int blkNum = 1;
        private long start_timestamp = 0L;
        private String[] sourceFields = null;
        private int[] sourceFieldMapping = null;
        private Configuration configuration;

        public TeradataInternalFastExportRecordReader(String splitSQL, Connection sessionConnection, Connection fastExportConnection, String host, int port, boolean noSpoolEnabled, String blockCountString, int uniqueid) {
            this.sessionConnection = sessionConnection;
            this.fastExportConnection = fastExportConnection;
            this.splitSQL = splitSQL;
            this.host = host;
            this.port = port;
            this.noSpoolEnabled = noSpoolEnabled;
            this.blockCountString = blockCountString;
            this.uniqueId = uniqueid;
            this.start_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.configuration = context.getConfiguration();
            this.blockCountList = new ArrayList();
            String[] strBlockCount = this.blockCountString.replaceAll("[\\[\\]]", "").split(",");
            for (int i = 0; i < strBlockCount.length; ++i) {
                this.blockCountList.add(new Integer(strBlockCount[i].trim()));
            }
            try {
                this.sessionPreparedStatement = this.sessionConnection.prepareStatement(this.splitSQL);
                this.fastExportPreparedStatement = this.fastExportConnection.prepareStatement(null);
                this.metaDataList = new ArrayList();
                do {
                    this.metaDataList.add(this.sessionPreparedStatement.getMetaData());
                } while (this.sessionPreparedStatement.getMoreResults());
                String sourceTableDescText = TeradataPlugInConfiguration.getInputTableDesc(this.configuration);
                this.sourceFields = TeradataPlugInConfiguration.getInputFieldNamesArray(this.configuration);
                this.sourceFieldMapping = TeradataSchemaUtils.lookupMappingFromTableDescText(sourceTableDescText, this.sourceFields);
                this.curValue = new TeradataObjectArrayWritable(this.sourceFieldMapping.length);
                String[] typeNames = TeradataSchemaUtils.lookupTypeNamesFromTableDescText(sourceTableDescText, this.sourceFields);
                this.curValue.setRecordTypes(typeNames);
                ResultSetMetaData metaData = this.metaDataList.get(0);
                this.fastExportPreparedStatement.setObject(1, metaData);
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return new LongWritable(this.resultCount);
        }

        public ConnectorRecord getCurrentValue() throws IOException, InterruptedException {
            return this.curValue;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            try {
                boolean exitLoop = false;
                int res = 0;
                int blkCnt = this.blockCountList.get(res);
                long stmtNum = 0L;
                int actualFxpSessions = ConnectorConfiguration.getNumMappers(this.configuration);
                do {
                    if (this.resultset == null) {
                        if (this.noSpoolEnabled) {
                            this.fastExportPreparedStatement.setInt(2, 1);
                        } else {
                            if (this.blkNum == 1) {
                                this.blkNum = 1 + this.uniqueId;
                            }
                            if (this.blkNum > blkCnt) {
                                return false;
                            }
                            stmtNum = (long)(res + 1) << 32;
                            this.fastExportPreparedStatement.setLong(2, stmtNum + (long)this.blkNum);
                            this.blkNum += actualFxpSessions;
                        }
                        try {
                            this.resultset = this.fastExportPreparedStatement.executeQuery();
                        }
                        catch (SQLException e) {
                            boolean endOfFastExport = false;
                            for (SQLException se = e; se != null; se = se.getNextException()) {
                                if (!this.noSpoolEnabled || se.getErrorCode() != 9112) continue;
                                endOfFastExport = true;
                                break;
                            }
                            if (endOfFastExport) {
                                return false;
                            }
                            throw new ConnectorException(e.getMessage(), e);
                        }
                    }
                    if (this.resultset.next()) {
                        this.curValue.readFields(this.resultset);
                        ++this.resultCount;
                        exitLoop = true;
                        continue;
                    }
                    this.resultset.close();
                    this.resultset = null;
                } while (!exitLoop);
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            return true;
        }

        public void close() throws IOException {
            String message;
            int retryCount = 0;
            this.logger.debug((Object)"Attempting to connect to InternalFastload coordinator to signal data transfer complete");
            while (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.socket.setTcpNoDelay(true);
                    this.logger.debug((Object)"Connected to InternalFastExport coordinator successfully");
                }
                catch (ConnectException e) {
                    if (++retryCount >= SOCKET_CONNECT_RETRY_MAX) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                    this.socket = null;
                    try {
                        int waitSeconds = new Random().nextInt(SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED) + SOCKET_CONNECT_RETRY_WAIT_MIN;
                        Thread.sleep(waitSeconds);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug((Object)"InterruptedException occurred during random sleep between retries");
                    }
                }
            }
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            try {
                if (this.sessionPreparedStatement != null) {
                    this.sessionPreparedStatement.close();
                    this.sessionPreparedStatement = null;
                }
                if (this.fastExportPreparedStatement != null) {
                    this.fastExportPreparedStatement.clearParameters();
                    this.fastExportPreparedStatement.close();
                    this.fastExportPreparedStatement = null;
                }
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            this.logger.debug((Object)"Signaling to InternalFastExport coordinator data transfer is complete for task");
            this.out.writeUTF(MSG_FASTEXPORT_TRANSFER_END);
            this.out.flush();
            while ((message = this.in.readUTF()).equals(MSG_FASTEXPORT_PING)) {
                this.logger.info((Object)"ping message received. ignore.");
            }
            if (!message.equals(MSG_FASTEXPORT_CONNECTION_CLOSE)) {
                this.logger.debug((Object)("Received unsupported message from InternalFastExport coordinator: " + message));
                throw new IOException("FastExport: message " + MSG_FASTEXPORT_CONNECTION_CLOSE + " expected");
            }
            this.socket.close();
            TeradataUtils.closeConnection(this.fastExportConnection);
            TeradataUtils.closeConnection(this.sessionConnection);
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("TeradataInternalFastExportRecordReader ended at: " + this.end_timestamp));
            this.logger.info((Object)("TeradataInternalFastExportRecordReader duration in seconds: " + (this.end_timestamp - this.start_timestamp) / 1000L));
        }
    }

    class InternalFastExportCoordinator
    implements Runnable {
        private int numSessions;
        private Configuration configuration;
        private Log logger = LogFactory.getLog(InternalFastExportCoordinator.class);
        private PreparedStatement preparedStatement;

        InternalFastExportCoordinator(int numSessions, Configuration configuration) {
            this.numSessions = numSessions;
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                this.beginExport(this.numSessions, this.configuration, server);
                this.logger.debug((Object)"Begin loading complete, starting end loading logic");
                this.endExport(this.numSessions, server);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage());
            }
            finally {
                try {
                    TeradataUtils.closeConnection(lsnConnection);
                }
                catch (ConnectorException e1) {
                    this.logger.error((Object)e1.getMessage());
                }
                TeradataInternalFastExportInputFormat.this.closeServer(server);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void beginExport(int sessionCount, Configuration configuration, ServerSocket server) throws ConnectorException {
            int i;
            boolean noSpoolEnabled = false;
            Socket[] sockets = new Socket[sessionCount];
            try {
                server.setSoTimeout(SOCKET_SERVER_ACCEPT_TIME_OUT);
                long timeoutValue = TeradataPlugInConfiguration.getInputFastExportSocketTimeout(configuration);
                long startTime = System.currentTimeMillis();
                while (TeradataInternalFastExportInputFormat.this.readyConnCount < sessionCount) {
                    if (!TeradataInternalFastExportInputFormat.getJobStatus()) {
                        this.logger.debug((Object)"TeradataInternalFastExportProcessor.jobSuccess is false");
                        throw new ConnectorException(22102);
                    }
                    try {
                        sockets[TeradataInternalFastExportInputFormat.this.readyConnCount] = server.accept();
                        sockets[TeradataInternalFastExportInputFormat.this.readyConnCount].setTcpNoDelay(true);
                        DataInputStream in = new DataInputStream(sockets[TeradataInternalFastExportInputFormat.this.readyConnCount++].getInputStream());
                        String command = in.readUTF();
                        if (!command.contains(MSG_FASTEXPORT_CONNECTION_READY)) {
                            this.logger.debug((Object)("Received failure message from mapper: " + command));
                            throw new ConnectorException(22102);
                        }
                        this.logger.debug((Object)("Received FastExport ready message from mapper (" + TeradataInternalFastExportInputFormat.this.readyConnCount + "/" + sessionCount + ")"));
                    }
                    catch (SocketTimeoutException e) {
                        long endTime = System.currentTimeMillis();
                        if (endTime - startTime < timeoutValue) continue;
                        throw new ConnectorException(22103);
                    }
                }
                Statement statement = lsnConnection.createStatement();
                String queryString = TeradataPlugInConfiguration.getInputSplitSql(configuration);
                this.preparedStatement = lsnConnection.prepareStatement(queryString);
                String beginFastExport = SQL_BEGIN_FASTEXPORT;
                this.logger.debug((Object)("Executing begin FastExport command: " + beginFastExport));
                statement.executeUpdate(beginFastExport);
                lsnConnection.nativeSQL(SQL_REQUEST_TRACKING_ON);
                lsnConnection.nativeSQL(SQL_PROVIDE_REQUEST_TRACKING);
                this.preparedStatement.execute();
                String requests = lsnConnection.nativeSQL(SQL_PROVIDE_REQUESTS);
                String[] requestFields = requests.split(LINE_SEP);
                for (int i2 = 0; i2 < requestFields.length; ++i2) {
                    if (!requestFields[i2].matches(".*activity_type=.*") || !requestFields[i2].split("=")[1].startsWith("196")) continue;
                    noSpoolEnabled = true;
                    break;
                }
                lsnConnection.nativeSQL(SQL_REQUEST_TRACKING_OFF);
                lsnConnection.nativeSQL(SQL_REQUEST_TRACKING_ON);
                lsnConnection.nativeSQL(SQL_CLEAR_REQUESTS);
                ArrayList<Integer> blockCountList = new ArrayList<Integer>();
                do {
                    if (noSpoolEnabled) {
                        blockCountList.add(new Integer(0x7FFFFFFE));
                        continue;
                    }
                    blockCountList.add(new Integer(this.preparedStatement.getUpdateCount()));
                } while (this.preparedStatement.getMoreResults() || this.preparedStatement.getUpdateCount() >= 0);
                String submitJobDir = configuration.get("mapreduce.job.dir");
                Path path = new Path(submitJobDir, FASTEXPORT_PARAMS_FILE_NAME);
                FileSystem fileSystem = path.getFileSystem(configuration);
                if (fileSystem.exists(path)) {
                    throw new ConnectorException(24002);
                }
                String maxReplicaString = configuration.get("dfs.replication.max");
                short maxReplicaNum = (short)(maxReplicaString == null || maxReplicaString.isEmpty() ? 512 : Integer.parseInt(maxReplicaString));
                int numMappers = ConnectorConfiguration.getNumMappers(configuration);
                FSDataOutputStream outputStream = numMappers < maxReplicaNum ? fileSystem.create(path, (short)numMappers) : fileSystem.create(path, maxReplicaNum);
                outputStream.writeUTF(Boolean.valueOf(noSpoolEnabled).toString());
                outputStream.writeUTF(blockCountList.toString());
                outputStream.close();
                TeradataInternalFastExportInputFormat.this.readyConnCount = 0;
                server.setSoTimeout(0);
                this.logger.debug((Object)"Signaling to mappers to begin FastExport transfer");
                while (TeradataInternalFastExportInputFormat.this.readyConnCount < sessionCount) {
                    DataOutputStream out = new DataOutputStream(sockets[TeradataInternalFastExportInputFormat.this.readyConnCount].getOutputStream());
                    out.writeUTF(MSG_FASTEXPORT_TRANSFER_BEGIN);
                    out.writeUTF(Integer.valueOf(TeradataInternalFastExportInputFormat.this.readyConnCount++).toString());
                    out.flush();
                }
                TeradataInternalFastExportInputFormat.this.readyConnCount = 0;
                i = 0;
            }
            catch (SQLException e) {
                try {
                    throw new ConnectorException(e.getMessage(), e);
                    catch (IOException e2) {
                        throw new ConnectorException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    int i3 = 0;
                    while (true) {
                        if (i3 >= sockets.length) {
                            throw throwable;
                        }
                        TeradataInternalFastExportInputFormat.this.closeSocket(sockets[i3]);
                        sockets[i3] = null;
                        ++i3;
                    }
                }
            }
            while (i < sockets.length) {
                TeradataInternalFastExportInputFormat.this.closeSocket(sockets[i]);
                sockets[i] = null;
                ++i;
            }
            return;
        }

        private void sendPingMsg(DataOutputStream[] outs) throws IOException {
            for (int i = 0; i < outs.length; ++i) {
                if (outs[i] == null) continue;
                outs[i].writeUTF(MSG_FASTEXPORT_PING);
                outs[i].flush();
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void endExport(int sessionCount, ServerSocket server) throws ConnectorException {
            int i;
            Socket[] sockets = new Socket[sessionCount];
            try {
                DataOutputStream[] outs = new DataOutputStream[sessionCount];
                server.setSoTimeout(SOCKET_PING_TIME_OUT);
                TeradataInternalFastExportInputFormat.this.readySessionCount = 0;
                while (TeradataInternalFastExportInputFormat.this.readySessionCount < sessionCount) {
                    if (!TeradataInternalFastExportInputFormat.getJobStatus()) {
                        this.logger.debug((Object)"TeradataInternalFastExportProcessor.jobSuccess is false");
                        throw new ConnectorException(22102);
                    }
                    try {
                        sockets[TeradataInternalFastExportInputFormat.this.readySessionCount] = server.accept();
                        sockets[TeradataInternalFastExportInputFormat.this.readySessionCount].setTcpNoDelay(true);
                    }
                    catch (SocketTimeoutException e) {
                        this.sendPingMsg(outs);
                        continue;
                    }
                    DataInputStream in = new DataInputStream(sockets[TeradataInternalFastExportInputFormat.this.readySessionCount].getInputStream());
                    outs[TeradataInternalFastExportInputFormat.this.readySessionCount] = new DataOutputStream(sockets[TeradataInternalFastExportInputFormat.this.readySessionCount].getOutputStream());
                    String command = in.readUTF();
                    if (!command.contains(MSG_FASTEXPORT_TRANSFER_END)) {
                        this.logger.debug((Object)("Received failure message from mapper: " + command));
                        throw new ConnectorException(22102);
                    }
                    ++TeradataInternalFastExportInputFormat.this.readySessionCount;
                    this.logger.debug((Object)("Received FastExport complete message from mapper (" + TeradataInternalFastExportInputFormat.this.readySessionCount + "/" + sessionCount + ")"));
                }
                server.setSoTimeout(0);
                this.preparedStatement.close();
                Statement statement = lsnConnection.createStatement();
                this.logger.debug((Object)("Executing end export command: " + SQL_END_FASTEXPORT));
                statement.executeUpdate(SQL_END_FASTEXPORT);
                statement.close();
                this.logger.debug((Object)"Signaling to mappers FastExport transfer is complete");
                TeradataInternalFastExportInputFormat.this.readySessionCount = 0;
                while (TeradataInternalFastExportInputFormat.this.readySessionCount < sessionCount) {
                    outs[TeradataInternalFastExportInputFormat.this.readySessionCount].writeUTF(MSG_FASTEXPORT_CONNECTION_CLOSE);
                    outs[TeradataInternalFastExportInputFormat.this.readySessionCount].flush();
                    ++TeradataInternalFastExportInputFormat.this.readySessionCount;
                }
                i = 0;
            }
            catch (SQLException e) {
                try {
                    throw new ConnectorException(e.getMessage(), e);
                    catch (IOException e2) {
                        throw new ConnectorException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    int i2 = 0;
                    while (true) {
                        if (i2 >= sockets.length) {
                            throw throwable;
                        }
                        TeradataInternalFastExportInputFormat.this.closeSocket(sockets[i2]);
                        sockets[i2] = null;
                        ++i2;
                    }
                }
            }
            while (i < sockets.length) {
                TeradataInternalFastExportInputFormat.this.closeSocket(sockets[i]);
                sockets[i] = null;
                ++i;
            }
            return;
        }
    }
}

