/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.TeradataObjectArrayWritable;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TeradataInputFormat
extends InputFormat<LongWritable, ConnectorRecord> {
    protected static final int SPLIT_LOCATIONS_MAX = 6;
    protected TeradataConnection connection = null;
    protected String inputTableName = null;
    protected String inputConditions = null;
    protected String[] inputFieldNamesArray = null;

    public void validateConfiguration(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        this.connection = TeradataUtils.openInputConnection(context);
        String inputProcessor = ConnectorConfiguration.getPlugInInputProcessor(configuration);
        if (inputProcessor.isEmpty()) {
            TeradataUtils.validateInputTeradataProperties(configuration, this.connection);
            TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, this.connection);
        }
    }

    public RecordReader<LongWritable, ConnectorRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        String splitSql = ((TeradataInputSplit)split).getSplitSql();
        return new TeradataRecordReader(splitSql);
    }

    public static class TeradataInputSplit
    extends InputSplit
    implements Writable {
        private String[] locations = null;
        private String splitSql = "";

        public TeradataInputSplit() {
        }

        public TeradataInputSplit(String sql) {
            this.splitSql = sql;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.locations == null ? new String[]{} : this.locations;
        }

        public long getLength() throws IOException, InterruptedException {
            return 1L;
        }

        public void readFields(DataInput input) throws IOException {
            this.splitSql = Text.readString((DataInput)input);
        }

        public void write(DataOutput output) throws IOException {
            Text.writeString((DataOutput)output, (String)this.splitSql);
        }

        public String getSplitSql() {
            return this.splitSql;
        }

        public void setSplitSql(String sql) {
            this.splitSql = sql;
        }
    }

    public class TeradataRecordReader
    extends RecordReader<LongWritable, ConnectorRecord> {
        private Log logger = LogFactory.getLog(TeradataRecordReader.class);
        private Connection connection = null;
        private PreparedStatement preparedStatement = null;
        private long resultCount = 0L;
        private TeradataObjectArrayWritable curValue = null;
        private ResultSet resultset = null;
        private String splitSQL;
        private long end_timestamp = 0L;
        private long start_timestamp = 0L;
        private String[] sourceFields = null;
        private int[] sourceFieldMapping = null;

        public TeradataRecordReader(String splitSQL) {
            this.splitSQL = splitSQL;
            this.start_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration configuration = context.getConfiguration();
            try {
                if (this.connection == null) {
                    this.connection = TeradataUtils.openInputConnection((JobContext)context).getConnection();
                }
                if (this.connection != null) {
                    this.logger.debug((Object)("split sql is: " + this.splitSQL));
                    this.preparedStatement = this.connection.prepareStatement(this.splitSQL);
                    this.preparedStatement.setFetchSize(TeradataPlugInConfiguration.getInputBatchSize(configuration));
                }
                String sourceTableDescText = TeradataPlugInConfiguration.getInputTableDesc(configuration);
                this.sourceFields = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
                this.sourceFieldMapping = TeradataSchemaUtils.lookupMappingFromTableDescText(sourceTableDescText, this.sourceFields);
                this.curValue = new TeradataObjectArrayWritable(this.sourceFieldMapping.length);
                String[] typeNames = TeradataSchemaUtils.lookupTypeNamesFromTableDescText(sourceTableDescText, this.sourceFields);
                this.curValue.setRecordTypes(typeNames);
            }
            catch (SQLException e) {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
                throw new ConnectorException(e.getMessage(), e);
            }
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return new LongWritable(this.resultCount);
        }

        public ConnectorRecord getCurrentValue() throws IOException, InterruptedException {
            return this.curValue;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            try {
                if (this.resultset == null) {
                    this.resultset = this.preparedStatement.executeQuery();
                }
                if (!this.resultset.next()) {
                    return false;
                }
                this.curValue.readFields(this.resultset);
                ++this.resultCount;
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            return true;
        }

        public void close() throws IOException {
            try {
                if (this.preparedStatement != null) {
                    this.preparedStatement.close();
                    this.preparedStatement = null;
                }
                this.end_timestamp = System.currentTimeMillis();
                this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
                this.logger.info((Object)("the total elapsed time of recordreader " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            finally {
                TeradataUtils.closeConnection(this.connection);
            }
        }
    }
}

