/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataBatchInsertProcessor;
import com.teradata.connector.teradata.utils.LogContainer;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TeradataBatchInsertOutputFormat<K, V>
extends OutputFormat<K, DBWritable> {
    private static Log logger = LogFactory.getLog(TeradataBatchInsertOutputFormat.class);
    protected TeradataConnection connection;

    protected void validateConfiguration(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        this.connection = TeradataUtils.openOutputConnection(context);
        String outputProcessor = ConnectorConfiguration.getPlugInOutputProcessor(configuration);
        if (outputProcessor.isEmpty()) {
            TeradataUtils.validateOutputTeradataProperties(configuration, this.connection);
            if (TeradataPlugInConfiguration.getOutputBatchSize(configuration) > 13683) {
                TeradataPlugInConfiguration.setOutputBatchSize(configuration, 13683);
            }
            TeradataSchemaUtils.setupTeradataTargetTableSchema(configuration, this.connection);
        }
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        if (ConnectorConfiguration.getPlugInOutputProcessor(configuration).isEmpty()) {
            this.validateConfiguration(context);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new FileOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
    }

    public RecordWriter<K, DBWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Connection jdbcConnection = null;
        PreparedStatement prepareStatement = null;
        int batchSize = 0;
        boolean stageEnabled = TeradataPlugInConfiguration.getOutputStageEnabled(context.getConfiguration());
        boolean disableFailover = TeradataPlugInConfiguration.getOutputBIDisableFailoverSupport(context.getConfiguration());
        String taskID = context.getTaskAttemptID().getTaskID().toString();
        String[] outputTableFieldNames = TeradataPlugInConfiguration.getOutputFieldNamesArray(context.getConfiguration());
        Configuration configuration = context.getConfiguration();
        String insertStmt = "";
        try {
            long numRows;
            if (context.getTaskAttemptID().getId() > 0 && (!stageEnabled || disableFailover)) {
                throw new ConnectorException(22011);
            }
            String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
            String outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
            outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
            this.connection = TeradataUtils.openOutputConnection((JobContext)context);
            if (context.getTaskAttemptID().getId() > 0 && stageEnabled && !disableFailover && (numRows = this.connection.getTableRowCount(outputTableName, "TDCH_BI_TASKID = '" + taskID + "'")) != 0L) {
                logger.info((Object)("Task ID " + taskID + " was restarted, deleting " + numRows + " records loaded by failed task from stage table"));
                this.connection.deleteTable(outputTableName, "TDCH_BI_TASKID = '" + taskID + "'");
            }
            if (stageEnabled && !disableFailover) {
                outputTableFieldNames = Arrays.copyOf(outputTableFieldNames, outputTableFieldNames.length + 1);
                outputTableFieldNames[outputTableFieldNames.length - 1] = TeradataBatchInsertProcessor.taskIDColumnName;
                insertStmt = TeradataConnection.getInsertPreparedStatmentSQLWithTaskID(outputTableName, outputTableFieldNames, taskID);
            } else {
                insertStmt = TeradataConnection.getInsertPreparedStatmentSQL(outputTableName, outputTableFieldNames);
            }
            logger.info((Object)insertStmt);
            batchSize = TeradataPlugInConfiguration.getOutputBatchSize(configuration);
            jdbcConnection = this.connection.getConnection();
            prepareStatement = jdbcConnection.prepareStatement(insertStmt);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ConnectorException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return new TeradataRecordWriter(jdbcConnection, prepareStatement, batchSize);
    }

    public class TeradataRecordWriter<K, V>
    extends RecordWriter<K, DBWritable> {
        protected Connection connection = null;
        protected PreparedStatement preparedStatement = null;
        protected int batchSize = 0;
        protected int batchCount = 0;
        protected long end_timestamp = 0L;
        protected long start_timestamp = System.currentTimeMillis();

        public TeradataRecordWriter() {
            logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        }

        public TeradataRecordWriter(Connection connection, PreparedStatement preparedStatement, int batchSize) {
            this();
            this.connection = connection;
            this.preparedStatement = preparedStatement;
            this.batchSize = batchSize;
        }

        public void write(K key, DBWritable value) throws IOException {
            try {
                try {
                    value.write(this.preparedStatement);
                    this.preparedStatement.addBatch();
                    ++this.batchCount;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (this.batchCount >= this.batchSize) {
                    this.preparedStatement.executeBatch();
                    this.batchCount = 0;
                }
            }
            catch (SQLException e) {
                ConnectorException start = new ConnectorException(e.getMessage(), e);
                while (e != null) {
                    StackTraceElement[] elements = e.getStackTrace();
                    int n = elements.length;
                    for (int i = 0; i < n; ++i) {
                        logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                    }
                    e = e.getNextException();
                }
                TeradataUtils.closeConnection(this.connection);
                throw start;
            }
        }

        public void close(TaskAttemptContext context) throws IOException {
            try {
                if (this.batchCount > 0) {
                    this.preparedStatement.executeBatch();
                }
                this.connection.commit();
                this.end_timestamp = System.currentTimeMillis();
                logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
                logger.info((Object)("the total elapsed time of recordwriter " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
            }
            catch (SQLException e) {
                ConnectorException start = new ConnectorException(e.getMessage(), e);
                while (e != null) {
                    StackTraceElement[] elements = e.getStackTrace();
                    int n = elements.length;
                    for (int i = 0; i < n; ++i) {
                        logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                    }
                    e = e.getNextException();
                }
                throw start;
            }
            finally {
                TeradataUtils.closeConnection(this.connection);
            }
            if (ConnectorConfiguration.getEnableHdfsLoggingFlag(context.getConfiguration()) && LogContainer.getInstance().listSize() > 0) {
                LogContainer.getInstance().writeHdfsLogs(context.getConfiguration());
            }
        }
    }
}

