/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.sample.CommonDBInputFormat;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class CommonDBSplitUtils {
    private static final BigDecimal POINT_BASE = new BigDecimal(65536);
    private static final int NUM_CHARS = 8;

    public static List<BigDecimal> getSplitPoints(BigDecimal minValue, BigDecimal maxValue, long num, int type) {
        BigDecimal numSplit = new BigDecimal(num);
        BigDecimal one = new BigDecimal(1);
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        BigDecimal remainder = maxValue.subtract(minValue).remainder(numSplit);
        int intRemainder = remainder.intValue();
        BigDecimal splitRange = CommonDBSplitUtils.bigDecimalDivision(maxValue.subtract(minValue), numSplit);
        BigDecimal currentPoint = minValue;
        list.add(currentPoint);
        for (long i = 1L; i < num; ++i) {
            currentPoint = currentPoint.add(splitRange);
            if (type == 4 && i <= (long)intRemainder) {
                currentPoint = currentPoint.add(one);
            }
            list.add(currentPoint);
        }
        return list;
    }

    private static BigDecimal stringToBigDecimal(String value) {
        BigDecimal denominatorValue = POINT_BASE;
        BigDecimal charBigDecimal = BigDecimal.ZERO;
        int len = Math.min(value.length(), 8);
        for (int i = 0; i < len; ++i) {
            int codePoint = value.codePointAt(i);
            charBigDecimal = charBigDecimal.add(CommonDBSplitUtils.bigDecimalDivision(new BigDecimal(codePoint), denominatorValue));
            denominatorValue = denominatorValue.multiply(POINT_BASE);
        }
        return charBigDecimal;
    }

    private static String bigDecimalToString(BigDecimal bigDecimal) {
        BigDecimal currentValue = bigDecimal.stripTrailingZeros();
        StringBuilder stringBuilder = new StringBuilder();
        for (int numConverted = 0; numConverted < 8; ++numConverted) {
            int currentCodeInt;
            currentValue = currentValue.multiply(POINT_BASE);
            int transferredCodeInt = currentCodeInt = currentValue.intValue();
            if (0 == currentCodeInt) break;
            transferredCodeInt = CommonDBSplitUtils.getSupportedCharCode(currentCodeInt);
            currentValue = currentValue.subtract(new BigDecimal(currentCodeInt));
            stringBuilder.append(Character.toChars(transferredCodeInt));
        }
        return stringBuilder.toString();
    }

    private static Date longToDate(long value, int sqlDataType) throws ConnectorException {
        switch (sqlDataType) {
            case 91: {
                return new java.sql.Date(value);
            }
            case 92: {
                return new Time(value);
            }
            case 93: {
                return new Timestamp(value);
            }
        }
        throw new ConnectorException(23001);
    }

    private static long dateToLong(ResultSet resultSet, int columnIndex, int sqlDataType) throws ConnectorException {
        try {
            switch (sqlDataType) {
                case 91: {
                    return resultSet.getDate(columnIndex).getTime();
                }
                case 92: {
                    return resultSet.getTime(columnIndex).getTime();
                }
                case 93: {
                    return resultSet.getTimestamp(columnIndex).getTime();
                }
            }
            throw new ConnectorException(23001);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private static List<Long> getTimeSplitPoints(long numSplits, long minValue, long maxValue) {
        ArrayList<Long> splitPoints = new ArrayList<Long>();
        List<BigDecimal> points = CommonDBSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 92);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).longValue());
        }
        return splitPoints;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByTimeType(Configuration configuration, String splitByColumn, ResultSet resultSetMinMaxValues) throws ConnectorException {
        try {
            int sqlDataType = resultSetMinMaxValues.getMetaData().getColumnType(1);
            long minValue = CommonDBSplitUtils.dateToLong(resultSetMinMaxValues, 1, sqlDataType);
            long maxValue = CommonDBSplitUtils.dateToLong(resultSetMinMaxValues, 2, sqlDataType);
            String lowerBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
            String upperBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " < ";
            String splitSql = CommonDBConfiguration.getInputSplitSql(configuration);
            int numSplits = ConnectorConfiguration.getNumMappers(configuration);
            List<Long> splitPoints = CommonDBSplitUtils.getTimeSplitPoints(numSplits, minValue, maxValue);
            ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
            long lowPoint = splitPoints.get(0);
            Date startDate = CommonDBSplitUtils.longToDate(lowPoint, sqlDataType);
            long highPoint = lowPoint;
            Date endDate = CommonDBSplitUtils.longToDate(highPoint, sqlDataType);
            if (sqlDataType == 93) {
                ((Timestamp)startDate).setNanos(resultSetMinMaxValues.getTimestamp(1).getNanos());
            }
            int i = 0;
            while (i < splitPoints.size()) {
                if (i == splitPoints.size() - 1) {
                    if (sqlDataType == 93) {
                        ((Timestamp)endDate).setNanos(resultSetMinMaxValues.getTimestamp(2).getNanos());
                    }
                    splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + "'" + startDate + "'"));
                    ++i;
                } else {
                    highPoint = splitPoints.get(++i);
                    endDate = CommonDBSplitUtils.longToDate(highPoint, sqlDataType);
                    splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + "'" + startDate + "' AND " + upperBoundary + "'" + endDate + "'"));
                }
                startDate = endDate;
            }
            return splits;
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByBooleanType(Configuration conf, String splitByColumn, boolean minValue, boolean maxValue) {
        ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
        String splitSql = CommonDBConfiguration.getInputSplitSql(conf);
        if (!minValue) {
            splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " = FALSE"));
        }
        if (maxValue) {
            splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " = TRUE"));
        }
        return splits;
    }

    private static List<Double> getDoubleSplitPoints(long numSplits, double minValue, double maxValue) {
        ArrayList<Double> splitPoints = new ArrayList<Double>();
        List<BigDecimal> points = CommonDBSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 8);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).doubleValue());
        }
        return splitPoints;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByDoubleType(Configuration configuration, String splitByColumn, double minValue, double maxValue) {
        double lowPoint;
        ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
        String splitSql = CommonDBConfiguration.getInputSplitSql(configuration);
        double minDoubleValue = minValue;
        double maxDoubleValue = maxValue;
        long numSplits = ConnectorConfiguration.getNumMappers(configuration);
        String lowerBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        List<Double> splitPoints = CommonDBSplitUtils.getDoubleSplitPoints(numSplits, minDoubleValue, maxDoubleValue);
        double highPoint = lowPoint = splitPoints.get(0).doubleValue();
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + Double.toString(lowPoint)));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + Double.toString(lowPoint) + " AND " + upperBoundary + Double.toString(highPoint)));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    private static List<Long> getIntegerSplitPoints(long numSplits, long minValue, long maxValue) {
        ArrayList<Long> splitPoints = new ArrayList<Long>();
        List<BigDecimal> points = CommonDBSplitUtils.getSplitPoints(new BigDecimal(minValue), new BigDecimal(maxValue), numSplits, 4);
        for (int i = 0; i < points.size(); ++i) {
            splitPoints.add(points.get(i).longValue());
        }
        return splitPoints;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByIntType(Configuration configuration, String splitByColumn, long minValue, long maxValue) {
        long lowPoint;
        long minIntValue = minValue;
        long maxIntValue = maxValue;
        String lowerBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        String splitSql = CommonDBConfiguration.getInputSplitSql(configuration);
        int numSplits = ConnectorConfiguration.getNumMappers(configuration);
        List<Long> splitPoints = CommonDBSplitUtils.getIntegerSplitPoints(numSplits, minIntValue, maxIntValue);
        ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
        long highPoint = lowPoint = splitPoints.get(0).longValue();
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + Long.toString(lowPoint)));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + Long.toString(lowPoint) + " AND " + upperBoundary + Long.toString(highPoint)));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    private static BigDecimal bigDecimalDivision(BigDecimal numerator, BigDecimal denominator) {
        try {
            return numerator.divide(denominator);
        }
        catch (ArithmeticException ae) {
            return numerator.divide(denominator, 1);
        }
    }

    private static List<BigDecimal> getBigDecimalSplitPoints(long numSplits, BigDecimal minDecimalValue, BigDecimal maxDecimalValue) {
        List<BigDecimal> splits = CommonDBSplitUtils.getSplitPoints(minDecimalValue, maxDecimalValue, numSplits, 3);
        return splits;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByDecimalType(Configuration configuration, String splitByColumn, BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal lowPoint;
        BigDecimal minDecimalValue = minValue;
        BigDecimal maxDecimalValue = maxValue;
        String lowerBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " >= ";
        String upperBoundary = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " < ";
        String splitSql = CommonDBConfiguration.getInputSplitSql(configuration);
        long numSplits = ConnectorConfiguration.getNumMappers(configuration);
        List<BigDecimal> splitPoints = CommonDBSplitUtils.getBigDecimalSplitPoints(numSplits, minDecimalValue, maxDecimalValue);
        ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
        BigDecimal highPoint = lowPoint = splitPoints.get(0);
        int i = 0;
        while (i < splitPoints.size()) {
            if (i == splitPoints.size() - 1) {
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + lowPoint.toString()));
                ++i;
            } else {
                highPoint = splitPoints.get(++i);
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowerBoundary + lowPoint.toString() + " AND " + upperBoundary + highPoint.toString()));
            }
            lowPoint = highPoint;
        }
        return splits;
    }

    private static List<String> getStringSplitPoints(int numSplits, String minString, String maxString, String commonPrefix) {
        BigDecimal minVal = CommonDBSplitUtils.stringToBigDecimal(minString);
        BigDecimal maxVal = CommonDBSplitUtils.stringToBigDecimal(maxString);
        List<BigDecimal> splitPoints = CommonDBSplitUtils.getBigDecimalSplitPoints(numSplits, minVal, maxVal);
        ArrayList<String> splitStrings = new ArrayList<String>();
        for (BigDecimal BigDecimalValue : splitPoints) {
            splitStrings.add(commonPrefix + CommonDBSplitUtils.bigDecimalToString(BigDecimalValue));
        }
        return splitStrings;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByStringType(Configuration configuration, String splitByColumn, String minValue, String maxValue) {
        String startString;
        char c2;
        char c1;
        int commonLength;
        String minString = minValue;
        String maxString = maxValue;
        String splitSql = CommonDBConfiguration.getInputSplitSql(configuration);
        int numSplits = ConnectorConfiguration.getNumMappers(configuration);
        String lowClausePrefix = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " >= '";
        String highClausePrefix = CommonDBSchemaUtils.quoteFieldName(splitByColumn) + " < '";
        int maxPrefixLength = Math.min(minString.length(), maxString.length());
        for (commonLength = 0; commonLength < maxPrefixLength && (c1 = minString.charAt(commonLength)) == (c2 = maxString.charAt(commonLength)); ++commonLength) {
        }
        String commonPrefix = minString.substring(0, commonLength);
        minString = minString.substring(commonLength);
        maxString = maxString.substring(commonLength);
        List<String> splitStrings = CommonDBSplitUtils.getStringSplitPoints(numSplits, minString, maxString, commonPrefix);
        ArrayList<CommonDBInputFormat.CommonDBInputSplit> splits = new ArrayList<CommonDBInputFormat.CommonDBInputSplit>();
        String endString = startString = splitStrings.get(0);
        int i = 0;
        while (i < splitStrings.size()) {
            if (i == splitStrings.size() - 1) {
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowClausePrefix + startString.replace("'", "''") + "'"));
                ++i;
            } else {
                endString = splitStrings.get(++i);
                splits.add(new CommonDBInputFormat.CommonDBInputSplit(splitSql + " " + lowClausePrefix + startString.replace("'", "''") + "' AND " + highClausePrefix + endString.replace("'", "''") + "'"));
            }
            startString = endString;
        }
        return splits;
    }

    public static List<CommonDBInputFormat.CommonDBInputSplit> getSplitsByColumnType(Configuration configuration, String splitbyColumn, ResultSet resultSetMinMaxValues) throws ConnectorException {
        try {
            int splitColumnDataType = resultSetMinMaxValues.getMetaData().getColumnType(1);
            switch (splitColumnDataType) {
                case 2: 
                case 3: {
                    return CommonDBSplitUtils.getSplitsByDecimalType(configuration, splitbyColumn, resultSetMinMaxValues.getBigDecimal(1), resultSetMinMaxValues.getBigDecimal(2));
                }
                case -7: 
                case 16: {
                    return CommonDBSplitUtils.getSplitsByBooleanType(configuration, splitbyColumn, resultSetMinMaxValues.getBoolean(1), resultSetMinMaxValues.getBoolean(2));
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return CommonDBSplitUtils.getSplitsByIntType(configuration, splitbyColumn, resultSetMinMaxValues.getLong(1), resultSetMinMaxValues.getLong(2));
                }
                case 6: 
                case 7: 
                case 8: {
                    return CommonDBSplitUtils.getSplitsByDoubleType(configuration, splitbyColumn, resultSetMinMaxValues.getDouble(1), resultSetMinMaxValues.getDouble(2));
                }
                case -1: 
                case 1: 
                case 12: {
                    return CommonDBSplitUtils.getSplitsByStringType(configuration, splitbyColumn, resultSetMinMaxValues.getString(1), resultSetMinMaxValues.getString(2));
                }
                case 91: 
                case 92: 
                case 93: {
                    return CommonDBSplitUtils.getSplitsByTimeType(configuration, splitbyColumn, resultSetMinMaxValues);
                }
            }
            throw new ConnectorException(23001);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static int getSupportedCharCode(int charCode) {
        if (charCode < 578) {
            return charCode <= 32 ? 33 : charCode;
        }
        if (charCode <= 591) {
            charCode = 592;
        } else if (charCode >= 880 && charCode <= 909) {
            charCode = 910;
        } else if (charCode >= 930 && charCode <= 1424) {
            charCode = 1425;
        } else if (charCode >= 1466 && charCode <= 1599) {
            charCode = 1600;
        } else if (charCode == 1631) {
            charCode = 1632;
        } else if (charCode == 1806) {
            charCode = 1807;
        } else if (charCode == 1867 || charCode == 1868) {
            charCode = 1869;
        } else if (charCode >= 1902 && charCode <= 1919) {
            charCode = 1920;
        } else if (charCode >= 1970 && charCode <= 2304) {
            charCode = 2305;
        } else if (charCode >= 2362 && charCode <= 2564) {
            charCode = 2565;
        } else if (charCode >= 2571 && charCode <= 4255) {
            charCode = 4256;
        } else if (charCode >= 4294 && charCode <= 4351) {
            charCode = 4352;
        } else if (charCode >= 4442 && charCode <= 4446) {
            charCode = 4447;
        } else if (charCode >= 4515 && charCode <= 4519) {
            charCode = 4520;
        } else if (charCode >= 4602 && charCode <= 5120) {
            charCode = 5121;
        } else if (charCode >= 5751 && charCode <= 8207) {
            charCode = 8208;
        } else if (charCode >= 8266 && charCode <= 9311) {
            charCode = 9312;
        } else if (charCode >= 9840 && charCode <= 13311) {
            charCode = 13312;
        } else if (charCode >= 19894 && charCode <= 19967) {
            charCode = 19968;
        } else if (charCode >= 40892 && charCode <= 44031) {
            charCode = 44032;
        } else if (charCode >= 55204 && charCode <= 64466) {
            charCode = 64467;
        } else if (charCode >= 64832 && charCode <= 64847) {
            charCode = 64848;
        } else if (charCode == 64912 || charCode == 64913) {
            charCode = 64914;
        } else if (charCode >= 64968 && charCode <= 65071) {
            charCode = 65072;
        } else if (charCode >= 65107 && charCode <= 65141) {
            charCode = 65142;
        } else if (charCode >= 65277 && charCode <= 65280) {
            charCode = 65281;
        } else if (charCode >= 65471) {
            charCode = 65470;
        }
        return charCode;
    }
}

