/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class CommonDBSchemaUtils {
    protected static final String PATTERN_MAP_TYPE = "\\s*(map\\s*[<].*[>])";
    protected static final String PATTERN_ARRAY_TYPE = "\\s*(array\\s*[<].*[>])";
    protected static final String PATTERN_STRUCT_TYPE = "\\s*(struct\\s*[<].*[>])";
    protected static final String PATTERN_UNION_TYPE = "\\s*(union\\s*[<].*[>])";
    public static final String LIST_COLUMNS = "columns";
    public static final String LIST_COLUMN_TYPES = "columns.types";
    private static final char ESCAPE_CHAR = '\\';
    private static final char DOT_CHAR = '.';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String REPLACE_DOUBLE_QUOTE = "\\\"";
    private static final char COMMA_CHAR = ',';
    private static final String REPLACE_DOUBLE_QUOTE_SQL = "\"\"";
    protected static final String SQL_SELECT_FROM_SOURCE_WHERE = "SELECT %s FROM %s %s";

    public static String quoteFieldName(String fieldName) {
        return CommonDBSchemaUtils.quoteFieldName(fieldName, REPLACE_DOUBLE_QUOTE);
    }

    private static String quoteFieldName(String fieldName, String replaceQuoteString) {
        if (fieldName == null || fieldName.isEmpty()) {
            return String.format("%c%c", Character.valueOf('\"'), Character.valueOf('\"'));
        }
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        parser.setEscapeChar('\\');
        List<String> tokens = parser.tokenize(fieldName);
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            if (token.length() > 1) {
                char begin = token.charAt(0);
                char end = token.charAt(token.length() - 1);
                if ((begin == '\'' || begin == '\"') && begin == end) {
                    token = token.substring(1, token.length() - 1);
                }
            }
            builder.append('\"').append(token.replace(String.valueOf('\"'), replaceQuoteString)).append('\"').append('.');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String concatFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null || fieldNamesArray.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String fieldName : fieldNamesArray) {
            builder.append(fieldName).append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] quoteFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null) {
            return new String[0];
        }
        String[] newFieldNamesArray = new String[fieldNamesArray.length];
        for (int i = 0; i < newFieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i].trim();
            newFieldNamesArray[i] = CommonDBSchemaUtils.quoteFieldName(fieldName);
        }
        return newFieldNamesArray;
    }

    public static int[] lookupMappingFromTableDescText(String tableDescText, String[] fieldNames) throws ConnectorException {
        if (tableDescText == null || tableDescText.length() <= 0) {
            throw new ConnectorException(14012);
        }
        if (fieldNames == null || fieldNames.length <= 0) {
            throw new ConnectorException(14004);
        }
        TeradataTableDesc schemaDesc = CommonDBSchemaUtils.tableDescFromText(tableDescText);
        Map<String, Integer> schemaColumnNames = schemaDesc.getColumnNameLowerCaseMap();
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setTrimSpaces(true);
        int fieldCount = fieldNames.length;
        parser.setDelimChar('.');
        int[] mappings = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = fieldNames[i].toLowerCase();
            Integer columnPosition = schemaColumnNames.get(fieldName);
            if (columnPosition == null) {
                throw new ConnectorException(14005);
            }
            mappings[i] = columnPosition;
        }
        return mappings;
    }

    public static String tableDescToJson(TeradataTableDesc tableDesc) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"database\":\"").append(tableDesc.getDatabaseName()).append("\"");
        sb.append(",\"table\":\"").append(tableDesc.getName()).append("\"");
        sb.append(",\"columns\":[");
        TeradataColumnDesc[] columns = tableDesc.getColumns();
        int columnCount = columns.length;
        for (int i = 0; i < columnCount; ++i) {
            try {
                ObjectMapper om = new ObjectMapper();
                StringWriter writer = new StringWriter();
                om.writeValue((Writer)writer, (Object)columns[i].getName());
                sb.append("{\"name\":").append(writer.toString());
            }
            catch (Exception e) {
                sb.append("{\"name\":\"").append(columns[i].getName()).append("\"");
            }
            sb.append(",\"type\":").append(columns[i].getType());
            sb.append(",\"typename\":\"").append(columns[i].getTypeName()).append("\"");
            sb.append(",\"nullable\":").append(columns[i].isNullable() ? 1 : 0);
            sb.append(",\"format\":\"").append(columns[i].getFormat()).append("\"");
            sb.append(",\"length\":").append(columns[i].getLength());
            sb.append(",\"chartype\":").append(columns[i].getCharType());
            sb.append(",\"casesensitive\":").append(columns[i].isCaseSensitive() ? 1 : 0);
            sb.append(",\"scale\":").append(columns[i].getScale());
            sb.append(",\"precision\":").append(columns[i].getPrecision());
            sb.append("},");
        }
        sb.setCharAt(sb.length() - 1, ']');
        sb.append("}}");
        return sb.toString();
    }

    public static TeradataTableDesc tableDescFromText(String tableDescText) {
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map tableMap = (Map)objectMapper.readValue(tableDescText, Map.class);
            tableDesc.setDatabaseName((String)tableMap.get("database"));
            tableDesc.setName((String)tableMap.get("table"));
            ArrayList columnList = (ArrayList)tableMap.get(LIST_COLUMNS);
            for (int i = 0; i < columnList.size(); ++i) {
                TeradataColumnDesc columnDesc = new TeradataColumnDesc();
                Map columnMap = (Map)columnList.get(i);
                columnDesc.setName((String)columnMap.get("name"));
                columnDesc.setType((Integer)columnMap.get("type"));
                columnDesc.setTypeName((String)columnMap.get("typename"));
                columnDesc.setFormat((String)columnMap.get("format"));
                columnDesc.setNullable((Integer)columnMap.get("nullable") > 0);
                Object lenObject = columnMap.get("length");
                columnDesc.setCharType((Integer)columnMap.get("chartype"));
                columnDesc.setCaseSensitive((Integer)columnMap.get("casesensitive") > 0);
                if (lenObject instanceof Integer) {
                    columnDesc.setLength(((Integer)lenObject).intValue());
                } else if (lenObject instanceof Long) {
                    columnDesc.setLength((Long)lenObject);
                }
                columnDesc.setScale((Integer)columnMap.get("scale"));
                columnDesc.setPrecision((Integer)columnMap.get("precision"));
                tableDesc.addColumn(columnDesc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableDesc;
    }

    public static int[] lookupTypesFromTableDescText(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        if (tableDescText == null || tableDescText.length() <= 0) {
            throw new ConnectorException(14012);
        }
        TeradataTableDesc tableDesc = CommonDBSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int[] mappings = null;
        int[] fieldDataTypes = null;
        int realFieldCount = 0;
        mappings = CommonDBSchemaUtils.lookupMappingFromTableDescText(tableDescText, fieldNamesArray);
        realFieldCount = mappings.length;
        fieldDataTypes = realFieldCount > 0 ? new int[realFieldCount] : null;
        for (int i = 0; i < realFieldCount; ++i) {
            fieldDataTypes[i] = columnDescs[mappings[i]].getType();
        }
        return fieldDataTypes;
    }

    public static int[] lookupFieldsSQLDataScales(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        TeradataTableDesc tableDesc = CommonDBSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int[] mappings = null;
        int[] fieldDataScales = null;
        int realFieldCount = 0;
        mappings = CommonDBSchemaUtils.lookupMappingFromTableDescText(tableDescText, fieldNamesArray);
        realFieldCount = mappings.length;
        fieldDataScales = realFieldCount > 0 ? new int[realFieldCount] : null;
        for (int i = 0; i < realFieldCount; ++i) {
            fieldDataScales[i] = columnDescs[mappings[i]].getScale();
        }
        return fieldDataScales;
    }

    public static String[] unquoteFieldNamesArray(String[] fieldNamesArray) {
        if (fieldNamesArray == null) {
            return new String[0];
        }
        String[] newFieldNamesArray = new String[fieldNamesArray.length];
        for (int i = 0; i < newFieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i].trim();
            newFieldNamesArray[i] = CommonDBSchemaUtils.unquoteFieldName(fieldName);
        }
        return newFieldNamesArray;
    }

    public static String unquoteFieldName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return "";
        }
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar('.');
        parser.setEscapeChar('\\');
        List<String> tokens = parser.tokenize(fieldName);
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            if (token.length() > 1) {
                char begin = token.charAt(0);
                char end = token.charAt(token.length() - 1);
                if ((begin == '\'' || begin == '\"') && begin == end) {
                    token = token.substring(1, token.length() - 1);
                }
            }
            token = token.replace(REPLACE_DOUBLE_QUOTE, String.valueOf('\"'));
            builder.append(token).append('.');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String quoteFieldNameForSql(String fieldName) {
        return CommonDBSchemaUtils.quoteFieldName(fieldName, REPLACE_DOUBLE_QUOTE_SQL);
    }

    public static int tranformTeradataDataType(int dataType) {
        if (dataType == 3 || dataType == 2) {
            return 3;
        }
        if (dataType == 8 || dataType == 6 || dataType == 8) {
            return 8;
        }
        if (dataType == 5 || dataType == 4 || dataType == -6) {
            return 4;
        }
        return dataType;
    }

    public static String getSelectSQL(String tableName, String[] columns) {
        StringBuilder colExpBuilder = new StringBuilder();
        if (columns != null && columns.length != 0) {
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    colExpBuilder.append(", ");
                }
                colExpBuilder.append(columns[i]);
            }
        } else {
            colExpBuilder.append('*');
        }
        return String.format(SQL_SELECT_FROM_SOURCE_WHERE, colExpBuilder.toString(), tableName, "");
    }

    protected static TeradataColumnDesc[] getColumnDescs(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        TeradataColumnDesc[] columns = new TeradataColumnDesc[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            TeradataColumnDesc column = new TeradataColumnDesc();
            column.setName(metadata.getColumnName(i));
            column.setType(metadata.getColumnType(i));
            column.setTypeName(metadata.getColumnTypeName(i));
            column.setClassName(metadata.getColumnClassName(i));
            column.setNullable(metadata.isNullable(i) > 0);
            column.setLength(metadata.getColumnDisplaySize(i));
            column.setCaseSensitive(metadata.isCaseSensitive(i));
            column.setPrecision(metadata.getPrecision(i));
            column.setScale(metadata.getScale(i));
            columns[i - 1] = column;
        }
        return columns;
    }

    public static TeradataColumnDesc[] getColumnDescsForSQL(String sql, Connection connection) throws SQLException {
        if (connection != null) {
            PreparedStatement stmt = connection.prepareStatement(sql);
            ResultSetMetaData metadata = stmt.getMetaData();
            TeradataColumnDesc[] desc = CommonDBSchemaUtils.getColumnDescs(metadata);
            stmt.close();
            return desc;
        }
        return null;
    }

    public static TeradataColumnDesc[] getColumnDesc(String tableName, String[] fieldNames, Connection connection) throws SQLException {
        return CommonDBSchemaUtils.getColumnDescsForSQL(CommonDBSchemaUtils.getSelectSQL(tableName, fieldNames), connection);
    }
}

