/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.utils;

import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import org.apache.hadoop.conf.Configuration;

public class CommonDBConfiguration {
    private static int VALUE_BATCH_SIZE = 1000;
    public static final String DB_INPUT_FIELD_NAMES_ARRAY = "db.input.field.name.array";
    public static final String DB_INPUT_BATCH_SIZE = "db.input.batch.size";
    public static final String DB_INPUT_TABLE_DESC = "db.input.table.desc";
    public static final String DB_INPUT_SPLIT_SQL = "db.input.split.sql";
    public static final String DB_OUTPUT_TABLE_DESC = "db.output.table.desc";
    public static final String DB_OUTPUT_FIELD_NAMES = "db.output.field.names";
    public static final String DB_OUTPUT_BATCH_SIZE = "db.output.batch.size";

    public static String[] getInputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(DB_INPUT_FIELD_NAMES_ARRAY, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setInputFieldNamesArray(Configuration configuration, String[] sourceFieldNamesArray) {
        sourceFieldNamesArray = CommonDBSchemaUtils.unquoteFieldNamesArray(sourceFieldNamesArray);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(sourceFieldNamesArray);
        configuration.set(DB_INPUT_FIELD_NAMES_ARRAY, fieldNamesJson);
    }

    public static void setInputBatchSize(Configuration configuration, int batchSize) {
        configuration.setInt(DB_INPUT_BATCH_SIZE, batchSize);
    }

    public static int getInputBatchSize(Configuration configuration) {
        return configuration.getInt(DB_INPUT_BATCH_SIZE, VALUE_BATCH_SIZE);
    }

    public static void setInputTableDesc(Configuration configuration, String inputTableDesc) {
        configuration.set(DB_INPUT_TABLE_DESC, inputTableDesc);
    }

    public static String getInputTableDesc(Configuration configuration) {
        return configuration.get(DB_INPUT_TABLE_DESC, "");
    }

    public static void setOutputTableDesc(Configuration configuration, String outputTableDesc) {
        configuration.set(DB_OUTPUT_TABLE_DESC, outputTableDesc);
    }

    public static String getOutputTableDesc(Configuration configuration) {
        return configuration.get(DB_OUTPUT_TABLE_DESC, "");
    }

    public static void setOutputFieldNamesArray(Configuration configuration, String[] targetFieldNamesArray) {
        targetFieldNamesArray = CommonDBSchemaUtils.unquoteFieldNamesArray(targetFieldNamesArray);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(targetFieldNamesArray);
        configuration.set(DB_OUTPUT_FIELD_NAMES, fieldNamesJson);
    }

    public static String[] getOutputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(DB_OUTPUT_FIELD_NAMES, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setOutputBatchSize(Configuration configuration, int batchSize) {
        configuration.setInt(DB_OUTPUT_BATCH_SIZE, batchSize);
    }

    public static int getOutputBatchSize(Configuration configuration) {
        return configuration.getInt(DB_OUTPUT_BATCH_SIZE, VALUE_BATCH_SIZE);
    }

    public static void setInputSplitSql(Configuration configuration, String splitSql) {
        configuration.set(DB_INPUT_SPLIT_SQL, splitSql);
    }

    public static String getInputSplitSql(Configuration configuration) {
        return configuration.get(DB_INPUT_SPLIT_SQL, "");
    }
}

