/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.aster.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.sample.plugin.aster.utils.AsterDBConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.hadoop.conf.Configuration;

public class AsterDBUtils {
    public static Connection openInputConnection(Configuration configuration) throws ConnectorException {
        String jdbcClassName = AsterDBConfiguration.getInputJdbcDriverClass(configuration);
        String jdbcUrl = AsterDBConfiguration.getInputJdbcUrl(configuration);
        String jdbcUserName = AsterDBConfiguration.getInputJdbcUserName(configuration);
        String jdbcPassword = AsterDBConfiguration.getInputJdbcPassword(configuration);
        try {
            Class.forName(jdbcClassName);
            return DriverManager.getConnection(jdbcUrl, jdbcUserName, jdbcPassword);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static Connection openOutputConnection(Configuration configuration) throws ConnectorException {
        String jdbcClassName = AsterDBConfiguration.getOutputJdbcDriverClass(configuration);
        String jdbcUrl = AsterDBConfiguration.getOutputJdbcUrl(configuration);
        String jdbcUserName = AsterDBConfiguration.getOutputJdbcUserName(configuration);
        String jdbcPassword = AsterDBConfiguration.getOutputJdbcPassword(configuration);
        try {
            Class.forName(jdbcClassName);
            return DriverManager.getConnection(jdbcUrl, jdbcUserName, jdbcPassword);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }
}

