/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.aster.processor;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.sample.plugin.aster.utils.AsterDBConfiguration;
import com.teradata.connector.sample.plugin.aster.utils.AsterDBUtils;
import com.teradata.connector.sample.plugin.processor.CommonDBOutputProcessor;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import java.sql.Connection;
import org.apache.hadoop.conf.Configuration;

public class AsterBatchInsertProcessor
extends CommonDBOutputProcessor {
    @Override
    public String getTableName(Configuration configuration) throws ConnectorException {
        Connection connection = null;
        try {
            connection = AsterDBUtils.openOutputConnection(configuration);
            String databaseName = AsterDBConfiguration.getAsterOutputDatabase(configuration);
            String schemaName = AsterDBConfiguration.getAsterOutputSchema(configuration);
            String tableName = AsterDBConfiguration.getAsterOutputTable(configuration);
            String string = tableName = CommonDBUtils.getQuotedEscapedName(databaseName, schemaName, tableName);
            return string;
        }
        catch (ConnectorException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            CommonDBUtils.CloseConnection(connection);
        }
    }

    @Override
    public Connection getConnection(Configuration conf) throws ConnectorException {
        return AsterDBUtils.openOutputConnection(conf);
    }
}

