/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public abstract class CommonDBOutputFormat<K, V>
extends OutputFormat<K, DBWritable> {
    private static Log logger = LogFactory.getLog(CommonDBOutputFormat.class);

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new FileOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
    }

    public RecordWriter<K, DBWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Connection connection;
        PreparedStatement prepareStatement = null;
        int batchSize = 0;
        Configuration configuration = context.getConfiguration();
        String insertStmt = "";
        try {
            if (context.getTaskAttemptID().getId() > 0) {
                throw new ConnectorException(22010);
            }
            connection = this.getConnection(configuration);
            connection.setAutoCommit(false);
            insertStmt = this.getInsertPreparedStatmentSQL(configuration);
            logger.info((Object)insertStmt);
            batchSize = CommonDBConfiguration.getOutputBatchSize(configuration);
            prepareStatement = connection.prepareStatement(insertStmt);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ConnectorException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return new TeradataRecordWriter(connection, prepareStatement, batchSize);
    }

    public abstract String getInsertPreparedStatmentSQL(Configuration var1);

    public abstract Connection getConnection(Configuration var1) throws ConnectorException;

    public class TeradataRecordWriter<K, V>
    extends RecordWriter<K, DBWritable> {
        protected Connection connection = null;
        protected PreparedStatement preparedStatement = null;
        protected int batchSize = 0;
        protected int batchCount = 0;
        protected long end_timestamp = 0L;
        protected long start_timestamp = System.currentTimeMillis();

        public TeradataRecordWriter() {
            logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        }

        public TeradataRecordWriter(Connection connection, PreparedStatement preparedStatement, int batchSize) {
            this();
            this.connection = connection;
            this.preparedStatement = preparedStatement;
            this.batchSize = batchSize;
        }

        public void write(K key, DBWritable value) throws IOException {
            try {
                value.write(this.preparedStatement);
                this.preparedStatement.addBatch();
                ++this.batchCount;
                if (this.batchCount >= this.batchSize) {
                    this.preparedStatement.executeBatch();
                    this.batchCount = 0;
                }
            }
            catch (SQLException e) {
                ConnectorException start = new ConnectorException(e.getMessage(), e);
                while (e != null) {
                    StackTraceElement[] elements = e.getStackTrace();
                    int n = elements.length;
                    for (int i = 0; i < n; ++i) {
                        logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                    }
                    e = e.getNextException();
                }
                CommonDBUtils.CloseConnection(this.connection);
                throw start;
            }
        }

        public void close(TaskAttemptContext context) throws IOException {
            try {
                if (this.batchCount > 0) {
                    this.preparedStatement.executeBatch();
                }
                this.connection.commit();
                this.end_timestamp = System.currentTimeMillis();
                logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
                logger.info((Object)("the total elapsed time of recordwriter " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
            }
            catch (SQLException e) {
                ConnectorException start = new ConnectorException(e.getMessage(), e);
                while (e != null) {
                    StackTraceElement[] elements = e.getStackTrace();
                    int n = elements.length;
                    for (int i = 0; i < n; ++i) {
                        logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                    }
                    e = e.getNextException();
                }
                throw start;
            }
            finally {
                CommonDBUtils.CloseConnection(this.connection);
            }
        }
    }
}

