/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.sample.CommonDBObjectArrayWritable;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBSplitUtils;
import com.teradata.connector.sample.plugin.utils.CommonDBUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class CommonDBInputFormat
extends InputFormat<LongWritable, ConnectorRecord> {
    protected static Log logger = LogFactory.getLog(CommonDBInputFormat.class);
    protected static final int SPLIT_LOCATIONS_MAX = 6;

    public abstract String getSplitRangeSQL(Configuration var1);

    public abstract String getMinMaxSQL(Configuration var1);

    public abstract String getOneAmpSQL(Configuration var1);

    public abstract void validataConfiguration(Configuration var1) throws ConnectorException;

    public abstract Connection getConnection(Configuration var1) throws ConnectorException;

    public abstract String getSplitColumn(Configuration var1);

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        this.validataConfiguration(configuration);
        String[] locations = HadoopConfigurationUtils.getAllActiveHosts(context);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        String splitSql = this.getSplitRangeSQL(configuration);
        CommonDBConfiguration.setInputSplitSql(configuration, splitSql);
        ResultSet resultSetMinMaxValues = null;
        Statement statement = null;
        Connection sqlConnection = null;
        if (numMappers == 1) {
            CommonDBInputSplit split = new CommonDBInputSplit(this.getOneAmpSQL(configuration));
            split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
            splits.add(split);
        } else {
            try {
                sqlConnection = this.getConnection(configuration);
                if (sqlConnection != null) {
                    String sql = this.getMinMaxSQL(configuration);
                    logger.info((Object)sql);
                    statement = sqlConnection.createStatement();
                    resultSetMinMaxValues = statement.executeQuery(sql);
                }
                if (resultSetMinMaxValues == null || !resultSetMinMaxValues.next()) {
                    throw new ConnectorException(23003);
                }
                if (resultSetMinMaxValues.getString(1) == null || resultSetMinMaxValues.getString(2) == null) {
                    throw new ConnectorException(23004);
                }
            }
            catch (SQLException e) {
                CommonDBUtils.CloseConnection(sqlConnection);
                throw new ConnectorException(e.getMessage(), e);
            }
            String splitColumnName = this.getSplitColumn(configuration);
            List<CommonDBInputSplit> columnSplits = CommonDBSplitUtils.getSplitsByColumnType(configuration, splitColumnName, resultSetMinMaxValues);
            for (int i = 0; i < columnSplits.size(); ++i) {
                CommonDBInputSplit split = columnSplits.get(i);
                split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                splits.add(split);
            }
        }
        try {
            if (resultSetMinMaxValues != null) {
                resultSetMinMaxValues.close();
                resultSetMinMaxValues = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            CommonDBUtils.CloseConnection(sqlConnection);
        }
        return splits;
    }

    public RecordReader<LongWritable, ConnectorRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new CommonDBRecordReader(((CommonDBInputSplit)split).getSplitSql());
    }

    public class CommonDBRecordReader
    extends RecordReader<LongWritable, ConnectorRecord> {
        private Log logger = LogFactory.getLog(CommonDBRecordReader.class);
        private Connection connection = null;
        private PreparedStatement preparedStatement = null;
        private long resultCount = 0L;
        private CommonDBObjectArrayWritable curValue = null;
        private ResultSet resultset = null;
        private String splitSQL;
        private long end_timestamp = 0L;
        private long start_timestamp = 0L;
        private String[] sourceFields = null;
        private int[] sourceFieldMapping = null;

        public CommonDBRecordReader(String splitSQL) {
            this.splitSQL = splitSQL;
            this.start_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration configuration = context.getConfiguration();
            try {
                if (this.connection == null) {
                    this.connection = CommonDBInputFormat.this.getConnection(configuration);
                }
                if (this.connection != null) {
                    this.logger.info((Object)("split sql is: " + this.splitSQL));
                    this.preparedStatement = this.connection.prepareStatement(this.splitSQL);
                    this.preparedStatement.setFetchSize(CommonDBConfiguration.getInputBatchSize(configuration));
                }
                String sourceTableDescText = CommonDBConfiguration.getInputTableDesc(configuration);
                this.sourceFields = CommonDBConfiguration.getInputFieldNamesArray(configuration);
                this.sourceFieldMapping = CommonDBSchemaUtils.lookupMappingFromTableDescText(sourceTableDescText, this.sourceFields);
                this.curValue = new CommonDBObjectArrayWritable(this.sourceFieldMapping.length);
            }
            catch (SQLException e) {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
                throw new ConnectorException(e.getMessage(), e);
            }
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return new LongWritable(this.resultCount);
        }

        public ConnectorRecord getCurrentValue() throws IOException, InterruptedException {
            return this.curValue;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            try {
                if (this.resultset == null) {
                    this.resultset = this.preparedStatement.executeQuery();
                }
                if (!this.resultset.next()) {
                    return false;
                }
                this.curValue.readFields(this.resultset);
                ++this.resultCount;
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            return true;
        }

        public void close() throws IOException {
            try {
                if (this.preparedStatement != null) {
                    this.preparedStatement.close();
                    this.preparedStatement = null;
                }
                this.end_timestamp = System.currentTimeMillis();
                this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
                this.logger.info((Object)("the total elapsed time of recordreader " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            finally {
                CommonDBUtils.CloseConnection(this.connection);
            }
        }
    }

    public static class CommonDBInputSplit
    extends InputSplit
    implements Writable {
        private String[] locations = null;
        private String splitSql = "";

        public CommonDBInputSplit() {
        }

        public CommonDBInputSplit(String sql) {
            this.splitSql = sql;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.locations == null ? new String[]{} : this.locations;
        }

        public long getLength() throws IOException, InterruptedException {
            return 1L;
        }

        public void readFields(DataInput input) throws IOException {
            this.splitSql = Text.readString((DataInput)input);
        }

        public void write(DataOutput output) throws IOException {
            Text.writeString((DataOutput)output, (String)this.splitSql);
        }

        public String getSplitSql() {
            return this.splitSql;
        }

        public void setSplitSql(String sql) {
            this.splitSql = sql;
        }
    }
}

