/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.idatastream.IDataStreamByteArray;
import com.teradata.connector.idatastream.schema.IDataStreamColumnDesc;
import com.teradata.connector.idatastream.utils.IDataStreamPlugInConfiguration;
import com.teradata.connector.idatastream.utils.IDataStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class IDataStreamSerDe
implements ConnectorSerDe {
    private Log logger = LogFactory.getLog(IDataStreamSerDe.class);
    private static byte[] nullbytes = null;
    private boolean leserver = true;
    private int inputFieldCount = 0;
    private int outputFieldCount = 0;
    private int numIndBytes = 0;
    private ConnectorRecord record = null;
    private boolean[] nullCols = null;
    private byte[] indBytes = null;
    private IDataStreamColumnDesc[] colDescs = null;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            String[] inputFieldTypes = IDataStreamPlugInConfiguration.getInputFieldTypesArray(configuration);
            this.inputFieldCount = inputFieldTypes.length;
            this.colDescs = new IDataStreamColumnDesc[this.inputFieldCount];
            for (int i = 0; i < this.inputFieldCount; ++i) {
                this.colDescs[i] = IDataStreamUtils.getIDataStreamColumnDescFromString(inputFieldTypes[i]);
            }
            this.record = new ConnectorRecord(this.inputFieldCount);
            this.numIndBytes = (int)Math.ceil((double)this.inputFieldCount / 8.0);
            this.nullCols = new boolean[this.numIndBytes * 8 + 1];
            try {
                int leserverint = Integer.parseInt(IDataStreamPlugInConfiguration.getInputLittleEndianServer(configuration));
                this.leserver = leserverint == 1;
            }
            catch (Exception e) {
                String leserverstr = IDataStreamPlugInConfiguration.getInputLittleEndianServer(configuration);
                this.leserver = leserverstr.toLowerCase().equals("yes");
            }
        } else {
            String[] outputFieldTypes = IDataStreamPlugInConfiguration.getOutputFieldTypesArray(configuration);
            this.outputFieldCount = outputFieldTypes.length;
            this.colDescs = new IDataStreamColumnDesc[this.outputFieldCount];
            for (int i = 0; i < this.outputFieldCount; ++i) {
                this.colDescs[i] = IDataStreamUtils.getIDataStreamColumnDescFromString(outputFieldTypes[i]);
            }
            this.numIndBytes = (int)Math.ceil((double)this.outputFieldCount / 8.0);
            this.indBytes = new byte[this.numIndBytes];
            try {
                int leserverint = Integer.parseInt(IDataStreamPlugInConfiguration.getOutputLittleEndianServer(configuration));
                this.leserver = leserverint == 1;
            }
            catch (Exception e) {
                String leserverstr = IDataStreamPlugInConfiguration.getOutputLittleEndianServer(configuration);
                this.leserver = leserverstr.toLowerCase().equals("yes");
            }
        }
    }

    @Override
    public Writable serialize(ConnectorRecord connectorRecord) throws ConnectorException {
        int i;
        Long totallen = 0L;
        Long len = 0L;
        Integer bytelen = 0;
        for (i = 0; i < this.numIndBytes; ++i) {
            this.indBytes[i] = 0;
            for (int j = 0; j < 8; ++j) {
                if (8 * i + j >= this.outputFieldCount || connectorRecord.get(8 * i + j) != null) continue;
                int n = i;
                this.indBytes[n] = (byte)(this.indBytes[n] | 1 << 7 - j);
            }
        }
        totallen = 0L;
        totallen = totallen + (long)this.numIndBytes;
        for (i = 0; i < this.outputFieldCount; ++i) {
            bytelen = IDataStreamSerDe.getByteLength(this.colDescs[i]);
            if (bytelen == 0) {
                if (connectorRecord.get(i) == null) {
                    switch (this.colDescs[i].getJDBCtype()) {
                        case 2004: 
                        case 2005: {
                            totallen = totallen + 8L;
                            break;
                        }
                        default: {
                            totallen = totallen + 2L;
                            break;
                        }
                    }
                    continue;
                }
                switch (this.colDescs[i].getJDBCtype()) {
                    case 2004: {
                        totallen = totallen + (long)(8 + ((byte[])connectorRecord.get(i)).length);
                        break;
                    }
                    case 2005: {
                        totallen = totallen + (long)(8 + ((String)connectorRecord.get(i)).getBytes().length);
                        break;
                    }
                    case -3: {
                        totallen = totallen + (long)(2 + ((byte[])connectorRecord.get(i)).length);
                        break;
                    }
                    default: {
                        totallen = totallen + (long)(2 + ((String)connectorRecord.get(i)).getBytes().length);
                        break;
                    }
                }
                continue;
            }
            totallen = totallen + (long)bytelen.intValue();
        }
        ByteBuffer lbb = ByteBuffer.allocate(2 + totallen.intValue() + 1);
        if (this.leserver) {
            lbb.order(ByteOrder.LITTLE_ENDIAN);
        }
        lbb.putShort(totallen.shortValue());
        lbb.put(this.indBytes);
        for (i = 0; i < this.outputFieldCount; ++i) {
            if (IDataStreamSerDe.getByteLength(this.colDescs[i]) == 0) {
                if (connectorRecord.get(i) == null) {
                    len = 0L;
                } else {
                    switch (this.colDescs[i].getJDBCtype()) {
                        case 2004: {
                            len = ((byte[])connectorRecord.get(i)).length;
                            break;
                        }
                        case 2005: {
                            len = ((String)connectorRecord.get(i)).getBytes().length;
                            break;
                        }
                        case -3: {
                            len = ((byte[])connectorRecord.get(i)).length;
                            break;
                        }
                        default: {
                            len = ((String)connectorRecord.get(i)).getBytes().length;
                        }
                    }
                }
                if (this.colDescs[i].getJDBCtype() == 2005 || this.colDescs[i].getJDBCtype() == 2004) {
                    lbb.putLong(len);
                } else {
                    lbb.putShort(len.shortValue());
                }
            }
            IDataStreamSerDe.getBytesFromObject(lbb, this.colDescs[i], connectorRecord.get(i), this.leserver);
        }
        lbb.put((byte)10);
        IDataStreamByteArray barray = new IDataStreamByteArray(lbb.array().length);
        barray.setByteArray(lbb.array(), 0, lbb.array().length);
        return barray;
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        IDataStreamByteArray barray = (IDataStreamByteArray)writable;
        byte[] buffer = barray.getByteArray();
        int rowStart = 0;
        String nulColS = "";
        for (int i = 0; i < this.numIndBytes; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((buffer[rowStart + i] >> j & 1) == 1) {
                    this.nullCols[8 * i + (7 - j)] = true;
                    nulColS = nulColS + (8 * i + (7 - j)) + ",";
                    continue;
                }
                this.nullCols[8 * i + (7 - j)] = false;
            }
        }
        this.logger.debug((Object)("Cols " + nulColS + " are null"));
        int columnStart = rowStart += this.numIndBytes;
        int columnEnd = rowStart;
        for (int columnIndex = 0; columnIndex < this.inputFieldCount; ++columnIndex) {
            columnStart = columnEnd;
            int bytelen = IDataStreamSerDe.getByteLength(this.colDescs[columnIndex]);
            if (bytelen == 0) {
                if (this.colDescs[columnIndex].getJDBCtype() == 2004 || this.colDescs[columnIndex].getJDBCtype() == 2005) {
                    bytelen = this.leserver ? (int)ByteBuffer.wrap(buffer, columnStart, 8).order(ByteOrder.LITTLE_ENDIAN).getLong() : (int)ByteBuffer.wrap(buffer, columnStart, 8).getLong();
                    columnStart += 8;
                } else {
                    bytelen = this.leserver ? (int)ByteBuffer.wrap(buffer, columnStart, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() : (int)ByteBuffer.wrap(buffer, columnStart, 2).getShort();
                    columnStart += 2;
                }
            }
            this.logger.debug((Object)("Bytelen for col " + columnIndex + " is " + bytelen));
            columnEnd = bytelen == 0 ? columnStart : columnStart + bytelen;
            if (bytelen == 0 || this.nullCols[columnIndex]) {
                this.record.set(columnIndex, null);
                continue;
            }
            this.logger.debug((Object)("Deser from offset " + columnStart + " to " + columnEnd));
            this.record.set(columnIndex, IDataStreamSerDe.getObjectFromBytes(this.colDescs[columnIndex], Arrays.copyOfRange(buffer, columnStart, columnEnd), this.leserver));
        }
        return this.record;
    }

    public static Integer getByteLength(IDataStreamColumnDesc desc) {
        switch (desc.getJDBCtype()) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 4;
            }
            case 2: 
            case 3: {
                if (1 <= desc.getPrecision() && desc.getPrecision() <= 2) {
                    return 1;
                }
                if (3 <= desc.getPrecision() && desc.getPrecision() <= 4) {
                    return 2;
                }
                if (5 <= desc.getPrecision() && desc.getPrecision() <= 9) {
                    return 4;
                }
                if (10 <= desc.getPrecision() && desc.getPrecision() <= 18) {
                    return 8;
                }
                if (19 <= desc.getPrecision() && desc.getPrecision() <= 38) {
                    return 16;
                }
            }
            case -2: 
            case 1: {
                return desc.getPrecision();
            }
            case -16: 
            case -3: 
            case 12: 
            case 2004: 
            case 2005: {
                return 0;
            }
            case 91: {
                return 10;
            }
            case 92: {
                if (desc.getPrecision() != 0) {
                    return 9 + desc.getPrecision();
                }
                return 8;
            }
            case 93: {
                if (desc.getPrecision() != 0) {
                    return 20 + desc.getPrecision();
                }
                return 19;
            }
        }
        return -1;
    }

    public static Object getObjectFromBytes(IDataStreamColumnDesc desc, byte[] ba, boolean leserver) throws ConnectorException {
        short svalue = 0;
        int ivalue = 0;
        long lvalue = 0L;
        float fvalue = 0.0f;
        double dvalue = 0.0;
        try {
            switch (desc.getJDBCtype()) {
                case -6: {
                    return new Byte(ba[0]);
                }
                case 5: {
                    svalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getShort() : ByteBuffer.wrap(ba).getShort();
                    return new Short(svalue);
                }
                case 4: {
                    ivalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getInt() : ByteBuffer.wrap(ba).getInt();
                    return new Integer(ivalue);
                }
                case -5: {
                    lvalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getLong() : ByteBuffer.wrap(ba).getLong();
                    return new Long(lvalue);
                }
                case 8: {
                    dvalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getDouble() : ByteBuffer.wrap(ba).getDouble();
                    return new Double(dvalue);
                }
                case 6: {
                    dvalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getDouble() : ByteBuffer.wrap(ba).getDouble();
                    return new Double(dvalue);
                }
                case 7: {
                    fvalue = leserver ? ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getFloat() : ByteBuffer.wrap(ba).getFloat();
                    return new Float(fvalue);
                }
                case 2: 
                case 3: {
                    if (leserver) {
                        ArrayUtils.reverse((byte[])ba);
                    }
                    return new BigDecimal(new BigInteger(ba), desc.getScale());
                }
                case -16: 
                case 1: 
                case 12: {
                    return new String(ba);
                }
                case -3: 
                case -2: {
                    return ba;
                }
                case 2004: {
                    return new IDataStreamSerialBlob(ba);
                }
                case 2005: {
                    return new IDataStreamSerialClob(new String(ba).toCharArray());
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorException(60007);
        }
        return null;
    }

    public static void getBytesFromObject(ByteBuffer bb, IDataStreamColumnDesc desc, Object o, boolean leserver) {
        if (nullbytes == null) {
            nullbytes = new byte[16];
        }
        switch (desc.getJDBCtype()) {
            case -6: {
                if (o == null) {
                    bb.put(nullbytes, 0, 1);
                    break;
                }
                bb.put((Byte)o);
                break;
            }
            case 5: {
                if (o == null) {
                    bb.put(nullbytes, 0, 2);
                    break;
                }
                bb.putShort((Short)o);
                break;
            }
            case 4: {
                if (o == null) {
                    bb.put(nullbytes, 0, 4);
                    break;
                }
                bb.putInt((Integer)o);
                break;
            }
            case -5: {
                if (o == null) {
                    bb.put(nullbytes, 0, 8);
                    break;
                }
                bb.putLong((Long)o);
                break;
            }
            case 8: {
                if (o == null) {
                    bb.put(nullbytes, 0, 8);
                    break;
                }
                bb.putDouble((Double)o);
                break;
            }
            case 6: {
                if (o == null) {
                    bb.put(nullbytes, 0, 8);
                    break;
                }
                bb.putDouble((Double)o);
                break;
            }
            case 7: {
                if (o == null) {
                    bb.put(nullbytes, 0, 4);
                    break;
                }
                bb.putFloat(((Float)o).floatValue());
                break;
            }
            case 2: 
            case 3: {
                byte[] dba;
                int bytelen = IDataStreamSerDe.getByteLength(desc);
                if (o == null) {
                    bb.put(new byte[bytelen]);
                    break;
                }
                BigDecimal bd = (BigDecimal)o;
                if (desc.getScale() != 0) {
                    bd = bd.movePointRight(desc.getScale());
                }
                if ((dba = bd.toBigInteger().toByteArray()).length != bytelen) {
                    byte[] dba2 = new byte[bytelen];
                    if ((dba[0] & 0x80) == 128) {
                        Arrays.fill(dba2, (byte)-1);
                    }
                    System.arraycopy(dba, 0, dba2, dba2.length - dba.length, dba.length);
                    dba = dba2;
                }
                if (leserver) {
                    ArrayUtils.reverse((byte[])dba);
                }
                bb.put(dba);
                break;
            }
            case 1: {
                if (o == null) {
                    bb.put(new byte[desc.getPrecision().intValue()]);
                    break;
                }
                bb.put(((String)o).getBytes());
                break;
            }
            case -16: 
            case 12: 
            case 2005: {
                if (o == null) break;
                bb.put(((String)o).getBytes());
                break;
            }
            case -2: {
                byte[] ba = new byte[desc.getPrecision().intValue()];
                if (o != null) {
                    System.arraycopy((byte[])o, 0, ba, 0, desc.getPrecision());
                }
                bb.put(ba);
                break;
            }
            case -3: 
            case 2004: {
                if (o == null) break;
                bb.put((byte[])o);
            }
        }
    }

    private static class IDataStreamSerialBlob
    extends SerialBlob {
        private static final long serialVersionUID = 1L;
        private byte[] data;

        public IDataStreamSerialBlob(byte[] bytes) throws SerialException, SQLException {
            super(bytes);
            this.data = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.data, 0, bytes.length);
        }

        @Override
        public InputStream getBinaryStream() throws SerialException {
            return new ByteArrayInputStream(this.data);
        }
    }

    private static class IDataStreamSerialClob
    extends SerialClob {
        private static final long serialVersionUID = 1L;
        private String data;

        public IDataStreamSerialClob(char[] bytes) throws SerialException, SQLException {
            super(bytes);
            this.data = new String(bytes);
        }

        @Override
        public InputStream getAsciiStream() throws SerialException, SQLException {
            try {
                return new ByteArrayInputStream(this.data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

