/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.common.utils.ConnectorUnicodeCharacterConverter;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hive.HiveORCFileOutputFormat;
import com.teradata.connector.hive.HiveParquetFileOutputFormat;
import com.teradata.connector.hive.HiveRCFileOutputFormat;
import com.teradata.connector.hive.HiveSequenceFileOutputFormat;
import com.teradata.connector.hive.HiveTextFileOutputFormat;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HiveUtils {
    private static Log logger = LogFactory.getLog(HiveUtils.class);
    public static final String LIST_COLUMNS = "columns";
    public static final String DEFAULT_DATABASE = "default";
    public static final String LIST_COLUMN_TYPES = "columns.types";
    public static final Long RANDOMSEED = 999999L;
    protected static final String SUPPORTED_TEXTFILE_INPUTFORMAT = "org.apache.hadoop.mapred.TextInputFormat";
    protected static final String SUPPORTED_TEXTFILE_OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat";
    protected static final String SUPPORTED_SEQUENCEFILE_INPUTFORMAT = "org.apache.hadoop.mapred.SequenceFileInputFormat";
    protected static final String SUPPORTED_SEQUENCEFILE_OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat";
    protected static final String SUPPORTED_RCFILE_INPUTFORMAT = "org.apache.hadoop.hive.ql.io.RCFileInputFormat";
    protected static final String SUPPORTED_RCFILE_OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.RCFileOutputFormat";
    protected static final String SUPPORTED_ORCFILE_INPUTFORMAT = "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat";
    protected static final String SUPPORTED_ORCFILE_OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat";
    protected static final String SUPPORTED_PARQUET_INPUTFORMAT = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
    protected static final String SUPPORTED_PARQUET_OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
    protected static final String SUPPORTED_LAZY_SIMPLE_SERDE = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    protected static final String SUPPORTED_COLUMNAR_SERDE = "org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe";
    protected static final String SUPPORTED_LB_COLUMNAR_SERDE = "org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe";
    protected static final String SUPPORTED_ORC_SERDE = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
    protected static final String SUPPORTED_PARQUET_SERDE = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
    protected static final String SLASH = "/";
    protected static final String COMMA = ",";
    protected static final String EQUALS = "=";
    protected static final String QUOTE = "\"";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final char SPACE_CHAR = ' ';
    protected static final String USAGE_VALUES = "values";
    protected static final String USAGE_REGEX = "regex";
    protected static final String HIVE_FIRST_FILE_NAME = "00000";
    protected static final org.apache.hadoop.io.Text HIVE_DEFAULT_NULL_SEQUENCE = new org.apache.hadoop.io.Text("\\N");
    protected static final byte HIVE_DEFAULT_ESCAPE_CHAR = 92;
    public static final byte[] DefaultSeparators = new byte[]{1, 2, 3};

    public static void loadHiveConf(Configuration configuration, ConnectorConfiguration.direction direction2) throws ConnectorException {
        try {
            String hiveConfFile = direction2 == ConnectorConfiguration.direction.input ? HivePlugInConfiguration.getInputConfigureFile(configuration) : HivePlugInConfiguration.getOutputConfigureFile(configuration);
            if (hiveConfFile.equals("")) {
                return;
            }
            Path hivePath = new Path(hiveConfFile);
            FileSystem fs = hivePath.getFileSystem(configuration);
            logger.info((Object)("Using hive-site.xml: " + fs.makeQualified(hivePath)));
            if (!fs.exists(hivePath)) {
                throw new ConnectorException(30007);
            }
            if (!fs.isFile(hivePath)) {
                throw new ConnectorException(30008);
            }
            BufferedInputStream in = new BufferedInputStream((InputStream)fs.open(hivePath));
            HiveUtils.readConfFromInputStream(in, configuration);
            ((InputStream)in).close();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)ConnectorStringUtils.getExceptionStack(e));
        }
        catch (SAXException e) {
            logger.error((Object)ConnectorStringUtils.getExceptionStack(e));
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private static final void readConfFromInputStream(InputStream in, Configuration configuration) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docbulider = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document confDoc = null;
        Element rootElement = null;
        confDoc = docbulider.parse(in);
        rootElement = confDoc.getDocumentElement();
        if (!"configuration".equals(rootElement.getTagName())) {
            throw new ConnectorException(32010);
        }
        NodeList parameters = rootElement.getChildNodes();
        HashSet<String> finalParams = new HashSet<String>();
        for (int i = 0; i < parameters.getLength(); ++i) {
            Node propNode = parameters.item(i);
            if (!(propNode instanceof Element)) continue;
            Element prop = (Element)propNode;
            if (prop.getTagName().equals("configuration")) {
                throw new ConnectorException(32010);
            }
            if (!prop.getTagName().equals("property")) {
                logger.warn((Object)"expected <property> tag");
            }
            NodeList childNodes = prop.getChildNodes();
            String attr = null;
            String value = null;
            boolean finalParam = false;
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node node = childNodes.item(j);
                if (!(node instanceof Element)) continue;
                Element field = (Element)node;
                if (field.getTagName().equals("name") && field.hasChildNodes()) {
                    attr = ((Text)field.getFirstChild()).getData().trim();
                }
                if (field.getTagName().equals("value") && field.hasChildNodes()) {
                    value = ((Text)field.getFirstChild()).getData();
                }
                if (!field.getTagName().equals("final") || !field.hasChildNodes()) continue;
                finalParam = ((Text)field.getFirstChild()).getData().equals("true");
            }
            if (attr == null || value == null) continue;
            if (!finalParams.contains(attr)) {
                configuration.set(attr, value);
            } else if (!value.equals(configuration.get(attr))) {
                logger.warn((Object)("attempt to override final parameter: " + attr + ":  From " + configuration.get(attr) + " to " + value));
            }
            if (!finalParam) continue;
            finalParams.add(attr);
        }
    }

    public static final String listToString(List<String> list) {
        StringBuilder buff = new StringBuilder();
        for (String item : list) {
            buff.append(item.trim()).append(COMMA);
        }
        int len = buff.length() - 1;
        buff.delete(len, len);
        return buff.toString();
    }

    public static void loadDataintoHiveTable(Configuration configuration, String databaseName, String tableName, HiveConf hiveConf, HiveMetaStoreClient client) throws ConnectorException {
        CliSessionState ss = new CliSessionState(hiveConf);
        logger.info((Object)"load data into hive table");
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        SessionState.start((SessionState)ss);
        Driver driver = new Driver(hiveConf);
        try {
            String outputPath = HivePlugInConfiguration.getOutputPaths(configuration);
            Path output = new Path(outputPath);
            FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)configuration);
            if (fs.isFile(output)) {
                int lastSlashPosition = outputPath.lastIndexOf(SLASH);
                outputPath = outputPath.substring(0, lastSlashPosition + 1);
            } else {
                for (FileStatus stat : fs.listStatus(output)) {
                    Path filePath = stat.getPath();
                    String name = filePath.getName();
                    if (!name.startsWith("_") && !name.startsWith(".") && stat.getLen() != 0L) continue;
                    fs.delete(filePath, true);
                }
            }
            String overwriteString = "";
            if (HivePlugInConfiguration.getOutputOverwrite(configuration)) {
                overwriteString = "overwrite ";
            }
            String cmd = !databaseName.isEmpty() && !databaseName.equalsIgnoreCase(DEFAULT_DATABASE) ? "Load data inpath '" + outputPath + "' " + overwriteString + "into table " + databaseName + "." + tableName : "Load data inpath '" + outputPath + "' " + overwriteString + "into table " + tableName;
            logger.debug((Object)("the hql statement is:" + cmd));
            CommandProcessorResponse code = driver.run(cmd);
            fs.delete(output, true);
            if (code.getResponseCode() != 0) {
                throw new ConnectorException(code.getErrorMessage());
            }
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (CommandNeedRetryException e) {
            throw new ConnectorException(32006);
        }
        finally {
            if (ss != null) {
                ss.close();
                ss = null;
            }
            if (driver != null) {
                driver.close();
                driver = null;
            }
        }
    }

    public static void addPartitionsToHiveTable(Configuration configuration, String databaseName, String tableName, HiveConf hiveConf, HiveMetaStoreClient client) throws ConnectorException {
        CliSessionState ss = new CliSessionState(hiveConf);
        logger.info((Object)"add partition to hive table");
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        SessionState.start((SessionState)ss);
        Driver driver = new Driver(hiveConf);
        String outputPath = HivePlugInConfiguration.getOutputPaths(configuration);
        try {
            if (outputPath.contains(COMMA)) {
                String tempOutputPath = outputPath.split(COMMA)[0];
                int firstEquals = tempOutputPath.indexOf(EQUALS);
                int firstValidateSlash = tempOutputPath.substring(0, firstEquals).lastIndexOf(SLASH);
                outputPath = outputPath.substring(0, firstValidateSlash);
            }
            FileSystem fs = FileSystem.get((URI)new Path(outputPath).toUri(), (Configuration)configuration);
            Path tempPath = new Path(outputPath);
            outputPath = tempPath.makeQualified(fs).toString();
            List<Path> sourcePaths = HadoopConfigurationUtils.getAllFilePaths(configuration, outputPath);
            HashSet<String> partitionValues = new HashSet<String>();
            int pathCount = sourcePaths.size();
            for (int i = 0; i < pathCount; ++i) {
                Path path = sourcePaths.get(i);
                String parentString = path.toString().substring(0, path.toString().lastIndexOf(47));
                partitionValues.add(parentString.substring(outputPath.length() + 1));
            }
            String tableLocation = client.getTable(databaseName, tableName).getSd().getLocation();
            for (String partitionValue : partitionValues) {
                String cmd;
                String sourcePath = outputPath + SLASH + partitionValue;
                String targetPath = tableLocation + SLASH + partitionValue;
                String targetFolder = targetPath.substring(0, targetPath.lastIndexOf(SLASH));
                if (!targetFolder.equals(tableLocation)) {
                    fs.mkdirs(new Path(targetFolder));
                }
                Partition oldPartition = null;
                try {
                    oldPartition = client.getPartition(databaseName, tableName, partitionValue);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                if (HivePlugInConfiguration.getOutputOverwrite(configuration) && oldPartition != null) {
                    client.dropPartition(databaseName, tableName, partitionValue, true);
                    oldPartition = null;
                }
                if (oldPartition != null) {
                    FileStatus[] fileStatus;
                    Path sourcePartitionPath = new Path(sourcePath);
                    for (FileStatus file : fileStatus = fs.listStatus(sourcePartitionPath)) {
                        String newPathString = file.getPath().getName();
                        if (fs.exists(new Path(targetPath, newPathString))) {
                            String newPartitionFileNameString = HiveUtils.getFileNameUnderHiveNamingConvention(targetPath, fs);
                            Boolean result = fs.rename(new Path(sourcePath, newPathString), new Path(targetPath, newPartitionFileNameString));
                            if (result.booleanValue()) continue;
                            logger.warn((Object)("Rename " + sourcePath + SLASH + newPathString + " to " + targetPath + SLASH + newPartitionFileNameString + "failed."));
                            continue;
                        }
                        Boolean result = fs.rename(new Path(sourcePath, newPathString), new Path(targetPath, newPathString));
                        if (result.booleanValue()) continue;
                        logger.warn((Object)("Rename " + sourcePath + SLASH + newPathString + " to " + targetPath + SLASH + newPathString + "failed."));
                    }
                    continue;
                }
                boolean result = fs.rename(new Path(sourcePath), new Path(targetPath));
                if (!result) {
                    logger.warn((Object)("Rename " + sourcePath + " to " + targetPath + "failed."));
                }
                String newPartitionValue = partitionValue.replaceAll(EQUALS, "='");
                newPartitionValue = newPartitionValue.replaceAll(SLASH, "',");
                newPartitionValue = newPartitionValue + "'";
                newPartitionValue = FileUtils.unescapePathName((String)newPartitionValue);
                if (!databaseName.isEmpty() && !databaseName.equalsIgnoreCase(DEFAULT_DATABASE)) {
                    driver.run("USE " + databaseName + "").getResponseCode();
                    cmd = "ALTER TABLE " + tableName + " ADD PARTITION ( " + newPartitionValue + ") location '" + tableLocation + SLASH + partitionValue + "'";
                } else {
                    cmd = "ALTER TABLE " + tableName + " ADD PARTITION ( " + newPartitionValue + ") location '" + tableLocation + SLASH + partitionValue + "'";
                }
                logger.debug((Object)("the hql statement is:" + cmd));
                driver.run(cmd).getResponseCode();
            }
            fs.delete(new Path(outputPath), true);
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (CommandNeedRetryException e) {
            throw new ConnectorException(32006);
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new ConnectorException(32001);
        }
        catch (UnknownTableException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (TException e) {
            throw new ConnectorException(32007);
        }
        finally {
            if (ss != null) {
                ss.close();
                ss = null;
            }
            if (driver != null) {
                driver.close();
                driver = null;
            }
        }
    }

    public static void checkHiveTableProperties(Table table) throws ConnectorException {
        StorageDescriptor sd = table.getSd();
        String inputFormat = sd.getInputFormat();
        String outputFormat = sd.getOutputFormat();
        String serdeLib = sd.getSerdeInfo().getSerializationLib();
        if (!(SUPPORTED_TEXTFILE_INPUTFORMAT.equalsIgnoreCase(inputFormat) || SUPPORTED_SEQUENCEFILE_INPUTFORMAT.equalsIgnoreCase(inputFormat) || SUPPORTED_ORCFILE_INPUTFORMAT.equalsIgnoreCase(inputFormat) || SUPPORTED_RCFILE_INPUTFORMAT.equalsIgnoreCase(inputFormat) || SUPPORTED_PARQUET_INPUTFORMAT.equalsIgnoreCase(inputFormat))) {
            throw new ConnectorException(32003);
        }
        if (!(SUPPORTED_TEXTFILE_OUTPUTFORMAT.equalsIgnoreCase(outputFormat) || SUPPORTED_SEQUENCEFILE_OUTPUTFORMAT.equalsIgnoreCase(outputFormat) || SUPPORTED_ORCFILE_OUTPUTFORMAT.equalsIgnoreCase(outputFormat) || SUPPORTED_RCFILE_OUTPUTFORMAT.equalsIgnoreCase(outputFormat) || SUPPORTED_PARQUET_OUTPUTFORMAT.equalsIgnoreCase(outputFormat))) {
            throw new ConnectorException(32004);
        }
        if (!(SUPPORTED_LAZY_SIMPLE_SERDE.equalsIgnoreCase(serdeLib) || SUPPORTED_ORC_SERDE.equalsIgnoreCase(serdeLib) || SUPPORTED_COLUMNAR_SERDE.equalsIgnoreCase(serdeLib) || SUPPORTED_LB_COLUMNAR_SERDE.equalsIgnoreCase(serdeLib) || SUPPORTED_PARQUET_SERDE.equalsIgnoreCase(serdeLib))) {
            throw new ConnectorException(32005);
        }
    }

    public static String setHiveSchemaToOutputHiveTable(Configuration configuration, String databaseName, String tableName, HiveMetaStoreClient client) throws ConnectorException {
        String path = null;
        try {
            Table hiveTable = client.getTable(databaseName, tableName);
            StorageDescriptor storageDescriptor = hiveTable.getSd();
            HiveUtils.checkHiveTableProperties(hiveTable);
            List fieldSchemas = storageDescriptor.getCols();
            String hiveTableSchema = "";
            int colNum = fieldSchemas.size() - 1;
            int i = 0;
            for (FieldSchema field : fieldSchemas) {
                hiveTableSchema = hiveTableSchema + field.getName() + " " + field.getType();
                if (i < colNum) {
                    hiveTableSchema = hiveTableSchema + COMMA;
                }
                ++i;
            }
            List partitioFields = hiveTable.getPartitionKeys();
            String partitionSchema = "";
            i = 0;
            colNum = partitioFields.size() - 1;
            for (FieldSchema field : partitioFields) {
                partitionSchema = partitionSchema + field.getName() + " " + field.getType();
                if (i < colNum) {
                    partitionSchema = partitionSchema + COMMA;
                }
                ++i;
            }
            HivePlugInConfiguration.setOutputTableSchema(configuration, hiveTableSchema);
            HivePlugInConfiguration.setOutputPartitionSchema(configuration, partitionSchema);
            String separator = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("field.delim");
            if (ConnectorStringUtils.isEmpty(separator)) {
                separator = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.format");
            }
            HivePlugInConfiguration.setOutputSeparator(configuration, ConnectorUnicodeCharacterConverter.toEncodedUnicode(separator));
            String value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.format");
            if (value != null && !value.isEmpty()) {
                configuration.set("serialization.format", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("colelction.delim")) != null && !value.isEmpty()) {
                configuration.set("colelction.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("mapkey.delim")) != null && !value.isEmpty()) {
                configuration.set("mapkey.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.null.format")) != null && !value.isEmpty()) {
                configuration.set("serialization.null.format", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.last.column.takes.rest")) != null && !value.isEmpty()) {
                configuration.set("serialization.last.column.takes.rest", value);
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("escape.delim")) != null && !value.isEmpty()) {
                configuration.set("escape.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if (hiveTable.getSd().getOutputFormat().contains("RCFile")) {
                value = hiveTable.getSd().getSerdeInfo().getSerializationLib();
                HivePlugInConfiguration.setOutputRCFileSerde(configuration, value);
            }
            path = storageDescriptor.getLocation();
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new ConnectorException(32001);
        }
        catch (TException e) {
            throw new ConnectorException(32007);
        }
        return path;
    }

    public static String setHiveSchemaToInputHiveTable(Configuration configuration, String databaseName, String tableName, HiveMetaStoreClient client) throws ConnectorException {
        String path = null;
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setDelimChar(' ');
        parser.setEscapeChar('\\');
        parser.setIgnoreContinousDelim(true);
        try {
            Table hiveTable = client.getTable(databaseName, tableName);
            StorageDescriptor storageDescriptor = hiveTable.getSd();
            HiveUtils.checkHiveTableProperties(hiveTable);
            List fieldSchemas = storageDescriptor.getCols();
            String hiveTableSchema = "";
            int colNum = fieldSchemas.size() - 1;
            int i = 0;
            for (FieldSchema field : fieldSchemas) {
                List<String> tokens = parser.tokenize(field.getName().trim(), 2, false);
                hiveTableSchema = hiveTableSchema + (tokens.size() > 1 ? QUOTE : "") + field.getName() + (tokens.size() > 1 ? QUOTE : "") + " " + field.getType();
                if (i < colNum) {
                    hiveTableSchema = hiveTableSchema + COMMA;
                }
                ++i;
            }
            List partitioFields = hiveTable.getPartitionKeys();
            String partitionSchema = "";
            i = 0;
            colNum = partitioFields.size() - 1;
            for (FieldSchema field : partitioFields) {
                partitionSchema = partitionSchema + field.getName() + " " + field.getType();
                if (i < colNum) {
                    partitionSchema = partitionSchema + COMMA;
                }
                ++i;
            }
            HivePlugInConfiguration.setInputTableSchema(configuration, hiveTableSchema);
            HivePlugInConfiguration.setInputPartitionSchema(configuration, partitionSchema);
            String separator = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("field.delim");
            if (ConnectorStringUtils.isEmpty(separator)) {
                separator = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.format");
            }
            HivePlugInConfiguration.setInputSeparator(configuration, ConnectorUnicodeCharacterConverter.toEncodedUnicode(separator));
            String value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.format");
            if (value != null && !value.isEmpty()) {
                configuration.set("serialization.format", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("colelction.delim")) != null && !value.isEmpty()) {
                configuration.set("colelction.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("mapkey.delim")) != null && !value.isEmpty()) {
                configuration.set("mapkey.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.null.format")) != null && !value.isEmpty()) {
                configuration.set("serialization.null.format", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.last.column.takes.rest")) != null && !value.isEmpty()) {
                configuration.set("serialization.last.column.takes.rest", value);
            }
            if ((value = (String)hiveTable.getSd().getSerdeInfo().getParameters().get("escape.delim")) != null && !value.isEmpty()) {
                configuration.set("escape.delim", ConnectorUnicodeCharacterConverter.toEncodedUnicode(value));
            }
            if (hiveTable.getSd().getInputFormat().contains("RCFile")) {
                value = hiveTable.getSd().getSerdeInfo().getSerializationLib();
                HivePlugInConfiguration.setInputRCFileSerde(configuration, value);
            }
            path = storageDescriptor.getLocation();
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new ConnectorException(32001);
        }
        catch (TException e) {
            throw new ConnectorException(32007);
        }
        return path;
    }

    public static void createHiveTable(Configuration configuration, String databaseName, String tableName, HiveConf hiveConf, HiveMetaStoreClient client) throws ConnectorException {
        try {
            SerDeInfo serDeInfo;
            StorageDescriptor sd;
            String targetPartitionSchema;
            Table table;
            block31: {
                String outputFormat;
                block30: {
                    table = new Table();
                    table.setDbName(databaseName);
                    table.setTableName(tableName);
                    UserGroupInformation ugi = null;
                    try {
                        ugi = UserGroupInformation.getCurrentUser();
                        table.setOwner(ugi.getUserName());
                    }
                    catch (Exception e1) {
                        try {
                            HadoopShims shims = ShimLoader.getHadoopShims();
                            Method mthd = null;
                            mthd = shims.getClass().getDeclaredMethod("getUGIForConf", Configuration.class);
                            ugi = (UserGroupInformation)mthd.invoke((Object)shims, configuration);
                            table.setOwner(ugi.getUserName());
                        }
                        catch (Exception e2) {
                            logger.warn((Object)"LoginException: Cannot get current user to set Hive table owner");
                        }
                    }
                    targetPartitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(configuration);
                    table.setTableType(TableType.MANAGED_TABLE.toString());
                    table.setTableTypeIsSet(true);
                    sd = new StorageDescriptor();
                    String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
                    List<String> schemafields = ConnectorSchemaUtils.parseColumns(targetTableSchema);
                    List<String> colNames = ConnectorSchemaUtils.parseColumnNames(schemafields);
                    List<String> colTypes = ConnectorSchemaUtils.parseColumnTypes(schemafields);
                    HiveSchemaUtils.updateNonScaleDecimalColumns(colTypes);
                    int colCount = colNames.size();
                    ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
                    for (int i = 0; i < colCount; ++i) {
                        fieldSchemas.add(new FieldSchema(colNames.get(i), colTypes.get(i).toLowerCase(), ""));
                    }
                    sd.setCols(fieldSchemas);
                    outputFormat = ConnectorConfiguration.getPlugInOutputFormat(configuration);
                    try {
                        Class<Object> clz = Class.forName(outputFormat);
                        if (clz.isAssignableFrom(HiveTextFileOutputFormat.class)) {
                            sd.setInputFormat(SUPPORTED_TEXTFILE_INPUTFORMAT);
                            sd.setOutputFormat(SUPPORTED_TEXTFILE_OUTPUTFORMAT);
                            break block30;
                        }
                        if (clz.isAssignableFrom(HiveSequenceFileOutputFormat.class)) {
                            sd.setInputFormat(SUPPORTED_SEQUENCEFILE_INPUTFORMAT);
                            sd.setOutputFormat(SUPPORTED_SEQUENCEFILE_OUTPUTFORMAT);
                            break block30;
                        }
                        if (clz.isAssignableFrom(HiveRCFileOutputFormat.class)) {
                            sd.setInputFormat(SUPPORTED_RCFILE_INPUTFORMAT);
                            sd.setOutputFormat(SUPPORTED_RCFILE_OUTPUTFORMAT);
                            break block30;
                        }
                        if (clz.isAssignableFrom(HiveORCFileOutputFormat.class)) {
                            sd.setInputFormat(SUPPORTED_ORCFILE_INPUTFORMAT);
                            sd.setOutputFormat(SUPPORTED_ORCFILE_OUTPUTFORMAT);
                            break block30;
                        }
                        if (clz.isAssignableFrom(HiveParquetFileOutputFormat.class)) {
                            sd.setInputFormat(SUPPORTED_PARQUET_INPUTFORMAT);
                            sd.setOutputFormat(SUPPORTED_PARQUET_OUTPUTFORMAT);
                            break block30;
                        }
                        throw new ConnectorException(32014);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                sd.setInputFormatIsSet(true);
                sd.setOutputFormatIsSet(true);
                sd.setParameters(new HashMap());
                sd.setParametersIsSet(true);
                serDeInfo = null;
                HashMap<String, String> sdParameters = new HashMap<String, String>();
                sdParameters.put("field.delim", ConnectorUnicodeCharacterConverter.fromEncodedUnicode(HivePlugInConfiguration.getOutputSeparator(configuration)));
                sdParameters.put("serialization.format", ConnectorUnicodeCharacterConverter.fromEncodedUnicode(HivePlugInConfiguration.getOutputSeparator(configuration)));
                sdParameters.put("line.delim", ConnectorUnicodeCharacterConverter.fromEncodedUnicode(HivePlugInConfiguration.getOutputLineSeparator(configuration)));
                String nullString = HivePlugInConfiguration.getOutputNullString(configuration);
                if (nullString != null) {
                    sdParameters.put("serialization.null.format", nullString);
                }
                try {
                    Class<Object> clz = Class.forName(outputFormat);
                    if (clz.isAssignableFrom(HiveRCFileOutputFormat.class)) {
                        String defSerde = HivePlugInConfiguration.getOutputRCFileSerde(configuration);
                        if (defSerde.isEmpty()) {
                            serDeInfo = new SerDeInfo("LazyBinaryColumnarSerDe", SUPPORTED_LB_COLUMNAR_SERDE, sdParameters);
                            break block31;
                        }
                        if (defSerde.equals(SUPPORTED_LB_COLUMNAR_SERDE)) {
                            serDeInfo = new SerDeInfo("LazyBinaryColumnarSerDe", SUPPORTED_LB_COLUMNAR_SERDE, sdParameters);
                            break block31;
                        }
                        if (defSerde.equals(SUPPORTED_COLUMNAR_SERDE)) {
                            serDeInfo = new SerDeInfo("ColumnarSerDe", SUPPORTED_COLUMNAR_SERDE, sdParameters);
                            break block31;
                        }
                        throw new ConnectorException(32005);
                    }
                    if (clz.isAssignableFrom(HiveORCFileOutputFormat.class)) {
                        serDeInfo = new SerDeInfo("OrcSerDe", SUPPORTED_ORC_SERDE, sdParameters);
                        break block31;
                    }
                    if (clz.isAssignableFrom(HiveTextFileOutputFormat.class) || clz.isAssignableFrom(HiveSequenceFileOutputFormat.class)) {
                        serDeInfo = new SerDeInfo("LazySimpleSerDe", SUPPORTED_LAZY_SIMPLE_SERDE, sdParameters);
                        break block31;
                    }
                    if (clz.isAssignableFrom(HiveParquetFileOutputFormat.class)) {
                        sdParameters.clear();
                        serDeInfo = new SerDeInfo("ParquetHiveSerDe", SUPPORTED_PARQUET_SERDE, sdParameters);
                        break block31;
                    }
                    throw new ConnectorException(32014);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
            }
            serDeInfo.setParametersIsSet(true);
            sd.setSerdeInfo(serDeInfo);
            sd.setSerdeInfoIsSet(true);
            table.setSd(sd);
            table.setSdIsSet(true);
            table.unsetParameters();
            if (targetPartitionSchema != null && targetPartitionSchema.length() != 0) {
                List<String> partitionfields = ConnectorSchemaUtils.parseColumns(targetPartitionSchema);
                List<String> partitionColNames = ConnectorSchemaUtils.parseColumnNames(partitionfields);
                List<String> partitionColTypes = ConnectorSchemaUtils.parseColumnTypes(partitionfields);
                HiveSchemaUtils.updateNonScaleDecimalColumns(partitionColTypes);
                ArrayList<FieldSchema> partitionKeys = new ArrayList<FieldSchema>();
                int colCnt = partitionColNames.size();
                for (int i = 0; i < colCnt; ++i) {
                    partitionKeys.add(new FieldSchema(partitionColNames.get(i), partitionColTypes.get(i).toLowerCase(), ""));
                }
                table.setPartitionKeys(partitionKeys);
                table.setPartitionKeysIsSet(true);
            }
            client.createTable(table);
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (AlreadyExistsException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (InvalidObjectException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new ConnectorException(32001);
        }
        catch (TException e) {
            throw new ConnectorException(32007);
        }
    }

    public static void checkFieldNamesContainPartitions(String[] fieldNames, String partitionSchema) throws ConnectorException {
        List<String> partitionFields;
        List<String> partitionFieldNames;
        List<String> fields;
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = fieldNames[i].toLowerCase();
        }
        if (!ConnectorStringUtils.isEmpty(partitionSchema) && !(fields = Arrays.asList(fieldNames)).containsAll(partitionFieldNames = ConnectorSchemaUtils.parseColumnNames(partitionFields = ConnectorSchemaUtils.parseColumns(partitionSchema.toLowerCase())))) {
            throw new ConnectorException(30004);
        }
    }

    public static void checkFieldNamesInSchema(String[] fieldNames, String tableSchema, String partitionSchema) throws ConnectorException {
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = fieldNames[i].toLowerCase();
        }
        List<String> fields = Arrays.asList(fieldNames);
        List<String> tableFields = ConnectorSchemaUtils.parseColumns(tableSchema.toLowerCase());
        List<String> tableFieldNames = ConnectorSchemaUtils.parseColumnNames(tableFields);
        List<String> partitionFields = ConnectorSchemaUtils.parseColumns(partitionSchema.toLowerCase());
        List<String> partitionFieldNames = ConnectorSchemaUtils.parseColumnNames(partitionFields);
        tableFieldNames.addAll(partitionFieldNames);
        if (!tableFieldNames.containsAll(fields)) {
            throw new ConnectorException(33001);
        }
    }

    public static void checkPartitionNamesInSchema(String tableSchema, String partitionSchema) throws ConnectorException {
        List<String> tableFields = ConnectorSchemaUtils.parseColumns(tableSchema);
        List<String> tableFieldNames = ConnectorSchemaUtils.parseColumnNames(tableFields);
        List<String> partitionFields = ConnectorSchemaUtils.parseColumns(partitionSchema);
        List<String> partitionFieldNames = ConnectorSchemaUtils.parseColumnNames(partitionFields);
        for (String partitionFildName : partitionFieldNames) {
            for (String tableFildName : tableFieldNames) {
                if (!partitionFildName.equalsIgnoreCase(tableFildName)) continue;
                throw new ConnectorException(30006);
            }
        }
    }

    public static long getRandomNumber() {
        Random generator = new Random(RANDOMSEED);
        return generator.nextLong();
    }

    public static String getFileNameUnderHiveNamingConvention(String directoryName, FileSystem fs) throws ConnectorException, IOException {
        int fixedLength;
        FileStatus[] fileStatus;
        Path directory = new Path(directoryName);
        String fileName = null;
        String firstFileName = HIVE_FIRST_FILE_NAME;
        if (!fs.exists(directory)) {
            throw new ConnectorException(32012);
        }
        if (!fs.getFileStatus(directory).isDir()) {
            throw new ConnectorException(32011);
        }
        int maxValue = 0;
        for (FileStatus file : fileStatus = fs.listStatus(directory)) {
            String name = file.getPath().getName();
            int value = 0;
            try {
                value = Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value <= maxValue) continue;
            maxValue = value;
        }
        fileName = String.valueOf(maxValue + 1);
        int length = fileName.length();
        if (length < (fixedLength = firstFileName.length())) {
            return firstFileName.substring(0, fixedLength - length) + fileName;
        }
        return fileName;
    }

    public static List<String> filterByValues(String fieldname, List<String> paths, String values) {
        ArrayList<String> result = new ArrayList<String>();
        String[] partitionvalues = values.split(COMMA);
        if (partitionvalues == null || partitionvalues.length == 0) {
            return result;
        }
        for (String val : partitionvalues) {
            for (String path : paths) {
                if (!path.contains(fieldname + EQUALS + val)) continue;
                result.add(path);
            }
        }
        return result;
    }

    public static List<String> filterByRegex(String fieldname, List<String> paths, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            if (!path.contains(fieldname + EQUALS)) continue;
            String val = "";
            val = path.substring(path.indexOf(fieldname + EQUALS) + (fieldname.length() + 1));
            int end = val.indexOf(SLASH);
            if (end != -1) {
                val = val.substring(0, end);
            }
            if (!val.matches(regex)) continue;
            result.add(path);
        }
        return result;
    }

    public static boolean isHiveOutputTablePartitioned(Configuration configuration) throws ConnectorException {
        boolean flag;
        block7: {
            flag = false;
            String database = HivePlugInConfiguration.getOutputDatabase(configuration);
            String tablename = HivePlugInConfiguration.getOutputTable(configuration);
            try {
                Table table;
                if (database.isEmpty()) {
                    database = DEFAULT_DATABASE;
                }
                if (tablename.isEmpty()) break block7;
                HiveConf hiveConf = new HiveConf(configuration, HiveUtils.class);
                HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.output);
                HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
                try {
                    table = client.getTable(database, tablename);
                }
                catch (NoSuchObjectException e) {
                    return false;
                }
                List partition = table.getPartitionKeys();
                if (partition.size() > 0) {
                    flag = true;
                }
            }
            catch (MetaException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (TException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Deprecated
    public static boolean isPartition(Configuration configuration) throws ConnectorException {
        boolean flag;
        block9: {
            flag = false;
            String database = HivePlugInConfiguration.getOutputDatabase(configuration);
            String tablename = HivePlugInConfiguration.getOutputTable(configuration);
            try {
                Table table;
                if (database.isEmpty()) {
                    database = DEFAULT_DATABASE;
                }
                if (tablename.isEmpty()) break block9;
                HiveConf hiveConf = new HiveConf(configuration, HiveUtils.class);
                try {
                    HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.output);
                }
                catch (ConnectorException e) {
                    e.printStackTrace();
                }
                HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
                try {
                    table = client.getTable(database, tablename);
                }
                catch (NoSuchObjectException e) {
                    return false;
                }
                List partition = table.getPartitionKeys();
                if (partition.size() > 0) {
                    flag = true;
                }
            }
            catch (MetaException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (TException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public static List<String> getPathsByPartitionFilter(Configuration configuration, String databaseName, String tableName, HiveMetaStoreClient client, String[] filters) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            List partitions = client.listPartitionNames(databaseName, tableName, (short)0);
            if (partitions == null || partitions.size() == 0) {
                return paths;
            }
            for (String filter : filters) {
                String[] items = filter.split("=>");
                if (items.length != 3) {
                    throw new ConnectorException(32013);
                }
                String fieldname = items[0];
                String usage = items[1];
                String values = items[2];
                if (usage.equalsIgnoreCase(USAGE_VALUES)) {
                    paths.addAll(HiveUtils.filterByValues(fieldname, partitions, values));
                    continue;
                }
                if (!usage.equalsIgnoreCase(USAGE_REGEX)) continue;
                paths.addAll(HiveUtils.filterByRegex(fieldname, partitions, values));
            }
        }
        catch (MetaException e) {
            e.printStackTrace();
        }
        catch (NoSuchObjectException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        return paths;
    }
}

