/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.serde;

import com.teradata.connector.common.ConnectorPartitionedWritable;
import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.converter.HiveDataType;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public abstract class HiveConnectorSerDe
implements ConnectorSerDe {
    private int[] mapping;
    protected int recordLen;
    protected boolean partitioned;
    protected JobContext context;
    protected Configuration configuration;
    protected ConnectorRecord record;
    protected ConnectorRecord deserRecord;
    protected ArrayList<String> partitionValues;
    protected int nonPartSize;
    protected HiveDataType[] inputSchemaDataTypes = null;
    private String[] partColNames;
    private int[] partCols = null;
    private ConnectorPartitionedWritable partWritable;
    private HiveDataType[] outputSchemaDataTypes = null;
    private String lastFilePath = "";
    private ConnectorDataTypeConverter[] serConverter;
    private ConnectorDataTypeConverter[] deserConverter;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        this.context = context;
        this.configuration = context.getConfiguration();
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            ConnectorRecordSchema inputSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(this.configuration));
            String[] fieldNames = HivePlugInConfiguration.getInputFieldNamesArray(this.configuration);
            String sourcePartitionSchema = HivePlugInConfiguration.getInputPartitionSchema(this.configuration);
            String[] schemaFieldNames = HivePlugInConfiguration.getInputTableFieldNamesArray(this.configuration);
            String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(this.configuration).trim();
            this.inputSchemaDataTypes = HiveSchemaUtils.lookupWritableHiveDataTypes(HivePlugInConfiguration.getInputTableFieldTypes(this.configuration));
            this.recordLen = inputSchema.getLength();
            if (sourcePartitionSchema.length() > 0) {
                this.partitioned = true;
                this.partitionValues = new ArrayList();
            }
            this.mapping = HiveSchemaUtils.getColumnMapping(schemaFieldNames, fieldNames);
            this.deserRecord = new ConnectorRecord(schemaFieldNames.length);
            this.nonPartSize = ConnectorSchemaUtils.parseColumns(sourceTableSchema.toLowerCase()).size();
            this.record = new ConnectorRecord(this.recordLen);
            this.deserConverter = HiveSchemaUtils.initializeHiveTypeEncoder(HivePlugInConfiguration.getInputTableSchema(this.configuration));
        } else {
            String targetPartitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(this.configuration);
            String[] schemaField = HivePlugInConfiguration.getOutputTableFieldNamesArray(this.configuration);
            int partitionColumnCnt = ConnectorSchemaUtils.parseColumns(targetPartitionSchema).size();
            String[] fieldNames = HivePlugInConfiguration.getOutputFieldNamesArray(this.configuration);
            this.mapping = HiveSchemaUtils.getColumnMapping(schemaField, fieldNames);
            this.nonPartSize = schemaField.length - partitionColumnCnt;
            this.record = new ConnectorRecord(this.nonPartSize);
            if (partitionColumnCnt > 0) {
                String[] fieldName = HivePlugInConfiguration.getOutputFieldNamesArray(this.configuration);
                this.partCols = ConnectorSchemaUtils.getHivePartitionMapping(fieldName, targetPartitionSchema);
                this.partColNames = new String[this.partCols.length];
                for (int i = 0; i < this.partCols.length; ++i) {
                    this.partColNames[i] = fieldName[this.partCols[i]];
                }
                this.partitioned = true;
                this.partWritable = new ConnectorPartitionedWritable();
            }
            this.outputSchemaDataTypes = HiveSchemaUtils.lookupWritableHiveDataTypes(HivePlugInConfiguration.getOutputTableFieldTypes(this.configuration));
            this.serConverter = HiveSchemaUtils.initializeHiveTypeDecoder(HivePlugInConfiguration.getOutputTableSchema(this.configuration));
        }
    }

    @Override
    public Writable serialize(ConnectorRecord value) throws ConnectorException {
        Writable result;
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] >= this.nonPartSize) continue;
            this.record.set(this.mapping[i], this.hiveTypeDecoder(this.mapping[i], value.get(i)));
        }
        try {
            result = this.doSerialize(this.record);
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new ConnectorException(e.getMessage(), e);
        }
        if (this.partitioned) {
            this.partWritable.setPartitionPath(this.getPartitionPath(value));
            this.partWritable.setRecord(result);
            return this.partWritable;
        }
        return result;
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        if (this.partitioned) {
            String newFilePath = this.configuration.get("map.input.file");
            if (!this.lastFilePath.equals(newFilePath)) {
                this.getPartitionValues(newFilePath);
                this.lastFilePath = newFilePath;
            }
            for (int i = 0; i < this.partitionValues.size(); ++i) {
                this.deserRecord.set(this.nonPartSize + i, this.partitionValues.get(i));
            }
        }
        try {
            this.doDeserialize(writable);
        }
        catch (SerDeException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            this.record.set(i, this.hiveTypeEncoder(this.mapping[i], this.deserRecord.get(this.mapping[i])));
        }
        return this.record;
    }

    private void getPartitionValues(String pathString) {
        int lastEqualPos;
        this.partitionValues.clear();
        while ((lastEqualPos = pathString.indexOf(61)) >= 0) {
            int lastSlashPos = (pathString = pathString.substring(lastEqualPos + 1)).indexOf(47);
            if (lastSlashPos >= 0) {
                String s = FileUtils.unescapePathName((String)pathString.substring(0, lastSlashPos));
                this.partitionValues.add(s);
                pathString = pathString.substring(lastSlashPos + 1);
                continue;
            }
            this.partitionValues.add(FileUtils.unescapePathName((String)pathString));
            break;
        }
    }

    private String getPartitionPath(ConnectorRecord value) throws ConnectorException {
        ArrayList<String> partValues = new ArrayList<String>();
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)this.context);
        String pathString = outputPath.toString();
        for (int i = 0; i < this.partCols.length; ++i) {
            int colToAppend = this.partCols[i];
            Object colValue = value.get(colToAppend);
            if (colValue == null) {
                throw new ConnectorException(15010);
            }
            String colValueStr = FileUtils.escapePathName((String)ConnectorSchemaUtils.getHivePathString(colValue));
            String partitionColName = FileUtils.escapePathName((String)this.partColNames[i].toLowerCase());
            partValues.add(colValueStr);
            pathString = pathString + "/" + partitionColName + "=" + colValueStr;
        }
        return pathString;
    }

    protected abstract Writable doSerialize(ConnectorRecord var1) throws SerDeException;

    protected abstract ConnectorRecord doDeserialize(Writable var1) throws SerDeException;

    private Object hiveTypeEncoder(int index, Object o) {
        HiveDataType type = this.inputSchemaDataTypes[index];
        if (HiveSchemaUtils.isHiveComplexType(type.getType())) {
            return this.deserConverter[index].convert(o);
        }
        return o;
    }

    private Object hiveTypeDecoder(int index, Object o) {
        HiveDataType type = this.outputSchemaDataTypes[index];
        if (HiveSchemaUtils.isHiveComplexType(type.getType()) || type.getType() == 3 || type.getType() == 1 || type.getType() == -2001) {
            return this.serConverter[index].convert(o);
        }
        return o;
    }
}

