/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.processor;

import com.teradata.connector.common.ConnectorOutputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import com.teradata.connector.hive.utils.HiveUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;

public class HiveOutputProcessor
implements ConnectorOutputProcessor {
    private Log logger = LogFactory.getLog(HiveOutputProcessor.class);

    @Override
    public int outputPreProcessor(JobContext context) throws ConnectorException {
        HiveMetaStoreClient client = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("hhmmss");
            Configuration configuration = context.getConfiguration();
            HiveConf hiveConf = new HiveConf(configuration, HiveOutputProcessor.class);
            String databaseName = HivePlugInConfiguration.getOutputDatabase(configuration);
            String tableName = HivePlugInConfiguration.getOutputTable(configuration);
            String targetPath = HivePlugInConfiguration.getOutputPaths(configuration);
            if (databaseName.isEmpty()) {
                databaseName = "default";
                HivePlugInConfiguration.setOutputDatabase(configuration, databaseName);
            }
            if (tableName.isEmpty() && targetPath.isEmpty()) {
                throw new ConnectorException(30002);
            }
            if (!tableName.isEmpty() && !targetPath.isEmpty()) {
                throw new ConnectorException(30001);
            }
            if (!tableName.isEmpty() && targetPath.isEmpty()) {
                UserGroupInformation ugi = null;
                try {
                    ugi = UserGroupInformation.getCurrentUser();
                }
                catch (Exception e1) {
                    try {
                        HadoopShims shims = ShimLoader.getHadoopShims();
                        Method mthd = null;
                        mthd = shims.getClass().getDeclaredMethod("getUGIForConf", Configuration.class);
                        ugi = (UserGroupInformation)mthd.invoke((Object)shims, configuration);
                    }
                    catch (Exception e2) {
                        throw new ConnectorException(e2.getMessage(), e2);
                    }
                }
                String user = ugi.getShortUserName();
                String userDirectory = "/user/" + user;
                FileSystem fs = FileSystem.get((Configuration)configuration);
                if (!fs.exists(new Path(userDirectory))) {
                    throw new ConnectorException(32009);
                }
                String path = userDirectory + "/temp_" + sdf.format(new Date());
                if (fs.exists(new Path(path))) {
                    Long randomNumberLong = HiveUtils.getRandomNumber();
                    path = path + "_" + randomNumberLong.toString();
                }
                HivePlugInConfiguration.setOutputPaths(configuration, path);
            }
            if (!tableName.isEmpty()) {
                String targetTableSchema;
                HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.output);
                client = new HiveMetaStoreClient(hiveConf);
                boolean tableExisted = false;
                try {
                    tableExisted = client.tableExists(databaseName, tableName);
                    if (tableExisted) {
                        HiveSchemaUtils.logHiveTableExtInfo(this.logger, databaseName, tableName, hiveConf);
                        HiveSchemaUtils.logHivePartitionValues(this.logger, databaseName, tableName, hiveConf);
                    } else {
                        this.logger.info((Object)("hive table " + databaseName + "." + tableName + " does not exist"));
                    }
                }
                catch (NoSuchObjectException e) {
                    e.printStackTrace();
                }
                catch (HiveException e) {
                    e.printStackTrace();
                }
                if (tableExisted) {
                    targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
                    if (!targetTableSchema.isEmpty()) {
                        throw new ConnectorException(30005);
                    }
                    HiveUtils.setHiveSchemaToOutputHiveTable(configuration, databaseName, tableName, client);
                } else {
                    targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
                    if (targetTableSchema.isEmpty()) {
                        throw new ConnectorException(30003);
                    }
                    if (ConnectorConfiguration.getOutputSerDe(configuration).contains("RCFile")) {
                        HivePlugInConfiguration.setOutputRCFileSerde(configuration, client.getConfigValue("hive.default.rcfile.serde", ""));
                    }
                }
            } else {
                String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
                if (targetTableSchema.isEmpty()) {
                    throw new ConnectorException(30003);
                }
                if (ConnectorConfiguration.getOutputSerDe(configuration).contains("RCFile")) {
                    HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.output);
                    client = new HiveMetaStoreClient(hiveConf);
                    HivePlugInConfiguration.setOutputRCFileSerde(configuration, client.getConfigValue("hive.default.rcfile.serde", ""));
                }
            }
            String[] targetFieldNames = HivePlugInConfiguration.getOutputFieldNamesArray(configuration);
            String targetPartitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(configuration);
            String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
            if (targetPartitionSchema.length() > 0) {
                HiveUtils.checkPartitionNamesInSchema(targetTableSchema, targetPartitionSchema);
            }
            if (targetFieldNames.length > 0) {
                HiveUtils.checkFieldNamesInSchema(targetFieldNames, targetTableSchema, targetPartitionSchema);
                HiveUtils.checkFieldNamesContainPartitions(targetFieldNames, targetPartitionSchema);
            }
            this.setupSchema(configuration);
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnknownDBException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (TException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            if (client != null) {
                client.close();
                client = null;
            }
        }
        return 0;
    }

    private void setupSchema(Configuration configuration) throws ConnectorException {
        String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(configuration).trim();
        String partitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(configuration).trim();
        if (partitionSchema.length() > 0) {
            targetTableSchema = targetTableSchema + "," + partitionSchema;
        }
        List<String> columns = ConnectorSchemaUtils.parseColumns(targetTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        if (HivePlugInConfiguration.getOutputFieldNamesArray(configuration).length == 0) {
            HivePlugInConfiguration.setOutputFieldNamesArray(configuration, columnNames.toArray(new String[columnNames.size()]));
        }
        String[] fieldNames = HivePlugInConfiguration.getOutputFieldNamesArray(configuration);
        ConnectorRecordSchema r = new ConnectorRecordSchema(fieldNames.length);
        int[] columnMapping = HiveSchemaUtils.getColumnMapping(columnNames.toArray(new String[columnNames.size()]), fieldNames);
        for (int i = 0; i < fieldNames.length; ++i) {
            r.setFieldType(i, HiveSchemaUtils.lookupHiveDataTypeByName(columnTypes.get(columnMapping[i])));
        }
        ConnectorRecordSchema userSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration));
        ConnectorSchemaUtils.formalizeConnectorRecordSchema(r);
        if (userSchema != null) {
            HiveSchemaUtils.checkSchemaMatch(userSchema, r);
        } else {
            ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(r));
        }
        HivePlugInConfiguration.setOutputTableFieldTypes(configuration, columnTypes.toArray(new String[columnTypes.size()]));
        HivePlugInConfiguration.setOutputTableFieldNamesArray(configuration, columnNames.toArray(new String[columnNames.size()]));
    }

    @Override
    public int outputPostProcessor(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        if (!ConnectorConfiguration.getJobSucceeded(configuration)) {
            return 1;
        }
        String databaseName = HivePlugInConfiguration.getOutputDatabase(configuration);
        String tableName = HivePlugInConfiguration.getOutputTable(configuration);
        HiveMetaStoreClient client = null;
        try {
            if (!tableName.isEmpty()) {
                HiveConf hiveConf = new HiveConf(configuration, HiveOutputProcessor.class);
                HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.output);
                client = new HiveMetaStoreClient(hiveConf);
                boolean tableExisted = client.tableExists(databaseName, tableName);
                if (!tableExisted) {
                    String targetPartitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(configuration);
                    HiveUtils.createHiveTable(configuration, databaseName, tableName, hiveConf, client);
                    if (!targetPartitionSchema.isEmpty()) {
                        HiveUtils.addPartitionsToHiveTable(configuration, databaseName, tableName, hiveConf, client);
                    } else {
                        HiveUtils.loadDataintoHiveTable(configuration, databaseName, tableName, hiveConf, client);
                    }
                } else {
                    String targetPartitionSchema = HivePlugInConfiguration.getOutputPartitionSchema(configuration);
                    if (!targetPartitionSchema.isEmpty()) {
                        HiveUtils.addPartitionsToHiveTable(configuration, databaseName, tableName, hiveConf, client);
                    } else {
                        HiveUtils.loadDataintoHiveTable(configuration, databaseName, tableName, hiveConf, client);
                    }
                }
            }
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnknownDBException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (TException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ConnectorException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            if (client != null) {
                client.close();
                client = null;
            }
        }
        return 0;
    }
}

