/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.processor;

import com.teradata.connector.common.ConnectorInputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import com.teradata.connector.hive.utils.HiveUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.thrift.TException;

public class HiveInputProcessor
implements ConnectorInputProcessor {
    private Log logger = LogFactory.getLog(HiveInputProcessor.class);

    @Override
    public int inputPreProcessor(JobContext context) throws ConnectorException {
        try {
            Configuration configuration = context.getConfiguration();
            String databaseName = HivePlugInConfiguration.getInputDatabase(configuration);
            String tableName = HivePlugInConfiguration.getInputTable(configuration);
            String sourcePaths = HivePlugInConfiguration.getInputPaths(configuration);
            String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(configuration);
            if (databaseName == null || databaseName.isEmpty()) {
                databaseName = "default";
                HivePlugInConfiguration.setInputDatabase(configuration, databaseName);
            }
            if (tableName.isEmpty()) {
                if (sourcePaths.isEmpty()) {
                    sourcePaths = configuration.get("mapred.input.dir", "");
                    if (sourcePaths.isEmpty()) {
                        throw new ConnectorException(31002);
                    }
                    HivePlugInConfiguration.setInputPaths(configuration, sourcePaths);
                    if (sourceTableSchema.isEmpty()) {
                        throw new ConnectorException(31003);
                    }
                } else if (sourceTableSchema.isEmpty()) {
                    throw new ConnectorException(31003);
                }
            } else if (!sourcePaths.isEmpty() || !configuration.get("mapred.input.dir", "").isEmpty()) {
                throw new ConnectorException(31001);
            }
            if (!tableName.isEmpty()) {
                HiveConf hiveConf = new HiveConf(configuration, HiveInputProcessor.class);
                HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.input);
                HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
                boolean tableExisted = client.tableExists(databaseName, tableName);
                if (!tableExisted) {
                    throw new ConnectorException(32001);
                }
                if (!ConnectorStringUtils.isEmpty(sourceTableSchema)) {
                    throw new ConnectorException(310005);
                }
                try {
                    HiveSchemaUtils.logHiveTableExtInfo(this.logger, databaseName, tableName, hiveConf);
                    HiveSchemaUtils.logHivePartitionValues(this.logger, databaseName, tableName, hiveConf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String path = HiveUtils.setHiveSchemaToInputHiveTable(configuration, databaseName, tableName, client);
                List partitions = client.listPartitions(databaseName, tableName, (short)2000);
                if (partitions.size() > 0) {
                    StringBuilder allPaths = new StringBuilder();
                    for (Partition partition : partitions) {
                        allPaths.append(partition.getSd().getLocation());
                        allPaths.append(",");
                    }
                    int pos = allPaths.length() - 1;
                    allPaths.deleteCharAt(pos);
                    HivePlugInConfiguration.setInputPaths(configuration, allPaths.toString());
                } else {
                    Path tablePath = new Path(path);
                    FileSystem fs = FileSystem.get((URI)tablePath.toUri(), (Configuration)configuration);
                    if (!fs.exists(tablePath)) {
                        this.logger.warn((Object)"hive table is empty with no data");
                        return 1001;
                    }
                    String allPaths = HadoopConfigurationUtils.getAllFilePaths(configuration, new String[]{path});
                    if (allPaths.isEmpty()) {
                        this.logger.warn((Object)"hive table is empty with no data");
                        return 1001;
                    }
                    HivePlugInConfiguration.setInputPaths(configuration, path);
                }
            } else {
                if (ConnectorStringUtils.isEmpty(sourceTableSchema)) {
                    throw new ConnectorException(31004);
                }
                String[] paths = HivePlugInConfiguration.getInputPaths(configuration).split(",");
                String allPaths = HadoopConfigurationUtils.getAllFilePaths(configuration, paths);
                HivePlugInConfiguration.setInputPaths(configuration, allPaths);
                if (ConnectorConfiguration.getInputSerDe(configuration).contains("RCFile")) {
                    HiveConf hiveConf = new HiveConf(configuration, HiveInputProcessor.class);
                    HiveUtils.loadHiveConf((Configuration)hiveConf, ConnectorConfiguration.direction.input);
                    HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
                    HivePlugInConfiguration.setInputRCFileSerde(configuration, client.getConfigValue("hive.default.rcfile.serde", ""));
                }
            }
            String[] sourceFieldNames = HivePlugInConfiguration.getInputFieldNamesArray(configuration);
            if (sourceFieldNames.length > 0) {
                sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(configuration);
                String sourcePartitionSchema = HivePlugInConfiguration.getInputPartitionSchema(configuration);
                HiveUtils.checkFieldNamesInSchema(sourceFieldNames, sourceTableSchema, sourcePartitionSchema);
            }
            this.setupSchema(configuration);
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnknownDBException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (TException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public int inputPostProcessor(JobContext context) throws ConnectorException {
        return 0;
    }

    private void setupSchema(Configuration configuration) throws ConnectorException {
        boolean isUDMapper;
        boolean partitioned = false;
        List<String> pcolumnNames = null;
        String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(configuration).trim();
        String partitionSchema = HivePlugInConfiguration.getInputPartitionSchema(configuration).trim();
        if (partitionSchema.length() > 0) {
            partitioned = true;
            List<String> pcolumns = ConnectorSchemaUtils.parseColumns(partitionSchema.toLowerCase());
            pcolumnNames = ConnectorSchemaUtils.parseColumnNames(pcolumns);
            sourceTableSchema = sourceTableSchema + "," + partitionSchema;
        }
        List<String> columns = ConnectorSchemaUtils.parseColumns(sourceTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        if (HivePlugInConfiguration.getInputFieldNamesArray(configuration).length == 0) {
            HivePlugInConfiguration.setInputFieldNamesArray(configuration, columnNames.toArray(new String[columnNames.size()]));
        }
        String[] fieldNames = HivePlugInConfiguration.getInputFieldNamesArray(configuration);
        HivePlugInConfiguration.setInputTableFieldTypes(configuration, columnTypes.toArray(new String[columnTypes.size()]));
        HivePlugInConfiguration.setInputTableFieldNamesArray(configuration, columnNames.toArray(new String[columnNames.size()]));
        boolean bl = isUDMapper = !ConnectorConfiguration.getJobMapper(configuration).isEmpty();
        if (!isUDMapper) {
            ConnectorRecordSchema r = new ConnectorRecordSchema(fieldNames.length);
            int[] columnMapping = HiveSchemaUtils.getColumnMapping(columnNames.toArray(new String[columnNames.size()]), fieldNames);
            for (int i = 0; i < columnMapping.length; ++i) {
                if (partitioned && pcolumnNames.contains(columnNames.get(columnMapping[i]))) {
                    r.setFieldType(i, 12);
                    continue;
                }
                r.setFieldType(i, HiveSchemaUtils.lookupHiveDataTypeByName(columnTypes.get(columnMapping[i])));
            }
            ConnectorSchemaUtils.formalizeConnectorRecordSchema(r);
            ConnectorRecordSchema userSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration));
            if (userSchema != null) {
                HiveSchemaUtils.checkSchemaMatch(userSchema, r);
            } else {
                ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(r));
            }
        }
    }
}

