/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class HiveRCFileRecordReader<K, V>
extends RecordReader<LongWritable, BytesRefArrayWritable> {
    private RCFile.Reader reader;
    private long start;
    private long end;
    private boolean endReached = false;
    private LongWritable key = null;
    private BytesRefArrayWritable value = null;
    protected Configuration configuration;

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.reader.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public BytesRefArrayWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        this.configuration = context.getConfiguration();
        Path path = fileSplit.getPath();
        FileSystem fileSystem = path.getFileSystem(this.configuration);
        this.reader = new RCFile.Reader(fileSystem, path, this.configuration);
        this.end = fileSplit.getStart() + fileSplit.getLength();
        if (fileSplit.getStart() > this.reader.getPosition()) {
            this.reader.sync(fileSplit.getStart());
        }
        this.start = this.reader.getPosition();
        this.endReached = this.start >= this.end;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.endReached) {
            return false;
        }
        if (this.key == null) {
            this.key = new LongWritable();
        }
        if (this.value == null) {
            this.value = new BytesRefArrayWritable();
        }
        boolean bl = this.endReached = !this.reader.next(this.key);
        if (this.endReached) {
            return false;
        }
        long lastSeenSyncPos = this.reader.lastSeenSyncPos();
        if (lastSeenSyncPos >= this.end) {
            this.endReached = true;
            return false;
        }
        this.reader.getCurrentRow(this.value);
        return true;
    }
}

