/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.utils;

import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;

public abstract class HdfsTextTransform {
    protected String nullString;
    protected String nullNonString;
    protected boolean customNullSet;

    private static long parseDateTimeWithFMTTZ(String value, DateFormat df, List<DateFormat> backupDateFormat, TimeZone sourceTimezone) {
        long milliSec;
        Calendar parseCal;
        block7: {
            java.util.Date d = null;
            parseCal = null;
            milliSec = 0L;
            try {
                d = df.parse(value);
                milliSec = d.getTime();
                parseCal = df.getCalendar();
            }
            catch (ParseException e) {
                for (int i = 0; i < backupDateFormat.size(); ++i) {
                    DateFormat dateFormat = backupDateFormat.get(i);
                    try {
                        d = dateFormat.parse(value);
                        milliSec = d.getTime();
                        parseCal = dateFormat.getCalendar();
                        break;
                    }
                    catch (ParseException e1) {
                        continue;
                    }
                }
                if (d != null) break block7;
                throw new RuntimeException(e);
            }
        }
        if (sourceTimezone == null) {
            return milliSec;
        }
        if (parseCal.isSet(15)) {
            milliSec = ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(milliSec, sourceTimezone);
        }
        return milliSec;
    }

    private HdfsTextTransform() {
        this.nullNonString = this.nullString = null;
        this.customNullSet = false;
    }

    public abstract int getType();

    public abstract Object transform(String var1);

    public abstract String toString(Object var1);

    public void setNullString(String nullString) {
        this.nullString = nullString;
        this.customNullSet = true;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullNonString(String nullNonString) {
        this.nullNonString = nullNonString;
        this.customNullSet = true;
    }

    public String getNullNonString() {
        return this.nullNonString;
    }

    public void setCustomNullSet(boolean customeNullSet) {
        this.customNullSet = customeNullSet;
    }

    public boolean getCustomNullSet() {
        return this.customNullSet;
    }

    public static HdfsTextTransform[] lookupTextTransformClass(String recordSchema, String nullString, String nullNonString, Configuration configuration, ConnectorConfiguration.direction direction2) {
        List<String> recordDataTypes = ConnectorSchemaUtils.parseColumnTypes(ConnectorSchemaUtils.parseColumns(recordSchema));
        HdfsTextTransform[] transformFunction = new HdfsTextTransform[recordDataTypes.size()];
        int i = 0;
        for (String dataType : recordDataTypes) {
            switch (HdfsSchemaUtils.lookupHdfsAvroDatatype(dataType)) {
                case 4: {
                    transformFunction[i] = new IntTransform();
                    break;
                }
                case -5: {
                    transformFunction[i] = new BigIntTransform();
                    break;
                }
                case 5: {
                    transformFunction[i] = new SmallIntTransform();
                    break;
                }
                case -6: {
                    transformFunction[i] = new TinyIntTransform();
                    break;
                }
                case 2: 
                case 3: {
                    transformFunction[i] = new DecimalTransform();
                    break;
                }
                case 91: {
                    String dateFormat = direction2 == ConnectorConfiguration.direction.input ? ConnectorConfiguration.getInputDateFormat(configuration) : ConnectorConfiguration.getOutputDateFormat(configuration);
                    transformFunction[i] = new DateTransformFMT(dateFormat).setupBackupDateFormat(configuration);
                    break;
                }
                case 92: {
                    String timezoneId;
                    String timeFormat;
                    if (direction2 == ConnectorConfiguration.direction.input) {
                        timeFormat = ConnectorConfiguration.getInputTimeFormat(configuration);
                        timezoneId = ConnectorConfiguration.getInputTimezoneId(configuration);
                    } else {
                        timeFormat = ConnectorConfiguration.getOutputTimeFormat(configuration);
                        timezoneId = ConnectorConfiguration.getOutputTimezoneId(configuration);
                    }
                    transformFunction[i] = new TimeTransformFMT(timezoneId, timeFormat, direction2).setupBackupDateFormat(configuration);
                    break;
                }
                case 93: {
                    String tsFormat;
                    String timezoneId;
                    if (direction2 == ConnectorConfiguration.direction.input) {
                        tsFormat = ConnectorConfiguration.getInputTimestampFormat(configuration);
                        timezoneId = ConnectorConfiguration.getInputTimezoneId(configuration);
                    } else {
                        tsFormat = ConnectorConfiguration.getOutputTimestampFormat(configuration);
                        timezoneId = ConnectorConfiguration.getOutputTimezoneId(configuration);
                    }
                    transformFunction[i] = new TimeStampTransformFMT(timezoneId, tsFormat, direction2).setupBackupDateFormat(configuration);
                    break;
                }
                case 6: {
                    transformFunction[i] = new FloatTransform();
                    break;
                }
                case 7: 
                case 8: {
                    transformFunction[i] = new DoubleTransform();
                    break;
                }
                case 16: {
                    transformFunction[i] = new BooleanTransform();
                    break;
                }
                case -3: 
                case -2: {
                    transformFunction[i] = new BinaryTransform();
                    break;
                }
                case 2004: {
                    transformFunction[i] = new BlobTransform();
                    break;
                }
                case 2005: {
                    transformFunction[i] = new ClobTransform();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    transformFunction[i] = new VarcharTransform();
                    break;
                }
                default: {
                    transformFunction[i] = new OtherTransform();
                }
            }
            if (!nullString.isEmpty() || !nullNonString.isEmpty()) {
                transformFunction[i].setCustomNullSet(true);
                transformFunction[i].setNullString(nullString);
                transformFunction[i].setNullNonString(nullNonString);
            }
            ++i;
        }
        return transformFunction;
    }

    public static class OtherTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 1882;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullString) ? null : value;
            }
            return value == null || value.length() == 0 ? null : value;
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class FloatTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 6;
        }

        @Override
        public Object transform(String value) {
            return value == null || value.length() == 0 ? null : Float.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class BooleanTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 16;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Boolean.valueOf(value);
            }
            return value == null || value.length() == 0 ? null : Boolean.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class ClobTransform
    extends HdfsTextTransform {
        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.equals(this.nullString) ? null : value;
            }
            return value == null || value.length() == 0 ? null : value;
        }

        @Override
        public final int getType() {
            return 2005;
        }

        @Override
        public String toString(Object value) {
            return (String)value;
        }
    }

    public static class BlobTransform
    extends HdfsTextTransform {
        @Override
        public final int getType() {
            return 2004;
        }

        @Override
        public Object transform(String value) {
            if (value == null || value.length() == 0) {
                return new byte[0];
            }
            if (this.customNullSet && value.equals(this.nullNonString)) {
                return new byte[0];
            }
            int len = value.length();
            switch (len) {
                case 0: {
                    return new byte[0];
                }
                case 1: {
                    byte[] bytesData = new byte[]{(byte)Character.digit(value.charAt(0), 16)};
                    return bytesData;
                }
            }
            byte[] bytesData = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                bytesData[i / 2] = (byte)((Character.digit(value.charAt(i), 16) << 4) + Character.digit(value.charAt(i + 1), 16));
            }
            return bytesData;
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class BinaryTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return -2;
        }

        public byte[] toBytes(String str) {
            char[] buffer = str.toCharArray();
            byte[] b = new byte[buffer.length << 1];
            for (int i = 0; i < buffer.length; ++i) {
                int bpos = i << 1;
                b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
                b[bpos + 1] = (byte)(buffer[i] & 0xFF);
            }
            return b;
        }

        @Override
        public Object transform(String value) {
            if (value == null || value.length() == 0) {
                return new byte[0];
            }
            if (this.customNullSet && value.equals(this.nullNonString)) {
                return new byte[0];
            }
            int len = value.length();
            switch (len) {
                case 0: {
                    return new byte[0];
                }
            }
            return this.toBytes(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class DoubleTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 8;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Double.valueOf(value);
            }
            return value == null || value.length() == 0 ? null : Double.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class VarcharTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 12;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.equals(this.nullString) ? null : value;
            }
            return value == null || value.length() == 0 ? null : value;
        }

        @Override
        public String toString(Object value) {
            return (String)value;
        }
    }

    public static class TimeStampTransformFMT
    extends HdfsTextTransform {
        private DateFormat df;
        private TimeZone timeZoneInfo;
        private List<DateFormat> backupDateFormat;

        public HdfsTextTransform setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.timestamp.format");
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                SimpleDateFormat df = new SimpleDateFormat(values.get(i));
                this.backupDateFormat.add(df);
            }
            return this;
        }

        public TimeStampTransformFMT(String timezoneId, String format, ConnectorConfiguration.direction d) {
            this.timeZoneInfo = timezoneId.trim().isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneId);
            if (format == null || format.isEmpty()) {
                this.df = null;
            } else {
                this.df = new SimpleDateFormat(format);
                if (d == ConnectorConfiguration.direction.output) {
                    this.df.setTimeZone(this.timeZoneInfo);
                }
            }
        }

        @Override
        public int getType() {
            return 93;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet ? value == null || value.length() == 0 || value.equals(this.nullNonString) : value == null || value.length() == 0) {
                return null;
            }
            long milliSec = 0L;
            if (this.df == null) {
                Timestamp ts = Timestamp.valueOf(value);
                return ts;
            }
            milliSec = HdfsTextTransform.parseDateTimeWithFMTTZ(value, this.df, this.backupDateFormat, this.timeZoneInfo);
            return new Timestamp(milliSec);
        }

        @Override
        public String toString(Object value) {
            if (this.df == null) {
                return value.toString();
            }
            Timestamp ts = (Timestamp)value;
            long milliSec = ts.getTime();
            milliSec = ConnectorDataTypeConverter.convertMillisecFromSourceToDefaultTZ(milliSec, this.timeZoneInfo);
            ts.setTime(milliSec);
            return this.df.format(value);
        }
    }

    public static class TimeTransformFMT
    extends HdfsTextTransform {
        private DateFormat df;
        private TimeZone timezoneInfo;
        private List<DateFormat> backupDateFormat;

        public HdfsTextTransform setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.time.format");
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                SimpleDateFormat df = new SimpleDateFormat(values.get(i));
                this.backupDateFormat.add(df);
            }
            return this;
        }

        public TimeTransformFMT(String timezoneId, String format, ConnectorConfiguration.direction d) {
            this.timezoneInfo = timezoneId.trim().isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneId);
            if (format == null || format.isEmpty()) {
                this.df = null;
            } else {
                this.df = new SimpleDateFormat(format);
                if (d == ConnectorConfiguration.direction.output) {
                    this.df.setTimeZone(this.timezoneInfo);
                }
            }
        }

        @Override
        public int getType() {
            return 92;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet ? value == null || value.length() == 0 || value.equals(this.nullNonString) : value == null || value.length() == 0) {
                return null;
            }
            if (this.df == null) {
                return Time.valueOf(value);
            }
            long milliSec = HdfsTextTransform.parseDateTimeWithFMTTZ(value, this.df, this.backupDateFormat, this.timezoneInfo);
            return new Time(milliSec);
        }

        @Override
        public String toString(Object value) {
            if (this.df == null) {
                return value.toString();
            }
            Time ts = (Time)value;
            long milliSec = ts.getTime();
            milliSec = ConnectorDataTypeConverter.convertMillisecFromSourceToDefaultTZ(milliSec, this.timezoneInfo);
            ts.setTime(milliSec);
            return this.df.format((Time)value);
        }
    }

    public static class DateTransformFMT
    extends HdfsTextTransform {
        DateFormat df;
        private List<DateFormat> backupDateFormat;

        public HdfsTextTransform setupBackupDateFormat(Configuration conf) {
            List<String> values = ConnectorConfiguration.getAllConfigurationItems(conf, "tdch.input.date.format");
            this.backupDateFormat = new ArrayList<DateFormat>();
            for (int i = 0; i < values.size(); ++i) {
                SimpleDateFormat df = new SimpleDateFormat(values.get(i));
                this.backupDateFormat.add(df);
            }
            return this;
        }

        public DateTransformFMT(String format) {
            this.df = format == null || format.isEmpty() ? null : new SimpleDateFormat(format);
        }

        @Override
        public int getType() {
            return 91;
        }

        @Override
        public Object transform(String value) {
            java.util.Date d;
            block7: {
                if (this.customNullSet ? value == null || value.length() == 0 || value.equals(this.nullNonString) : value == null || value.length() == 0) {
                    return null;
                }
                if (this.df == null) {
                    return Date.valueOf(value);
                }
                d = null;
                try {
                    d = this.df.parse(value);
                }
                catch (ParseException e) {
                    for (int i = 0; i < this.backupDateFormat.size(); ++i) {
                        DateFormat dateFormat = this.backupDateFormat.get(i);
                        try {
                            d = dateFormat.parse(value);
                            break;
                        }
                        catch (ParseException e1) {
                            continue;
                        }
                    }
                    if (d != null) break block7;
                    throw new RuntimeException(e);
                }
            }
            return new Date(d.getTime());
        }

        @Override
        public String toString(Object value) {
            if (this.df == null) {
                return value.toString();
            }
            return this.df.format((Date)value);
        }
    }

    public static class DecimalTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : new BigDecimal(value);
            }
            return value == null || value.length() == 0 ? null : new BigDecimal(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class TinyIntTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return -6;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Byte.valueOf(value);
            }
            return value == null || value.length() == 0 ? null : Byte.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class SmallIntTransform
    extends HdfsTextTransform {
        @Override
        public int getType() {
            return 5;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Short.valueOf(value);
            }
            return value == null || value.length() == 0 ? null : Short.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class BigIntTransform
    extends HdfsTextTransform {
        @Override
        public final int getType() {
            return -5;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Long.valueOf(value);
            }
            return value == null || value.length() == 0 ? null : Long.valueOf(value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }

    public static class IntTransform
    extends HdfsTextTransform {
        @Override
        public final int getType() {
            return 4;
        }

        @Override
        public Object transform(String value) {
            if (this.customNullSet) {
                return value == null || value.length() == 0 || value.equals(this.nullNonString) ? null : Integer.valueOf(value.trim());
            }
            return value == null || value.length() == 0 ? null : Integer.valueOf(value.trim());
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }
    }
}

