/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class HdfsAvroSchemaUtils {
    private static Log logger = LogFactory.getLog(HdfsAvroSchemaUtils.class);

    public static boolean avroFieldsSetDefaultOrNull(Schema s, String[] fieldNames) {
        List fields = s.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            int j;
            Schema.Field field = (Schema.Field)fields.get(i);
            for (j = 0; j < fieldNames.length && !field.name().equals(fieldNames[j].trim()); ++j) {
            }
            if (j != fieldNames.length || field.defaultValue() != null || HdfsAvroSchemaUtils.avroSchemaIsNullable(field)) continue;
            return false;
        }
        return true;
    }

    public static boolean avroSchemaIsNullable(Schema.Field field) {
        if (field.schema().getType().equals((Object)Schema.Type.NULL)) {
            return true;
        }
        if (field.schema().getType().equals((Object)Schema.Type.UNION)) {
            List types = field.schema().getTypes();
            for (int k = 0; k < types.size(); ++k) {
                Schema subSchema = (Schema)types.get(k);
                if (!subSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                return true;
            }
        }
        return false;
    }

    public static Schema buildAvroSchemaFromFile(Configuration configuration, String avroschemafile) throws ConnectorException {
        if (avroschemafile.trim().equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String tmp;
            Path filePath = new Path(avroschemafile);
            FileSystem fs = filePath.getFileSystem(configuration);
            logger.info((Object)("Using avro schema in file : " + fs.makeQualified(filePath)));
            if (!fs.exists(filePath)) {
                throw new ConnectorException(50001);
            }
            if (!fs.isFile(filePath)) {
                throw new ConnectorException(50002);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(filePath)));
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return new Schema.Parser().parse(sb.toString());
    }

    public static Schema fetchSchemaFromInputPath(Configuration configuration) throws ConnectorException {
        String inputDir = configuration.get("mapred.input.dir", "");
        String[] paths = StringUtils.split((String)inputDir);
        Path[] inputPath = new Path[paths.length];
        Schema s = null;
        FileSystem fileSystem = null;
        for (int i = 0; i < inputPath.length; ++i) {
            FileStatus[] fs;
            Path path = new Path(StringUtils.unEscapeString((String)paths[i]));
            try {
                if (fileSystem == null) {
                    fileSystem = path.getFileSystem(configuration);
                }
                if ((fs = fileSystem.listStatus(path)) == null) {
                    continue;
                }
            }
            catch (FileNotFoundException e) {
                logger.debug((Object)ConnectorStringUtils.getExceptionStack(e));
                continue;
            }
            catch (IOException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            for (int j = 0; j < fs.length; ++j) {
                try {
                    Path filepath = fs[j].getPath();
                    FsInput si = new FsInput(filepath, configuration);
                    DataFileReader dfr = new DataFileReader((SeekableInput)si, (DatumReader)new ReflectDatumReader());
                    s = dfr.getSchema();
                    dfr.close();
                    si.close();
                }
                catch (IOException e) {
                    logger.debug((Object)ConnectorStringUtils.getExceptionStack(e));
                    continue;
                }
                if (s == null) continue;
                return s;
            }
        }
        return s;
    }

    public static void checkFieldNamesInSchema(String[] fieldNames, Schema avroSchema) throws ConnectorException {
        List fields = avroSchema.getFields();
        ArrayList<String> avroFields = new ArrayList<String>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            avroFields.add(((Schema.Field)fields.get(i)).name());
        }
        HdfsSchemaUtils.checkFieldNames(fieldNames, Arrays.asList(fieldNames));
    }

    public static int[] getAvroColumnMapping(Schema avroSchema, String[] mappingNames) throws ConnectorException {
        List fields = avroSchema.getFields();
        ArrayList<String> avroFields = new ArrayList<String>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            avroFields.add(((Schema.Field)fields.get(i)).name());
        }
        return HdfsSchemaUtils.getColumnMapping(avroFields, mappingNames);
    }

    public static void formalizeAvroRecordSchema(List<Schema.Field> fields, ConnectorRecordSchema avroSchema, int[] mapping) throws ConnectorException {
        for (int i = 0; i < avroSchema.getLength(); ++i) {
            int index = mapping == null ? i : mapping[i];
            Schema.Field field = fields.get(index);
            int type = HdfsSchemaUtils.lookupHdfsAvroDatatype(field.schema().getType().getName());
            if (type != -2005) continue;
            avroSchema.setFieldType(i, 1882);
        }
    }
}

