/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hdfs.converter.HdfsAvroConverter;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeConverter;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeDefinition;
import com.teradata.connector.hdfs.utils.HdfsAvroSchemaUtils;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.nio.ByteBuffer;
import java.util.List;
import junit.framework.Assert;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.mapred.AvroKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsAvroSerDe
implements ConnectorSerDe {
    protected Configuration configuration;
    protected ConnectorRecord sourceConnectorRecord = null;
    protected GenericRecord avroRecord;
    protected ObjectWritable objectWritable = null;
    protected GenericRecord record;
    private AvroKey<GenericRecord> key = null;
    protected int[] mappings = null;
    JobContext context;
    protected List<Schema.Field> fields;
    int sourceRecordLen;
    int targetRecordLen;
    private ConnectorDataTypeConverter[] serConverter;
    private ConnectorDataTypeConverter[] deserConverter;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        this.configuration = context.getConfiguration();
        this.context = context;
        if (direction2 == ConnectorConfiguration.direction.input) {
            String[] fieldnames = HdfsPlugInConfiguration.getInputFieldNamesArray(this.configuration);
            Schema s = new Schema.Parser().parse(HdfsPlugInConfiguration.getInputAvroSchema(this.configuration));
            if (fieldnames.length > 0) {
                this.mappings = HdfsAvroSchemaUtils.getAvroColumnMapping(s, fieldnames);
                this.sourceConnectorRecord = new ConnectorRecord(this.mappings.length);
                this.sourceRecordLen = this.mappings.length;
            } else {
                this.sourceRecordLen = s.getFields().size();
                this.sourceConnectorRecord = new ConnectorRecord(this.sourceRecordLen);
            }
            this.fields = s.getFields();
            this.initializeJsonEncoder();
        } else {
            String[] fieldnames = HdfsPlugInConfiguration.getOutputFieldNamesArray(this.configuration);
            this.objectWritable = new ObjectWritable();
            this.key = new AvroKey();
            Schema s = new Schema.Parser().parse(HdfsPlugInConfiguration.getOutputAvroSchema(this.configuration));
            GenericRecordBuilder recordBuilder = new GenericRecordBuilder(s);
            this.fields = s.getFields();
            for (int i = 0; i < this.fields.size(); ++i) {
                Schema.Field f = this.fields.get(i);
                if (f.defaultValue() != null) {
                    recordBuilder.clear(f);
                    continue;
                }
                if (!HdfsAvroSchemaUtils.avroSchemaIsNullable(f)) {
                    recordBuilder.set(f, HdfsAvroDataTypeDefinition.getAvroDefaultNullValue(f.schema()));
                    continue;
                }
                recordBuilder.set(f, null);
            }
            this.record = recordBuilder.build();
            this.key.datum((Object)this.record);
            this.objectWritable.set(this.key);
            if (fieldnames.length > 0) {
                this.mappings = HdfsAvroSchemaUtils.getAvroColumnMapping(s, fieldnames);
                this.targetRecordLen = this.mappings.length;
            } else {
                this.targetRecordLen = s.getFields().size();
            }
            this.initializeJsonDecoder();
        }
    }

    @Override
    public Writable serialize(ConnectorRecord connectorRecord) throws ConnectorException {
        for (int i = 0; i < connectorRecord.getAllObject().length; ++i) {
            Object object = connectorRecord.get(i);
            int mIndex = this.mappings == null ? i : this.mappings[i];
            Schema.Field f = this.fields.get(mIndex);
            if (object == null) {
                if (HdfsAvroSchemaUtils.avroSchemaIsNullable(f)) {
                    this.record.put(mIndex, null);
                    continue;
                }
                this.record.put(mIndex, HdfsAvroDataTypeDefinition.getAvroDefaultNullValue(f.schema()));
                continue;
            }
            int orgType = HdfsSchemaUtils.lookupHdfsAvroDatatype(f.schema().getType().getName());
            this.record.put(mIndex, this.avroTypeDecoder(object, orgType, i));
        }
        return this.objectWritable;
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        Object objectwritable = ((ObjectWritable)writable).get();
        this.avroRecord = (GenericRecord)((AvroKey)objectwritable).datum();
        for (int i = 0; i < this.sourceRecordLen; ++i) {
            int index = this.mappings == null ? i : this.mappings[i];
            int orgType = HdfsSchemaUtils.lookupHdfsAvroDatatype(this.fields.get(index).schema().getType().getName());
            this.sourceConnectorRecord.set(i, this.avroTypeEncoder(this.avroRecord.get(index), orgType, i));
        }
        return this.sourceConnectorRecord;
    }

    private Object avroTypeDecoder(Object o, int orgType, int index) {
        Assert.assertTrue((o != null ? 1 : 0) != 0);
        if (!HdfsAvroConverter.isComplexType(orgType)) {
            return o;
        }
        return this.serConverter[index].convert(o);
    }

    private Object avroTypeEncoder(Object o, int orgType, int index) {
        if (orgType == -2) {
            return ((ByteBuffer)o).array();
        }
        if (!HdfsAvroConverter.isComplexType(orgType)) {
            return o;
        }
        return this.deserConverter[index].convert(o);
    }

    private void initializeJsonDecoder() throws ConnectorException {
        Schema targetAvroSchema = new Schema.Parser().parse(HdfsPlugInConfiguration.getOutputAvroSchema(this.configuration));
        ConnectorRecordSchema sourceRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(this.configuration));
        this.serConverter = new ConnectorDataTypeConverter[sourceRecordSchema.getLength()];
        for (int i = 0; i < this.serConverter.length; ++i) {
            int sourceType = sourceRecordSchema.getFieldType(i);
            int index = this.mappings != null ? this.mappings[i] : i;
            Schema targetSchema = ((Schema.Field)targetAvroSchema.getFields().get(index)).schema();
            int targetType = HdfsAvroDataTypeDefinition.getAvroDataType(targetSchema);
            HdfsAvroDataTypeConverter converter = null;
            if (!HdfsAvroConverter.isComplexType(targetType)) continue;
            converter = targetType == -2005 ? HdfsAvroConverter.lookupSimpleTypeToAvroUnionConverter(this.context, targetSchema, sourceType) : (targetType == -2000 ? new HdfsAvroDataTypeConverter.AvroNull() : new HdfsAvroDataTypeConverter.JsonStringToAvroObject(targetSchema));
            this.serConverter[i] = converter;
        }
    }

    private void initializeJsonEncoder() throws ConnectorException {
        Schema sourceAvroSchema = new Schema.Parser().parse(HdfsPlugInConfiguration.getInputAvroSchema(this.configuration));
        ConnectorRecordSchema targetSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(this.configuration));
        this.deserConverter = new ConnectorDataTypeConverter[targetSchema.getLength()];
        for (int i = 0; i < this.deserConverter.length; ++i) {
            HdfsAvroDataTypeConverter converter;
            int index = this.mappings == null ? i : this.mappings[i];
            Schema sourceFieldSchema = ((Schema.Field)sourceAvroSchema.getFields().get(index)).schema();
            int sourceType = HdfsAvroDataTypeDefinition.getAvroDataType(sourceFieldSchema);
            Assert.assertTrue((!HdfsAvroConverter.isComplexType(targetSchema.getFieldType(i)) ? 1 : 0) != 0);
            if (!HdfsAvroConverter.isComplexType(sourceType)) continue;
            switch (sourceType) {
                case -2005: {
                    Assert.assertTrue((targetSchema.getFieldType(i) == 12 || targetSchema.getFieldType(i) == 1882 ? 1 : 0) != 0);
                    converter = HdfsAvroConverter.lookupAvroUnionToSimpleTypeConverter(this.context, sourceFieldSchema, targetSchema.getFieldType(i));
                    break;
                }
                case -2006: 
                case -2004: 
                case -2003: 
                case -2002: 
                case -2001: {
                    converter = new HdfsAvroDataTypeConverter.AvroObjectToJsonString(sourceFieldSchema);
                    converter.setDefaultValue("");
                    break;
                }
                case -2000: {
                    converter = new HdfsAvroDataTypeConverter.AvroNull();
                    break;
                }
                default: {
                    throw new ConnectorException(50012);
                }
            }
            converter.setNullable(true);
            this.deserConverter[i] = converter;
        }
    }
}

