/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.processor;

import com.teradata.connector.common.ConnectorInputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsTextFileInputProcessor
implements ConnectorInputProcessor {
    private Log logger = LogFactory.getLog(HdfsTextFileInputProcessor.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int inputPreProcessor(JobContext context) throws ConnectorException {
        ConnectorRecordSchema userRecordSchema;
        Configuration configuration = context.getConfiguration();
        String inputPaths = HdfsPlugInConfiguration.getInputPaths(configuration);
        if (inputPaths.isEmpty()) {
            String dir = configuration.get("mapred.input.dir", "");
            if (dir.isEmpty()) {
                throw new ConnectorException(13005);
            }
            HdfsPlugInConfiguration.setInputPaths(configuration, dir);
        }
        try {
            inputPaths = HdfsPlugInConfiguration.getInputPaths(configuration);
            String allPaths = HadoopConfigurationUtils.getAllFilePaths(configuration, new String[]{inputPaths});
            if (allPaths.isEmpty()) {
                this.logger.warn((Object)"HDFS input source path is empty with no data");
                return 1001;
            }
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        String[] fieldnames = HdfsPlugInConfiguration.getInputFieldNamesArray(configuration);
        String sourceSchema = HdfsPlugInConfiguration.getInputSchema(configuration);
        if (fieldnames.length > 0 && sourceSchema.isEmpty()) {
            throw new ConnectorException(50009);
        }
        if (fieldnames.length > 0 && !sourceSchema.isEmpty()) {
            HdfsSchemaUtils.checkFieldNamesInSchema(fieldnames, sourceSchema);
        }
        if (!ConnectorConfiguration.getJobMapper(configuration).isEmpty()) {
            return 0;
        }
        boolean bl = false;
        boolean isUDMapper = bl;
        if (isUDMapper) return 0;
        List<String> schemaFieldNames = null;
        List<String> schemaFieldDataTypes = null;
        List<String> schemaFields = null;
        if (!sourceSchema.isEmpty()) {
            schemaFields = ConnectorSchemaUtils.parseColumns(sourceSchema.toLowerCase());
            schemaFieldNames = ConnectorSchemaUtils.parseColumnNames(schemaFields);
            schemaFieldDataTypes = ConnectorSchemaUtils.parseColumnTypes(schemaFields);
        }
        if ((userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration))) != null) {
            if (sourceSchema.isEmpty()) throw new ConnectorException(50008);
            if (fieldnames.length != 0) {
                if (userRecordSchema.getLength() == fieldnames.length) return 0;
                throw new ConnectorException(14013);
            }
            if (userRecordSchema.getLength() != schemaFields.size()) {
                throw new ConnectorException(14013);
            }
            HdfsSchemaUtils.checkDataType(schemaFieldDataTypes, userRecordSchema.getFieldTypes());
            return 0;
        }
        ConnectorRecordSchema sourceRecordSchema = null;
        if (schemaFieldNames == null) return 0;
        if (schemaFieldNames.size() <= 0) return 0;
        if (fieldnames.length > 0) {
            int[] mapping = HdfsSchemaUtils.getColumnMapping(schemaFieldNames, fieldnames);
            sourceRecordSchema = new ConnectorRecordSchema(fieldnames.length);
            for (int index = 0; index < fieldnames.length; ++index) {
                sourceRecordSchema.setFieldType(index, HdfsSchemaUtils.lookupHdfsAvroDatatype(schemaFieldDataTypes.get(mapping[index])));
            }
        } else {
            sourceRecordSchema = new ConnectorRecordSchema(schemaFieldNames.size());
            for (int index = 0; index < schemaFieldNames.size(); ++index) {
                sourceRecordSchema.setFieldType(index, HdfsSchemaUtils.lookupHdfsAvroDatatype(schemaFieldDataTypes.get(index)));
            }
        }
        ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(sourceRecordSchema)));
        return 0;
    }

    @Override
    public int inputPostProcessor(JobContext context) throws ConnectorException {
        return 0;
    }
}

