/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.converter;

import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeDefinition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;

public abstract class HdfsAvroDataTypeConverter
extends ConnectorDataTypeConverter {

    public static final class AvroNull
    extends HdfsAvroDataTypeConverter {
        @Override
        public Object convert(Object object) {
            return null;
        }
    }

    public static final class ByteArrayToAvroBinary
    extends ConnectorDataTypeConverter {
        @Override
        public Object convert(Object object) {
            if (object == null) {
                return ByteBuffer.allocate(0);
            }
            byte[] bytes = (byte[])object;
            ByteBuffer bb = ByteBuffer.allocate(bytes.length);
            System.arraycopy(bytes, 0, bb.array(), 0, bytes.length);
            return bb;
        }
    }

    public static final class AvroBinaryToString
    extends HdfsAvroDataTypeConverter {
        private ConnectorDataTypeConverter.BinaryToString bts = new ConnectorDataTypeConverter.BinaryToString();

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : "";
            }
            return this.bts.convert(((ByteBuffer)object).array());
        }
    }

    public static final class BlobToAvroBinary
    extends HdfsAvroDataTypeConverter {
        private ConnectorDataTypeConverter.BlobToBinary blobToBytes = new ConnectorDataTypeConverter.BlobToBinary();

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return null;
            }
            byte[] bytes = (byte[])this.blobToBytes.convert(object);
            if (bytes.length == 0) {
                return ByteBuffer.allocate(0);
            }
            ByteBuffer bb = ByteBuffer.allocate(bytes.length);
            System.arraycopy(bytes, 0, bb.array(), 0, bytes.length);
            return bb;
        }
    }

    public static final class AvroBinaryToBytes
    extends HdfsAvroDataTypeConverter {
        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : HdfsAvroDataTypeDefinition.BYTE_NULL_VALUE;
            }
            return ((ByteBuffer)object).array();
        }
    }

    public static final class NonStringToAvroUnion
    extends HdfsAvroDataTypeConverter {
        private ConnectorDataTypeConverter[] converters;

        public void setConverter(ConnectorDataTypeConverter[] c) {
            this.converters = c;
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            Object o = null;
            boolean canCast = false;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.converters.length; ++i) {
                if (this.converters[i] == null) continue;
                try {
                    o = this.converters[i].convert(object);
                }
                catch (Exception e) {
                    sb.append(ConnectorStringUtils.getExceptionStack(e));
                    sb.append("\n");
                    o = null;
                    continue;
                }
                canCast = true;
                if (o == null) continue;
                return o;
            }
            if (!canCast) {
                throw new RuntimeException(sb.toString());
            }
            return o;
        }
    }

    public static final class AvroUnionToSimpleType
    extends HdfsAvroDataTypeConverter {
        private ConnectorDataTypeConverter[] converters;

        public void setConverter(ConnectorDataTypeConverter[] c) {
            this.converters = c;
        }

        @Override
        public Object convert(Object object) {
            Object o = null;
            boolean canCast = false;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.converters.length; ++i) {
                if (this.converters[i] == null) continue;
                try {
                    o = this.converters[i].convert(object);
                }
                catch (Exception e) {
                    sb.append(ConnectorStringUtils.getExceptionStack(e));
                    sb.append("\n");
                    o = null;
                    continue;
                }
                canCast = true;
                if (o == null) continue;
                return o;
            }
            if (!canCast) {
                throw new RuntimeException(sb.toString());
            }
            return o;
        }
    }

    public static final class AvroObjectToJsonString
    extends HdfsAvroDataTypeConverter {
        private Schema fieldSchema;
        private GenericDatumWriter<Object> w;
        private ByteArrayOutputStream outstream;
        private JsonEncoder e;

        public AvroObjectToJsonString(Schema s) {
            this.fieldSchema = s;
            this.w = new GenericDatumWriter(s);
            this.outstream = new ByteArrayOutputStream();
            try {
                this.e = EncoderFactory.get().jsonEncoder(this.fieldSchema, (OutputStream)this.outstream);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : "";
            }
            this.outstream.reset();
            try {
                this.w.write(object, (Encoder)this.e);
                this.e.flush();
                return this.outstream.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static final class ClobToAvroObject
    extends HdfsAvroDataTypeConverter {
        private ConnectorDataTypeConverter.ClobToString clobToStr = new ConnectorDataTypeConverter.ClobToString();
        private JsonStringToAvroObject jSonToAvro;

        public ClobToAvroObject(Schema s) {
            this.jSonToAvro = new JsonStringToAvroObject(s);
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            String json_str = (String)this.clobToStr.convert(object);
            return this.jSonToAvro.convert(json_str);
        }
    }

    public static final class JsonStringToAvroObject
    extends HdfsAvroDataTypeConverter {
        private Schema fieldSchema;
        private GenericDatumReader<Object> r;
        private JsonDecoder e2;

        public JsonStringToAvroObject(Schema s) {
            this.fieldSchema = s;
            this.r = new GenericDatumReader(s);
            try {
                this.e2 = DecoderFactory.get().jsonDecoder(this.fieldSchema, "");
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Object convert(Object object) {
            try {
                if (object == null) {
                    return null;
                }
                this.e2.configure(object.toString());
                return this.r.read(null, (Decoder)this.e2);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

