/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hcat.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.Credentials;

@Deprecated
public class HCatSchemaUtils {
    private static Class<?> HCatFieldSchemaClass = null;
    private static Class<?> HCatInputFormatClass = null;
    private static Class<?> HCatOutputFormatClass = null;
    private static Class<?> HCatOutputJobInfoClass = null;
    private static Class<?> HCatSchemaClass = null;
    private static Class<?> HCatTableInfoClass = null;
    private static Constructor<?> HCatSchemaConstructor = null;
    private static Method HCatFieldSchemaGetNameMethod = null;
    private static Method HCatFieldSchemaGetTypeStringMethod = null;
    private static Method HCatInputFormatGetTableSchemaMethod = null;
    private static Method HCatInputFormatSetInputMethod = null;
    private static Method HCatOutputFormatSetOutputMethod = null;
    private static Method HCatOutputJobInfoCreateMethod = null;
    private static Method HCatOutputJobInfoGetTableInfoMethod = null;
    private static Method HCatOutputFormatSetSchemaMethod = null;
    private static Method HCatSchemaAppendMethod = null;
    private static Method HCatSchemaGetIntTypeMethod = null;
    private static Method HCatSchemaGetStringTypeMethod = null;
    private static Method HCatSchemaGetFieldsMethod = null;
    private static Method HCatSchemaGetFieldNamesMethod = null;
    private static Method HCatSchemaSizeMethod = null;
    private static Method HCatTableInfoGetDataColumnsMethod = null;
    private static Method HCatTableInfoGetPartitionColumnsMethod = null;

    public static String[] getTargetFieldsTypeNameFromHCatOutputFormat(JobContext context, String databaseName, String tableName, String[] fieldNames) throws ConnectorException {
        String[] types = new String[fieldNames.length];
        int i = 0;
        try {
            Object HCatSchemaInstance = HCatSchemaUtils.buildHCatSchemaInstanceFromHCatOutputFormat(context, databaseName, tableName);
            for (String name : fieldNames) {
                Object HCatFieldSchemaInstance = HCatSchemaGetStringTypeMethod.invoke(HCatSchemaInstance, name);
                types[i++] = (String)HCatFieldSchemaGetTypeStringMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return types;
    }

    public static List<String> getHCatSchemaFieldNamesFromHCatInputFormat(Configuration configuration, String databaseName, String tableName) throws ConnectorException {
        List fieldNames = null;
        try {
            HCatInputFormatSetInputMethod.invoke(null, configuration, databaseName, tableName);
            Object HCatSchemaInstance = HCatInputFormatGetTableSchemaMethod.invoke(null, configuration);
            fieldNames = (List)HCatSchemaGetFieldNamesMethod.invoke(HCatSchemaInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return fieldNames;
    }

    private static Object buildHCatSchemaInstanceFromHCatOutputFormat(JobContext context, String databaseName, String tableName) throws ConnectorException {
        Object HCatSchemaInstance;
        Configuration configuration = context.getConfiguration();
        try {
            Object HCatOutputJobInfoInstance = HCatOutputJobInfoCreateMethod.invoke(null, databaseName, tableName, null);
            HCatOutputFormatSetOutputMethod.invoke(null, configuration, context.getCredentials(), HCatOutputJobInfoInstance);
            HCatSchemaInstance = HCatSchemaConstructor.newInstance(new LinkedList());
            Object HCatTableInfoInstance = HCatOutputJobInfoGetTableInfoMethod.invoke(HCatOutputJobInfoInstance, new Object[0]);
            Object HCatSchemaInstanceDataColumns = HCatTableInfoGetDataColumnsMethod.invoke(HCatTableInfoInstance, new Object[0]);
            Object HCatSchemaInstancePartitionColumns = HCatTableInfoGetPartitionColumnsMethod.invoke(HCatTableInfoInstance, new Object[0]);
            List DataColumnFields = (List)HCatSchemaGetFieldsMethod.invoke(HCatSchemaInstanceDataColumns, new Object[0]);
            List PartitionColumnFields = (List)HCatSchemaGetFieldsMethod.invoke(HCatSchemaInstancePartitionColumns, new Object[0]);
            for (Object field : DataColumnFields) {
                HCatSchemaAppendMethod.invoke(HCatSchemaInstance, field);
            }
            for (Object field : PartitionColumnFields) {
                HCatSchemaAppendMethod.invoke(HCatSchemaInstance, field);
            }
            HCatOutputFormatSetSchemaMethod.invoke(null, configuration, HCatSchemaInstance);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return HCatSchemaInstance;
    }

    public static List<String> getHCatSchemaFieldNamesFromHCatOutputFormat(JobContext context, String databaseName, String tableName) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        List fieldNames = null;
        try {
            Object HCatSchemaInstance = HCatSchemaUtils.buildHCatSchemaInstanceFromHCatOutputFormat(context, databaseName, tableName);
            fieldNames = (List)HCatSchemaGetFieldNamesMethod.invoke(HCatSchemaInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return fieldNames;
    }

    public static String getTableSchemaFromHCatInputFormat(Configuration configuration, String databaseName, String tableName) throws ConnectorException {
        String tableSchema = null;
        try {
            HCatInputFormatSetInputMethod.invoke(null, configuration, databaseName, tableName);
            Object HCatSchemaInstance = HCatInputFormatGetTableSchemaMethod.invoke(null, configuration);
            int schemaSize = (Integer)HCatSchemaSizeMethod.invoke(HCatSchemaInstance, new Object[0]);
            String delimiter = "";
            String fieldName = null;
            String typeName = null;
            Object HCatFieldSchemaInstance = null;
            StringBuffer tableSchemaSB = new StringBuffer();
            for (int i = 0; i < schemaSize; ++i) {
                HCatFieldSchemaInstance = HCatSchemaGetIntTypeMethod.invoke(HCatSchemaInstance, i);
                fieldName = (String)HCatFieldSchemaGetNameMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
                typeName = (String)HCatFieldSchemaGetTypeStringMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
                tableSchemaSB.append(delimiter + fieldName + " " + typeName);
                delimiter = ",";
            }
            tableSchema = tableSchemaSB.toString();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return tableSchema;
    }

    public static String getTableSchemaFromHCatOutputFormat(JobContext context, String databaseName, String tableName) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        String tableSchema = null;
        try {
            Object HCatSchemaInstance = HCatSchemaUtils.buildHCatSchemaInstanceFromHCatOutputFormat(context, databaseName, tableName);
            int schemaSize = (Integer)HCatSchemaSizeMethod.invoke(HCatSchemaInstance, new Object[0]);
            String delimiter = "";
            String fieldName = null;
            String typeName = null;
            Object HCatFieldSchemaInstance = null;
            StringBuffer tableSchemaSB = new StringBuffer();
            for (int i = 0; i < schemaSize; ++i) {
                HCatFieldSchemaInstance = HCatSchemaGetIntTypeMethod.invoke(HCatSchemaInstance, i);
                fieldName = (String)HCatFieldSchemaGetNameMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
                typeName = (String)HCatFieldSchemaGetTypeStringMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
                tableSchemaSB.append(delimiter + fieldName + " " + typeName);
                delimiter = ",";
            }
            tableSchema = tableSchemaSB.toString();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        return tableSchema;
    }

    public static ConnectorRecordSchema getRecordSchema(JobContext context, String databaseName, String tableName, String[] fieldNames, ConnectorConfiguration.direction direction2) throws ConnectorException {
        int i;
        ConnectorRecordSchema schema;
        Configuration configuration = context.getConfiguration();
        Object HCatSchemaInstance = null;
        try {
            if (ConnectorConfiguration.direction.input == direction2) {
                HCatInputFormatSetInputMethod.invoke(null, configuration, databaseName, tableName);
                HCatSchemaInstance = HCatInputFormatGetTableSchemaMethod.invoke(null, configuration);
            } else {
                HCatSchemaInstance = HCatSchemaUtils.buildHCatSchemaInstanceFromHCatOutputFormat(context, databaseName, tableName);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        if (HCatSchemaInstance == null) {
            throw new ConnectorException(14012);
        }
        ConnectorRecordSchema recordSchema = ConnectorConfiguration.direction.input == direction2 ? ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration)) : ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration));
        List hcatFieldNames = null;
        try {
            hcatFieldNames = (List)HCatSchemaGetFieldNamesMethod.invoke(HCatSchemaInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        if (recordSchema != null && recordSchema.getLength() > 0) {
            schema = new ConnectorRecordSchema(recordSchema.getLength());
            for (i = 0; i < recordSchema.getLength(); ++i) {
                schema.setFieldType(i, recordSchema.getFieldType(i));
                schema.setDataTypeConverter(i, recordSchema.getDataTypeConverter(i));
                schema.setParameters(i, recordSchema.getParameters(i));
            }
        } else {
            schema = new ConnectorRecordSchema(fieldNames.length);
        }
        i = 0;
        try {
            for (String name : fieldNames) {
                Object hcatFieldSchemaInstance = null;
                int j = 0;
                for (String fieldname : hcatFieldNames) {
                    if (name.equalsIgnoreCase(fieldname)) {
                        try {
                            hcatFieldSchemaInstance = HCatSchemaGetStringTypeMethod.invoke(HCatSchemaInstance, fieldname);
                            break;
                        }
                        catch (Exception e) {
                            throw new ConnectorException(e.getMessage());
                        }
                    }
                    if (++j != hcatFieldNames.size()) continue;
                    throw new ConnectorException(14005);
                }
                String typeName = null;
                try {
                    typeName = (String)HCatFieldSchemaGetTypeStringMethod.invoke(hcatFieldSchemaInstance, new Object[0]);
                }
                catch (Exception e) {
                    throw new ConnectorException(e.getMessage());
                }
                if (recordSchema != null && recordSchema.getLength() > 0 && recordSchema.getFieldType(i) == 1883) continue;
                schema.setFieldType(i++, HiveSchemaUtils.lookupHiveDataTypeByName(typeName));
            }
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    public static int[] getColumnMapping(String[] ColNames, String[] mappingNames) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < ColNames.length; ++i) {
            map.put(ColNames[i].toLowerCase().trim(), i);
        }
        int[] mapping = new int[mappingNames.length];
        for (int i = 0; i < mappingNames.length; ++i) {
            mapping[i] = (Integer)map.get(mappingNames[i].toLowerCase().trim());
        }
        return mapping;
    }

    public static String buildTableSchema(Object HCatSchemaInstance) throws ConnectorException {
        int schemaSize = 0;
        try {
            schemaSize = (Integer)HCatSchemaSizeMethod.invoke(HCatSchemaInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
        StringBuffer tableSchema = new StringBuffer();
        String delimiter = "";
        for (int i = 0; i < schemaSize; ++i) {
            String fieldName = null;
            String typeName = null;
            try {
                Object HCatFieldSchemaInstance = HCatSchemaGetIntTypeMethod.invoke(HCatSchemaInstance, i);
                fieldName = (String)HCatFieldSchemaGetNameMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
                typeName = (String)HCatFieldSchemaGetTypeStringMethod.invoke(HCatFieldSchemaInstance, new Object[0]);
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage());
            }
            tableSchema.append(delimiter + fieldName + " " + typeName);
            delimiter = ",";
        }
        return tableSchema.toString();
    }

    static {
        try {
            HCatInputFormatClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatInputFormat");
            HCatOutputFormatClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatOutputFormat");
            HCatOutputJobInfoClass = Class.forName("org.apache.hive.hcatalog.mapreduce.OutputJobInfo");
            HCatTableInfoClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatTableInfo");
            HCatSchemaClass = Class.forName("org.apache.hive.hcatalog.data.schema.HCatSchema");
            HCatFieldSchemaClass = Class.forName("org.apache.hive.hcatalog.data.schema.HCatFieldSchema");
        }
        catch (ClassNotFoundException e) {
            try {
                HCatInputFormatClass = Class.forName("org.apache.hcatalog.mapreduce.HCatInputFormat");
                HCatOutputFormatClass = Class.forName("org.apache.hcatalog.mapreduce.HCatOutputFormat");
                HCatOutputJobInfoClass = Class.forName("org.apache.hcatalog.mapreduce.OutputJobInfo");
                HCatTableInfoClass = Class.forName("org.apache.hcatalog.mapreduce.HCatTableInfo");
                HCatSchemaClass = Class.forName("org.apache.hcatalog.data.schema.HCatSchema");
                HCatFieldSchemaClass = Class.forName("org.apache.hcatalog.data.schema.HCatFieldSchema");
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e);
            }
        }
        try {
            HCatSchemaConstructor = HCatSchemaClass.getConstructor(List.class);
            HCatInputFormatSetInputMethod = HCatInputFormatClass.getMethod("setInput", Configuration.class, String.class, String.class);
            HCatOutputFormatSetOutputMethod = HCatOutputFormatClass.getMethod("setOutput", Configuration.class, Credentials.class, HCatOutputJobInfoClass);
            HCatInputFormatGetTableSchemaMethod = HCatInputFormatClass.getMethod("getTableSchema", Configuration.class);
            HCatSchemaAppendMethod = HCatSchemaClass.getMethod("append", HCatFieldSchemaClass);
            HCatSchemaSizeMethod = HCatSchemaClass.getMethod("size", new Class[0]);
            HCatSchemaGetIntTypeMethod = HCatSchemaClass.getMethod("get", Integer.TYPE);
            HCatSchemaGetStringTypeMethod = HCatSchemaClass.getMethod("get", String.class);
            HCatSchemaGetFieldsMethod = HCatSchemaClass.getMethod("getFields", new Class[0]);
            HCatSchemaGetFieldNamesMethod = HCatSchemaClass.getMethod("getFieldNames", new Class[0]);
            HCatFieldSchemaGetNameMethod = HCatFieldSchemaClass.getMethod("getName", new Class[0]);
            HCatFieldSchemaGetTypeStringMethod = HCatFieldSchemaClass.getMethod("getTypeString", new Class[0]);
            HCatOutputJobInfoCreateMethod = HCatOutputJobInfoClass.getMethod("create", String.class, String.class, Map.class);
            HCatOutputJobInfoGetTableInfoMethod = HCatOutputJobInfoClass.getMethod("getTableInfo", new Class[0]);
            HCatOutputFormatSetSchemaMethod = HCatOutputFormatClass.getMethod("setSchema", Configuration.class, HCatSchemaClass);
            HCatTableInfoGetDataColumnsMethod = HCatTableInfoClass.getMethod("getDataColumns", new Class[0]);
            HCatTableInfoGetPartitionColumnsMethod = HCatTableInfoClass.getMethod("getPartitionColumns", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

