/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.net.NetUtils;

public class HadoopConfigurationUtils {
    private static Log logger = LogFactory.getLog(HadoopConfigurationUtils.class);
    private static final int SELECT_HOST_RANGE_MIN = 10;
    private static final int MIN_PORT_NUMBER = 8678;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int REACHABLE_TIMEOUT = 2000;
    private static final PathFilter FILTER = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static int getMaxMapTasks(JobContext context) throws ConnectorException {
        try {
            JobConf jobConf = new JobConf(context.getConfiguration());
            JobClient jc = new JobClient(jobConf);
            ClusterStatus status = jc.getClusterStatus(true);
            return status.getMaxMapTasks();
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)"Get Cluster Status function is not supported on this platform");
            return -1;
        }
    }

    public static int getMaxReduceTasks(JobContext context) throws ConnectorException {
        try {
            JobConf jobConf = new JobConf(context.getConfiguration());
            JobClient jc = new JobClient(jobConf);
            ClusterStatus status = jc.getClusterStatus(true);
            return status.getMaxReduceTasks();
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)"Get Cluster Status function is not supported on this platform");
            return -1;
        }
    }

    public static void utilizeMaxConcurrentMappers(JobContext context) throws ConnectorException {
        int retryCount;
        int numDataNodes = 0;
        try {
            Class<?> ClusterClass = Class.forName("org.apache.hadoop.mapreduce.Cluster");
            Constructor<?> ClusterConstructor = ClusterClass.getConstructor(Configuration.class);
            Method ClusterGetClusterStatusMethod = ClusterClass.getMethod("getClusterStatus", new Class[0]);
            Object ClusterInstance = ClusterConstructor.newInstance(context.getConfiguration());
            ClusterMetrics metrics = (ClusterMetrics)ClusterGetClusterStatusMethod.invoke(ClusterInstance, new Object[0]);
            numDataNodes = metrics.getTaskTrackerCount();
            logger.debug((Object)("ClusterMetrics returned " + numDataNodes + " data nodes in the cluster"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Num mappers throttle functionality requires APIs which are not available on the cluster, mapper throttle functionality is being bypassed");
            return;
        }
        Configuration config = context.getConfiguration();
        int maxYarnMemory = config.getInt("yarn.scheduler.maximum-allocation-mb", 0);
        int mapMemory = config.getInt("mapreduce.map.memory.mb", 0);
        if (maxYarnMemory <= 0 || mapMemory <= 0) {
            logger.warn((Object)"Num mappers throttle functionality requires YARN which is not available on the cluster, mapper throttle functionality is being bypassed");
            return;
        }
        int maxContainers = (int)Math.floor((double)maxYarnMemory / (double)mapMemory);
        logger.debug((Object)("Yarn is configured to allocate " + maxYarnMemory + " mb per datanode"));
        logger.debug((Object)("MapReduce is configured to allocate " + mapMemory + " mb per mapper"));
        logger.debug((Object)("The cluster can handle " + (maxContainers *= numDataNodes) + " containers concurrently"));
        String queuename = context.getConfiguration().get("mapred.job.queue.name", "");
        queuename = queuename.isEmpty() ? context.getConfiguration().get("mapreduce.job.queuename") : queuename;
        queuename = queuename.isEmpty() ? "default" : queuename;
        int minMappers = ConnectorConfiguration.getThrottleNumMappersMinMappers(context.getConfiguration());
        int retryTime = ConnectorConfiguration.getThrottleNumMappersRetrySeconds(context.getConfiguration());
        int originalRetryCount = retryCount = ConnectorConfiguration.getThrottleNumMappersRetryCount(context.getConfiguration());
        if (minMappers != 0 && (retryTime <= 0 || retryCount <= 0)) {
            throw new ConnectorException(15050);
        }
        int usedContainers = 0;
        int maxTDCHContainers = 0;
        float capacity = 0.0f;
        float maxQueueContainers = 0.0f;
        try {
            Object AppUsageReportInstance;
            Class<?> YarnClientClass = Class.forName("org.apache.hadoop.yarn.client.api.YarnClient");
            Class<?> QueueInfoClass = Class.forName("org.apache.hadoop.yarn.api.records.QueueInfo");
            Class<?> ApplicationReportClass = Class.forName("org.apache.hadoop.yarn.api.records.ApplicationReport");
            Class<?> AppUsageReportClass = Class.forName("org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport");
            Method YarnClientCreateYarnClientMethod = YarnClientClass.getMethod("createYarnClient", new Class[0]);
            Method YarnClientInitMethod = YarnClientClass.getMethod("init", Configuration.class);
            Method YarnClientStartMethod = YarnClientClass.getMethod("start", new Class[0]);
            Method YarnClientGetQueueInfoMethod = YarnClientClass.getMethod("getQueueInfo", String.class);
            Method QueueInfoGetCapacityMethod = QueueInfoClass.getMethod("getCapacity", new Class[0]);
            Method QueueInfoGetApplicationsMethod = QueueInfoClass.getMethod("getApplications", new Class[0]);
            Method ApplicationReportGetAppUsageReportMethod = ApplicationReportClass.getMethod("getApplicationResourceUsageReport", new Class[0]);
            Method AppUsageReportGetReservedContainersMethod = AppUsageReportClass.getMethod("getNumReservedContainers", new Class[0]);
            Method AppUsageReportGetUsedContainersMethod = AppUsageReportClass.getMethod("getNumUsedContainers", new Class[0]);
            Object YarnClientInstance = YarnClientCreateYarnClientMethod.invoke(null, new Object[0]);
            YarnClientInitMethod.invoke(YarnClientInstance, context.getConfiguration());
            YarnClientStartMethod.invoke(YarnClientInstance, new Object[0]);
            Object QueueInfoInstance = YarnClientGetQueueInfoMethod.invoke(YarnClientInstance, queuename);
            capacity = ((Float)QueueInfoGetCapacityMethod.invoke(QueueInfoInstance, new Object[0])).floatValue();
            maxQueueContainers = (float)Math.ceil((float)maxContainers * capacity);
            logger.debug((Object)("Queue " + queuename + " has a static capacity of " + capacity + ", equivalent to " + maxQueueContainers + " containers"));
            for (Object ApplicationReportInstance : (List)QueueInfoGetApplicationsMethod.invoke(QueueInfoInstance, new Object[0])) {
                AppUsageReportInstance = ApplicationReportGetAppUsageReportMethod.invoke(ApplicationReportInstance, new Object[0]);
                usedContainers += ((Integer)AppUsageReportGetReservedContainersMethod.invoke(AppUsageReportInstance, new Object[0])).intValue();
                usedContainers += ((Integer)AppUsageReportGetUsedContainersMethod.invoke(AppUsageReportInstance, new Object[0])).intValue();
            }
            logger.debug((Object)("Queue " + queuename + " has applications running which are utilizing " + usedContainers + " containers"));
            maxTDCHContainers = (int)(maxQueueContainers - (float)usedContainers);
            logger.debug((Object)"Max Concurrent Containers for TDCH:");
            logger.debug((Object)("\tMax containers for the cluster:\t" + maxContainers));
            logger.debug((Object)("\tMax containers for the queue:\t" + maxQueueContainers));
            logger.debug((Object)("\tMax concurrent containers for TDCH:\t" + maxTDCHContainers));
            logger.debug((Object)("\tMin containers requested by user:\t" + minMappers));
            if (minMappers != 0 && maxTDCHContainers < minMappers && retryCount != 0) {
                logger.info((Object)("Queue " + queuename + " can run less than " + minMappers + " containers concurrently, job will be submitted once more than " + minMappers + " containers become available"));
            }
            while (minMappers != 0 && maxTDCHContainers < minMappers && retryCount-- != 0) {
                Thread.sleep(retryTime * 1000);
                usedContainers = 0;
                QueueInfoInstance = YarnClientGetQueueInfoMethod.invoke(YarnClientInstance, queuename);
                for (Object ApplicationReportInstance : (List)QueueInfoGetApplicationsMethod.invoke(QueueInfoInstance, new Object[0])) {
                    AppUsageReportInstance = ApplicationReportGetAppUsageReportMethod.invoke(ApplicationReportInstance, new Object[0]);
                    usedContainers += ((Integer)AppUsageReportGetReservedContainersMethod.invoke(AppUsageReportInstance, new Object[0])).intValue();
                    usedContainers += ((Integer)AppUsageReportGetUsedContainersMethod.invoke(AppUsageReportInstance, new Object[0])).intValue();
                }
                logger.debug((Object)("Queue " + queuename + " has applications running which are utilizing " + usedContainers + " containers"));
                maxTDCHContainers = (int)(maxQueueContainers - (float)usedContainers);
                logger.debug((Object)"Max Concurrent Containers for TDCH:");
                logger.debug((Object)("\tMax containers for the cluster:\t" + maxContainers));
                logger.debug((Object)("\tMax containers for the queue:\t" + maxQueueContainers));
                logger.debug((Object)("\tMax concurrent containers for TDCH:\t" + maxTDCHContainers));
                logger.debug((Object)("\tMin containers requested by user:\t" + minMappers));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Num mappers throttle functionality requires YARN which is not available on the cluster, mapper throttle functionality is being bypassed");
            return;
        }
        int nummappers = ConnectorConfiguration.getNumMappers(config);
        if (maxTDCHContainers <= 0) {
            throw new ConnectorException(15048, queuename);
        }
        if (minMappers != 0 && maxTDCHContainers < minMappers) {
            throw new ConnectorException(15049, minMappers, queuename, originalRetryCount, retryTime);
        }
        if (nummappers > maxTDCHContainers) {
            logger.warn((Object)("User-defined nummappers value utilizes more containers (" + nummappers + ") than the cluster can handle concurrently (" + maxTDCHContainers + "), overwiting user-defined value"));
            ConnectorConfiguration.setNumMappers(config, maxTDCHContainers);
        }
    }

    public static String[] getAllActiveHosts(JobContext context) throws ConnectorException {
        String[] hosts = new String[]{};
        try {
            JobConf jobConf = new JobConf(context.getConfiguration());
            JobClient jc = new JobClient(jobConf);
            ClusterStatus status = jc.getClusterStatus(true);
            Collection trackers = status.getActiveTrackerNames();
            if (trackers.size() > 0) {
                hosts = new String[trackers.size()];
                int count = 0;
                for (String tracker : trackers) {
                    int colonpos = tracker.indexOf(58);
                    String host = colonpos >= 0 ? tracker.substring(0, colonpos) : tracker;
                    int underscorepos = host.indexOf(95);
                    if (underscorepos >= 0) {
                        host = host.substring(underscorepos + 1);
                    }
                    hosts[count++] = host;
                }
            }
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)"getClusterStatus is not supported on this platform");
        }
        return hosts;
    }

    public static int getUnusedPort() throws ConnectorException {
        for (int i = 8678; i < 65535; ++i) {
            try {
                ServerSocket socket = new ServerSocket(i);
                socket.close();
                socket = null;
                return i;
            }
            catch (IOException e) {
                continue;
            }
        }
        throw new ConnectorException(22007);
    }

    public static ServerSocket createServerSocket(int port, int backlog) throws ConnectorException {
        if (port == 0) {
            for (int i = 8678; i < 65535; ++i) {
                try {
                    ServerSocket socket = new ServerSocket(i, backlog);
                    return socket;
                }
                catch (IOException e) {
                    continue;
                }
            }
            throw new ConnectorException(22007);
        }
        try {
            ServerSocket socket = new ServerSocket(port, backlog);
            return socket;
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static String getClusterNodeInterface(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        String hdfsInterfaceName = configuration.get("dfs.datanode.dns.interface", "default");
        String mapreduceInterfaceName = configuration.get("mapred.tasktracker.dns.interface", "default");
        try {
            if (hdfsInterfaceName.equals("default") && mapreduceInterfaceName.equals("default")) {
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress trackerAddr = null;
                if (configuration.get("mapred.job.tracker", "local").equals("local")) {
                    trackerAddr = InetAddress.getLocalHost();
                } else {
                    String jobtracker = configuration.get("mapred.job.tracker", "localhost:8012");
                    try {
                        trackerAddr = NetUtils.createSocketAddr((String)jobtracker).getAddress();
                    }
                    catch (Exception e1) {
                        for (String host : HadoopConfigurationUtils.getAllActiveHosts(context)) {
                            try {
                                trackerAddr = NetUtils.createSocketAddr((String)host, (int)7).getAddress();
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
                if (trackerAddr == null) {
                    throw new ConnectorException(22015);
                }
                boolean isReachableSuccess = false;
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = netInterfaces.nextElement();
                    if (!trackerAddr.isReachable(networkInterface, 0, 2000)) continue;
                    isReachableSuccess = true;
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        return inetAddress.getHostAddress();
                    }
                }
                if (isReachableSuccess) {
                    throw new ConnectorException(22008);
                }
                throw new ConnectorException(22014);
            }
            String interfaceName = null;
            interfaceName = !hdfsInterfaceName.equals("default") ? hdfsInterfaceName : mapreduceInterfaceName;
            NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address)) continue;
                return inetAddress.getHostAddress();
            }
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static String[] selectUniqueActiveHosts(String[] allActiveHosts, int numberOfHosts) {
        if (allActiveHosts == null) {
            return new String[0];
        }
        if (allActiveHosts.length <= numberOfHosts) {
            return allActiveHosts;
        }
        String[] hosts = new String[numberOfHosts];
        int range = allActiveHosts.length / numberOfHosts;
        if (range >= 10) {
            Random rand = new Random();
            for (int i = 0; i < numberOfHosts; ++i) {
                hosts[i] = allActiveHosts[rand.nextInt(range) + range * i];
            }
        } else {
            ArrayList<String> allActiveHostArrays = new ArrayList<String>(Arrays.asList(allActiveHosts));
            Collections.shuffle(allActiveHostArrays);
            for (int i = 0; i < numberOfHosts; ++i) {
                hosts[i] = allActiveHostArrays.get(i);
            }
        }
        return hosts;
    }

    public static String getAllFilePaths(Configuration configuration, String[] paths) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (String path : paths) {
            Path p = new Path(path);
            FileSystem fs = p.getFileSystem(configuration);
            HadoopConfigurationUtils.addInputPathRecursively(result, fs, p, FILTER);
        }
        int size = result.size();
        if (size <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(((FileStatus)result.get(i)).getPath().toString()).append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static List<Path> getAllFilePaths(Configuration configuration, String path) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<Path> resultPaths = new ArrayList<Path>();
        Path p = new Path(path);
        FileSystem fs = p.getFileSystem(configuration);
        HadoopConfigurationUtils.addInputPathRecursively(result, fs, p, FILTER);
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            resultPaths.add(((FileStatus)result.get(i)).getPath());
        }
        return resultPaths;
    }

    protected static void addInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDir()) {
                HadoopConfigurationUtils.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    public static int getNextFilePathIncrement(Configuration configuration, String folderPath, String filePrefix, int numDigit) throws IOException {
        String fp;
        String filepath;
        Path p = new Path(folderPath);
        FileSystem fs = p.getFileSystem(configuration);
        if (!fs.exists(p) || numDigit <= 0) {
            return 0;
        }
        if (fs.isFile(p)) {
            throw new ConnectorException(15001);
        }
        if (filePrefix == null) {
            filePrefix = "";
        }
        if (!fs.isFile(new Path(filepath = (fp = p.toUri().toString() + "/") + filePrefix + String.format("%0" + numDigit + "d", 0)))) {
            return 0;
        }
        int beginDigit = 1;
        int endDigit = 1;
        boolean firstNumberFound = false;
        for (int i = 1; i < numDigit + 1; ++i) {
            beginDigit = endDigit;
            filepath = fp + filePrefix + String.format("%0" + numDigit + "d", endDigit *= 10);
            if (fs.isFile(new Path(filepath))) continue;
            firstNumberFound = true;
            break;
        }
        if (firstNumberFound) {
            while (beginDigit != endDigit) {
                int middleDigit = (beginDigit + endDigit) / 2;
                filepath = fp + filePrefix + String.format("%0" + numDigit + "d", middleDigit);
                if (fs.isFile(new Path(filepath))) {
                    beginDigit = middleDigit + 1;
                    continue;
                }
                endDigit = middleDigit;
            }
        } else {
            throw new ConnectorException(15002);
        }
        return endDigit;
    }

    @Deprecated
    public static void configureMapSpeculative(Configuration configuration, boolean value) {
        configuration.setBoolean("mapred.map.tasks.speculative.execution", value);
    }

    public static String getOutputBaseName(JobContext context) {
        return context.getConfiguration().get("mapreduce.output.basename", "part");
    }

    public static String getAliasFileFormatName(String fileFormat) {
        if (fileFormat.equalsIgnoreCase("orc")) {
            return "orcfile";
        }
        return fileFormat;
    }
}

