/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import com.teradata.connector.common.exception.ConnectorException;

public class ConnectorUnicodeCharacterConverter {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static char charToHexChar(int ch) {
        return hexChars[ch & 0xF];
    }

    public static String toEncodedUnicode(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        for (int x = 0; x < input.length(); ++x) {
            char ch = input.charAt(x);
            if (ch > '=' && ch < '\u007f') {
                if (ch == '\\') {
                    output.append('\\').append('\\');
                    continue;
                }
                output.append(ch);
                continue;
            }
            if (ch < ' ' || ch > '~') {
                output.append('\\');
                output.append('u');
                output.append(ConnectorUnicodeCharacterConverter.charToHexChar(ch >> 12 & 0xF));
                output.append(ConnectorUnicodeCharacterConverter.charToHexChar(ch >> 8 & 0xF));
                output.append(ConnectorUnicodeCharacterConverter.charToHexChar(ch >> 4 & 0xF));
                output.append(ConnectorUnicodeCharacterConverter.charToHexChar(ch & 0xF));
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String fromEncodedUnicode(String input) throws ConnectorException {
        if (input == null) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        int x = 0;
        while (x < input.length()) {
            char ch;
            if ((ch = input.charAt(x++)) == '\\' && input.length() != 1) {
                char chtemp = ch;
                if ((ch = input.charAt(x++)) == 'u') {
                    int value = 0;
                    for (int i = 0; i < 4; ++i) {
                        if ((ch = input.charAt(x++)) >= '0' && ch <= '9') {
                            value = (value << 4) + ch - 48;
                            continue;
                        }
                        if (ch >= 'a' && ch <= 'f') {
                            value = (value << 4) + 10 + ch - 97;
                            continue;
                        }
                        if (ch >= 'A' && ch <= 'F') {
                            value = (value << 4) + 10 + ch - 65;
                            continue;
                        }
                        throw new ConnectorException(15004);
                    }
                    output.append((char)value);
                    continue;
                }
                if (ch != 'u' && chtemp == '\\') {
                    return "\\";
                }
                throw new ConnectorException(15004);
            }
            output.append(ch);
        }
        return output.toString();
    }
}

