/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import com.teradata.connector.common.utils.ConnectorSchemaParser;
import junit.framework.Assert;
import org.junit.Test;

public class ConnectorSchemaParserTest {
    @Test
    public void testConnectorSchemaParser() {
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        Assert.assertEquals((boolean)false, (boolean)parser.isQuoted("'one' "));
        parser.setTrimSpaces(true);
        Assert.assertEquals((boolean)true, (boolean)parser.isQuoted("'one' "));
        String text = "'one',, ('two', three), four,";
        Assert.assertEquals((int)1, (int)parser.tokenize(text, 1, false).size());
        Assert.assertEquals((int)5, (int)parser.tokenize(text).size());
        parser.setIgnoreContinousDelim(true);
        Assert.assertEquals((int)4, (int)parser.tokenize(text).size());
        parser.setBracketChars('{', '}');
        Assert.assertEquals((int)5, (int)parser.tokenize(text).size());
        parser.setDelimChar('/');
        Assert.assertEquals((int)1, (int)parser.tokenize(text).size());
        parser.setDelimChar(',');
        parser.setQuoteChar('`');
        Assert.assertEquals((int)4, (int)parser.tokenize("'one',, ('two', three), `four,`").size());
        parser.setIgnoreQuotes(true);
        Assert.assertEquals((int)5, (int)parser.tokenize("'one',, ('two', three), `four,`").size());
        parser.setMatchBrackets(false);
        Assert.assertEquals((int)2, (int)parser.tokenize("{one,two}").size());
        parser.setMatchBrackets(true);
        Assert.assertEquals((int)1, (int)parser.tokenize("{one,two}").size());
        parser.setEscapeChar(',');
        Assert.assertEquals((String)"one\\two", (String)parser.tokenize("one\\,two").get(0));
    }
}

