/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class ConnectorMapredUtils {
    public static TaskAttemptContext createTaskAttemptContext(Configuration configuration, TaskAttemptContext taskContext) {
        try {
            Constructor<Object> ctor = null;
            if (TaskAttemptContext.class.getConstructors().length == 0) {
                Class<?> c = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
                Class<?> taid = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptID");
                ctor = c.getConstructor(Configuration.class, taid);
            } else {
                ctor = TaskAttemptContext.class.getConstructor(Configuration.class, TaskAttemptID.class);
            }
            return (TaskAttemptContext)ctor.newInstance(configuration, taskContext.getTaskAttemptID());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JobContext createJobContext(TaskAttemptContext taskContext) {
        try {
            Constructor<Object> ctor = null;
            if (JobContext.class.getConstructors().length == 0) {
                Class<?> c = Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
                Class<?> taid = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptID");
                ctor = c.getConstructor(Configuration.class, taid);
            } else {
                ctor = JobContext.class.getConstructor(Configuration.class, TaskAttemptID.class);
            }
            return (JobContext)ctor.newInstance(taskContext.getConfiguration(), taskContext.getTaskAttemptID());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

