/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import au.com.bytecode.opencsv.CSVParser;
import java.io.IOException;

public class ConnectorCsvParser {
    private char fieldSeparator = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private CSVParser csvParser;

    public ConnectorCsvParser() {
        this.initialize();
    }

    public ConnectorCsvParser(String fieldSeparator, String quoteChar, String escapeChar) {
        if (!fieldSeparator.isEmpty()) {
            this.fieldSeparator = fieldSeparator.charAt(0);
        }
        if (!quoteChar.isEmpty()) {
            this.quoteChar = quoteChar.charAt(0);
        }
        if (!escapeChar.isEmpty()) {
            this.escapeChar = escapeChar.charAt(0);
        }
        this.initialize();
    }

    public ConnectorCsvParser(char fieldSeparator, char quoteChar, char escapeChar) {
        this.fieldSeparator = fieldSeparator;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.initialize();
    }

    private void initialize() {
        this.csvParser = new CSVParser(this.fieldSeparator, this.quoteChar, this.escapeChar);
    }

    public String[] parse(String csvString) throws IOException {
        String[] result = this.csvParser.parseLine(csvString);
        return result;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }
}

